<?php

if ( !defined( 'ABSPATH' ) ) {
	exit;
}

add_action( 'pre_get_posts', 'team_post_per_page_archive' );

function team_post_per_page_archive( $query ) {

	if ( ! is_admin() && $query->is_main_query() ) {

		if ( is_post_type_archive( 'team' ) || is_tax('cat_team') ) {

			if( $query->is_post_type_archive( 'team' ) || $query->is_tax('cat_team') ) {
				$query->set('post_type', array( 'team' ) );
				$query->set('posts_per_page', get_theme_mod( 'ova_team_total_record', 6 ) );

				$orderby 	= get_theme_mod( 'ova_team_orderby', 'ID' );
				$order 		= get_theme_mod( 'ova_team_order', 'DESC' );

				$query->set('order', $order );

				if ( $orderby === 'ova_team_met_order_team' ) {
					$query->set('orderby', 'meta_value_num' );
					$query->set('meta_type', 'NUMERIC' );
					$query->set('meta_key', 'ova_team_met_order_team' );
				} else {
					$query->set('orderby', $orderby );
				}
			}
		}

	}
}

function ova_get_teams( $args ) {

	$category 		= $args['category'];
	$total_count 	= $args['total_count'];
	$orderby_post 	= $args['orderby_post'];
	$order_post 	= $args['order_post'];

	$wp_args = array(
		'post_type' 		=> 'team',
		'post_status' 		=> 'publish',
		'order'				=> $order_post,
		'orderby' 			=> $orderby_post,
		'posts_per_page' 	=> $total_count,

	);

	if ( $orderby_post == 'ova_team_met_order_team' ) {
		$wp_args['orderby'] 	= 'meta_value_num';
		$wp_args['meta_type'] 	= 'NUMERIC';
		$wp_args['meta_key'] 	= $orderby_post;
	}
	if ( $category != 'all' ) {
		$wp_args['tax_query'] = array(
			array(
				'taxonomy'         => 'cat_team',
				'field'            => 'slug',
				'terms'            => $category,
				'include_children' => true,
				'operator'         => 'IN',
			),
		);
	}

	$the_query = new WP_Query( $wp_args );
	return $the_query;
}

function ova_query_team_ajax($args) {

	$order 			= $args['order'];
	$order_by 		= $args['orderby'];
	$posts_per_page = $args['posts_per_page'];
	$cate 			= intval( $args['cate'] );

	$wp_args = array(
		'post_type' 		=> 'team',
		'post_status' 		=> 'publish',
		'order' 			=> $order,
		'orderby' 			=> $order_by,
		'posts_per_page' 	=> $posts_per_page,
	);

	if ( array_key_exists('offset', $args) ) {
		if ($args['offset'] != -1) {
			$wp_args['offset'] = $args['offset'];
		}
	}

	if ( $order_by == 'ova_team_met_order_team' ) {
		$wp_args['orderby'] 	= 'meta_value_num';
		$wp_args['meta_key'] 	= $order_by;
		$wp_args['meta_type'] 	= 'NUMERIC';
	}

	if ($cate != 0) {
		$wp_args['tax_query'] = array(
			array(
				'taxonomy'         => 'cat_team',
				'field'            => 'term_id',
				'terms'            => $cate,
				'include_children' => true,
				'operator'         => 'IN',
			),
		);
	}

	return new WP_Query( $wp_args );
}

function ova_team_pagination_ajax($total_pages,$curent_page,$posts_per_page,$args){
	if ( $total_pages > 1 ) :
		$page_num_arr = range(1, $total_pages);
		?>
	<div class="ova_team_pagination_ajax"
		data-args="<?php echo esc_attr( json_encode( $args ) ); ?>">
		<nav class="navigation pagination">
			<div class="nav-links">
				<ul class="page-numbers">
					<?php if ( $curent_page > 1 ): ?>
						<?php $offset = $posts_per_page * ( max( $curent_page - 1, 1) - 1) == 0 ? -1 : $posts_per_page * ( max( $curent_page - 1, 1) - 1); ?>
						<li>
							<a class="prev page-numbers" href="#"
								aria-label="<?php esc_attr_e('Previous Page', 'ova-team'); ?>"
								data-offset="<?php echo esc_attr( $offset ); ?>"
								data-page="<?php echo esc_attr( max( $curent_page - 1, 1) ); ?>">
								<i class="ovaicon-back"></i>
							</a>
						</li>
					<?php endif;

					$first_item = max( $curent_page - 1, 1 );
					$last_item = min( $curent_page + 1, $total_pages );
					if ($curent_page == 1) {
						$last_item = min( $curent_page + 2, $total_pages );
					}
					if ($curent_page == $total_pages) {
						$first_item = max( $curent_page - 2, 1 );
					}
					$sub_page_num_arr = range( $first_item, $last_item );

					foreach ( $sub_page_num_arr as $page_number ): ?>
						<li>
							<?php if ( $curent_page == $page_number ): ?>
								<span aria-current="page" class="page-numbers current">
									<?php echo esc_html( $page_number ); ?>
								</span>
							<?php else: ?>
							<?php
								$offset = $posts_per_page * ($page_number - 1) == 0 ? -1 : $posts_per_page * ($page_number - 1);
							?>
							<a href="#" class="page-numbers"
								data-offset="<?php echo esc_attr( $offset ); ?>"
								data-page="<?php echo esc_attr( $page_number ); ?>">
								<?php echo esc_html( $page_number ); ?>
							</a>
							<?php endif; ?>
						</li>
					<?php endforeach; ?>

					<?php if ( $curent_page < $total_pages ): ?>
						<li>
							<a class="next page-numbers" href="#"
							aria-label="<?php esc_attr_e('Next Page', 'ova-team'); ?>"
							data-offset="<?php echo esc_attr( $posts_per_page * ( min( $curent_page + 1, $total_pages) - 1) ); ?>"
							data-page="<?php echo esc_attr( min( $curent_page + 1, $total_pages) ); ?>">
							<i class="ovaicon-next"></i>
							</a>
						</li>
					<?php endif; ?>

				</ul>
			</div>
		</nav>
	</div>
<?php endif;
}

function ova_team_show_list( $teams, $template, $args_show ) {
	$show_image  = get_theme_mod( 'archive_team_show_image', 'yes' );
	?>

	<div class="content <?php if( $show_image != 'yes' ) echo 'no-image'; ?>">
		<?php if($teams->have_posts() ) : while ( $teams->have_posts() ) : $teams->the_post();
			if ( $template == "grid_modern" || $template == "grid_modern_2"  ) {
				ovateam_get_template( 'parts/item-team-modern.php', $args_show );

			} elseif( $template == "grid2_template_1" || $template == "grid2_template_2" ) {
				ovateam_get_template( 'parts/item-team-2.php', $args_show );

			} elseif( $template == "grid3_template_1" || $template == "grid3_template_2" ) {
				ovateam_get_template( 'parts/item-team-3.php', $args_show );

			} else {
				ovateam_get_template( 'parts/item-team.php', $args_show );
			}
		endwhile; endif; wp_reset_postdata(); ?>
	</div>

	<?php
}