<?php if ( !defined( 'ABSPATH' ) ) exit();
   
    if ( isset( $args['id'] ) && $args['id'] ) {
		$id = $args['id'];
	} else {
		$id = get_the_id();
	}

	$image_id 		= get_post_thumbnail_id();
	$image_alt 		= get_the_title();
	$image_src 		= '';

	if ( $image_id ) {
		if ( get_post_meta( $image_id, '_wp_attachment_image_alt', true ) ) {
			$image_alt = get_post_meta( $image_id, '_wp_attachment_image_alt', true );
		} else {
			$image_alt = get_the_title( $image_id );
		}
		$image_src 		= isset(wp_get_attachment_image_src( $image_id, 'large' )[0]) ? wp_get_attachment_image_src( $image_id, 'large' )[0] : '';
	}

	if( $image_src == '' ) {
		$image_src  = \Elementor\Utils::get_placeholder_image_src();
	}

	$job = get_post_meta( $id, 'ova_team_met_job', true );

	// show fields
	$show_image 	= isset($args['show_image']) ? $args['show_image'] : 'yes';
	$show_name 		= isset($args['show_name']) ? $args['show_name'] : 'yes';
	$show_job  		= isset($args['show_job']) ? $args['show_job'] : 'yes';
	$show_social  	= isset($args['show_social']) ? $args['show_social'] : 'yes';
	$show_link_to  	= isset($args['show_link_to']) ? $args['show_link_to'] : 'yes';

?>

	<div class="items elementor-items">
		<?php if( $show_image == 'yes' ) { ?>
			<div class="ova-media">
				<?php if( $show_link_to == 'yes' ) { ?>
				<a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>">
				<?php } ?>
					<img src="<?php echo esc_url( $image_src ); ?>" alt="<?php echo esc_attr( $image_alt ); ?>">
				<?php if( $show_link_to == 'yes' ) { ?>
				</a>
				<?php } ?>
			</div>
		<?php } ?>

		<div class="ova-info-content">
			<?php if( $show_name == 'yes' ) { ?>
				<?php if( $show_link_to == 'yes' ) { ?>
				<a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>">
				<?php } ?>
					<h3 class="name">
						<?php the_title(); ?>
					</h3>
				<?php if( $show_link_to == 'yes' ) { ?>
				</a>
				<?php } ?>
			<?php } ?>

			<?php if( ! empty( $job ) && $show_job == 'yes' ) { ?>
				<p class="job">
					<?php echo esc_html( $job ); ?>
				</p>
			<?php } ?>
		</div>
	</div>