<?php defined( 'ABSPATH' ) || exit();

if( !class_exists( 'OVACOLL_admin_assets' ) ){
	class OVACOLL_admin_assets{

		public function __construct(){
			add_action( 'admin_footer', array( $this, 'enqueue_scripts' ), 10, 2 );
		}

		public function enqueue_scripts(){

			global $post_type;

			if ( $post_type === 'collection' ) {
				// Select2
				wp_enqueue_style( 'select2', OVACOLL_PLUGIN_URI.'assets/libs/select2/select2.min.css' );
				wp_enqueue_script( 'select2', OVACOLL_PLUGIN_URI.'assets/libs/select2/select2.min.js', array('jquery'), null, true );
			}

			if ( get_current_screen()->base === 'collections_page_settings_collection' ) { 
				// Jquery UI
				wp_enqueue_style( 'jquery-ui', OVACOLL_PLUGIN_URI.'assets/libs/jquery-ui/jquery-ui.min.css' );
				wp_enqueue_script( 'jquery-ui-tabs' );
			}

			if ( $post_type === 'collection' || $post_type === 'artist' || get_current_screen()->base === 'collections_page_settings_collection' ) { 
				wp_enqueue_style( 'ovacoll-admin-style', OVACOLL_PLUGIN_URI.'assets/css/admin/ovacoll-admin-style.css' );
				wp_enqueue_script( 'ovacoll-admin-script', OVACOLL_PLUGIN_URI.'assets/js/admin/ovacoll-admin-script.js' );
			}

		}
	}

	new OVACOLL_admin_assets();
}
