<?php
namespace ova_collections_elementor\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


class ova_artists extends Widget_Base {


	public function get_name() {
		return 'ova_artists';
	}

	public function get_title() {
		return esc_html__( 'Explore the Artists', 'ova-collection' );
	}

	public function get_icon() {
		return 'eicon-posts-grid';
	}

	public function get_categories() {
		return [ 'ovatheme_collections' ];
	}

	public function get_script_depends() {
		return [ '' ];
	}

	public function get_style_depends() {
		wp_enqueue_style( 'ovacoll_artist_style', OVACOLL_PLUGIN_URI.'assets/css/frontend/ovacoll-artist-style.css' );
		return [];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Content', 'ova-collection' ),
			]
		);

		$this->add_control(
			'total_count',
			[
				'label'   => esc_html__( 'Total Artist', 'ova-collection' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => 3
			]
		);

		$this->add_control(
			'order_by',
			[
				'label' => esc_html__( 'Order By', 'ova-collection' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'date',
				'options' => [
					'date' 	=> esc_html__( 'Date', 'ova-collection' ),
					'title' => esc_html__( 'Title', 'ova-collection' ),
					'sort' 	=> esc_html__( 'Custom Sort', 'ova-collection' ),
					'ID' 	=> esc_html__( 'ID', 'ova-collection' ),
				],
			]
		);

		$this->add_control(
			'order',
			[
				'label' => esc_html__( 'Order', 'ova-collection' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'DESC',
				'options' => [
					'ASC'  	=> esc_html__( 'Ascending', 'ova-collection' ),
					'DESC' 	=> esc_html__( 'Descending', 'ova-collection' ),
				],
			]
		);

		$this->add_control( 
			'show_image',
			[
				'label' => esc_html__( 'Show Image', 'ova-collection' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'ova-collection' ),
				'label_off' => esc_html__( 'Hide', 'ova-collection' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control( 
			'show_title',
			[
				'label' => esc_html__( 'Show Title', 'ova-collection' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'ova-collection' ),
				'label_off' => esc_html__( 'Hide', 'ova-collection' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control( 
			'show_skill',
			[
				'label' => esc_html__( 'Show SKill', 'ova-collection' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'ova-collection' ),
				'label_off' => esc_html__( 'Hide', 'ova-collection' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control( 
			'show_phone',
			[
				'label' => esc_html__( 'Show Phone', 'ova-collection' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'ova-collection' ),
				'label_off' => esc_html__( 'Hide', 'ova-collection' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control( 
			'show_email',
			[
				'label' => esc_html__( 'Show Email', 'ova-collection' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'ova-collection' ),
				'label_off' => esc_html__( 'Hide', 'ova-collection' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

	}


	protected function render() {

		$settings = $this->get_settings();

		$args = array(
			'post_type' 		=> 'artist',
			'post_status' 		=> 'publish',
			'posts_per_page' 	=> $settings['total_count'],
			'order'				=> $settings['order'],
			'orderby'			=> $settings['order_by']
		);

		if ( 'sort' === $settings['order_by'] ) {
			$args['orderby'] 	= 'meta_value_num';
			$args['meta_key'] 	= 'artist_custom_sort';
		}
		
		$artists  = new \WP_Query($args);

		// show fields
		$args_show = array(
			'show_image'   => $settings['show_image'],
			'show_title'   => $settings['show_title'],
			'show_skill'   => $settings['show_skill'],
			'show_phone'   => $settings['show_phone'],
			'show_email'   => $settings['show_email'],
		); 

		?>

		<div class="archive_artist elementor-artists">
			<div class="content">
				<?php if($artists->have_posts() ) : while ( $artists->have_posts() ) : $artists->the_post();
					ovacoll_get_template( 'parts/item-artist.php', $args_show );
				endwhile; endif; wp_reset_postdata(); ?>
			</div>
		</div>

		<?php 
	}
}
