<?php 

if( !defined( 'ABSPATH' ) ) exit();

if( !class_exists( 'OVADEP_custom_post_type' ) ) {

	class OVADEP_custom_post_type{

		public function __construct(){
			add_action( 'init', array( $this, 'OVADEP_register_post_type_ova_dep' ) );
			add_action( 'init', array( $this, 'OVADEP_register_taxonomy_ova_dep' ) );
		}

		
		function OVADEP_register_post_type_ova_dep() {

			$taxonomies = array('cat_department');

			$labels = array(
				'name'                  => _x( 'Departments', 'Post Type General Name', 'ova-dep' ),
				'singular_name'         => _x( 'Department', 'Post Type Singular Name', 'ova-dep' ),
				'menu_name'             => __( 'Departments', 'ova-dep' ),
				'name_admin_bar'        => __( 'Department', 'ova-dep' ),
				'archives'              => __( 'Item Archives', 'ova-dep' ),
				'attributes'            => __( 'Item Attributes', 'ova-dep' ),
				'parent_item_colon'     => __( 'Parent Item:', 'ova-dep' ),
				'all_items'             => __( 'All Departments', 'ova-dep' ),
				'add_new_item'          => __( 'Add New', 'ova-dep' ),
				'add_new'               => __( 'Add New', 'ova-dep' ),
				'new_item'              => __( 'New Item', 'ova-dep' ),
				'edit_item'             => __( 'Edit Department', 'ova-dep' ),
				'view_item'             => __( 'View Item', 'ova-dep' ),
				'view_items'            => __( 'View Items', 'ova-dep' ),
				'search_items'          => __( 'Search Item', 'ova-dep' ),
				'not_found'             => __( 'Not found', 'ova-dep' ),
				'not_found_in_trash'    => __( 'Not found in Trash', 'ova-dep' ),
			);
			$args = array(
				'description'         => __( 'Post Type Description', 'ova-dep' ),
				'labels'              => $labels,
				'supports'            => array( 'title','excerpt', 'editor', 'comments', 'thumbnail' ),
				'taxonomies'          => $taxonomies,
				'hierarchical'        => false,
				'public'              => true,
				'show_ui'             => true,
				'show_in_rest'      => true,
				'menu_position'       => 20,
				'menu_icon' 		  => 'dashicons-networking',
				'query_var'           => true,
				'has_archive'         => true,
				'exclude_from_search' => true,
				'publicly_queryable'  => true,
				'rewrite'             => array( 'slug' => _x( 'ova_dep', 'URL slug', 'ova-dep' ) ),
				'capability_type'     => 'post',
			);
			register_post_type( 'ova_dep', $args );
		}

		function OVADEP_register_taxonomy_ova_dep(){
		

			$labels = array(
				'name'                       => _x( 'Department categories', 'Post Type General Name', 'ova-dep' ),
				'singular_name'              => _x( 'Category', 'Post Type Singular Name', 'ova-dep' ),
				'menu_name'                  => __( 'Categories', 'ova-dep' ),
				'all_items'                  => __( 'All Category Department', 'ova-dep' ),
				'parent_item'                => __( 'Parent Item', 'ova-dep' ),
				'parent_item_colon'          => __( 'Parent Item:', 'ova-dep' ),
				'new_item_name'              => __( 'New Item Name', 'ova-dep' ),
				'add_new_item'               => __( 'Add New Category', 'ova-dep' ),
				'add_new'                    => __( 'Add New Category', 'ova-dep' ),
				'edit_item'                  => __( 'Edit Category', 'ova-dep' ),
				'view_item'                  => __( 'View Item', 'ova-dep' ),
				'separate_items_with_commas' => __( 'Separate items with commas', 'ova-dep' ),
				'add_or_remove_items'        => __( 'Add or remove items', 'ova-dep' ),
				'choose_from_most_used'      => __( 'Choose from the most used', 'ova-dep' ),
				'popular_items'              => __( 'Popular Items', 'ova-dep' ),
				'search_items'               => __( 'Search Items', 'ova-dep' ),
				'not_found'                  => __( 'Not Found', 'ova-dep' ),
				'no_terms'                   => __( 'No items', 'ova-dep' ),
				'items_list'                 => __( 'Items list', 'ova-dep' ),
				'items_list_navigation'      => __( 'Items list navigation', 'ova-dep' ),
			);
			
			$args = array(
				'labels'            => $labels,
				'hierarchical'      => true,
				'publicly_queryable' => true,
				'public'            => true,
				'show_ui'           => true,
				'show_in_rest'      => true,
				'show_admin_column' => true,
				'show_in_nav_menus' => true,
				'show_tagcloud'     => false,
				'rewrite'            => array(
					'slug'       => _x( 'cat_department','Department Slug', 'ova-dep' ),
					'with_front' => false,
					'feeds'      => true,
				),
			);
			register_taxonomy( 'cat_department', array( 'ova_dep' ), $args );
		}
	}

	new OVADEP_custom_post_type();
}