<?php

if ( !defined( 'ABSPATH' ) ) {
	exit;
}

// query archive
add_action( 'pre_get_posts', 'ova_dep_post_per_page_archive' );
function ova_dep_post_per_page_archive( $query ) {
	if ( ! is_admin() && $query->is_main_query() ) {

		// Archive
		if ( is_post_type_archive( 'ova_dep' ) || is_tax('cat_department') ) {

			if( $query->is_post_type_archive( 'ova_dep' ) || $query->is_tax('cat_department') ) {
				
				$query->set('post_type', 'ova_dep' );
				$query->set('posts_per_page', get_theme_mod( 'ova_dep_total_record', 9 ) );

				if( get_query_var( 'cat_department' ) != '' ){

					$taxquery = array(
				        array(
				            'taxonomy' => 'cat_department',
				            'field' => 'slug',
				            'terms' => get_query_var( 'cat_department' )
				        )
				    );
				    $query->set( 'tax_query', $taxquery );
					
				}

				$orderby 	= get_theme_mod( 'ova_dep_orderby', 'sort_order' );
				$order 		= get_theme_mod( 'ova_dep_order', 'ASC' );

				$query->set('order', $order );

				if ( $orderby === 'sort_order' ) {
					$query->set('orderby', 'meta_value_num' );
					$query->set('meta_type', 'NUMERIC' );
		        	$query->set('meta_key', 'ova_dep_met_order_dep' );
				} else {
					$query->set('orderby', $orderby );
				}
	    	}
		}


		// Search
		$search_department = isset( $_GET['search_department'] ) ? esc_html( $_GET['search_department'] ) : '' ;

		if( $search_department != ''){

			$name = isset( $_GET['ovadep_name'] ) ? esc_html( $_GET['ovadep_name'] ) : '' ;
			$cat  = isset( $_GET['ovadep_cat'] )  ? esc_html( $_GET['ovadep_cat'] )  : '' ;
			
			$paged      = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
			$orderby 	= get_theme_mod( 'ova_dep_orderby', 'sort_order' );
			$order 		= get_theme_mod( 'ova_dep_order', 'ASC' );


			if( $paged != '' ){
				$query->set( 'paged', $paged );
			}

			$query->set( 'post_type', 'ova_dep' );
			$query->set( 'order', $order );

			switch ($orderby) {
				case 'title':
				$query->set( 'orderby', 'title' );
				break;

				case 'ova_dep_met_order_dep':
				$query->set( 'orderby' , 'meta_value' );
				$query->set( 'meta_key', $orderby );
				break;
				
				case 'ID':
				$query->set( 'orderby', 'ID');
				break;
				
				default:
				break;
			}


			// Query Taxonomy
			if($name){
				$query->set( 's' , $name );
			}
			if($cat){
				$query->set( 
					'tax_query',
					array(
						array(
							'taxonomy' => 'cat_department',
							'field'    => 'slug',
							'terms'    => $cat,
						)
					)		
				);
			}

		}

	}
}

// get list category department dropdown
add_filter( 'ovadep_cat_dropdown', 'ovadep_cat_dropdown');
function ovadep_cat_dropdown($selected){

	$args = array(
		'show_option_all'   => '' ,
		'show_option_none'   => esc_html__( 'All Categories', 'ova-dep' ),
		'post_type'         => 'ova_dep',
		'post_status'       => 'publish',
		'posts_per_page'    => '-1',
		'option_none_value' => '',
		'orderby'           => 'ID',
		'order'             => 'ASC',
		'show_count'        => 0,
		'hide_empty'        => 0,
		'child_of'          => 0,
		'exclude'           => '',
		'include'           => '',
		'echo'              => 1,
		'selected'          => $selected,
		'hierarchical'      => 1,
		'name'              => 'ovadep_cat',
		'id'                => '',
		'depth'             => 0,
		'tab_index'         => 0,
		'taxonomy'          => 'cat_department',
		'hide_if_empty'     => false,
		'value_field'       => 'slug',
		'class' 			=> 'ovadep_cat',
	);
	
	return wp_dropdown_categories($args);
}

// get list category department
function ovadep_cat_list( $parent_id, $term_ids){
	if (! $parent_id) {
		return;
	}
	$args = array(
		'taxonomy' 		=> 'cat_department',
		'orderby' 		=> 'name',
		'order'   		=> 'ASC',
		'hide_empty' 	=> false,
		'parent' 		=> $parent_id,
	);

	$id 				= get_the_ID();
	$term_id 			= get_queried_object_id();
	$child_categories 	= get_categories( $args );

	if ( $child_categories ) {

	?>
		<ul class="child-cate">
			<?php foreach ($child_categories as $child) {
				$active_class = $child->term_id == $term_id ? 'active' : '';
				if ( $id ) {
					$active_class = in_array( $child->term_id, $term_ids) ? 'active' : '';
				}
				?>
					<li class="item">
						<a href="<?php echo esc_url( get_term_link( $child ) ); ?>"
							class="item-link <?php echo esc_attr( $active_class ); ?>"
							data-slug="<?php echo esc_attr( $child->slug ); ?>"
							title="<?php echo esc_attr( $child->name ); ?>"
						>
							<span class="cate_name">
								<?php echo esc_html( $child->name ); ?>
							</span>
							<?php if (get_term_children( $child->term_id, 'cat_department' ) ): ?>
								<i class="fas fa-plus" aria-hidden="true"></i>
							<?php endif; ?>
						</a>
						<?php ovadep_cat_list( $child->term_id, $term_ids); ?>
					</li>
			<?php } ?>
		</ul>
		<?php
	}
}

// get data element
function ova_dep_get_department_elements( $args ){
	
	if( $args['category'] == 'all' ){
		$args_new = array(
			'post_type' => 'ova_dep',
			'post_status' => 'publish',
			'posts_per_page' => $args['total_count'],
		);
	} else {
		$args_new = array(
			'post_type' => 'ova_dep',
			'post_status' => 'publish',
			'posts_per_page' => $args['total_count'],
			'tax_query' => array(
				array(
					'taxonomy' => 'cat_department',
					'field'    => 'slug',
					'terms'    => $args['category'],
				)
			),
		);
	}

	$args_dep_order = [];
	if( $args['orderby_post'] === 'ova_dep_met_order_dep' ) {
		$args_dep_order = [
			'meta_key' 	=> $args['orderby_post'],
			'orderby' 	=> 'meta_value_num',
			'meta_type' => 'NUMERIC',
			'order'   	=> $args['order_post'],
		];
	} else { 
		$args_dep_order = [
			'orderby' => $args['orderby_post'],
			'order'   => $args['order_post'],
		];
	}

	$args_dep 	= array_merge( $args_new, $args_dep_order );
	$deps  		= new \WP_Query($args_dep);

	return $deps;

}

/**
 * Get icon attachment file
 */
function ova_dep_get_icon_attachment_file( $ext_file = '' ){
	if( $ext_file == '' ) return '<i class="fas fa-file-alt"></i>';

	if( $ext_file === 'docx' || $ext_file === 'doc' ){
		$icon = '<i class="fas fa-file-alt" aria-hidden="true"></i>';
	} elseif( $ext_file === 'jpg' || $ext_file === 'gif' || $ext_file === 'png' ){
		$icon = '<i class="fas fa-file-image" aria-hidden="true"></i>';
	} elseif( $ext_file === 'pdf' ){
		$icon = '<i class="gimonticon gimonticon-pdf-file" aria-hidden="true"></i>';
	} elseif( $ext_file === 'mp4' ){
		$icon = '<i class="fas fa-file-video" aria-hidden="true"></i>';
	} else{
		$icon = '<i class="fas fa-file-alt" aria-hidden="true"></i>';
	}

	return $icon;
}

/**
 * Get file size
 */
function ova_dep_get_file_size( $url_file = '' ){
	if( $url_file === '' ) return;
	$upload_dir = wp_upload_dir();
	$path_upload_full = $upload_dir['path'];

	$path_upload_sub = substr( $path_upload_full, 0, strpos( $path_upload_full, 'wp-content/uploads' ) );


	$position = strpos( $url_file, 'wp-content/uploads' );
	$sub_str = substr( $url_file, $position );
	$path_file = $path_upload_sub . $sub_str;

	$file_size_byte = filesize( $path_file );
	$file_size_kb = $file_size_byte * 0.0009765625;
	$file_size_kb = round( $file_size_kb );

	return $file_size_kb;
}

/**
 * Get files data from ID
 */
function ova_dep_get_name_files( $ID ) {
	$args = array(
	    'post_type' => 'attachment',
	    'p'		=> $ID
	);
	$query = new WP_Query( $args );

	return $query->posts;
}

function ova_dep_custom_text ($content = "",$limit = 15) {

    $content = explode(' ', $content, $limit);

    if (count($content)>=$limit) {
        array_pop($content);
        $content = implode(" ",$content).'...';
    } else {
        $content = implode(" ",$content);
    }

    $content = preg_replace('`[[^]]*]`','',$content);
    
    return strip_tags( $content );
}

// Get all id department
function ova_dep_get_all_id(){
   $all_ids = get_posts( array(
        'post_type'      => 'ova_dep',
        'posts_per_page' => -1,
        'post_status'    => 'publish',
        'fields'         => 'ids',
    ));

    return $all_ids;
}