<?php

if (!defined( 'ABSPATH' )) {
	exit;
}
if (!class_exists( 'Ova_Dir_Customize' )){

	class Ova_Dir_Customize {

		public function __construct() {
			add_action( 'customize_register', array( $this, 'ova_dir_customize_register' ) );
		}

		public function ova_dir_customize_register($wp_customize) {

			$this->ova_dir_init( $wp_customize );

			do_action( 'ova_dir_customize_register', $wp_customize );
		}


		/* Directory */
		public function ova_dir_init( $wp_customize ){

			$wp_customize->add_panel( 'ova_dir_panel', array(
			  	'title' => esc_html__( 'Directory', 'ova-dir' ),
			  	'priority' => 5,
			) );

			$wp_customize->add_section('ova_dir_section', array(
				'title'    => esc_html__('Google Map', 'ova-dir'),
				'panel' => 'ova_dir_panel',
				'priority' => 10,
				'capability' => 'edit_theme_options',
			));

			$wp_customize->add_section( 'ova_dir_archive_section' , array(
				'title'      => esc_html__( 'Archive', 'ova-dir' ),
				'priority'   => 10,
				'panel' => 'ova_dir_panel',
			) );

			$wp_customize->add_section( 'ova_dir_single_section' , array(
				'title'      => esc_html__( 'Single', 'ova-dir' ),
				'priority'   => 10,
				'panel' => 'ova_dir_panel',
			) );

			$wp_customize->add_setting('ova_dir_google_map_api', array(
				'default'        => '',
				'capability'     => 'edit_theme_options',
				'type'           => 'option',
			));

			// Map
			$wp_customize->add_setting( 'ova_dir_use_google_map', array(
				'type' 				=> 'theme_mod', // or 'option'
				'capability' 		=> 'edit_theme_options',
				'theme_supports' 	=> '', // Rarely needed.
				'default' 			=> 'yes',
				'transport' 		=> 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			));

			$wp_customize->add_control('ova_dir_use_google_map', array(
				'label' 	=> esc_html__('Use Google Map','ova-dir'),
				'section' 	=> 'ova_dir_section',
				'settings' 	=> 'ova_dir_use_google_map',
				'type' 		=>'select',
				'choices' 	=> array(
					'yes' 	=> esc_html__( 'Yes', 'ova-dir' ),
					'no' 	=> esc_html__( 'No', 'ova-dir' ),
				)
			));

			$wp_customize->add_control('ova_dir_google_map_api', array(
				'label'      => esc_html__('Google Map Api Key', 'ova-dir'),
				'section'    => 'ova_dir_section',
				'settings'   => 'ova_dir_google_map_api',
				'description' => esc_html__('https://developers.google.com/maps/documentation/javascript/get-api-key','ova-dir'),
			));

			$wp_customize->add_setting( 'ova_dir_single_zoom', array(
				'capability' => 'edit_theme_options',
				'sanitize_callback' => 'sanitize_text_field',
				'default' => 14,
			) );

			$wp_customize->add_control( 'ova_dir_single_zoom', array(
				'type' => 'number',
				'section' => 'ova_dir_section', // Add a default or your own section
				'label' => esc_html__( 'Single Zoom', 'ova-dir' ),
			) );

			$wp_customize->add_setting( 'ova_dir_archive_zoom', array(
				'capability' => 'edit_theme_options',
				'sanitize_callback' => 'sanitize_text_field',
				'default' => 3,
			) );

			$wp_customize->add_control( 'ova_dir_archive_zoom', array(
				'type' => 'number',
				'section' => 'ova_dir_section', // Add a default or your own section
				'label' => esc_html__( 'Archive Zoom', 'ova-dir' ),
			) );

			$wp_customize->add_setting( 'ova_dir_latitude', array(
				'capability' => 'edit_theme_options',
				'sanitize_callback' => 'sanitize_text_field',
				'default' => 39.177972,
			) );

			$wp_customize->add_control( 'ova_dir_latitude', array(
				'type' => 'number',
				'section' => 'ova_dir_section', // Add a default or your own section
				'label' => esc_html__( 'Latitude', 'ova-dir' ),
				) );

			$wp_customize->add_setting( 'ova_dir_longitude', array(
				'capability' => 'edit_theme_options',
				'sanitize_callback' => 'sanitize_text_field',
				'default' => -100.36375,
			) );

			$wp_customize->add_control( 'ova_dir_longitude', array(
				'type' => 'number',
				'section' => 'ova_dir_section', // Add a default or your own section
				'label' => esc_html__( 'Longitude ', 'ova-dir' ),
			) );

			// Archive
			$wp_customize->add_setting( 'ova_dir_total_record', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => 8,
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('ova_dir_total_record', array(
				'label' => esc_html__('Number of posts per page','ova-dir'),
				'section' => 'ova_dir_archive_section',
				'settings' => 'ova_dir_total_record',
				'type' =>'number'
			));

			$wp_customize->add_setting( 'ova_dir_orderby', array(
				'type' 				=> 'theme_mod', // or 'option'
				'capability' 		=> 'edit_theme_options',
				'theme_supports' 	=> '', // Rarely needed.
				'default' 			=> 'ID',
				'transport' 		=> 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			));

			$wp_customize->add_control('ova_dir_orderby', array(
				'label' 	=> esc_html__('Order By','ova-dir'),
				'section' 	=> 'ova_dir_archive_section',
				'settings' 	=> 'ova_dir_orderby',
				'type' 		=>'select',
				'choices' 	=> array(
					'ova_dir_met_order_dir' 	=> esc_html__( 'Sort Order', 'ova-dir' ),
					'ova_dir_met_publish_date' 	=> esc_html__( 'Published Date', 'ova-dir' ),
					'ID' 						=> esc_html__( 'ID', 'ova-dir' ),
					'title' 					=> esc_html__( 'Title', 'ova-dir' ),
					'date' 						=> esc_html__( 'Date', 'ova-dir' ),
					'rand' 						=> esc_html__( 'Random', 'ova-dir' ),
				)
			));

			$wp_customize->add_setting( 'ova_dir_order', array(
				'type' 				=> 'theme_mod', // or 'option'
				'capability' 		=> 'edit_theme_options',
				'theme_supports' 	=> '', // Rarely needed.
				'default' 			=> 'DESC',
				'transport' 		=> 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			));

			$wp_customize->add_control('ova_dir_order', array(
				'label' 	=> esc_html__('Order','ova-dir'),
				'section' 	=> 'ova_dir_archive_section',
				'settings' 	=> 'ova_dir_order',
				'type' 		=>'select',
				'choices' 	=> array(
					'ASC' 	=> esc_html__( 'Ascending', 'ova-dir' ),
					'DESC' 	=> esc_html__( 'Descending', 'ova-dir' ),
				)
			));

			$wp_customize->add_setting( 'ova_dir_layout', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => 'two_column',
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('ova_dir_layout', array(
				'label' => esc_html__('Layout','ova-dir'),
				'section' => 'ova_dir_archive_section',
				'settings' => 'ova_dir_layout',
				'type' =>'select',
				'choices' => array(
					'one_column'  	=> esc_html__( '1 column', 'ova-dir' ),
					'two_column'  	=> esc_html__( '2 column', 'ova-dir' ),
					'three_column' 	=> esc_html__( '3 column', 'ova-dir' ),
				)
			));

			$wp_customize->add_setting( 'ova_dir_archive_sidebar', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => 'right_sidebar',
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('ova_dir_archive_sidebar', array(
				'label' => esc_html__('Sidebar','ova-dir'),
				'section' => 'ova_dir_archive_section',
				'settings' => 'ova_dir_archive_sidebar',
				'type' =>'select',
				'choices' => array(
					'left_sidebar'    	=> esc_html__( 'Left Sidebar', 'ova-dir' ),
					'right_sidebar'    	=> esc_html__( 'Right Sidebar', 'ova-dir' ),
					'no_sidebar'      	=> esc_html__( 'No Sidebar', 'ova-dir' ),
				)
			));

			$wp_customize->add_setting( 'header_archive_dir', array(
			  	'type' => 'theme_mod', // or 'option'
			  	'capability' => 'edit_theme_options',
			  	'theme_supports' => '', // Rarely needed.
			  	'default' => 'default',
			  	'transport' => 'refresh', // or postMessage
			  	'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('header_archive_dir', array(
				'label' => esc_html__('Header','ova-dir'),
				'section' => 'ova_dir_archive_section',
				'settings' => 'header_archive_dir',
				'type' =>'select',
				'choices' => apply_filters('gimont_list_header', '')
			));

			$wp_customize->add_setting( 'archive_footer_dir', array(
			  	'type' => 'theme_mod', // or 'option'
			  	'capability' => 'edit_theme_options',
			  	'theme_supports' => '', // Rarely needed.
			  	'default' => 'default',
			  	'transport' => 'refresh', // or postMessage
			  	'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('archive_footer_dir', array(
				'label' => esc_html__('Footer','ova-dir'),
				'section' => 'ova_dir_archive_section',
				'settings' => 'archive_footer_dir',
				'type' =>'select',
				'choices' => apply_filters('gimont_list_footer', '')
			));

			$wp_customize->add_setting( 'ova_dir_archive_show_map', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => 'yes',
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('ova_dir_archive_show_map', array(
				'label' => esc_html__('Show Map','ova-dir'),
				'section' => 'ova_dir_archive_section',
				'settings' => 'ova_dir_archive_show_map',
				'type' =>'select',
				'choices' => array(
					'yes'	=> esc_html__( 'Yes', 'ova-dir' ),
					'no'	=> esc_html__( 'No', 'ova-dir' ),
				)
			));

			$wp_customize->add_setting( 'ova_dir_archive_show_image', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => 'yes',
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('ova_dir_archive_show_image', array(
				'label' => esc_html__('Show Image','ova-dir'),
				'section' => 'ova_dir_archive_section',
				'settings' => 'ova_dir_archive_show_image',
				'type' =>'select',
				'choices' => array(
					'yes'	=> esc_html__( 'Yes', 'ova-dir' ),
					'no'	=> esc_html__( 'No', 'ova-dir' ),
				)
			));

			$wp_customize->add_setting( 'ova_dir_archive_show_title', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => 'yes',
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('ova_dir_archive_show_title', array(
				'label' => esc_html__('Show Title','ova-dir'),
				'section' => 'ova_dir_archive_section',
				'settings' => 'ova_dir_archive_show_title',
				'type' =>'select',
				'choices' => array(
					'yes'	=> esc_html__( 'Yes', 'ova-dir' ),
					'no'	=> esc_html__( 'No', 'ova-dir' ),
				)
			));

			$wp_customize->add_setting( 'ova_dir_archive_show_location', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => 'yes',
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('ova_dir_archive_show_location', array(
				'label' => esc_html__('Show Location','ova-dir'),
				'section' => 'ova_dir_archive_section',
				'settings' => 'ova_dir_archive_show_location',
				'type' =>'select',
				'choices' => array(
					'yes'	=> esc_html__( 'Yes', 'ova-dir' ),
					'no'	=> esc_html__( 'No', 'ova-dir' ),
				)
			));

			$wp_customize->add_setting( 'ova_dir_archive_show_category', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => 'yes',
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('ova_dir_archive_show_category', array(
				'label' => esc_html__('Show Category','ova-dir'),
				'section' => 'ova_dir_archive_section',
				'settings' => 'ova_dir_archive_show_category',
				'type' =>'select',
				'choices' => array(
					'yes'	=> esc_html__( 'Yes', 'ova-dir' ),
					'no'	=> esc_html__( 'No', 'ova-dir' ),
				)
			));

			$wp_customize->add_setting( 'ova_dir_archive_show_link_to', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => 'yes',
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('ova_dir_archive_show_link_to', array(
				'label' => esc_html__('Show Link to Detail','ova-dir'),
				'section' => 'ova_dir_archive_section',
				'settings' => 'ova_dir_archive_show_link_to',
				'type' =>'select',
				'choices' => array(
					'yes'	=> esc_html__( 'Yes', 'ova-dir' ),
					'no'	=> esc_html__( 'No', 'ova-dir' ),
				)
			));

			// Single
			$wp_customize->add_setting( 'ova_dir_single_sidebar', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => 'right_sidebar',
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('ova_dir_single_sidebar', array(
				'label' => esc_html__('Sidebar','ova-dir'),
				'section' => 'ova_dir_single_section',
				'settings' => 'ova_dir_single_sidebar',
				'type' =>'select',
				'choices' => array(
					'left_sidebar'    	=> esc_html__( 'Left Sidebar', 'ova-dir' ),
					'right_sidebar'    	=> esc_html__( 'Right Sidebar', 'ova-dir' ),
					'no_sidebar'      	=> esc_html__( 'No Sidebar', 'ova-dir' ),
				)
			));

			$wp_customize->add_setting( 'header_single_dir', array(
			  	'type' => 'theme_mod', // or 'option'
			  	'capability' => 'edit_theme_options',
			  	'theme_supports' => '', // Rarely needed.
			  	'default' => 'default',
			  	'transport' => 'refresh', // or postMessage
			  	'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('header_single_dir', array(
				'label' => esc_html__('Header','ova-dir'),
				'section' => 'ova_dir_single_section',
				'settings' => 'header_single_dir',
				'type' =>'select',
				'choices' => apply_filters('gimont_list_header', '')
			));

			$wp_customize->add_setting( 'single_footer_dir', array(
			  	'type' => 'theme_mod', // or 'option'
			  	'capability' => 'edit_theme_options',
			  	'theme_supports' => '', // Rarely needed.
			  	'default' => 'default',
			  	'transport' => 'refresh', // or postMessage
			  	'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('single_footer_dir', array(
				'label' => esc_html__('Footer','ova-dir'),
				'section' => 'ova_dir_single_section',
				'settings' => 'single_footer_dir',
				'type' =>'select',
				'choices' => apply_filters('gimont_list_footer', '')
			));

			$wp_customize->add_setting( 'ova_dir_single_show_image', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => 'yes',
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('ova_dir_single_show_image', array(
				'label' => esc_html__('Show Image','ova-dir'),
				'section' => 'ova_dir_single_section',
				'settings' => 'ova_dir_single_show_image',
				'type' =>'select',
				'choices' => array(
					'yes'	=> esc_html__( 'Yes', 'ova-dir' ),
					'no'	=> esc_html__( 'No', 'ova-dir' ),
				)
			));

			$wp_customize->add_setting( 'ova_dir_single_show_content', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => 'yes',
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('ova_dir_single_show_content', array(
				'label' => esc_html__('Show Content','ova-dir'),
				'section' => 'ova_dir_single_section',
				'settings' => 'ova_dir_single_show_content',
				'type' =>'select',
				'choices' => array(
					'yes'	=> esc_html__( 'Yes', 'ova-dir' ),
					'no'	=> esc_html__( 'No', 'ova-dir' ),
				)
			));

			$wp_customize->add_setting( 'ova_dir_single_show_contact_title', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => 'yes',
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('ova_dir_single_show_contact_title', array(
				'label' => esc_html__('Show Contact Title','ova-dir'),
				'section' => 'ova_dir_single_section',
				'settings' => 'ova_dir_single_show_contact_title',
				'type' =>'select',
				'choices' => array(
					'yes'	=> esc_html__( 'Yes', 'ova-dir' ),
					'no'	=> esc_html__( 'No', 'ova-dir' ),
				)
			));

			$wp_customize->add_setting( 'ova_dir_single_show_contact', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => 'yes',
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('ova_dir_single_show_contact', array(
				'label' => esc_html__('Show Contact','ova-dir'),
				'section' => 'ova_dir_single_section',
				'settings' => 'ova_dir_single_show_contact',
				'type' =>'select',
				'choices' => array(
					'yes'	=> esc_html__( 'Yes', 'ova-dir' ),
					'no'	=> esc_html__( 'No', 'ova-dir' ),
				)
			));

			$wp_customize->add_setting( 'ova_dir_single_show_share', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => 'yes',
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('ova_dir_single_show_share', array(
				'label' => esc_html__('Show Share','ova-dir'),
				'section' => 'ova_dir_single_section',
				'settings' => 'ova_dir_single_show_share',
				'type' =>'select',
				'choices' => array(
					'yes'	=> esc_html__( 'Yes', 'ova-dir' ),
					'no'	=> esc_html__( 'No', 'ova-dir' ),
				)
			));

			$wp_customize->add_setting( 'ova_dir_single_show_map', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => 'yes',
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('ova_dir_single_show_map', array(
				'label' => esc_html__('Show Map','ova-dir'),
				'section' => 'ova_dir_single_section',
				'settings' => 'ova_dir_single_show_map',
				'type' =>'select',
				'choices' => array(
					'yes'	=> esc_html__( 'Yes', 'ova-dir' ),
					'no'	=> esc_html__( 'No', 'ova-dir' ),
				)
			));

			$wp_customize->add_setting( 'ova_dir_single_show_opening_hours', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => 'yes',
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('ova_dir_single_show_opening_hours', array(
				'label' => esc_html__('Show Opening hours','ova-dir'),
				'section' => 'ova_dir_single_section',
				'settings' => 'ova_dir_single_show_opening_hours',
				'type' =>'select',
				'choices' => array(
					'yes'	=> esc_html__( 'Yes', 'ova-dir' ),
					'no'	=> esc_html__( 'No', 'ova-dir' ),
				)
			));

			$wp_customize->add_setting( 'ova_dir_single_show_gallery', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => 'yes',
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('ova_dir_single_show_gallery', array(
				'label' => esc_html__('Show Gallery','ova-dir'),
				'section' => 'ova_dir_single_section',
				'settings' => 'ova_dir_single_show_gallery',
				'type' =>'select',
				'choices' => array(
					'yes'	=> esc_html__( 'Yes', 'ova-dir' ),
					'no'	=> esc_html__( 'No', 'ova-dir' ),
				)
			));

			$wp_customize->add_setting( 'ova_dir_single_show_category', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => 'yes',
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('ova_dir_single_show_category', array(
				'label' => esc_html__('Show Category','ova-dir'),
				'section' => 'ova_dir_single_section',
				'settings' => 'ova_dir_single_show_category',
				'type' =>'select',
				'choices' => array(
					'yes'	=> esc_html__( 'Yes', 'ova-dir' ),
					'no'	=> esc_html__( 'No', 'ova-dir' ),
				)
			));

			$wp_customize->add_setting( 'ova_dir_single_show_tags', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => 'yes',
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('ova_dir_single_show_tags', array(
				'label' => esc_html__('Show Tags','ova-dir'),
				'section' => 'ova_dir_single_section',
				'settings' => 'ova_dir_single_show_tags',
				'type' =>'select',
				'choices' => array(
					'yes'	=> esc_html__( 'Yes', 'ova-dir' ),
					'no'	=> esc_html__( 'No', 'ova-dir' ),
				)
			));

			$wp_customize->add_setting( 'ova_dir_comments', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => 'yes',
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('ova_dir_comments', array(
				'label' => esc_html__('Show Comments','ova-dir'),
				'section' => 'ova_dir_single_section',
				'settings' => 'ova_dir_comments',
				'type' =>'select',
				'choices' => array(
					'yes'	=> esc_html__( 'Yes', 'ova-dir' ),
					'no'	=> esc_html__( 'No', 'ova-dir' ),
				)
			));

		}

	}

}

new Ova_Dir_Customize();