<?php if ( !defined( 'ABSPATH' ) ) exit();

	global $post;
	
	$id = get_the_ID();

	$dir_title 	= $args['dir_title'];

	$args = array(
		'taxonomy' 	=> 'cat_dir',
		'orderby' 	=> 'name',
		'order'   	=> 'ASC',
		'hide_empty' => false,
		'parent' => 0,
	);

	$terms = get_the_terms( $post, 'cat_dir' );
	$term_ids = [];

	if ( $terms ) {
		foreach ($terms as $key => $term) {
			array_push( $term_ids, $term->term_id );
		}
	}

	$categories = get_categories($args);
	$term_id 	= get_queried_object_id();

?>

<div class="ova-dir-category">
	<?php if($dir_title != '') { ?>
		<h2 class="title">
			<?php echo esc_html( $dir_title ); ?>
		</h2>
	<?php } ?>

	<ul class="directory-cat-list">
		<?php if ( $categories ): ?>
			<?php foreach ($categories as $category): 
				$active_class = $category->term_id == $term_id ? 'active' : '';
				if ( $id ) {
					$active_class = in_array( $category->term_id, $term_ids) ? 'active' : '';
				}
			?>
				<li class="item">
					<a href="<?php echo esc_url( get_term_link( $category ) ); ?>"
						class="item-link <?php echo esc_attr( $active_class ); ?>"
						data-slug="<?php echo esc_attr( $category->slug ); ?>"
						title="<?php echo esc_attr( $category->name ); ?>"
					>
						<span class="cate_name">
							<?php echo esc_html( $category->name ); ?>
						</span>
						<?php if (get_term_children( $category->term_id, 'cat_dir' ) ): ?>
							<i class="fas fa-plus" role="button" aria-label="<?php esc_attr_e('Category Dropdown','ova-dir'); ?>"></i>
						<?php endif; ?>	
					</a>

					<?php ova_dir_get_child_cate( $category->term_id, $term_ids ); ?>
				</li>
			<?php endforeach; ?>
		<?php endif; ?>
	</ul>
</div>