jQuery(document).ready(function($) {

    /* Document Filter */
    $(document).on("submit",".ova-doc-archive #ova-doc-filter",function(e){
        e.preventDefault();

        var cateName        = $(this).find("#ovadoc_name").val();
        var publishedDate   = $(this).find("#ovadoc_date").val();
        var cateSlug        = $(this).find("#ovadoc_category").val();
       
        var docContent  = $(".ova-doc-content .content_inner");
        var loader      = $(".ova-doc-content .doc_loader");

        var args_show   = docContent.data('args_show');
        var formData    = {cate_name:cateName, published_date:publishedDate, cate_slug:cateSlug};

        docContent.addClass("overlay");
        loader.addClass("is-active");

        $('html, body').animate({
            scrollTop: $(".ova-doc-content").offset().top
        });

        $.ajax({
            type: "post",
            dataType: "html",
            url: ova_doc_ajax_object.ajax_url,
            data: {
                action: 'ova_doc_filter_ajax',
                form_data: formData,
                args_show: args_show
            },
            success: function(response){
                docContent.removeClass("overlay");
                docContent.html(response);
                loader.removeClass("is-active");
            }
        });
    } );
    
    /* Document Category */
    $(document).on('click', ".ova-doc-archive .ova-doc-category .item-link", function (e) {
        e.preventDefault();
        e.stopPropagation();

        var cateLink    = $(".ova-doc-archive .ova-doc-category .item-link");
        var cateItem    = $(".ova-doc-archive .ova-doc-category .item");
        var docContent  = $(".ova-doc-content .content_inner");
        var loader      = $(".ova-doc-content .doc_loader");

        var args_show   = docContent.data('args_show');
        var cateSlug    = $(this).attr("data-slug");

        cateLink.removeClass("active");
        $(this).addClass("active");

        docContent.addClass("overlay");
        loader.addClass("is-active");

        $('html, body').animate({
            scrollTop: $(".ova-doc-content").offset().top
        });

        $.ajax({
            type: "post",
            dataType: "html",
            url: ova_doc_ajax_object.ajax_url,
            data: {
                action: 'ova_show_doc_list',
                slug: cateSlug,
                args_show: args_show
            },
            success: function(response){
                docContent.removeClass("overlay");
                docContent.html(response);
                loader.removeClass("is-active");
            }
        });
    });

    /* Document Category Click Icon "+" to Show Child Category */
    $(document).on('click', ".ova-doc-archive .ova-doc-category .item-link i", function (e) {
        e.preventDefault();
        e.stopPropagation();
        var cateChild = $(this).parent().next();
        if ( $(this).attr("class") == "fas fa-plus" ) {
            $(this).attr("class", "fas fa-minus");
        } else {
            $(this).attr("class", "fas fa-plus");
        }
        cateChild.slideToggle();
    });

    /* Document Pagination */
    $(document).on('click', ".ova_doc_pagination_ajax .page-numbers", function (e) {    
        e.preventDefault();

        var dataArgs = $(document).find(".ova_doc_pagination_ajax").attr("data-args");
        var args     = JSON.parse( dataArgs );
        var offset   = parseInt( $(this).attr("data-offset") );
        var page     = parseInt( $(this).attr("data-page") );

        var docContent = $(".ova-doc-content .content_inner");
        var loader     = $(".ova-doc-content .doc_loader");

        var args_show  = docContent.data('args_show');

        if (page) {
            docContent.addClass("overlay");
            loader.addClass("is-active");

            $('html, body').animate({
                scrollTop: $(".ova-doc-content").offset().top
            });

            $.ajax({
                type: "post",
                dataType: "html",
                url: ova_doc_ajax_object.ajax_url,
                data: {
                    action: 'ova_doc_pagination_ajax',
                    args: args,
                    offset: offset,
                    page: page,
                    args_show: args_show
                },
                success: function(response){
                    docContent.removeClass("overlay");
                    docContent.html(response);
                    loader.removeClass("is-active");
                }
            });
        }
    });
    
    /* Caleran init */
    if ( $(".ova-doc-archive .ova-doc-filter").length > 0 ) {
        var locale       = $('.ova-doc-filter .date-control').data('locale');
        var rangeLabel   = $('.ova-doc-filter .date-control').data('range_label');
        var ranges_title = $('.ova-doc-filter .date-control').data('ranges_title');

        $("#ovadoc_date").caleran(
            {
                startEmpty: true,
                locale: locale,
                rangeLabel: rangeLabel,
                ranges:[
                    {
                        title:ranges_title[0],
                        startDate:moment(),
                        endDate:moment()
                    },
                    {
                        title:ranges_title[1],
                        startDate:moment(),
                        endDate:moment().add(2,"days")
                    },
                    {
                        title:ranges_title[2],
                        startDate:moment(),
                        endDate:moment().add(4,"days")
                    },
                    {
                        title:ranges_title[3],
                        startDate:moment(),
                        endDate:moment().add(6,"days")
                    },
                    {
                        title:ranges_title[4],
                        startDate:moment(),
                        endDate:moment().endOf("week")
                    },
                    {
                        title:ranges_title[5],
                        startDate:moment(),
                        endDate:moment().endOf("month")
                    }
                ]
            }
        );
    };

    /* Select2*/
    if ($('.ovadoc_cat').length > 0) {
        $('.ovadoc_cat').select2({
            language: {
                inputTooShort: function() {
                    return Select2Text.input_short;
                },
                noResults: function (params) {
                  return Select2Text.no_results;
                }
            }
        });
    };


    /* Auto completed name - search form archive */
    var data_names = $('.ova-doc-archive').data('names');

    var data = [];
    for(var id in data_names){
        var child_data = {"id": id, "text": data_names[id]};
        data.push(child_data);
    }

    /* select 2*/
    if ($('.ova-doc-archive .ovadoc_name').length > 0) {
        $('.ova-doc-archive .ovadoc_name').select2({
            data: data,
            minimumInputLength: 1,
            maximumSelectionSize: 1,
            width: '100%',
            multiple: false,
            placeholder: Placeholder.name,
            language: {
                inputTooShort: function() {
                    return Select2Text.input_short;
                },
                noResults: function (params) {
                  return Select2Text.no_results;
                }
            }
        });
    }

    $('.ova-doc-archive .ovadoc_name').on('change', function(e){
        e.preventDefault();
        var value = $(this).find("option:selected").text();
        $(this).val(value);
        $(this).find('option:selected').prop("selected", false);
    });

    
});