<?php
namespace ova_doc_elementor\Widgets;

use Elementor\Widget_Base;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class ova_document_ajax extends Widget_Base {

	public function get_name() {
		return 'ova_document_ajax';
	}

	public function get_title() {
		return esc_html__( 'Document Ajax', 'ova-doc' );
	}

	public function get_icon() {
		return 'eicon-search-results';
	}

	public function get_categories() {
		return [ 'ovatheme_doc' ];
	}

	public function get_script_depends() {
		wp_enqueue_script('ova_doc_caleran_hammer', OVADOC_PLUGIN_URI . 'assets/libs/caleran/vendor/jquery.hammer.js', array('jquery'), false, true);
		wp_enqueue_script('ova_doc_caleran_moment', OVADOC_PLUGIN_URI . 'assets/libs/caleran/vendor/moment.min.js', array('jquery'), false, true);
		wp_enqueue_style( 'ova_doc_caleran', OVADOC_PLUGIN_URI.'assets/libs/caleran/css/caleran.min.css' );
		wp_enqueue_script('ova_doc_caleran_js', OVADOC_PLUGIN_URI . 'assets/libs/caleran/js/caleran.min.js', array('jquery'), false, true);
		
		wp_enqueue_style( 'ova_doc_select2', OVADOC_PLUGIN_URI.'assets/libs/select2/select2.min.css', array(), null );
		wp_enqueue_script( 'ova_doc_select2', OVADOC_PLUGIN_URI.'assets/libs/select2/select2.min.js', array('jquery'), false, true );

		wp_enqueue_script('ovadoc_script', OVADOC_PLUGIN_URI . 'assets/js/ova-doc.js', array('jquery'), false, true);	
		wp_localize_script( 'ovadoc_script', 'Placeholder', array('name' => esc_html__( 'Name', 'ova-doc' )) );

		wp_enqueue_script('ova_show_doc_script', OVADOC_PLUGIN_URI . 'assets/js/show-document.js', array('jquery'), false, true);
		wp_localize_script( 'ova_show_doc_script', 'ova_doc_ajax_object', array( 'ajax_url' => admin_url( 'admin-ajax.php' ) ) );	
		
		return [ '' ];
	}

	public function get_style_depends() {
		wp_enqueue_style( 'ovadoc-ajax', OVADOC_PLUGIN_URI.'assets/css/elementor/ova-doc-ajax.css' );
		wp_enqueue_style( 'ovadoc-category', OVADOC_PLUGIN_URI.'assets/css/elementor/ova-doc-category.css' );
		wp_enqueue_style( 'ova_show_doc_style', OVADOC_PLUGIN_URI.'assets/css/frontend/show-document.css' );		
		return [];
	}

	protected function register_controls() {

		/*Content*/
		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__( 'Content', 'ova-doc' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

			$this->add_control(
				'doc_title',
				[
					'label' => esc_html__( 'Title', 'ova-doc' ),
					'type' => \Elementor\Controls_Manager::TEXT,
					'default' => esc_html__( 'All Categories', 'ova-doc' ),
					'label_block' => true,
				]
			);

			$this->add_control(
				'number_column',
				[
					'label' => esc_html__( 'Number Column', 'ova-doc' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'default' => 'two_column',
					'options' => [
						'one_column' => esc_html__( '1 Column', 'ova-doc' ),
						'two_column' => esc_html__( '2 Columns', 'ova-doc' ),
						'three_column' => esc_html__( '3 Columns', 'ova-doc' ),
					],
				]
			);

			$this->add_control(
				'posts_per_page',
				[
					'label'   		=> esc_html__( 'Posts Per Page', 'ova-doc' ),
					'type'    		=> \Elementor\Controls_Manager::NUMBER,
					'default'       => 6
				]
			);

			$this->add_control(
				'order',
				[
					'label' => esc_html__( 'Order', 'ova-doc' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'default' => 'ASC',
					'options' => [
						'ASC' => esc_html__( 'Ascending', 'ova-doc' ),
						'DESC' => esc_html__( 'Descending', 'ova-doc' ),
					],
				]
			);

			$this->add_control(
				'orderby',
				[
					'label' => esc_html__( 'Order By', 'ova-doc' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'default' => 'title',
					'options' => [
						'ID'  	=> esc_html__( 'ID', 'ova-doc' ),
						'date'  => esc_html__( 'Date', 'ova-doc' ),
						'title' => esc_html__( 'Title', 'ova-doc' ),
						'rand'  => esc_html__( 'Random', 'ova-doc' ),
						'ova_sev_met_order_sev' => esc_html__( 'Sort Order', 'ova-doc' ),
					],
				]
			);
		
			$this->add_control(
				'category_not_in',
				[
					'label'   		=> esc_html__( 'Category Not In', 'ova-doc' ),
					'type'    		=> \Elementor\Controls_Manager::TEXT,
					'description' 	=> esc_html__( 'Enter the service category IDs. IDs are separated by "|". Ex: 1|2|3.', 'ova-doc' ),
				]
			);

			$this->add_control(
				'show_sidebar',
				[
					'label' => esc_html__( 'Show Sidebar', 'ova-doc' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'ova-doc' ),
					'label_off' => esc_html__( 'Hide', 'ova-doc' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);

			$this->add_control(
				'show_view_icon',
				[
					'label' => esc_html__( 'Show View Icon', 'ova-doc' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'ova-doc' ),
					'label_off' => esc_html__( 'Hide', 'ova-doc' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);

			$this->add_control(
				'show_download_icon',
				[
					'label' => esc_html__( 'Show Download Icon', 'ova-doc' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'ova-doc' ),
					'label_off' => esc_html__( 'Hide', 'ova-doc' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);

			$this->add_control(
				'show_date',
				[
					'label' => esc_html__( 'Show Date', 'ova-doc' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'ova-doc' ),
					'label_off' => esc_html__( 'Hide', 'ova-doc' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);

			$this->add_control(
				'show_title',
				[
					'label' => esc_html__( 'Show Title', 'ova-doc' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'ova-doc' ),
					'label_off' => esc_html__( 'Hide', 'ova-doc' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);

			$this->add_control(
				'show_link_to',
				[
					'label' => esc_html__( 'Show Link of Title', 'ova-doc' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'ova-doc' ),
					'label_off' => esc_html__( 'Hide', 'ova-doc' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);

		$this->end_controls_section();

		$this->start_controls_section(
			'search_form_section',
			[
				'label' => esc_html__( 'Search Form', 'ova-doc' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

			$this->add_control(
				'show_search_name',
				[
					'label' => esc_html__( 'Show Name', 'ova-doc' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'ova-doc' ),
					'label_off' => esc_html__( 'Hide', 'ova-doc' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);

			$this->add_control(
				'show_search_date',
				[
					'label' => esc_html__( 'Show Published Date', 'ova-doc' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'ova-doc' ),
					'label_off' => esc_html__( 'Hide', 'ova-doc' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);

			$this->add_control(
				'show_search_category',
				[
					'label' => esc_html__( 'Show Category', 'ova-doc' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'ova-doc' ),
					'label_off' => esc_html__( 'Hide', 'ova-doc' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);

		$this->end_controls_section();

	}


	protected function render() {
		$settings = $this->get_settings_for_display();
		$template = apply_filters( 'el_elementor_ova_document_ajax', 'elementor/ova_document_ajax.php' );

		ob_start();
		ovadoc_get_template( $template, $settings );
		echo ob_get_clean();
	}
}
