<?php if ( !defined( 'ABSPATH' ) ) exit();

global $post;

$id = get_the_ID();

$category_not_in = isset($args['category_not_in']) ? $args['category_not_in'] : '';

$args_cat_query = array(
	'taxonomy' 	 => 'cat_doc',
	'orderby' 	 => 'name',
	'order'   	 => 'ASC',
	'hide_empty' => false,
	'parent' 	 => 0,
	'exclude'    => explode( '|', $category_not_in )
);

$terms 		= get_the_terms( $post, 'cat_doc' );
$term_ids 	= [];

if ( $terms ) {
	foreach ($terms as $key => $term) {
		array_push( $term_ids, $term->term_id );
	}
}

$categories = get_categories($args_cat_query);
$term_id 	= get_queried_object_id();

?>

<div class="ova-doc-category">
	<h2 class="title">
		<?php echo esc_html( $doc_title ); ?>	
	</h2>
	
	<ul class="document-cat-list">
		<?php if ( $categories ): ?>
			<?php foreach ($categories as $category): ?>
				<?php
					$active_class = $category->term_id == $term_id ? 'active' : '';
					if ( $id ) {
						$active_class = in_array( $category->term_id, $term_ids) ? 'active' : '';
					}
				?>
				<li class="item">
					<a href="<?php echo esc_url( get_term_link( $category ) ); ?>"
						class="item-link <?php echo esc_attr( $active_class ); ?>"
						data-slug="<?php echo esc_attr( $category->slug ); ?>"
						title="<?php echo esc_attr( $category->name ); ?>"
					>
						<span class="cate_name"><?php echo esc_html( $category->name ); ?></span>
						<?php if (get_term_children( $category->term_id, 'cat_doc' ) ): ?>
							<i class="fas fa-plus" aria-hidden="true"></i>
						<?php endif; ?>	
					</a>
					<?php ova_doc_get_child_cate( $category->term_id, $term_ids ); ?>
				</li>
			<?php endforeach; ?>
		<?php endif; ?>
	</ul>
</div>