<?php if ( !defined( 'ABSPATH' ) ) exit();

$cate_slug  = 'all';

$args_query = array(
	'order_by' 			=> $orderby,
	'order' 			=> $order,
	'posts_per_page' 	=> $posts_per_page,
	'cate' 				=> $cate_slug,
);

$documents = ova_doc_query( $args_query );

// show fields
$args_show = array(
	'show_date' 		 	=> $show_date,
	'show_title' 		 	=> $show_title,
	'show_link_to' 	     	=> $show_link_to,
	'show_view_icon' 	 	=> $show_view_icon,
	'show_download_icon' 	=> $show_download_icon,
);


$category_not_in = isset($args['category_not_in']) ? $args['category_not_in'] : '';

$args_cat_query = array(
	'taxonomy' 	 => 'cat_doc',
	'orderby' 	 => 'name',
	'order'   	 => 'ASC',
	'hide_empty' => false,
	'parent' 	 => 0,
	'exclude'    => explode( '|', $category_not_in )
);

$terms 		= get_the_terms( $documents, 'cat_doc' );
$term_ids 	= [];

if ( $terms ) {
	foreach ($terms as $key => $term) {
		array_push( $term_ids, $term->term_id );
	}
}

$categories = get_categories($args_cat_query);
$term_id 	= get_queried_object_id();

// get document list names
$all_ids   = ova_doc_get_all_id();
$all_names = [];

foreach ($all_ids as $id ) {
	$all_names[$id] = get_the_title($id);
}

// caleran config
$range_label  = esc_html__('Ranges:','ova-doc');
$ranges_title = array(
	esc_html__('Today','ova-doc'),
	esc_html__('3 Days','ova-doc'),
	esc_html__('5 Days','ova-doc'),
	esc_html__('1 Week','ova-doc'),
	esc_html__('Till Next Week','ova-doc'),
	esc_html__('Till Next Month','ova-doc'),
);

?>

<div class="ova-doc-archive ova-document-ajax <?php printf( '%1$s', $number_column ); ?>" data-names="<?php echo esc_attr(json_encode($all_names)); ?>">

	<?php if($show_sidebar == 'yes') : ?>
		<div class="ova-doc-category">
			<?php if( !empty($doc_title) ) : ?>
				<h2 class="title">
					<?php echo esc_html( $doc_title ); ?>
				</h2>
			<?php endif; ?>

			<ul class="document-cat-list">
				<?php if ( $categories ): foreach ($categories as $category):
					$active_class = $category->term_id == $term_id ? 'active' : '';
					if ( $id ) {
						$active_class = in_array( $category->term_id, $term_ids) ? 'active' : '';
					}
				?>
					<li class="item">
						<a href="<?php echo esc_url( get_term_link( $category ) ); ?>"
							class="item-link <?php echo esc_attr( $active_class ); ?>"
							data-slug="<?php echo esc_attr( $category->slug ); ?>"
							title="<?php echo esc_attr( $category->name ); ?>"
						>
						<span class="cate_name">
							<?php echo esc_html( $category->name ); ?>
						</span>
						<?php if (get_term_children( $category->term_id, 'cat_doc' ) ): ?>
							<i class="fas fa-plus" aria-hidden="true"></i>
						<?php endif; ?>	
						</a>
						<?php ova_doc_get_child_cate( $category->term_id, $term_ids ); ?>
					</li>
				<?php endforeach; endif; ?>
			</ul>
		</div>
	<?php endif; ?>

	<div class="ova-doc-content">
		<?php if($show_search_name == 'yes' || $show_search_date == 'yes' || $show_search_category == 'yes' ) : ?>
			<form id="ova-doc-filter" class="ova-doc-filter" method="POST" autocomplete="off">
				<div class="wrapper">
					<?php if($show_search_name == 'yes' ) : ?>
						<div class="form-control name_control">
							<label for="name"><?php esc_html_e( 'Name', 'ova-doc' ); ?></label>
							<input type="text" name="s" class="ovadoc_name" id="ovadoc_name">
						</div>
					<?php endif; ?>

					<?php if($show_search_date == 'yes' ) : ?>
						<div class="form-control">
							<label for="date">
								<?php esc_html_e( 'Published Date', 'ova-doc' ); ?>
							</label>
							<div class="date-control" data-locale="<?php echo esc_attr( get_locale() );?>"
								data-range_label="<?php echo esc_attr($range_label);?>"
								data-ranges_title="<?php echo esc_attr(json_encode($ranges_title));?>"
							>
								<input type="text" name="date" id="ovadoc_date">
								<div class="icon">
									<i class="far fa-calendar-alt" aria-hidden="true"></i>
								</div>
							</div>
						</div>
					<?php endif; ?>

					<?php if($show_search_category == 'yes' ) : ?>
						<div class="form-control">
							<label for="category">
								<?php esc_html_e( 'Category', 'ova-doc' ); ?>	
							</label>
							<?php $ovadoc_cat_dropdown = apply_filters( 'ovadoc_cat_dropdown', $cate_slug ); ?>
						</div>
					<?php endif; ?>

					<div class="form-control">
						<button type="submit" class="ova-doc-submit">
							<?php esc_html_e( 'Find Document', 'ova-doc' ); ?>	
						</button>
					</div>
				</div>
			</form>
		<?php endif; ?>

		<span class="loader doc_loader"></span>

		<div class="content_inner" data-args_show="<?php echo esc_attr( json_encode($args_show) );?>">
			<?php
				$total_pages 	= $documents->max_num_pages;
				$curent_page 	= 1;
				ob_start();
				ova_get_doc_list( $documents, 'all', $args_show );
				ova_doc_pagination_ajax($total_pages,$curent_page,$posts_per_page,$args_query);
				echo ob_get_clean();
			?>
		</div>
	</div>

	<div class="ova-doc-modal"></div>
</div>