<?php if ( !defined( 'ABSPATH' ) ) exit();
	get_header( );

	global $post;

	$id 			= get_the_ID();
	$sidebar		= get_theme_mod( 'ova_doc_single_sidebar', 'left_sidebar' );
	$list_document 	= get_post_meta( $id, 'ova_doc_met_list_document', true );
	$terms 			= get_the_terms( $post, 'cat_doc' );
	$published_date = get_post_meta( $id, 'ova_doc_met_publish_date', true);

	$show_date     = get_theme_mod( 'ova_doc_single_show_date', 'yes' ); 
	$show_category = get_theme_mod( 'ova_doc_single_show_category', 'yes' ); 
	$show_title    = get_theme_mod( 'ova_doc_single_show_title', 'yes' ); 
	$show_content  = get_theme_mod( 'ova_doc_single_show_content', 'yes' ); 
	$show_files    = get_theme_mod( 'ova_doc_single_show_files', 'yes' ); 
	$show_share    = get_theme_mod( 'ova_doc_single_show_share', 'yes' ); 
	$show_comments = get_theme_mod( 'ova_doc_comments', 'yes' ); 

?>

<div class="ova-doc-single">
	<div class="row_site">
		<div class="container_site">
			<div class="ova-doc-wrapper <?php printf( 'single_%1$s', $sidebar ); ?>">

				<?php if ( $sidebar == 'left_sidebar' && is_active_sidebar( 'ova-doc-sidebar' ) ) { ?>
					<div class="ova-doc-sidebar-wrapper">
						<div class="ova-doc-sidebar">
							<?php dynamic_sidebar('ova-doc-sidebar'); ?>
						</div>
					</div>
				<?php } ?>

				<div class="ova-doc-content">

					<?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>

						<div class="entry">
							<?php if ( $published_date && $show_date == 'yes' ): ?>
								<span class="date">
									<?php echo esc_html( date_i18n( 'F d, Y', $published_date ) ); ?>
								</span>
							<?php endif; ?>

							<?php if ( $show_date == 'yes' && $show_category == 'yes' ): ?>
								<span class="separator">
									<?php echo esc_html__( '-', 'ova-doc' ); ?>
								</span>
							<?php endif; ?>
							
							<?php if ( $terms && $show_category == 'yes' ) :
								$cate_links = array();
								foreach ($terms as $cate) {
									array_push( $cate_links, '<a href="'.esc_url( get_term_link( $cate ) ).'" title="'.esc_attr( get_the_title($id) ).'">'.esc_html( $cate->name ).'</a>' );
								}
							?>
								<p class="categories"><?php printf( implode(", ",$cate_links) ); ?></p>
							<?php endif; ?>
						</div>

						<?php if ( $show_title == 'yes' ): ?>
							<h2 class="title">
								<?php the_title(); ?>	
							</h2>
						<?php endif; ?>

						<?php if ( $show_content == 'yes' ): ?>
							<div class="content">
								<?php the_content(); ?>
							</div>
						<?php endif; ?>

						<?php if( ! empty( $list_document ) && $show_files == 'yes' ){ ?>
							<div class="attachment-file">
								<h2 class="title"><?php esc_html_e( 'Attachments', 'ova-doc' ); ?></h2>
								<?php ova_get_file_list( $id ); ?>
							</div>
						<?php } ?>

					<?php endwhile; endif; wp_reset_postdata(); ?>

					<?php if( has_filter( 'ova_share_social' ) && $show_share == 'yes' ){ 
						apply_filters( 'ova_share_social', get_the_permalink(), get_the_title() );
			        } ?>

			        <?php
				        if ( $show_comments == 'yes' ) {
				        	if( comments_open( get_the_ID() ) ) {
					        	comments_template(); 
					        }
				        }
			        ?>
				</div>

				<?php if ( $sidebar == 'right_sidebar' && is_active_sidebar( 'ova-doc-sidebar' ) ) { ?>
					<div class="ova-doc-sidebar-wrapper">
						<div class="ova-doc-sidebar">
							<?php dynamic_sidebar('ova-doc-sidebar'); ?>
						</div>
					</div>
				<?php } ?>

			</div>
		</div>
	</div>
</div>

<?php get_footer( );