<?php
namespace ova_ovaev_elementor\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


class ova_event_info extends Widget_Base {

	public function get_name() {		
		return 'ova_event_info';
	}

	public function get_title() {
		return esc_html__( 'Event Info', 'ovaev' );
	}

	public function get_icon() {
		return 'eicon-info';
	}

	public function get_categories() {
		return [ 'ovaev_template' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'section_info',
			[
				'label' => esc_html__( 'Content', 'ovaev' ),
			]
		);

		    $this->add_control(
				'time_format',
				[
					'label' 	=> esc_html__( 'Time Format', 'ovaev' ),
					'type' 		=> Controls_Manager::SELECT,
					'options' 	=> [
						'H:i' 		=> esc_html__( 'H:i 24 Hour	', 'ovaev' ),
						'g:i A' 	=> esc_html__( 'g:i A 12 Hour', 'ovaev' ),
						'g:i a' 	=> esc_html__( 'g:i a 12 hour', 'ovaev' ),
					],
					'default' 	=> 'g:i a',
				]
			);
			
			$this->add_control(
				'separator',
				[
					'label' 	=> esc_html__( 'Time Separator', 'ovaev' ),
					'type' 		=> Controls_Manager::TEXT,
					'default' 	=> esc_html__( ' to ', 'ovaev' ),
				]
			);

			$this->add_control(
				'show_time',
				[
					'label' => esc_html__( 'Show Time', 'ovaev' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'ovaev' ),
					'label_off' => esc_html__( 'Hide', 'ovaev' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);

			$this->add_control(
				'show_date',
				[
					'label' => esc_html__( 'Show Date', 'ovaev' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'ovaev' ),
					'label_off' => esc_html__( 'Hide', 'ovaev' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);

			$this->add_control(
				'show_category',
				[
					'label' => esc_html__( 'Show Category', 'ovaev' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'ovaev' ),
					'label_off' => esc_html__( 'Hide', 'ovaev' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);

			$this->add_control(
				'show_organizer',
				[
					'label' => esc_html__( 'Show Organizer Name', 'ovaev' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'ovaev' ),
					'label_off' => esc_html__( 'Hide', 'ovaev' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);

			$this->add_control(
				'show_phone',
				[
					'label' => esc_html__( 'Show Phone', 'ovaev' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'ovaev' ),
					'label_off' => esc_html__( 'Hide', 'ovaev' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);

			$this->add_control(
				'show_email',
				[
					'label' => esc_html__( 'Show Email', 'ovaev' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'ovaev' ),
					'label_off' => esc_html__( 'Hide', 'ovaev' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);

			$this->add_control(
				'show_website',
				[
					'label' => esc_html__( 'Show Website', 'ovaev' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'ovaev' ),
					'label_off' => esc_html__( 'Hide', 'ovaev' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);

			$this->add_control(
				'show_location',
				[
					'label' => esc_html__( 'Show Location', 'ovaev' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'ovaev' ),
					'label_off' => esc_html__( 'Hide', 'ovaev' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);

			$this->add_control(
				'show_gg_calendar',
				[
					'label' => esc_html__( 'Show Google Calendar', 'ovaev' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'ovaev' ),
					'label_off' => esc_html__( 'Hide', 'ovaev' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);

			$this->add_control(
				'show_ical_export',
				[
					'label' => esc_html__( 'Show Ical Export', 'ovaev' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'ovaev' ),
					'label_off' => esc_html__( 'Hide', 'ovaev' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);

			$this->add_control(
				'show_share',
				[
					'label' => esc_html__( 'Show Share', 'ovaev' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'ovaev' ),
					'label_off' => esc_html__( 'Hide', 'ovaev' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);

		$this->end_controls_section();

		 $this->start_controls_section(
            'contact_details_style',
            [
                'label' => esc_html__( 'Contact Details', 'ovaev' ),
                'tab' 	=> Controls_Manager::TAB_STYLE,
            ]
        );

		    $this->add_responsive_control(
	            'contact_details_padding',
	            [
	                'label' 		=> esc_html__( 'Padding', 'ovaev' ),
	                'type' 			=> Controls_Manager::DIMENSIONS,
	                'size_units' 	=> [ 'px', '%', 'em' ],
	                'selectors' 	=> [
	                    '{{WRAPPER}} .ovaev-event-info' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
	                ],
	            ]
	        );

	        $this->add_control(
				'contact_details_bgcolor',
				[
					'label' => esc_html__( 'Background Color', 'ovaev' ),
					'type' 	=> Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ovaev-event-info' => 'background-color: {{VALUE}};',
					],
				]
			);

        	$this->add_control(
				'contact_details_label_options',
				[
					'label' 	=> esc_html__( 'Label Options', 'ovaev' ),
					'type' 		=> Controls_Manager::HEADING,
					'separator' => 'before',
				]
			);

				$this->add_control(
					'contact_details_title_color',
					[
						'label' => esc_html__( 'Color', 'ovaev' ),
						'type' 	=> Controls_Manager::COLOR,
						'selectors' => [
							'{{WRAPPER}} .ovaev-event-info .info-contact li .label' => 'color: {{VALUE}};',
						],
					]
				);

			$this->add_control(
				'contact_details_description_options',
				[
					'label' 	=> esc_html__( 'Description Options', 'ovaev' ),
					'type' 		=> Controls_Manager::HEADING,
					'separator' => 'before',
				]
			);

				$this->add_control(
					'contact_details_description_color',
					[
						'label' => esc_html__( 'Color', 'ovaev' ),
						'type' 	=> Controls_Manager::COLOR,
						'selectors' => [
							'{{WRAPPER}} .ovaev-event-info .info-contact li .info' => 'color: {{VALUE}};',
							'{{WRAPPER}} .ovaev-event-info .info-contact li a' => 'color: {{VALUE}};',
						],
					]
				);

				$this->add_control(
					'contact_details_description_underline_hover_color',
					[
						'label' => esc_html__( 'Link Underline Color', 'ovaev' ),
						'type' 	=> Controls_Manager::COLOR,
						'selectors' => [
							'{{WRAPPER}} .ovaev-event-info .info-contact li a:hover:before' => 'background-color: {{VALUE}};',
						],
					]
				);

        $this->end_controls_section();

	}

	protected function render() {

		$settings 	= $this->get_settings();

		// show fields
		$show_time			    = $settings['show_time'];
		$show_date			    = $settings['show_date'];
		$show_category			= $settings['show_category'];
		$show_organizer			= $settings['show_organizer'];
		$show_phone			    = $settings['show_phone'];
		$show_email		        = $settings['show_email'];
		$show_website	        = $settings['show_website'];
		$show_location	        = $settings['show_location'];
		$show_gg_calendar  		= $settings['show_gg_calendar'];
		$show_ical_export  		= $settings['show_ical_export'];
		$show_share	       		= $settings['show_share'];

		$id 		= get_the_ID();
		$post_type 	= get_post_type( $id );
		
		if ( empty( $post_type ) || 'event' != $post_type ) {
			echo '<div class="ovaev_elementor_none"><span>' . esc_html( $this->get_title() ) . '</span></div>';
			return;
		}

		$name        	= get_post_meta( $id, 'ovaev_organizer', true);
		$phone       	= get_post_meta( $id, 'ovaev_phone', true);
		$email       	= get_post_meta( $id, 'ovaev_email', true);
		$website     	= get_post_meta( $id, 'ovaev_website', true);
		$location       = get_post_meta( $id, 'ovaev_venue', true);

		// Date format
		$date_format 		= apply_filters( 'ovaev_date_event_format', get_option('date_format') );

		// Time format
		$time_format 	    = $settings['time_format'];

		// Time separator
		$separator 		    = $settings['separator'];	

		// Start date
		$ovaev_start_date 	= get_post_meta( $id, 'ovaev_start_date_time', true );
		$start_date    		= $ovaev_start_date != '' ? date_i18n( $date_format, $ovaev_start_date ) : '';

		// Start time
		$ovaev_start_time 	= get_post_meta( $id, 'ovaev_start_time', true );
		$start_time 		= $ovaev_start_time ? date( $time_format, strtotime($ovaev_start_time) ) : '';

		// End date
		$ovaev_end_date   	= get_post_meta( $id, 'ovaev_end_date_time', true );
		$end_date      		= $ovaev_end_date != '' ? date_i18n( $date_format, $ovaev_end_date) : '';

		// End time
		$ovaev_end_time   	= get_post_meta( $id, 'ovaev_end_time', true );
		$end_time      		= $ovaev_end_time ? date( $time_format, strtotime($ovaev_end_time) ) : ''; 
        
        // Category
		$category    = get_the_terms($id, 'event_category');

		$date_start  = $ovaev_start_date  	? date('m/d/y H:i', $ovaev_start_date ) : '';
		$date_end    = $ovaev_end_date 		? date('m/d/y H:i', $ovaev_end_date ) 	: '';

		?>
		    <div class="ovaev-event-info">
				<ul class="info-contact">
					<?php if ( $show_time == 'yes' ): ?>
						<li>
							<span class="label"><?php esc_html_e('Time','ovaev'); ?></span>
							<?php if( $start_date == $end_date && $start_date != '' ){ ?>
								<span class="info">
									<?php echo esc_html( $start_time ). $separator .$end_time; ?>
								</span>
							<?php }else{ ?>
								<span class="info">
									<span><?php echo esc_html( $start_time ); ?></span>
								</span>
							<?php } ?>	
						</li>
					<?php endif; ?>

					<?php if ( $start_date != '' && $show_date == 'yes' ): ?>
						<li>
							<span class="label"><?php esc_html_e('Date','ovaev'); ?></span>
							<span class="info"><?php echo esc_html( $start_date ); ?></span>
						</li>
					<?php endif; ?>

					<?php if ( !empty($category) && $show_category == 'yes' ) : ?>
						<li>
							<span class="label"><?php esc_html_e('Category','ovaev'); ?></span>
							<span class="info">
								<?php 
									$arr_link = array();
									foreach( $category as $cat ) { 
								        $category_link = get_term_link($cat->term_id);
								        if ( $category_link ) {
								        	$link = '<a href="'.esc_url( $category_link ).'" title="'.esc_attr($cat->name).'">'.$cat->name.'</a>';
	                                    	array_push( $arr_link, $link );
								        }
									}
									if ( !empty( $arr_link ) && is_array( $arr_link ) ) {
										echo join(', ', $arr_link);
									}
								?>
							</span>						
						</li>
					<?php endif; ?>

					<?php if ( $name != '' && $show_organizer == 'yes'): ?>
						<li>
							<span class="label"><?php esc_html_e('Organizer Name','ovaev'); ?></span>
							<span class="info"><?php echo esc_html( $name ); ?></span>
						</li>
					<?php endif; ?>

					<?php if ( $phone != '' && $show_phone == 'yes' ): ?>
						<li>
							<span class="label"><?php esc_html_e('Phone','ovaev'); ?></span>
							<a href="tel:<?php echo esc_attr( $phone ); ?>" class="info"><?php echo esc_html( $phone ); ?></a>
						</li>
					<?php endif; ?>

					<?php if ( $email != '' && $show_email == 'yes' ): ?>
						<li>
							<span class="label"><?php esc_html_e('Email','ovaev'); ?></span>
							<a href="mailto:<?php echo esc_attr( $email ); ?>" class="info"><?php echo esc_html( $email ); ?></a>
						</li>
					<?php endif; ?>

					<?php if ( $website != '' && $show_website == 'yes' ): ?>
						<li>
							<span class="label"><?php esc_html_e('Website','ovaev'); ?></span>
							<a href="<?php echo esc_url( $website ); ?>" class="info" target="_blank"><?php echo esc_html( $website ); ?></a>
						</li>
					<?php endif; ?>

					<?php if ( $location != '' && $show_location == 'yes' ): ?>
						<li>
							<span class="label"><?php esc_html_e('Location','ovaev'); ?></span>
							<span class="info"><?php echo esc_html( $location ); ?></span>
						</li>
					<?php endif; ?>
				</ul>

				<?php if( $show_gg_calendar == 'yes' || $show_ical_export == 'yes' ){ ?>
					<div class="ovaev-calendar-sync">
						<?php if( $show_gg_calendar == 'yes' ){ ?>
						<a href="http://addtocalendar.com/atc/google?utz=420&amp;uln=en-US&amp;vjs=1.5&amp;e[0][date_start]=<?php echo esc_html($date_start);?>&amp;e[0][date_end]=<?php echo esc_html($date_end);?>&amp;e[0][timezone]=<?php echo get_option('timezone_string'); ?>&amp;e[0][title]=<?php echo get_the_title();?>&amp;e[0][description]=<?php echo get_the_excerpt().'<br><br>'.get_the_permalink();?>&amp;e[0][location]=<?php echo esc_html($location);?>&amp;e[0][organizer]=<?php echo esc_html($name);?>&amp;e[0][organizer_email]=<?php echo esc_html($email);?>" target="_blank" rel="nofollow"><?php esc_html_e( '+ Google Calendar', 'ovaev' );?></a>
						<?php } ?>

						<?php if( $show_ical_export == 'yes' ){ ?>
						<a href="http://addtocalendar.com/atc/ical?utz=420&amp;uln=en-US&amp;vjs=1.5&amp;e[0][date_start]=<?php echo esc_html($date_start);?>&amp;e[0][date_end]=<?php echo esc_html($date_end);?>&amp;e[0][timezone]=<?php echo get_option('timezone_string'); ?>&amp;e[0][title]=<?php echo get_the_title();?>&amp;e[0][description]=<?php echo get_the_excerpt().'<br><br>'.get_the_permalink();?>&amp;e[0][location]=<?php echo esc_html($location);?>&amp;e[0][organizer]=<?php echo esc_html($name);?>&amp;e[0][organizer_email]=<?php echo esc_html($email);?>" target="_blank" rel="nofollow"><?php esc_html_e( '+ Ical Export', 'ovaev' );?></a>
						<?php } ?>
					</div>
				<?php } ?>

				<?php if ( $show_share == 'yes' ) : ?>
					<div class="ovaev-event-share">
						<?php echo apply_filters('ovaev_share_social', get_the_permalink(), get_the_title() ); ?>
					</div>
				<?php endif; ?>
  			</div>
		<?php
	}
}