<?php if ( !defined( 'ABSPATH' ) ) exit(); 

	$id = get_the_ID();
		
	$ovaev_start_date = get_post_meta( $id, 'ovaev_start_date_time', true );
	$ovaev_end_date   = get_post_meta( $id, 'ovaev_end_date_time', true );

	$date_start  = $ovaev_start_date != '' ? date_i18n( get_option( 'date_format' ), $ovaev_start_date ) : '';
	$time_start  = $ovaev_start_date != '' ? date_i18n( get_option( 'time_format' ), $ovaev_start_date ) : '';
	$date_end    = $ovaev_end_date != '' ? date_i18n( get_option( 'date_format' ), $ovaev_end_date ) : '';
	$time_end    = $ovaev_end_date != '' ? date_i18n( get_option( 'time_format' ), $ovaev_end_date ) : '';

	$date  = $ovaev_start_date != '' ? date_i18n( 'd', $ovaev_start_date ) : '';
	$month = $ovaev_start_date != '' ? date_i18n( 'M', $ovaev_start_date ) : '';

	$type_list  = isset($args['type_list']) ? $args['type_list'] : 'type1' ;
	$args_show  = isset($args['args_show']) ? $args['args_show'] : [] ;

	// show fields
	$show_thumbnail  = isset($args_show['show_thumbnail']) ? $args_show['show_thumbnail'] : 'yes';
	$show_date  	 = isset($args_show['show_date']) ? $args_show['show_date'] : 'yes';
	$show_hour  	 = isset($args_show['show_hour']) ? $args_show['show_hour'] : 'yes';
	$show_location   = isset($args_show['show_location']) ? $args_show['show_location'] : 'yes';
	$show_title      = isset($args_show['show_title']) ? $args_show['show_title'] : 'yes';
	$show_short_desc = isset($args_show['show_short_desc']) ? $args_show['show_short_desc'] : 'yes';
	$show_link_to    = isset($args_show['show_link_to']) ? $args_show['show_link_to'] : 'yes';

?>

<div class="item <?php echo esc_attr($type_list);?>">

	<div class="date-time_title">

		<?php if( $type_list == 'type1' && $show_date == 'yes' ) { ?>
			<?php if( $date_start != '' ){ ?>
				<div class="date-start">
					<span><?php echo esc_html($date_start);?></span>
				</div>
			<?php } ?>
		<?php } ?>

		<?php if( $type_list != 'type1' && $show_date == 'yes' ) { ?>
			<?php if( $date_start != '' ){ ?>
				<div class="date-start">
					<span class="date"><?php echo esc_html($date);?></span>
					<span class="month"><?php echo esc_html($month);?></span>
				</div>
			<?php } ?>
		<?php } ?>

		<?php do_action( 'ovaev_loop_thumbnail', $id, $show_date, $show_link_to, $show_thumbnail ); ?>
	    
	    <div class="time_title">

	    	<?php if( $type_list == 'type1') { ?>
		    	<div class="time-venue">
		    		<?php if($show_hour == 'yes') : ?>
						<?php if( $date_start === $date_end && $date_end != '' && $date_start != '' ){ ?>
							<div class="time">
								<span class="icon-time"><i class="fas fa-clock icon_event" aria-hidden="true"></i></span>
								<span><?php echo esc_html($time_start); ?> - <?php echo esc_html($time_end); ?></span>
							</div>
						<?php } elseif( $date_start != $date_end && $date_end != '' && $date_start != '' ){ ?>
							<div class="time">
								<span class="icon-time"><i class="fas fa-clock icon_event" aria-hidden="true"></i></span>
								<span><?php echo esc_html($time_start); ?> - <?php echo esc_html($time_end); ?> @ <?php echo esc_html($date_end);?></span>
							</div>
						<?php } ?>
					<?php endif; ?>
					
					<?php if($show_location == 'yes') {
						do_action( 'ovaev_loop_venue', $id ); 
					} ?>
				</div>
			<?php } ?>

			<?php if( $type_list == 'type2' && $show_hour == 'yes' ) { ?>
				<?php if( $date_start === $date_end && $date_end != '' && $date_start != '' ){ ?>
					<div class="time">
						<span class="icon-time"><i class="fas fa-clock icon_event" aria-hidden="true"></i></span>
						<span><?php echo esc_html($time_start); ?> - <?php echo esc_html($time_end); ?></span>
					</div>
				<?php } elseif( $date_start != $date_end && $date_end != '' && $date_start != '' ){ ?>
					<div class="time">
						<span class="icon-time"><i class="fas fa-clock icon_event" aria-hidden="true"></i></span>
						<span><?php echo esc_html($time_start); ?> - <?php echo esc_html($time_end); ?> @ <?php echo esc_html($date_end);?></span>
					</div>
				<?php } ?>
			<?php } ?>

			<?php if( $show_title == 'yes') { ?>
				<h3 class="title">
					<?php if( $show_link_to == 'yes') { ?>
				    <a href="<?php echo get_the_permalink( $id );?>" title="<?php echo get_the_title( $id );?>">
				    <?php } ?>
						<?php echo get_the_title( $id ) ?>
					<?php if( $show_link_to == 'yes') { ?>
					</a>
					<?php } ?>
				</h3>
			<?php } ?>

			<?php if( $type_list == 'type2' && $show_location == 'yes' ) { ?>
				<?php do_action( 'ovaev_loop_venue', $id ); ?>
			<?php } ?>

			<?php if( $type_list == 'type3') { ?>
				<div class="time-venue">
					<?php if($show_hour == 'yes') : ?>
						<?php if( $date_start === $date_end && $date_end != '' && $date_start != '' ){ ?>
							<div class="time">
								<span class="icon-time"><i class="fas fa-clock icon_event" aria-hidden="true"></i></span>
								<span><?php echo esc_html($time_start); ?> - <?php echo esc_html($time_end); ?></span>
							</div>
						<?php } elseif( $date_start != $date_end && $date_end != '' && $date_start != '' ){ ?>
							<div class="time">
								<span class="icon-time"><i class="fas fa-clock icon_event" aria-hidden="true"></i></span>
								<span><?php echo esc_html($time_start); ?> - <?php echo esc_html($time_end); ?> @ <?php echo esc_html($date_end);?></span>
							</div>
						<?php } ?>
					<?php endif; ?>
					
					<?php if($show_location == 'yes') {
						do_action( 'ovaev_loop_venue', $id ); 
					} ?>
				</div>
			<?php } ?>

	    </div>

	</div>

	<?php if( $type_list != 'type3' && $show_short_desc == 'yes' ) {
		do_action( 'ovaev_loop_excerpt', $id ); 
	} ?>

	<?php if( $show_link_to == 'yes') { ?>
	    <a href="<?php echo get_the_permalink( $id ) ?>" class="readmore up-arrow" aria-label="<?php esc_attr_e( 'View Event', 'ovaev' ); ?>">
			<i aria-hidden="true" class="fas fa-arrow-up"></i>
		</a>
	<?php } ?>
	
</div>