<?php if ( !defined( 'ABSPATH' ) ) exit();

	$get_search_cat 		 = isset( $_GET["ovaev_type"] ) 				? $_GET["ovaev_type"] 				: '';
	$ovaev_start_date_search = isset( $_GET["ovaev_start_date_search"] ) 	? $_GET["ovaev_start_date_search"] 	: '';
	$ovaev_end_date_search   = isset( $_GET["ovaev_end_date_search"] ) 		? $_GET["ovaev_end_date_search"] 	: '';

	$lang 			= OVAEV_Settings::archive_format_date_lang();
	$date_format 	= OVAEV_Settings::archive_event_format_date();
	$time_format 	= OVAEV_Settings::archive_event_format_time();

	$settings 		= $args['settings'];
	$events			= $args['events'];
	$args_show 		= isset($args['args_show']) ? $args['args_show'] : [];

	$layout 		= $settings['layout'];
	$column 		= $settings['column'];
	$posts_per_page = $settings['posts_per_page'];
	$order 			= $settings['order'];
	$orderby 		= $settings['order_by'];
	$category_slug 	= $settings['category'];
	$time_event 	= $settings['time_event'];

	$total_pages 	= $events->max_num_pages;
	$current 		= 1;

	// show fileds
	$show_search_date     = isset($args_show['show_search_date']) ? $args_show['show_search_date'] : 'yes';
	$show_search_category = isset($args_show['show_search_category']) ? $args_show['show_search_category'] : 'yes';

	$args_show = array(
		'show_thumbnail'  => isset($args_show['show_thumbnail']) ? $args_show['show_thumbnail'] : 'yes',
		'show_date' 	  => isset($args_show['show_date']) ? $args_show['show_date'] : 'yes',
		'show_hour' 	  => isset($args_show['show_hour']) ? $args_show['show_hour'] : 'yes',
		'show_location'   => isset($args_show['show_location']) ? $args_show['show_location'] : 'yes',
		'show_title' 	  => isset($args_show['show_title']) ? $args_show['show_title'] : 'yes',
		'show_short_desc' => isset($args_show['show_short_desc']) ? $args_show['show_short_desc'] : 'yes',
		'show_link_to' 	  => isset($args_show['show_link_to']) ? $args_show['show_link_to'] : 'yes',
	);

?>

<div class="ovaev-wrapper-search-ajax">

	<!-- Search Form -->
	<?php if($show_search_date == 'yes' || $show_search_category == 'yes') : ?>
		<div class="ovaev-search-ajax-form search_archive_event">
			<form action="<?php echo esc_url(get_post_type_archive_link( 'event' )); ?>" method="GET" name="search_event" autocomplete="off">
				<?php if($show_search_date == 'yes') : ?>
					<div class="start_date">
						<label class="second_font ova-label-search visuallyhidden" for="ovaev_start_date_search">
							<?php esc_html_e('Start Date', 'ovaev') ?>
						</label>

						<input type="text" 
							id="ovaev_start_date_search" 
							class="ovaev_start_date_search" 
							data-lang="<?php echo esc_attr($lang); ?>" 
							data-date="<?php echo esc_attr($date_format); ?>" 
							data-time="<?php echo esc_attr($time_format); ?>" 
							placeholder="<?php echo esc_attr__( 'From', 'ovaev' ); ?>" 
							name="ovaev_start_date_search" 
							value="<?php echo esc_attr( $ovaev_start_date_search ); ?>" 
						/>

						<i class="far fa-calendar-alt" aria-hidden="true"></i>
					</div>

					<div class="end_date">
						<label class="second_font ova-label-search visuallyhidden" for="ovaev_end_date_search">
							<?php esc_html_e('End Date', 'ovaev') ?>
						</label>
						
						<input 
							type="text" 
							id="ovaev_end_date_search" 
							class="ovaev_end_date_search" 
							data-lang="<?php echo esc_attr($lang); ?>" 
							data-date="<?php echo esc_attr($date_format); ?>" 
							placeholder="<?php echo esc_attr__( 'To', 'ovaev' ); ?>" 
							name="ovaev_end_date_search" 
							value="<?php echo esc_attr( $ovaev_end_date_search ); ?>" 
						/>

						<i class="far fa-calendar-alt" aria-hidden="true"></i>
					</div>
				<?php endif; ?>

				<?php if($show_search_category == 'yes') : ?>
					<div class="ovaev_cat_search">
						<label class="second_font ova-label-search visuallyhidden" for="ovaev_type">
							<?php esc_html_e('Category', 'ovaev'); ?>
						</label>

						<?php $dropdown_args1 = apply_filters( 'OVAEV_event_type', $get_search_cat ); ?>
						<i class="arrow_carrot-down" aria-hidden="true"></i>
					</div>
				<?php endif; ?>

				<div class="wrap-ovaev_submit">
					<input class="second_font ovaev_submit" type="submit" value="<?php esc_html_e('Find Event', 'ovaev'); ?>" />
				</div>

				<input type="hidden" name="post_type" value="event">
				<input type="hidden" name="search_event" value="search-event">
				
			</form>
		</div>
	<?php endif; ?>

	<!-- Events -->
	<div class="ovaev-search-ajax-container">
		<div class="search-ajax-content">
			<div class="archive_event ovaev-search-ajax-events<?php echo ' '.esc_attr( $column );?>">
				<?php if( $events->have_posts() ) : while( $events->have_posts() ) : $events->the_post();
					switch ($layout) {
						case '1':
							ovaev_get_template( 'event-templates/event-type1.php', $args_show );
							break;
						case '2':
							ovaev_get_template( 'event-templates/event-type2.php', $args_show );
							break;
						case '3':
							ovaev_get_template( 'event-templates/event-type3.php', $args_show );
							break;
						case '4':
							ovaev_get_template( 'event-templates/event-type4.php', $args_show );
							break;
						case '5':
							ovaev_get_template( 'event-templates/event-type5.php', $args_show );
							break;
						case '6':
							ovaev_get_template( 'event-templates/event-type6.php', $args_show );
							break;
						case '7':
							ovaev_get_template( 'event-templates/event-type7.php', $args_show );
							break;
						default:
							ovaev_get_template( 'event-templates/event-type1.php', $args_show );
					}
				?>

				<?php endwhile; else: wp_reset_postdata(); ?>
					<div class="search_not_found">
						<?php esc_html_e( 'No Events found', 'ovaev' ); ?>
					</div>
				<?php endif; wp_reset_postdata(); ?>
			</div>

			<div class="data-events" 
				data-layout="<?php echo esc_attr( $layout ); ?>" 
				data-column="<?php echo esc_attr( $column ); ?>" 
				data-per-page="<?php echo esc_attr( $posts_per_page ); ?>" 
				data-order="<?php echo esc_attr( $order ); ?>" 
				data-orderby="<?php echo esc_attr( $orderby ); ?>" 
				data-category-slug="<?php echo esc_attr( $category_slug ); ?>" 
				data-time-event="<?php echo esc_attr( $time_event ); ?>"
				data-args_show="<?php echo esc_attr( json_encode($args_show) ); ?>"
			>
			</div>
		</div>

		<!-- Loader -->
		<div class="wrap_loader">
			<svg class="loader" width="50" height="50">
				<circle cx="25" cy="25" r="10" stroke="#a1a1a1"/>
				<circle cx="25" cy="25" r="20" stroke="#a1a1a1"/>
			</svg>
		</div>

	</div>
	<!-- End Events -->

	<!-- Pagination -->
	<div class="search-ajax-pagination-wrapper">
	<?php if ( $total_pages > 1 ): ?>
		<div class="search-ajax-pagination events_pagination" data-total-page="<?php echo esc_attr( $total_pages ); ?>">
			<ul class="page-numbers">
				<?php for ( $i = 1; $i <= $total_pages; $i++ ): ?>
					<?php if ( $i == 1 ): ?>
						<li>
							<span class="prev page-number" data-paged="<?php echo esc_attr( $current - 1 ); ?>" style="display:none">
								<i class="ovaicon-back" aria-hidden="true"></i>
							</span>
						</li>
						<li>
							<span class="page-number current" data-paged="<?php echo esc_attr( $i ); ?>">
								<?php echo esc_attr( $i ); ?>
							</span>
						</li>
					<?php elseif ( $i == $total_pages ): ?>
						<li>
							<span class="page-number" data-paged="<?php echo esc_attr( $i ); ?>">
								<?php echo esc_attr( $i ); ?>
							</span>
						</li>
						<li>
							<span class="next page-number" data-paged="<?php echo esc_attr( $current + 1 ); ?>">
								<i class="ovaicon-next" aria-hidden="true"></i>
							</span>
						</li>
					<?php else: ?>
						<li>
							<span class="page-number" data-paged="<?php echo esc_attr( $i ); ?>">
								<?php echo esc_attr( $i ); ?>
							</span>
						</li>
					<?php endif; ?>
				<?php endfor; ?>
			</ul>
		</div>
	<?php endif; ?>
	</div>

</div>