<?php
namespace ovaex_elementor\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use OVAEX_Settings;

if ( !defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class ovaex_exhibition_type extends Widget_Base {

	public function get_name() {
		return 'ovaex_exhibition_type';
	}

	public function get_title() {
		return esc_html__( 'Exhibition Grid & Slide', 'ovaex' );
	}

	public function get_icon() {
		return 'eicon-posts-grid';
	}

	public function get_categories() {
		return [ 'ovatheme_exhibition' ];
	}

	public function get_script_depends() {
		// Carousel
		wp_enqueue_style( 'carousel', OVAEX_PLUGIN_URI.'assets/libs/owl-carousel/assets/owl.carousel.min.css' );
		wp_enqueue_script( 'carousel', OVAEX_PLUGIN_URI.'assets/libs/owl-carousel/owl.carousel.min.js', array('jquery'), false, true );

		wp_enqueue_script( 'script-elementor-ovaex' );
		
		return [ '' ];
	}

	public function get_style_depends() {
		wp_enqueue_style( 'ovaex-style', OVAEX_PLUGIN_URI.'assets/css/frontend/ovaex-style.css', array(), null );
		return [];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Content', 'ovaex' ),
			]
		);

			$this->add_control(
				'total_count',
				[
					'label'   => esc_html__( 'Total Exhibition', 'ovaex' ),
					'type'    => Controls_Manager::NUMBER,
					'default' => 3
				]
			);

			$this->add_control(
				'time_exhibition',
				[
					'label'   => esc_html__( 'Choose time', 'ovaex' ),
					'type'    => Controls_Manager::SELECT,
					'options' => [
						'all'      => esc_html__( 'All','ovaex' ),
						'current'  => esc_html__( 'Current','ovaex' ),
						'upcoming' => esc_html__( 'Upcoming','ovaex' ),
						'past'     => esc_html__( 'Past','ovaex' ),
					],
					'default'   => 'all',
				]
			);

			$this->add_control(
				'categories',
				[
					'label'   	=> esc_html__( 'Categories', 'ovaex' ),
					'multiple' 	=> true,
					'type'    	=> \Elementor\Controls_Manager::SELECT2,
					'options' 	=> $this->get_all_categories(),
				]
			);

			$this->add_control(
				'artist',
				[
					'label'   	=> esc_html__( 'Artist', 'ovaex' ),
					'type'    	=> \Elementor\Controls_Manager::SELECT,
					'default' 	=> '',
					'options' 	=> $this->get_all_artists(),
				]
			);

			$this->add_control(
				'upcoming_day_ex',
				[
					'label'     => esc_html__( 'Upcoming Day','ovaex' ),
					'type'      => Controls_Manager::NUMBER,
					'default'   => 100,
					'min'       => 1,
					'condition' => [
						'time_exhibition' => 'upcoming'
					]
				]
			);

			$this->add_control(
				'order',
				[
					'label'   => esc_html__( 'Order', 'ovaex' ),
					'type'    => Controls_Manager::SELECT,
					'default' => 'DESC',
					'options' => [
						'DESC' => esc_html__( 'Descending', 'ovaex' ),
						'ASC'  => esc_html__( 'Ascending', 'ovaex' ),
						
					],

				]
			);

			$this->add_control(
				'exhibition_type',
				[
					'label' => esc_html__( 'Exhibition Type','ovaex' ),
					'type' => Controls_Manager::SELECT,
					'options' => [
						'grid' 	=> esc_html__( 'Grid','ovaex' ),
						'slide' => esc_html__( 'Slide','ovaex' )
					],
					'default' => 'grid'
				]
			);

			$this->add_control(
				'total_columns_slide',
				[
					'label'   => esc_html__( 'Desktop: Total item each slide', 'ovaex' ),
					'type'    => Controls_Manager::SELECT,
					'default' => '2',
					'options' => [
						'1' => esc_html__( '1 items', 'ovaex' ),
						'2' => esc_html__( '2 items', 'ovaex' ),
						'3' => esc_html__( '3 items', 'ovaex' ),
						'4' => esc_html__( '4 items', 'ovaex' ),
					],
					'condition' => [
						'exhibition_type' => 'slide',  
					]
				]
			);

			$this->add_control(
				'items_ipad',
				[
					'label'   => esc_html__( 'Ipad: Total item each slide', 'ovaex' ),
					'type'    => Controls_Manager::SELECT,
					'default' => '2',
					'options' => [
						'1' => esc_html__( '1 items', 'ovaex' ),
						'2' => esc_html__( '2 items', 'ovaex' ),
						'3' => esc_html__( '3 items', 'ovaex' ),
						'4' => esc_html__( '4 items', 'ovaex' ),
					],
					'condition' => [
						'exhibition_type' => 'slide',

					]
				]
			);

			$this->add_control(
				'items_mobile',
				[
					'label'   => esc_html__( 'Mobile: Total item each slide', 'ovaex' ),
					'type'    => Controls_Manager::SELECT,
					'default' => '1',
					'options' => [
						'1' => esc_html__( '1 items', 'ovaex' ),
						'2' => esc_html__( '2 items', 'ovaex' ),
						'3' => esc_html__( '3 items', 'ovaex' ),
						'4' => esc_html__( '4 items', 'ovaex' ),
					],
					'condition' => [
						'exhibition_type' => 'slide',
					]
				]
			);

			$this->add_control(
				'show_image',
				[
					'label' => esc_html__( 'Show Image', 'ova-doc' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'ova-doc' ),
					'label_off' => esc_html__( 'Hide', 'ova-doc' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);

			$this->add_control(
				'show_date',
				[
					'label' => esc_html__( 'Show Date', 'ova-doc' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'ova-doc' ),
					'label_off' => esc_html__( 'Hide', 'ova-doc' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);

			$this->add_control(
				'show_category',
				[
					'label' => esc_html__( 'Show Category', 'ova-doc' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'ova-doc' ),
					'label_off' => esc_html__( 'Hide', 'ova-doc' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);

			$this->add_control(
				'show_title',
				[
					'label' => esc_html__( 'Show Title', 'ova-doc' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'ova-doc' ),
					'label_off' => esc_html__( 'Hide', 'ova-doc' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);

			$this->add_control(
				'show_link_of_title',
				[
					'label' => esc_html__( 'Show Link of Title', 'ova-doc' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'ova-doc' ),
					'label_off' => esc_html__( 'Hide', 'ova-doc' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);

			$this->add_control(
				'show_view_exhibition',
				[
					'label' => esc_html__( 'Show View Exhibition', 'ova-doc' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'ova-doc' ),
					'label_off' => esc_html__( 'Hide', 'ova-doc' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);

		$this->end_controls_section();


		$this->start_controls_section(
			'section_slider',
			[
				'label' => esc_html__( 'Slider Settings', 'ovaex' ),
				'condition' => [
					'exhibition_type' => 'slide'
				]
			]
		);

		$this->add_control(
			'margin_items',
			[
				'label' => esc_html__( 'Margin Right Items', 'ovaex' ),
				'type' => Controls_Manager::NUMBER,
				'default' => 30,
			]
		);

		$this->add_control(
			'dots_control',
			[
				'label'   => esc_html__( 'Show Dots Control', 'ovaex' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);


		$this->add_control(
			'pause_on_hover',
			[
				'label'   => esc_html__( 'Pause on Hover', 'ovaex' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'autoplay',
			[
				'label'   => esc_html__( 'Autoplay', 'ovaex' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'autoplay_speed',
			[
				'label'     => esc_html__( 'Autoplay Speed', 'ovaex' ),
				'type'      => Controls_Manager::NUMBER,
				'default'   => 5000,
				'condition' => [
					'autoplay' => 'yes',
				]
			]
		);

		$this->add_control(
			'infinite',
			[
				'label'   => esc_html__( 'Infinite Loop', 'ovaex' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'smartspeed',
			[
				'label'   => esc_html__( 'Smart Speed', 'ovaex' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => 500
			]
		);

		$this->add_control(
			'slideby',
			[
				'label' => esc_html__( "Slide by", 'ovaex' ),
				'type'  => Controls_Manager::NUMBER,
				'default' => '1'
			]
		);

		$this->end_controls_section();

		// Title style
		$this->start_controls_section(
			'section_title_style',
			[
				'label' => esc_html__( 'Title', 'ovaex' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'title_typography',
				'label' 	=> esc_html__( 'Typography', 'ovaex' ),
				'selector' 	=> '{{WRAPPER}} .exhibition_arc .wrap-content .post-items .content h3',
			]
		);

		$this->add_control(
			'title_color',
			[
				'label' 	=> esc_html__( 'Color', 'ovaex' ),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .exhibition_arc .wrap-content .post-items .content h3' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'title_hover_color',
			[
				'label' 	=> esc_html__( 'Color Hover', 'ovaex' ),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .exhibition_arc .wrap-content .post-items .content h3:hover' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'title_magin',
			[
				'label' 		=> esc_html__( 'Margin', 'ovaex' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', 'em', '%' ],
				'selectors' 	=> [
					'{{WRAPPER}} .exhibition_arc .wrap-content .post-items .content h3' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();
		
	}

	private function get_all_categories() {
		$result = array();

		$args = array(
           'taxonomy' 	=> 'cat_exhibition',
           'orderby' 	=> 'name',
           'order'   	=> 'ASC'
       	);
	
		$categories = get_categories( $args );

		if ( $categories ) {
			foreach( $categories as $cate ) {
				$result[$cate->slug] = $cate->cat_name;
			}
		}

		return $result;
	}

	private function get_all_artists() {
		$result = array(
			'' => esc_html__( 'All', 'ovaex' ),
		);

		$args_artists = array(
			'post_type'      	=> 'artist',
			'post_status' 		=> 'publish',
			'posts_per_page' 	=> -1,
			'fields' 			=> 'ids',
		);

		$artists = get_posts( $args_artists );

		if ( !empty( $artists ) && is_array( $artists ) ) {
			foreach( $artists as $id ) {
				$result[$id] = get_the_title( $id );
			}
		}

		return $result;
	}

	protected function render() {
		$settings = $this->get_settings();

		$exhibition_type = $settings['exhibition_type'];
		$exhibition_class = '';
		if ( $exhibition_type == 'slide' ) {
			$exhibition_class = 'slide-owl owl-carousel';
		} elseif ( $exhibition_type == 'grid') {
			$exhibition_class = 'grid';
		}

		// Get setting slide
		$data_option['total_columns_slide'] = absint( $settings['total_columns_slide'] ); 
		$data_option['items_ipad']          = absint( $settings['items_ipad'] ); 
		$data_option['items_mobile']        = absint( $settings['items_mobile'] ); 
		$data_option['smartSpeed']          = absint( $settings['smartspeed'] );
		$data_option['margin']              = absint( $settings['margin_items'] ); 
		$data_option['loop']                =  ( $settings['infinite'] == 'yes') ? true : false;
		$data_option['autoplay']            =  ( $settings['autoplay'] == 'yes') ? true : false;
		$data_option['autoplayTimeout']     = absint( $settings['autoplay_speed'] );
		$data_option['autoplayHoverPause']  =  ( $settings['pause_on_hover'] == 'yes') ? true : false;
		$data_option['dots']                =  ( $settings['dots_control'] == 'yes') ? true : false;
		$data_option['slideBy']             = absint( $settings['slideby'] );
		
		$data_option_encode = wp_json_encode($data_option);

		// Get data Exhibition
		$ovaex_order 			= $settings['order'];
		$ovaex_post_per_page 	= $settings['total_count'];
		$upcoming_day 			= $settings['upcoming_day_ex'];
		$categories 			= $settings['categories'];
		$artist 				= $settings['artist'];

		$args_basic = $args_cat = $args_artist = array();

		if ( $settings['time_exhibition'] == 'current') {
			$args_basic = array(
				'post_type'      => 'exhibition',
				'post_status'    => 'publish',
				'order'          => $ovaex_order,
				'posts_per_page' => $ovaex_post_per_page,
				'meta_query'     => array(
					array(
						'relation' => 'AND',
						array(
							'key'     => 'ex_start_date',
							'value'   => current_time('timestamp' ),
							'compare' => '<'
						),
						array(
							'key'     => 'ex_end_date',
							'value'   => current_time('timestamp' ),
							'compare' => '>='
						)
					)
				)
			);
		} elseif ( $settings['time_exhibition'] == 'upcoming' ) {
			$args_basic = array(
				'post_type'      	=> 'exhibition',
				'post_status'    	=> 'publish',
				'order'          	=> $ovaex_order,
				'posts_per_page' 	=> $ovaex_post_per_page,
				'meta_query' 		=> array(
					array(
						'relation' => 'AND',
						array(
							'key'      => 'ex_start_date',
							'value'    => current_time( 'timestamp' ),
							'compare'  => '>'
						),
						array(
							'key'     => 'ex_start_date',
							'value'   => current_time( 'timestamp') + ( $upcoming_day * 24 * 60 * 60 ),
							'compare' => '<='
						)	
					)
				)
			);
		} elseif ( $settings['time_exhibition'] == 'past' ) {
			$args_basic = array(
				'post_type'      => 'exhibition',
				'post_status'    => 'publish',
				'order'          => $ovaex_order,
				'posts_per_page' => $ovaex_post_per_page,
				'meta_query'     => array(
					array(
						'key'     => 'ex_end_date',
						'value'   => current_time('timestamp' ),
						'compare' => '<',					
					),
				),
			);
		} else {
			$args_basic = array(
				'post_type'      => 'exhibition',
				'post_status'    => 'publish',
				'order'          => $ovaex_order,
				'posts_per_page' => $ovaex_post_per_page,
			);
		}

		if ( !empty( $categories ) && is_array( $categories ) ) {
			$args_cat = array(
				'tax_query' => array(
					array(
						'taxonomy' => 'cat_exhibition',
						'field'    => 'slug',
						'terms'    => $categories,
					)
				)
			);
		}

		if ( !empty( $artist ) ) {
			$args_artist = array(
				'meta_query' => array(
					array(
						'key'     => 'exhibition_artist',
						'value'   => $artist,
						'compare' => 'LIKE'
					)
				)
			);
		}

		$args = array_merge_recursive( $args_basic, $args_artist, $args_cat );
		
		$exhibition  = new \WP_Query( $args ); 

		// show fields
		$args_show = array(
			'show_title' 		   => $settings['show_title'],
			'show_link_of_title'   => $settings['show_link_of_title'],
			'show_image'   		   => $settings['show_image'],
			'show_date'			   => $settings['show_date'],
			'show_category'	       => $settings['show_category'],
			'show_view_exhibition' => $settings['show_view_exhibition'],
		);
	?>
		
		<div class="exhibition_arc element_exh">
			<div class="ova-wrap-exhibition wrap-content <?php echo esc_attr($exhibition_class);?>" <?php if($exhibition_type == 'slide') : ?> 
				data-options="<?php echo esc_attr($data_option_encode); ?>" <?php endif; ?>
			>
				<?php if( $exhibition->have_posts() ) : while( $exhibition->have_posts() ) : $exhibition->the_post();
					ovaex_get_template( 'parts/item-exhibition.php', $args_show );
				endwhile; endif; wp_reset_postdata(); ?>
			</div>
		</div>
	<?php }
}