(function( $ ){
	'use strict';

	$(document).ready(function() {

        $('.ova-load-more-por').on( 'click', function() {
            var paged   = $(this).closest('.ova_more_por').attr('data-paged');
            var perpage = $(this).closest('.ova_more_por').attr('data-perpage');
            var cat     = $(this).closest('.ova_more_por').attr('data-cat');
            var type    = $(this).closest('.ova_more_por').attr('data-type');

            var new_paged = parseInt(paged) + 1;
            $(this).closest('.ova_more_por').attr('data-paged',new_paged);

            $('.ova-load-more-por').css({'display':'none'});
            $('.ova-loader').css({'display':'inline-block'});

            jQuery.ajax({
                url: ajax_object.ajax_url,
                type: 'POST',
                data: ({
                    action: 'ova_loadmore_portfolio',
                    paged: paged,
                    perpage: perpage,
                    cat: cat,
                    type: type,
                }),
                success: function(data) {
                    if ( data ){
                        $('.content-por').append(data).isotope('appended', data);

                        $('.content-por').imagesLoaded( function() {
                            $('.content-por').isotope( 'reloadItems' ).isotope();
                        });

                        $('.ova-load-more-por').css({'display':'inline-block'});
                        $('.ova-loader').css({'display':'none'});
                    } else {
                        $('.ova-loader').css({'display':'none'});
                        $('.ova-nodata').css({'display':'block'});
                        $('.ova-nodata span').css({'display':'inline-block'});
                    }
                }
            });
        });

        $(".content-por").each(function(){
            var $mcontainer = $(this);
            $mcontainer.imagesLoaded( function() {
                $mcontainer.isotope({
                    itemSelector : '.ovapor-item',
                    animationOptions: {
                        duration: 750,
                        easing: 'linear'
                    },
                });

                if ( $mcontainer.hasClass('classic-portfolio') ){
                    $mcontainer.isotope({
                        layoutMode: 'fitRows',
                        fitRows: {
                        gutter: 30
                        },
                    })
                }
            });
        });

        $('.archive-por .list-cat-por li').click(function() {
            $(".archive-por .list-cat-por li").removeClass("active");
            $(this).addClass("active");        
            var selector = $(this).attr('data-filter'); 

            $(".content-por").isotope({ 
                filter: selector, 
                animationOptions: { 
                    duration: 750, 
                    easing: 'linear', 
                    queue: false, 
                } 
            }); 

            if( $(this).hasClass('classic-portfolio') ){
                $(".content-por").isotope({
                    layoutMode: 'fitRows',
                    fitRows: {
                        gutter: 30
                    },
                })
            }

            return false; 
        }); 

        $('.archive-por .list-cat-por .cate_name').on("click",function(e){
            e.preventDefault();
            var id          = $(this).attr("data-id");
            var cateDesc    = $(".archive-por .category-desc");
            var loader      = $(".archive-por .ova-por-loader .loader");
            cateDesc.html("");
            loader.addClass("is-active");
            $.ajax({
                type: "post",
                dataType: "html",
                url: ajax_object.ajax_url,
                data: {
                    action: 'ova_por_category_desc',
                    id: id,
                },
                success: function(response){
                    loader.removeClass("is-active");
                    cateDesc.html(response);
                },
                error: function(err){
                    console.log(err);
                }
            });
        });

   });

})(jQuery); 	