<?php

namespace ova_por_elementor;

use ova_por_elementor\widgets\ova_por_slide;
use ova_por_elementor\widgets\ova_por_slide_2;
use ova_por_elementor\widgets\ova_por_grid;
use ova_por_elementor\widgets\ova_por_grid_2;
use ova_por_elementor\widgets\ova_por_gallery;




if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


/**
 * Main Plugin Class
 *
 * Register new elementor widget.
 *
 * @since 1.0.0
 */
class Ova_Sev_Register_Elementor {

	/**
	 * Constructor
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 */
	public function __construct() {
		$this->add_actions();
	}

	/**
	 * Add Actions
	 *
	 * @since 1.0.0
	 *
	 * @access private
	 */
	private function add_actions() {

	     // Register Ovatheme Category in Pane
	    add_action( 'elementor/elements/categories_registered', array( $this, 'add_ovatheme_portfolio_category' ) );
	    
		
		add_action( 'elementor/widgets/register', [ $this, 'on_widgets_registered' ] );
		

	}

	
	public function add_ovatheme_portfolio_category(  ) {

	    \Elementor\Plugin::instance()->elements_manager->add_category(
	        'ovatheme_portfolio',
	        [
	            'title' => __( 'Ovatheme Portfolio', 'ova-team' ),
	            'icon' => 'fa fa-plug',
	        ]
	    );

	}


	/**
	 * On Widgets Registered
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 */
	public function on_widgets_registered() {
		$this->includes();
		$this->register_widget();
	}

	/**
	 * Includes
	 *
	 * @since 1.0.0
	 *
	 * @access private
	 */
	private function includes() {
		require OVAPOR_PLUGIN_PATH . 'elementor/widgets/ova_por_slide.php';
		require OVAPOR_PLUGIN_PATH . 'elementor/widgets/ova_por_slide_2.php';
		require OVAPOR_PLUGIN_PATH . 'elementor/widgets/ova_por_grid.php';
		require OVAPOR_PLUGIN_PATH . 'elementor/widgets/ova_por_grid_2.php';
		require OVAPOR_PLUGIN_PATH . 'elementor/widgets/ova_por_gallery.php';
	}

	/**
	 * Register Widget
	 *
	 * @since 1.0.0
	 *
	 * @access private
	 */
	private function register_widget() {
		\Elementor\Plugin::instance()->widgets_manager->register( new ova_por_slide() );
		\Elementor\Plugin::instance()->widgets_manager->register( new ova_por_slide_2() );
		\Elementor\Plugin::instance()->widgets_manager->register( new ova_por_grid() );
		\Elementor\Plugin::instance()->widgets_manager->register( new ova_por_grid_2() );
		\Elementor\Plugin::instance()->widgets_manager->register( new ova_por_gallery() );
	}

}

new Ova_Sev_Register_Elementor();
