<?php
namespace ova_sev_elementor\Widgets;

use Elementor\Widget_Base;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class ova_sev_info extends Widget_Base {

	public function get_name() {
		return 'ova_sev_info';
	}

	public function get_title() {
		return esc_html__( 'Service Info', 'ova-sev' );
	}

	public function get_icon() {
		return 'eicon-info';
	}

	public function get_categories() {
		return [ 'ovatheme_service' ];
	}

	public function get_script_depends() {
		return [ '' ];
	}

	public function get_style_depends() {
		wp_enqueue_style( 'ova-sev-info', OVASEV_PLUGIN_URI.'/assets/css/elementor/sev-info.css', array(), null);
		return [];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Content', 'ova-sev' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

			$this->add_control(
				'wc_content_warning',
				[
					'type' 	=> \Elementor\Controls_Manager::RAW_HTML,
					'raw' 	=> esc_html__( "Don't enter Service ID if you use this element in Service Sidebar.In Elementor Preview ( When empty Service ID ) , this element display an example service info of the latest service", 'ova-sev' ),
					'content_classes' => 'elementor-panel-alert elementor-panel-alert-info',
				]
			);

			$this->add_control(
				'sid',
				[
					'label'  => esc_html__( 'Service ID', 'ova-sev' ),
					'type'   => \Elementor\Controls_Manager::NUMBER,
				]
			);	

			$this->add_control(
				'title',
				[
					'label'  => esc_html__( 'Title', 'ova-sev' ),
					'type'   => \Elementor\Controls_Manager::TEXT,
					'default' => esc_html__( 'Contact', 'ova-sev' ),
				]
			);	

		$this->end_controls_section();


		/* Title */
		$this->start_controls_section(
				'title_style_section',
				[
					'label' => esc_html__( 'Title', 'ova-sev' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name' => 'title_typography',
					'selector' => '{{WRAPPER}} .ova-sev-info .title',
				]
			);

			$this->add_control(
				'title_color',
				[
					'label' => esc_html__( 'Color', 'ova-sev' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-sev-info .title' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_control(
				'title_background',
				[
					'label' => esc_html__( 'Background', 'ova-sev' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-sev-info .title' => 'background: {{VALUE}}',
						'{{WRAPPER}} .ova-sev-info .title:after' => 'border-top-color: {{VALUE}}',
					],
				]
			);

		$this->end_controls_section();

	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		$template = apply_filters( 'el_elementor_ova_sev_info', 'elementor/ova_sev_info.php' );

		ob_start();
		ovasev_get_template( $template, $settings );
		echo ob_get_clean();
	}
}
