<?php

if ( !defined( 'ABSPATH' ) ) {
	exit;
}

if( !function_exists( 'ovasev_locate_template' ) ){
	function ovasev_locate_template( $template_name, $template_path = '', $default_path = '' ) {
		
		// Set variable to search in ovacoll-templates folder of theme.
		if ( ! $template_path ) :
			$template_path = 'ovasev-templates/';
		endif;

		// Set default plugin templates path.
		if ( ! $default_path ) :
			$default_path = OVASEV_PLUGIN_PATH . 'templates/'; // Path to the template folder
		endif;

		// Search template file in theme folder.
		$template = locate_template( array(
			$template_path . $template_name
			// $template_name
		) );

		// Get plugins template file.
		if ( ! $template ) :
			$template = $default_path . $template_name;
		endif;

		return apply_filters( 'ovasev_locate_template', $template, $template_name, $template_path, $default_path );
	}

}


function ovasev_get_template( $template_name, $args = array(), $tempate_path = '', $default_path = '' ) {
	if ( is_array( $args ) && isset( $args ) ) :
		extract( $args );
	endif;
	$template_file = ovasev_locate_template( $template_name, $tempate_path, $default_path );
	if ( ! file_exists( $template_file ) ) :
		_doing_it_wrong( __FUNCTION__, sprintf( '<code>%s</code> does not exist.', $template_file ), '1.0.0' );
		return;
	endif;

	
	include $template_file;
}

function ovasev_slugify($text, string $divider = '_') {

  	// replace non letter or digits by divider
  	$text = preg_replace('~[^\pL\d]+~u', $divider, $text);

  	// remove unwanted characters
  	$text = preg_replace('~[^-\w]+~', '', $text);

  	// trim
  	$text = trim($text, $divider);

  	// remove duplicate divider
  	$text = preg_replace('~-+~', $divider, $text);

  	// lowercase
  	$text = strtolower($text);

  	if (empty($text)) {
    	return '';
  	}

  	return $text;

}


add_filter( 'gimont_header_customize', 'gimont_header_customize_sev', 10, 1 );
function gimont_header_customize_sev( $header ){

	$single_sev_template = get_theme_mod( 'ova_sev_single_template', 'template_1' );

	$single_template = get_post_meta( get_the_ID(), 'ova_sev_met_single_template', true );
    if ( $single_template != '' ) {
        $single_sev_template = $single_template;
    }

	if( is_tax( 'cat_sev' ) ||  get_query_var( 'cat_sev' ) != '' || is_post_type_archive( 'ova_sev' ) ){

	  	$header = get_theme_mod( 'header_archive_sev', 'default' );

	}else if( is_singular( 'ova_sev' ) ){

		if ( $single_sev_template == 'template_2' ) {
            $header = get_theme_mod( 'header_single_sev_2', 'default' );
        } else {
           $header = get_theme_mod( 'header_single_sev', 'default' );
        }

	}

	return $header;

}

add_filter( 'gimont_footer_customize', 'gimont_footer_customize_sev', 10, 1 );
function gimont_footer_customize_sev( $footer ){

	$single_sev_template = get_theme_mod( 'ova_sev_single_template', 'template_1' );

	$single_template = get_post_meta( get_the_ID(), 'ova_sev_met_single_template', true );
    if ( $single_template != '' ) {
        $single_sev_template = $single_template;
    }
    
   if( is_tax( 'cat_sev' ) ||  get_query_var( 'cat_sev' ) != '' || is_post_type_archive( 'ova_sev' ) ){

        $footer = get_theme_mod( 'archive_footer_sev', 'default' );

    }else if( is_singular( 'ova_sev' ) ){

    	if ( $single_sev_template == 'template_2' ) {
            $footer = get_theme_mod( 'single_footer_sev_2', 'default' );
        } else {
            $footer = get_theme_mod( 'single_footer_sev', 'default' );
        }
        
    }

    return $footer;

}