<?php

if (!defined( 'ABSPATH' )) {
	exit;
}
if (!class_exists( 'Ova_Tema_Customize' )){

	class Ova_Tema_Customize {

		public function __construct() {
			add_action( 'customize_register', array( $this, 'ova_team_customize_register' ) );
		}

		public function ova_team_customize_register($wp_customize) {

			$this->ova_team_init( $wp_customize );

			do_action( 'ova_team_customize_register', $wp_customize );
		}


		/* Team */
		public function ova_team_init( $wp_customize ){

			$wp_customize->add_panel( 'ova_team_panel', array(
			  	'title' => esc_html__( 'Team', 'ova-team' ),
			  	'priority' => 5,
			) );


			$wp_customize->add_section( 'ova_team_archive_section' , array(
				'title'      => esc_html__( 'Archive', 'ova-team' ),
				'priority'   => 1,
				'panel' => 'ova_team_panel',
			) );

			$wp_customize->add_section( 'ova_team_single_section' , array(
				'title'      => esc_html__( 'Single', 'ova-team' ),
				'priority'   => 2,
				'panel' => 'ova_team_panel',
			) );

			// Archive
			$wp_customize->add_setting( 'ova_team_total_record', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => '6',
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('ova_team_total_record', array(
				'label' => esc_html__('Number of posts per page','ova-team'),
				'section' => 'ova_team_archive_section',
				'settings' => 'ova_team_total_record',
				'type' =>'number'
			));

			$wp_customize->add_setting( 'ova_team_orderby', array(
				'type' 				=> 'theme_mod', // or 'option'
				'capability' 		=> 'edit_theme_options',
				'theme_supports' 	=> '', // Rarely needed.
				'default' 			=> 'ID',
				'transport' 		=> 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			));

			$wp_customize->add_control('ova_team_orderby', array(
				'label' 	=> esc_html__('Orderby','ova-team'),
				'section' 	=> 'ova_team_archive_section',
				'settings' 	=> 'ova_team_orderby',
				'type' 		=>'select',
				'choices' 	=> array(
					'ova_team_met_order_team' 	=> esc_html__( 'Sort Order', 'ova-team' ),
					'ID' 			=> esc_html__( 'ID', 'ova-team' ),
					'title' 		=> esc_html__( 'Title', 'ova-team' ),
					'date' 			=> esc_html__( 'Date', 'ova-team' ),
					'rand' 			=> esc_html__( 'Random', 'ova-team' ),
				)
			));

			$wp_customize->add_setting( 'ova_team_order', array(
				'type' 				=> 'theme_mod', // or 'option'
				'capability' 		=> 'edit_theme_options',
				'theme_supports' 	=> '', // Rarely needed.
				'default' 			=> 'DESC',
				'transport' 		=> 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			));

			$wp_customize->add_control('ova_team_order', array(
				'label' 	=> esc_html__('Order','ova-team'),
				'section' 	=> 'ova_team_archive_section',
				'settings' 	=> 'ova_team_order',
				'type' 		=>'select',
				'choices' 	=> array(
					'ASC' 	=> esc_html__( 'Ascending', 'ova-team' ),
					'DESC' 	=> esc_html__( 'Descending', 'ova-team' ),
				)
			));

			$wp_customize->add_setting( 'ova_team_template', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => 'grid_default',
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('ova_team_template', array(
				'label' => esc_html__('Template','ova-team'),
				'section' => 'ova_team_archive_section',
				'settings' => 'ova_team_template',
				'type' =>'select',
				'choices' => array(
					'grid_default'   	=> esc_html__( 'Grid Default', 'ova-team' ),
					'grid_modern' 		=> esc_html__( 'Grid Modern', 'ova-team' ),
					'grid_modern_2'  	=> esc_html__( 'Grid Modern 2', 'ova-team' ),
					'grid2_template_1'  => esc_html__( 'Grid 2 - Template 1', 'ova-team' ),
					'grid2_template_2'  => esc_html__( 'Grid 2 - Template 2', 'ova-team' ),
					'grid3_template_1'  => esc_html__( 'Grid 3 - Template 1', 'ova-team' ),
					'grid3_template_2'  => esc_html__( 'Grid 3 - Template 2', 'ova-team' ),
				)
			));

			$wp_customize->add_setting( 'ova_team_layout', array(
				'type' => 'theme_mod', // or 'option'
				'capability' => 'edit_theme_options',
				'theme_supports' => '', // Rarely needed.
				'default' => 'three_column',
				'transport' => 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('ova_team_layout', array(
				'label' => esc_html__('Layout','ova-team'),
				'section' => 'ova_team_archive_section',
				'settings' => 'ova_team_layout',
				'type' =>'select',
				'choices' => array(
					'two_column'   => esc_html__( '2 column', 'ova-team' ),
					'three_column' => esc_html__( '3 column', 'ova-team' ),
					'four_column'  => esc_html__( '4 column', 'ova-team' ),
				)
			));

			$wp_customize->add_setting( 'header_archive_team', array(
			  	'type' => 'theme_mod', // or 'option'
			  	'capability' => 'edit_theme_options',
			  	'theme_supports' => '', // Rarely needed.
			  	'default' => 'default',
			  	'transport' => 'refresh', // or postMessage
			  	'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('header_archive_team', array(
				'label' => esc_html__('Header','ova-team'),
				'section' => 'ova_team_archive_section',
				'settings' => 'header_archive_team',
				'type' =>'select',
				'choices' => apply_filters('gimont_list_header', '')
			));

			$wp_customize->add_setting( 'archive_footer_team', array(
			  	'type' => 'theme_mod', // or 'option'
			  	'capability' => 'edit_theme_options',
			  	'theme_supports' => '', // Rarely needed.
			  	'default' => 'default',
			  	'transport' => 'refresh', // or postMessage
			  	'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('archive_footer_team', array(
				'label' => esc_html__('Footer','ova-team'),
				'section' => 'ova_team_archive_section',
				'settings' => 'archive_footer_team',
				'type' =>'select',
				'choices' => apply_filters('gimont_list_footer', '')
			));

			$wp_customize->add_setting( 'archive_team_show_filter', array(
				'type' 				=> 'theme_mod', // or 'option'
				'capability' 		=> 'edit_theme_options',
				'theme_supports' 	=> '', // Rarely needed.
				'default' 			=> 'yes',
				'transport' 		=> 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			));

			$wp_customize->add_control('archive_team_show_filter', array(
				'label' 	=> esc_html__('Show Filter','ova-team'),
				'section' 	=> 'ova_team_archive_section',
				'settings' 	=> 'archive_team_show_filter',
				'type' 		=>'select',
				'choices' 	=> array(
					'yes' 	=> esc_html__( 'Yes', 'ova-team' ),
					'no' 	=> esc_html__( 'No', 'ova-team' ),
				)
			));

			$wp_customize->add_setting( 'archive_team_show_image', array(
				'type' 				=> 'theme_mod', // or 'option'
				'capability' 		=> 'edit_theme_options',
				'theme_supports' 	=> '', // Rarely needed.
				'default' 			=> 'yes',
				'transport' 		=> 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			));

			$wp_customize->add_control('archive_team_show_image', array(
				'label' 	=> esc_html__('Show Image','ova-team'),
				'section' 	=> 'ova_team_archive_section',
				'settings' 	=> 'archive_team_show_image',
				'type' 		=>'select',
				'choices' 	=> array(
					'yes' 	=> esc_html__( 'Yes', 'ova-team' ),
					'no' 	=> esc_html__( 'No', 'ova-team' ),
				)
			));

			$wp_customize->add_setting( 'archive_team_show_name', array(
				'type' 				=> 'theme_mod', // or 'option'
				'capability' 		=> 'edit_theme_options',
				'theme_supports' 	=> '', // Rarely needed.
				'default' 			=> 'yes',
				'transport' 		=> 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			));

			$wp_customize->add_control('archive_team_show_name', array(
				'label' 	=> esc_html__('Show Name','ova-team'),
				'section' 	=> 'ova_team_archive_section',
				'settings' 	=> 'archive_team_show_name',
				'type' 		=>'select',
				'choices' 	=> array(
					'yes' 	=> esc_html__( 'Yes', 'ova-team' ),
					'no' 	=> esc_html__( 'No', 'ova-team' ),
				)
			));

			$wp_customize->add_setting( 'archive_team_show_job', array(
				'type' 				=> 'theme_mod', // or 'option'
				'capability' 		=> 'edit_theme_options',
				'theme_supports' 	=> '', // Rarely needed.
				'default' 			=> 'yes',
				'transport' 		=> 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			));

			$wp_customize->add_control('archive_team_show_job', array(
				'label' 	=> esc_html__('Show Job','ova-team'),
				'section' 	=> 'ova_team_archive_section',
				'settings' 	=> 'archive_team_show_job',
				'type' 		=>'select',
				'choices' 	=> array(
					'yes' 	=> esc_html__( 'Yes', 'ova-team' ),
					'no' 	=> esc_html__( 'No', 'ova-team' ),
				)
			));

			$wp_customize->add_setting( 'archive_team_show_social', array(
				'type' 				=> 'theme_mod', // or 'option'
				'capability' 		=> 'edit_theme_options',
				'theme_supports' 	=> '', // Rarely needed.
				'default' 			=> 'yes',
				'transport' 		=> 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			));

			$wp_customize->add_control('archive_team_show_social', array(
				'label' 	=> esc_html__('Show Social','ova-team'),
				'section' 	=> 'ova_team_archive_section',
				'settings' 	=> 'archive_team_show_social',
				'type' 		=>'select',
				'choices' 	=> array(
					'yes' 	=> esc_html__( 'Yes', 'ova-team' ),
					'no' 	=> esc_html__( 'No', 'ova-team' ),
				)
			));

			$wp_customize->add_setting( 'archive_team_show_link_to', array(
				'type' 				=> 'theme_mod', // or 'option'
				'capability' 		=> 'edit_theme_options',
				'theme_supports' 	=> '', // Rarely needed.
				'default' 			=> 'yes',
				'transport' 		=> 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			));

			$wp_customize->add_control('archive_team_show_link_to', array(
				'label' 	=> esc_html__('Show Link to Detail','ova-team'),
				'section' 	=> 'ova_team_archive_section',
				'settings' 	=> 'archive_team_show_link_to',
				'type' 		=>'select',
				'choices' 	=> array(
					'yes' 	=> esc_html__( 'Yes', 'ova-team' ),
					'no' 	=> esc_html__( 'No', 'ova-team' ),
				)
			));


			// Single
			$wp_customize->add_setting( 'header_single_team', array(
			  	'type' => 'theme_mod', // or 'option'
			  	'capability' => 'edit_theme_options',
			  	'theme_supports' => '', // Rarely needed.
			  	'default' => 'default',
			  	'transport' => 'refresh', // or postMessage
			  	'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('header_single_team', array(
				'label' => esc_html__('Header','ova-team'),
				'section' => 'ova_team_single_section',
				'settings' => 'header_single_team',
				'type' =>'select',
				'choices' => apply_filters('gimont_list_header', '')
			));

			$wp_customize->add_setting( 'single_footer_team', array(
			  	'type' => 'theme_mod', // or 'option'
			  	'capability' => 'edit_theme_options',
			  	'theme_supports' => '', // Rarely needed.
			  	'default' => 'default',
			  	'transport' => 'refresh', // or postMessage
			  	'sanitize_callback' => 'sanitize_text_field' // Get function name 
			) );

			$wp_customize->add_control('single_footer_team', array(
				'label' => esc_html__('Footer','ova-team'),
				'section' => 'ova_team_single_section',
				'settings' => 'single_footer_team',
				'type' =>'select',
				'choices' => apply_filters('gimont_list_footer', '')
			));

			$wp_customize->add_setting( 'ova_team_slogan_field_type', array(
				'type' 				=> 'theme_mod', // or 'option'
				'capability' 		=> 'edit_theme_options',
				'theme_supports' 	=> '', // Rarely needed.
				'default' 			=> 'textarea',
				'transport' 		=> 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			));

			$wp_customize->add_control('ova_team_slogan_field_type', array(
				'label' 	=> esc_html__('Slogan: Field type','ova-team'),
				'section' 	=> 'ova_team_single_section',
				'settings' 	=> 'ova_team_slogan_field_type',
				'type' 		=>'select',
				'choices' 	=> array(
					'textarea' 	=> esc_html__( 'Textarea', 'ova-team' ),
					'wysiwyg' 	=> esc_html__( 'Wysiwyg ( TinyMCE editor )', 'ova-team' ),
				)
			));

			$wp_customize->add_setting( 'ova_team_short_desc_field_type', array(
				'type' 				=> 'theme_mod', // or 'option'
				'capability' 		=> 'edit_theme_options',
				'theme_supports' 	=> '', // Rarely needed.
				'default' 			=> 'textarea',
				'transport' 		=> 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			));

			$wp_customize->add_control('ova_team_short_desc_field_type', array(
				'label' 	=> esc_html__('Short Description: Field type','ova-team'),
				'section' 	=> 'ova_team_single_section',
				'settings' 	=> 'ova_team_short_desc_field_type',
				'type' 		=>'select',
				'choices' 	=> array(
					'textarea' 	=> esc_html__( 'Textarea', 'ova-team' ),
					'wysiwyg' 	=> esc_html__( 'Wysiwyg ( TinyMCE editor )', 'ova-team' ),
				)
			));

			$wp_customize->add_setting( 'single_team_show_image', array(
				'type' 				=> 'theme_mod', // or 'option'
				'capability' 		=> 'edit_theme_options',
				'theme_supports' 	=> '', // Rarely needed.
				'default' 			=> 'yes',
				'transport' 		=> 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			));

			$wp_customize->add_control('single_team_show_image', array(
				'label' 	=> esc_html__('Show Image','ova-team'),
				'section' 	=> 'ova_team_single_section',
				'settings' 	=> 'single_team_show_image',
				'type' 		=>'select',
				'choices' 	=> array(
					'yes' 	=> esc_html__( 'Yes', 'ova-team' ),
					'no' 	=> esc_html__( 'No', 'ova-team' ),
				)
			));

			$wp_customize->add_setting( 'single_team_show_job', array(
				'type' 				=> 'theme_mod', // or 'option'
				'capability' 		=> 'edit_theme_options',
				'theme_supports' 	=> '', // Rarely needed.
				'default' 			=> 'yes',
				'transport' 		=> 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			));

			$wp_customize->add_control('single_team_show_job', array(
				'label' 	=> esc_html__('Show Job','ova-team'),
				'section' 	=> 'ova_team_single_section',
				'settings' 	=> 'single_team_show_job',
				'type' 		=>'select',
				'choices' 	=> array(
					'yes' 	=> esc_html__( 'Yes', 'ova-team' ),
					'no' 	=> esc_html__( 'No', 'ova-team' ),
				)
			));

			$wp_customize->add_setting( 'single_team_show_name', array(
				'type' 				=> 'theme_mod', // or 'option'
				'capability' 		=> 'edit_theme_options',
				'theme_supports' 	=> '', // Rarely needed.
				'default' 			=> 'yes',
				'transport' 		=> 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			));

			$wp_customize->add_control('single_team_show_name', array(
				'label' 	=> esc_html__('Show Name','ova-team'),
				'section' 	=> 'ova_team_single_section',
				'settings' 	=> 'single_team_show_name',
				'type' 		=>'select',
				'choices' 	=> array(
					'yes' 	=> esc_html__( 'Yes', 'ova-team' ),
					'no' 	=> esc_html__( 'No', 'ova-team' ),
				)
			));

			$wp_customize->add_setting( 'single_team_show_slogan', array(
				'type' 				=> 'theme_mod', // or 'option'
				'capability' 		=> 'edit_theme_options',
				'theme_supports' 	=> '', // Rarely needed.
				'default' 			=> 'yes',
				'transport' 		=> 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			));

			$wp_customize->add_control('single_team_show_slogan', array(
				'label' 	=> esc_html__('Show Slogan','ova-team'),
				'section' 	=> 'ova_team_single_section',
				'settings' 	=> 'single_team_show_slogan',
				'type' 		=>'select',
				'choices' 	=> array(
					'yes' 	=> esc_html__( 'Yes', 'ova-team' ),
					'no' 	=> esc_html__( 'No', 'ova-team' ),
				)
			));

			$wp_customize->add_setting( 'single_team_show_short_desc', array(
				'type' 				=> 'theme_mod', // or 'option'
				'capability' 		=> 'edit_theme_options',
				'theme_supports' 	=> '', // Rarely needed.
				'default' 			=> 'yes',
				'transport' 		=> 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			));

			$wp_customize->add_control('single_team_show_short_desc', array(
				'label' 	=> esc_html__('Show Short Description','ova-team'),
				'section' 	=> 'ova_team_single_section',
				'settings' 	=> 'single_team_show_short_desc',
				'type' 		=>'select',
				'choices' 	=> array(
					'yes' 	=> esc_html__( 'Yes', 'ova-team' ),
					'no' 	=> esc_html__( 'No', 'ova-team' ),
				)
			));

			$wp_customize->add_setting( 'single_team_show_experience', array(
				'type' 				=> 'theme_mod', // or 'option'
				'capability' 		=> 'edit_theme_options',
				'theme_supports' 	=> '', // Rarely needed.
				'default' 			=> 'yes',
				'transport' 		=> 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			));

			$wp_customize->add_control('single_team_show_experience', array(
				'label' 	=> esc_html__('Show Experience','ova-team'),
				'section' 	=> 'ova_team_single_section',
				'settings' 	=> 'single_team_show_experience',
				'type' 		=>'select',
				'choices' 	=> array(
					'yes' 	=> esc_html__( 'Yes', 'ova-team' ),
					'no' 	=> esc_html__( 'No', 'ova-team' ),
				)
			));

			$wp_customize->add_setting( 'single_team_show_email', array(
				'type' 				=> 'theme_mod', // or 'option'
				'capability' 		=> 'edit_theme_options',
				'theme_supports' 	=> '', // Rarely needed.
				'default' 			=> 'yes',
				'transport' 		=> 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			));

			$wp_customize->add_control('single_team_show_email', array(
				'label' 	=> esc_html__('Show Email','ova-team'),
				'section' 	=> 'ova_team_single_section',
				'settings' 	=> 'single_team_show_email',
				'type' 		=>'select',
				'choices' 	=> array(
					'yes' 	=> esc_html__( 'Yes', 'ova-team' ),
					'no' 	=> esc_html__( 'No', 'ova-team' ),
				)
			));

			$wp_customize->add_setting( 'single_team_show_phone', array(
				'type' 				=> 'theme_mod', // or 'option'
				'capability' 		=> 'edit_theme_options',
				'theme_supports' 	=> '', // Rarely needed.
				'default' 			=> 'yes',
				'transport' 		=> 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			));

			$wp_customize->add_control('single_team_show_phone', array(
				'label' 	=> esc_html__('Show Phone','ova-team'),
				'section' 	=> 'ova_team_single_section',
				'settings' 	=> 'single_team_show_phone',
				'type' 		=>'select',
				'choices' 	=> array(
					'yes' 	=> esc_html__( 'Yes', 'ova-team' ),
					'no' 	=> esc_html__( 'No', 'ova-team' ),
				)
			));

			$wp_customize->add_setting( 'single_team_show_process', array(
				'type' 				=> 'theme_mod', // or 'option'
				'capability' 		=> 'edit_theme_options',
				'theme_supports' 	=> '', // Rarely needed.
				'default' 			=> 'yes',
				'transport' 		=> 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			));

			$wp_customize->add_control('single_team_show_process', array(
				'label' 	=> esc_html__('Show List Process','ova-team'),
				'section' 	=> 'ova_team_single_section',
				'settings' 	=> 'single_team_show_process',
				'type' 		=>'select',
				'choices' 	=> array(
					'yes' 	=> esc_html__( 'Yes', 'ova-team' ),
					'no' 	=> esc_html__( 'No', 'ova-team' ),
				)
			));

			$wp_customize->add_setting( 'single_team_show_social', array(
				'type' 				=> 'theme_mod', // or 'option'
				'capability' 		=> 'edit_theme_options',
				'theme_supports' 	=> '', // Rarely needed.
				'default' 			=> 'yes',
				'transport' 		=> 'refresh', // or postMessage
				'sanitize_callback' => 'sanitize_text_field' // Get function name 
			));

			$wp_customize->add_control('single_team_show_social', array(
				'label' 	=> esc_html__('Show Social','ova-team'),
				'section' 	=> 'ova_team_single_section',
				'settings' 	=> 'single_team_show_social',
				'type' 		=>'select',
				'choices' 	=> array(
					'yes' 	=> esc_html__( 'Yes', 'ova-team' ),
					'no' 	=> esc_html__( 'No', 'ova-team' ),
				)
			));

		}

	}

}

new Ova_Tema_Customize();