(function($){
	"use strict";
	
	$(window).on('elementor/frontend/init', function () {
		
        elementorFrontend.hooks.addAction('frontend/element_ready/gimont_elementor_countdown.default', function(){
	       
	        /* Add your code here */
	    	var dataDate 	= JSON.parse( $('.ova-countdown').attr('data-date') );
        	var year 		= parseInt( dataDate.year );
        	var month 		= parseInt( dataDate.month );
        	var day 		= parseInt( dataDate.day );
        	var hours 		= parseInt( dataDate.hours );
        	var minutes 	= parseInt( dataDate.minutes );
        	var timezone 	= dataDate.timezone;
        	var language 	= dataDate.lang;
        	var langUrl 	= dataDate.langUrl;
        	var format		= dataDate.format;
        	var austDay 	= new Date(); 
			austDay 		= new Date(year, month - 1, day, hours, minutes); 

        	if ( language != 'en' ) {
        		$.localise(langUrl, {language: language, loadBase: true});
        		$('.ova-countdown').countdown($.extend({until: austDay,timezone: timezone, padZeroes: true, format: format }, $.countdown.regionalOptions[language]));
        	} else {
        		$('.ova-countdown').countdown({until: austDay,timezone: timezone, padZeroes: true, format: format });
        	}
			
	        });
       
        
   });

})(jQuery);
