<?php

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Background;
use Elementor\Utils;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


class Gimont_Elementor_Counter_List_2 extends Widget_Base {

	
	public function get_name() {
		return 'gimont_elementor_counter_list_2';
	}

	
	public function get_title() {
		return esc_html__( 'Counter List 2', 'gimont' );
	}

	
	public function get_icon() {
		return 'eicon-counter-circle';
	}

	
	public function get_categories() {
		return [ 'gimont' ];
	}

	public function get_script_depends() {
		// appear js
		wp_enqueue_script( 'gimont-counter-appear', get_theme_file_uri('/assets/libs/appear/appear.js'), array('jquery'), false, true);
		// Odometer for counter
		wp_enqueue_style( 'odometer', get_template_directory_uri().'/assets/libs/odometer/odometer.min.css' );
		wp_enqueue_script( 'odometer', get_template_directory_uri().'/assets/libs/odometer/odometer.min.js', array('jquery'), false, true );
		return [ 'gimont-elementor-counter-list-2' ];
	}

	public function get_style_depends() {
		wp_enqueue_style( 'gimont-elementor-counter-list-2', GIMONT_URI.'/assets/scss/elementor/counters/counter-list-2.css' );
		return [];
	}
	
	// Add Your Controll In This Function
	protected function register_controls() {

		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Content', 'gimont' ),
			]
		);	

			$this->add_control(
				'template',
				[
					'label' => esc_html__( 'Template', 'gimont' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'default' => 'template_1',
					'options' => [
						'template_1' => esc_html__( 'Template 1', 'gimont' ),
						'template_2' => esc_html__( 'Template 2', 'gimont' ),
					],
				]
			);

		    $this->add_control(
				'number_column',
				[
					'label' => esc_html__( 'Number Column', 'gimont' ),
					'type' => Controls_Manager::SELECT,
					'default' => 'four_column',
					'options' => [
						'one_column' => esc_html__('Single Column', 'gimont'),
						'two_column' => esc_html__('2 Columns', 'gimont'),
						'three_column' => esc_html__('3 Columns', 'gimont'),
						'four_column' => esc_html__('4 Columns', 'gimont'),
					]
				]
			);

		    $repeater = new \Elementor\Repeater();

			    $repeater->add_control(
					'number',
					[
						'label' 	=> esc_html__( 'Number', 'gimont' ),
						'type'    => Controls_Manager::NUMBER,
						'default' => 84,
					]
				);

				$repeater->add_control(
					'suffix',
					[
						'label'  => esc_html__( 'Suffix', 'gimont' ),
						'type'   => Controls_Manager::TEXT,
					]
				);

				$repeater->add_control(
					'title',
					[
						'label' 	=> esc_html__( 'Title', 'gimont' ),
						'type' 	=> Controls_Manager::TEXTAREA,
						'default' => esc_html__( 'People lived in the city', 'gimont' ),
					]
				);
			

			$this->add_control(
				'items',
				[
					'label' => esc_html__( 'Items', 'gimont' ),
					'type' => Controls_Manager::REPEATER,
					'fields' => $repeater->get_controls(),
					'default' => [
						[	
							'title'   => esc_html__( 'Established', 'gimont' ),
							'number'  => 1994,
						],
						[	
							'title'  => esc_html__( 'Area KM Square', 'gimont' ),
							'number'  => 568138,
						],
						[	
							'title'  => esc_html__( 'City Hospitals', 'gimont' ),
							'number'  => 560,
						],
						[	
							'title'  => esc_html__( 'Jobs created', 'gimont' ),
							'number'  => 82752,
						],
					],
					'title_field' => '{{{ title }}}',
				]
			);

			$this->add_responsive_control(
				'align_heading',
				[
					'label' 	=> esc_html__( 'Alignment', 'gimont' ),
					'type' 		=> \Elementor\Controls_Manager::CHOOSE,
					'options' 	=> [
						'left' => [
							'title' => esc_html__( 'Left', 'gimont' ),
							'icon' 	=> 'eicon-text-align-left',
						],
						'center' => [
							'title' => esc_html__( 'Center', 'gimont' ),
							'icon' 	=> 'eicon-text-align-center',
						],
						'right' => [
							'title' => esc_html__( 'Right', 'gimont' ),
							'icon' 	=> 'eicon-text-align-right',
						],
					],
					'toggle' 	=> true,
					'selectors' => [
						'{{WRAPPER}} .ova-counter-list-2' => 'text-align: {{VALUE}}',
					],
				]
			);
			
		$this->end_controls_section();

		/* Begin Counter Style */
		$this->start_controls_section(
            'counter_style',
            [
               'label' => esc_html__( 'Counter', 'gimont' ),
               'tab' 	=> Controls_Manager::TAB_STYLE,
            ]
        );

			$this->add_control(
				'counter_bgcolor',
				[
					'label' 	=> esc_html__( 'Background', 'gimont' ),
					'type' 		=> Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-counter-list-2-wrapper' => 'background: {{VALUE}};',
					],
				]
			);

			$this->add_control(
				'counter_bgcolor_hover',
				[
					'label' 	=> esc_html__( 'Background Hover', 'gimont' ),
					'type' 		=> Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-counter-list-2-wrapper:hover' => 'background: {{VALUE}};',
					],
				]
			);

		    $this->add_responsive_control(
	            'counter_padding',
	            [
	                'label' 		=> esc_html__( 'Padding', 'gimont' ),
	                'type' 			=> Controls_Manager::DIMENSIONS,
	                'size_units' 	=> [ 'px', '%', 'em' ],
	                'selectors' 	=> [
	                    '{{WRAPPER}} .ova-counter-list-2-wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
	                ],
	            ]
	        );

	        $this->add_group_control(
				\Elementor\Group_Control_Box_Shadow::get_type(),
				[
					'name' => 'box_shadow',
					'label' => esc_html__( 'Box Shadow', 'gimont' ),
					'selector' => '{{WRAPPER}} .ova-counter-list-2-wrapper',
				]
			);

			$this->add_responsive_control(
				'counter_border_radius',
				array(
					'label'      => esc_html__( 'Border Radius', 'gimont' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => array( 'px', '%' ),
					'selectors'  => array(
						'{{WRAPPER}} .ova-counter-list-2-wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
				)
			);

        $this->end_controls_section();
		/* End counter style */  

		/* Begin suffix Style */
		$this->start_controls_section(
            'suffix_style',
            [
                'label' => esc_html__( 'Suffix', 'gimont' ),
                'tab' 	=> Controls_Manager::TAB_STYLE,
            ]
        );

            $this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' 		=> 'suffix_typography',
					'selector' 	=> '{{WRAPPER}} .ova-counter-list-2 .suffix',
				]
			);

			$this->add_control(
				'suffix_color',
				[
					'label' 	=> esc_html__( 'Color', 'gimont' ),
					'type' 		=> Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-counter-list-2 .suffix' => 'color: {{VALUE}};',
					],
				]
			);

			$this->add_control(
				'suffix_color_hover',
				[
					'label' 	=> esc_html__( 'Color Hover', 'gimont' ),
					'type' 		=> Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-counter-list-2:hover .suffix' => 'color: {{VALUE}};',
					],
				]
			);

			$this->add_responsive_control(
	            'suffix_padding',
	            [
	                'label' 		=> esc_html__( 'Padding', 'gimont' ),
	                'type' 			=> Controls_Manager::DIMENSIONS,
	                'size_units' 	=> [ 'px', '%', 'em' ],
	                'selectors' 	=> [
	                    '{{WRAPPER}} .ova-counter-list-2 .suffix' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
	                ],
	            ]
	        );

        $this->end_controls_section();
		/* End suffix style */

		/* Begin title Style */
		$this->start_controls_section(
            'title_style',
            [
                'label' => esc_html__( 'Title', 'gimont' ),
                'tab' 	=> Controls_Manager::TAB_STYLE,
            ]
        );

            $this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' 		=> 'title_typography',
					'selector' 	=> '{{WRAPPER}} .ova-counter-list-2 .title',
				]
			);

			$this->add_control(
				'title_color',
				[
					'label' 	=> esc_html__( 'Color', 'gimont' ),
					'type' 		=> Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-counter-list-2 .title' => 'color: {{VALUE}};',
					],
				]
			);

			$this->add_control(
				'title_color_hover',
				[
					'label' 	=> esc_html__( 'Color Hover', 'gimont' ),
					'type' 		=> Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-counter-list-2:hover .title' => 'color: {{VALUE}};',
					],
				]
			);

			$this->add_responsive_control(
	            'title_padding',
	            [
	                'label' 		=> esc_html__( 'Padding', 'gimont' ),
	                'type' 			=> Controls_Manager::DIMENSIONS,
	                'size_units' 	=> [ 'px', '%', 'em' ],
	                'selectors' 	=> [
	                    '{{WRAPPER}} .ova-counter-list-2 .title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
	                ],
	            ]
	        );

        $this->end_controls_section();
		/* End title style */

		
	}

	// Render Template Here
	protected function render() {

		$settings   = $this->get_settings();
        
        $template 	   = $settings['template'];
        $items 		   = $settings['items'];
        $number_column = $settings['number_column'];

		?>
           
            <div class="ova-counter-list-2-wrapper <?php echo esc_attr( $template ); ?> <?php echo esc_attr($number_column) ;?>">

            	<?php foreach( $items as $item ) { 
					$number     = isset( $item['number'] ) ? $item['number'] : '100';
					$suffix     = $item['suffix'];
					$title      = $item['title'];
			    ?>

		           <div class="ova-counter-list-2" data-count="<?php echo esc_attr( $number ); ?>">	  

		           		<?php if ($template == 'template_1'): ?>
		           			<div class="line"></div>    
		           		<?php endif;?>       

		           		<div class="wrapper-content">
		           			<?php if (!empty( $title )): ?>
								<h3 class="title"><?php echo esc_html( $title ); ?></h3>
							<?php endif;?>

							<?php if ($template == 'template_2'): ?>
			           			<div class="line"></div>    
			           		<?php endif;?>

							<div class="odometer-wrapper">
								<span class="odometer">0</span>
								<span class="suffix">
									<?php echo esc_html( $suffix ); ?>
						        </span>
						    </div>
		           		</div>

		           		

		           </div>

	           <?php } ?>

            </div>
		 	
		<?php
	}

	
}
$widgets_manager->register( new Gimont_Elementor_Counter_List_2() );