<?php

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Background;
use Elementor\Utils;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


class Gimont_Elementor_Counter_List extends Widget_Base {

	
	public function get_name() {
		return 'gimont_elementor_counter_list';
	}

	
	public function get_title() {
		return esc_html__( 'Counter List', 'gimont' );
	}

	
	public function get_icon() {
		return 'eicon-counter-circle';
	}

	
	public function get_categories() {
		return [ 'gimont' ];
	}

	public function get_script_depends() {
		// appear js
		wp_enqueue_script( 'gimont-counter-appear', get_theme_file_uri('/assets/libs/appear/appear.js'), array('jquery'), false, true);
		// Odometer for counter
		wp_enqueue_style( 'odometer', get_template_directory_uri().'/assets/libs/odometer/odometer.min.css' );
		wp_enqueue_script( 'odometer', get_template_directory_uri().'/assets/libs/odometer/odometer.min.js', array('jquery'), false, true );
		return [ 'gimont-elementor-counter-list' ];
	}

	public function get_style_depends() {
		wp_enqueue_style( 'gimont-elementor-counter-list', GIMONT_URI.'/assets/scss/elementor/counters/counter-list.css' );
		return [];
	}
	
	// Add Your Controll In This Function
	protected function register_controls() {

		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Content', 'gimont' ),
			]
		);	

			$this->add_control(
				'template',
				[
					'label' => esc_html__( 'Template', 'gimont' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'default' => 'template_1',
					'options' => [
						'template_1' => esc_html__( 'Template 1', 'gimont' ),
						'template_2' => esc_html__( 'Template 2', 'gimont' ),
					],
				]
			);

		    $this->add_control(
				'number_column',
				[
					'label' => esc_html__( 'Number Column', 'gimont' ),
					'type' => Controls_Manager::SELECT,
					'default' => 'four_column',
					'options' => [
						'one_column' => esc_html__('Single Column', 'gimont'),
						'two_column' => esc_html__('2 Columns', 'gimont'),
						'three_column' => esc_html__('3 Columns', 'gimont'),
						'four_column' => esc_html__('4 Columns', 'gimont'),
					]
				]
			);

		    $repeater = new \Elementor\Repeater();

		    	$repeater->add_control(
					'icon',
					[
						'label' 	=> __( 'Icon', 'gimont' ),
						'type' 		=> Controls_Manager::ICONS,
						'default' 	=> [
							'value' 	=> 'gimonticon gimonticon-real-estate',
							'library' 	=> 'all',
						],
					]
				);

			    $repeater->add_control(
					'number',
					[
						'label' 	=> esc_html__( 'Number', 'gimont' ),
						'type'    => Controls_Manager::NUMBER,
						'default' => 84,
					]
				);

				$repeater->add_control(
					'suffix',
					[
						'label'  => esc_html__( 'Suffix', 'gimont' ),
						'type'   => Controls_Manager::TEXT,
						'default' => 'k',
					]
				);

				$repeater->add_control(
					'title',
					[
						'label' 	=> esc_html__( 'Title', 'gimont' ),
						'type' 	=> Controls_Manager::TEXTAREA,
						'default' => esc_html__( 'People lived in the city', 'gimont' ),
					]
				);
			

			$this->add_control(
				'items',
				[
					'label' => esc_html__( 'Items', 'gimont' ),
					'type' => Controls_Manager::REPEATER,
					'fields' => $repeater->get_controls(),
					'default' => [
						[	
							'title'   => esc_html__( 'Home ownership costs', 'gimont' ),
							'number'  => 4,
							'suffix'  => 'th'
						],
						[	
							'icon'   => [
								'value' => 'gimonticon gimonticon-park',
							],
							'title'  => esc_html__( 'Private gardenlands', 'gimont' ),
							'number'  => 36,
							'suffix'  => '%'
						],
						[	
							'icon'   => [
								'value' => 'gimonticon gimonticon-running-man',
							],
							'title'  => esc_html__( 'People lived in the city', 'gimont' ),
							'number'  => 84,
						],
						[	
							'icon'   => [
								'value' => 'gimonticon gimonticon-radar',
							],
							'title'  => esc_html__( 'Kilometers region covers', 'gimont' ),
							'number'  => 3.3,
						],
					],
					'title_field' => '{{{ title }}}',
				]
			);

			$this->add_responsive_control(
				'align_heading',
				[
					'label' 	=> esc_html__( 'Alignment', 'gimont' ),
					'type' 		=> \Elementor\Controls_Manager::CHOOSE,
					'options' 	=> [
						'left' => [
							'title' => esc_html__( 'Left', 'gimont' ),
							'icon' 	=> 'eicon-text-align-left',
						],
						'center' => [
							'title' => esc_html__( 'Center', 'gimont' ),
							'icon' 	=> 'eicon-text-align-center',
						],
						'right' => [
							'title' => esc_html__( 'Right', 'gimont' ),
							'icon' 	=> 'eicon-text-align-right',
						],
					],
					'toggle' 	=> true,
					'selectors' => [
						'{{WRAPPER}} .ova-counter-list' => 'text-align: {{VALUE}}',
					],
				]
			);
			
		$this->end_controls_section();

		/* Begin Counter Style */
		$this->start_controls_section(
            'counter_style',
            [
               'label' => esc_html__( 'Counter', 'gimont' ),
               'tab' 	=> Controls_Manager::TAB_STYLE,
            ]
        );

			$this->add_control(
				'counter_bgcolor',
				[
					'label' 	=> esc_html__( 'Background', 'gimont' ),
					'type' 		=> Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-counter-list' => 'background: {{VALUE}};',
					],
				]
			);

			$this->add_control(
				'counter_bgcolor_hover',
				[
					'label' 	=> esc_html__( 'Background Hover', 'gimont' ),
					'type' 		=> Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-counter-list:hover' => 'background: {{VALUE}};',
					],
				]
			);

		    $this->add_responsive_control(
	            'counter_padding',
	            [
	                'label' 		=> esc_html__( 'Padding', 'gimont' ),
	                'type' 			=> Controls_Manager::DIMENSIONS,
	                'size_units' 	=> [ 'px', '%', 'em' ],
	                'selectors' 	=> [
	                    '{{WRAPPER}} .ova-counter-list' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
	                ],
	            ]
	        );

	        $this->add_group_control(
				\Elementor\Group_Control_Box_Shadow::get_type(),
				[
					'name' => 'box_shadow',
					'label' => esc_html__( 'Box Shadow', 'gimont' ),
					'selector' => '{{WRAPPER}} .ova-counter-list',
				]
			);

			$this->add_responsive_control(
				'counter_border_radius',
				array(
					'label'      => esc_html__( 'Border Radius', 'gimont' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => array( 'px', '%' ),
					'selectors'  => array(
						'{{WRAPPER}} .ova-counter-list' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
				)
			);

        $this->end_controls_section();
		/* End counter style */
        
        /* Begin icon Style */
		$this->start_controls_section(
			'section_icon_style',
			[
				'label' => esc_html__( 'Icon', 'gimont' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_control(
				'icon_fontsize',
				[
					'label' 		=> esc_html__( 'Size', 'gimont' ),
					'type' 			=> Controls_Manager::SLIDER,
					'size_units' 	=> [ 'px' ],
					'range' => [
						'px' => [
							'min' 	=> 0,
							'max' 	=> 90,
							'step' 	=> 1,
						]
					],
					'selectors' 	=> [
						'{{WRAPPER}} .ova-counter-list .icon' => 'font-size: {{SIZE}}{{UNIT}};',
					],
				]
			);

			$this->add_control(
				'icon_color',
				[
					'label' 	=> esc_html__( 'Color', 'gimont' ),
					'type' 		=> Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-counter-list .icon' => 'color : {{VALUE}};',
					],
				]
			);

			$this->add_control(
				'icon_color_hover',
				[
					'label' 	=> esc_html__( 'Color Hover', 'gimont' ),
					'type' 		=> Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-counter-list:hover .icon' => 'color : {{VALUE}};',
					],
				]
			);

			$this->add_control(
				'icon_bgcolor',
				[
					'label' 	=> esc_html__( 'Background Color', 'gimont' ),
					'type' 		=> Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-counter-list .icon' => 'background-color : {{VALUE}};',
					],
				]
			);

			$this->add_control(
				'icon_bgcolor_hover',
				[
					'label' 	=> esc_html__( 'Background Color Hover', 'gimont' ),
					'type' 		=> Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-counter-list:hover .icon' => 'background-color : {{VALUE}};',
					],
				]
			);

			$this->add_responsive_control(
				'icon_margin',
				[
					'label' 		=> esc_html__( 'Margin', 'gimont' ),
					'type' 			=> Controls_Manager::DIMENSIONS,
					'size_units' 	=> [ 'px', 'em', '%' ],
					'selectors' 	=> [
						'{{WRAPPER}} .ova-counter-list .icon' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

		$this->end_controls_section(); 
		// End Style tab Icon

		/* Begin number (odometer) Style */
		$this->start_controls_section(
            'number_style',
            [
                'label' => esc_html__( 'Number', 'gimont' ),
                'tab' 	=> Controls_Manager::TAB_STYLE,
            ]
        );

			 $this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' 		=> 'number_typography',
					'selector' 	=> '{{WRAPPER}} .ova-counter-list .odometer',
				]
			);

			$this->add_control(
				'number_color',
				[
					'label' 	=> esc_html__( 'Color', 'gimont' ),
					'type' 		=> Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-counter-list .odometer' => 'color: {{VALUE}};',
					],
				]
			);

			$this->add_control(
				'number_color_hover',
				[
					'label' 	=> esc_html__( 'Color Hover', 'gimont' ),
					'type' 		=> Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-counter-list:hover .odometer' => 'color: {{VALUE}};',
					],
				]
			);

        $this->end_controls_section();
		/* End number style */

		/* Begin suffix Style */
		$this->start_controls_section(
            'suffix_style',
            [
                'label' => esc_html__( 'Suffix', 'gimont' ),
                'tab' 	=> Controls_Manager::TAB_STYLE,
            ]
        );

            $this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' 		=> 'suffix_typography',
					'selector' 	=> '{{WRAPPER}} .ova-counter-list .suffix',
				]
			);

			$this->add_control(
				'suffix_color',
				[
					'label' 	=> esc_html__( 'Color', 'gimont' ),
					'type' 		=> Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-counter-list .suffix' => 'color: {{VALUE}};',
					],
				]
			);

			$this->add_control(
				'suffix_color_hover',
				[
					'label' 	=> esc_html__( 'Color Hover', 'gimont' ),
					'type' 		=> Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-counter-list:hover .suffix' => 'color: {{VALUE}};',
					],
				]
			);

			$this->add_responsive_control(
	            'suffix_padding',
	            [
	                'label' 		=> esc_html__( 'Padding', 'gimont' ),
	                'type' 			=> Controls_Manager::DIMENSIONS,
	                'size_units' 	=> [ 'px', '%', 'em' ],
	                'selectors' 	=> [
	                    '{{WRAPPER}} .ova-counter-list .suffix' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
	                ],
	            ]
	        );

        $this->end_controls_section();
		/* End suffix style */

		/* Begin title Style */
		$this->start_controls_section(
            'title_style',
            [
                'label' => esc_html__( 'Title', 'gimont' ),
                'tab' 	=> Controls_Manager::TAB_STYLE,
            ]
        );

            $this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' 		=> 'title_typography',
					'selector' 	=> '{{WRAPPER}} .ova-counter-list .title',
				]
			);

			$this->add_control(
				'title_color',
				[
					'label' 	=> esc_html__( 'Color', 'gimont' ),
					'type' 		=> Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-counter-list .title' => 'color: {{VALUE}};',
					],
				]
			);

			$this->add_control(
				'title_color_hover',
				[
					'label' 	=> esc_html__( 'Color Hover', 'gimont' ),
					'type' 		=> Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-counter-list:hover .title' => 'color: {{VALUE}};',
					],
				]
			);

			$this->add_responsive_control(
	            'title_padding',
	            [
	                'label' 		=> esc_html__( 'Padding', 'gimont' ),
	                'type' 			=> Controls_Manager::DIMENSIONS,
	                'size_units' 	=> [ 'px', '%', 'em' ],
	                'selectors' 	=> [
	                    '{{WRAPPER}} .ova-counter-list .title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
	                ],
	            ]
	        );

        $this->end_controls_section();
		/* End title style */

		
	}

	// Render Template Here
	protected function render() {

		$settings   = $this->get_settings();
        
        $template 	   = $settings['template'];
        $items 		   = $settings['items'];
        $number_column = $settings['number_column'];

		?>
           
            <div class="ova-counter-list-wrapper <?php echo esc_attr( $template ); ?> <?php echo esc_attr($number_column) ;?>">

            	<?php foreach( $items as $item ) { 
	                $class_icon = $item['icon']['value'];
					$number     = isset( $item['number'] ) ? $item['number'] : '100';
					$suffix     = $item['suffix'];
					$title      = $item['title'];
			    ?>

		           <div class="ova-counter-list" data-count="<?php echo esc_attr( $number ); ?>">
		                
			            <?php if(!empty( $class_icon )) : ?>
			            	<div class="icon-wrapper">
			            		<div class="icon">
									<i class="<?php echo esc_attr( $class_icon ); ?>"></i>
								</div>
			            	</div>
						<?php endif; ?>
			            
		                <div class="odometer-wrapper">
							<span class="odometer">0</span>
							<span class="suffix">
								<?php echo esc_html( $suffix ); ?>
					        </span>
					    </div>
						
			      	     <?php if (!empty( $title )): ?>
							<h3 class="title"><?php echo esc_html( $title ); ?></h3>
						<?php endif;?>

		           </div>

	           <?php } ?>

            </div>
		 	
		<?php
	}

	
}
$widgets_manager->register( new Gimont_Elementor_Counter_List() );