<?php

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Utils;
use Elementor\Group_Control_Border;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Gimont_Elementor_Image_Box extends Widget_Base {

	public function get_name() {
		return 'gimont_elementor_image_box';
	}

	public function get_title() {
		return esc_html__( 'Ova Image Box', 'gimont' );
	}

	public function get_icon() {
		return 'eicon-image-box';
	}

	public function get_categories() {
		return [ 'gimont' ];
	}

	public function get_script_depends() {
		return [ '' ];
	}

	public function get_style_depends() {
		wp_enqueue_style( 'gimont-elementor-image-box', GIMONT_URI.'/assets/scss/elementor/images/image-box.css' );
		return [];
	}
	
	// Add Your Controll In This Function
	protected function register_controls() {

		/* Content */
		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Content', 'gimont' ),
			]
		);

			$this->add_control(
				'link',
				[
					'label' => esc_html__( 'Link', 'gimont' ),
					'type' => \Elementor\Controls_Manager::URL,
					'placeholder' => esc_html__( 'https://your-link.com', 'gimont' ),
					'options' => [ 'url', 'is_external', 'nofollow' ],
					'default' => [
						'url' => '',
						'is_external' => false,
						'nofollow' => false,
					],
					'label_block' => true,
				]
			);

			$this->add_control(
				'image',
				[
					'label' => esc_html__( 'Choose Image', 'gimont' ),
					'type' => \Elementor\Controls_Manager::MEDIA,
					'default' => [
						'url' => \Elementor\Utils::get_placeholder_image_src(),
					],
				]
			);

			$this->add_control(
				'title',
				[
					'label' => esc_html__( 'Title', 'gimont' ),
					'type' => \Elementor\Controls_Manager::TEXT,
					'default' => esc_html__( 'Equality and Solidarity', 'gimont' ),
					'label_block' => true,
				]
			);

			$this->add_control(
				'description',
				[
					'label' => esc_html__( 'Description', 'gimont' ),
					'type' => \Elementor\Controls_Manager::TEXTAREA,
					'default' => esc_html__( 'There are many variations of passages available but majority simply ', 'gimont' ),
					'label_block' => true,
				]
			);

			$this->add_control(
				'text_link',
				[
					'label' => esc_html__( 'Text Link (Button)', 'gimont' ),
					'type' => \Elementor\Controls_Manager::TEXT,
					'default' => esc_html__( 'Read More', 'gimont' ),
				]
			);

		$this->end_controls_section();

		/* General */
		$this->start_controls_section(
				'style_section',
				[
					'label' => esc_html__( 'General', 'gimont' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_responsive_control(
				'item_margin',
				[
					'label' => esc_html__( 'Margin', 'gimont' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-image-box .content_inner' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_responsive_control(
				'item_padding',
				[
					'label' => esc_html__( 'Padding', 'gimont' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-image-box .content_inner' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_control(
				'item_bg',
				[
					'label' => esc_html__( 'Background', 'gimont' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-image-box .content_inner' => 'background: {{VALUE}}',
					],
				]
			);

		$this->end_controls_section();

		/* Title */
		$this->start_controls_section(
				'title_style_section',
				[
					'label' => esc_html__( 'Title', 'gimont' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name' => 'title_typography',
					'selector' => '{{WRAPPER}} .ova-image-box .content_inner .title',
				]
			);

			$this->add_control(
				'title_color',
				[
					'label' => esc_html__( 'Color', 'gimont' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-image-box .content_inner .title' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_responsive_control(
				'title_margin',
				[
					'label' => esc_html__( 'Margin', 'gimont' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-image-box .content_inner .title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

		$this->end_controls_section();

		/* Description */
		$this->start_controls_section(
			'description_style_section',
			[
				'label' => esc_html__( 'Description', 'gimont' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name' => 'description_typography',
					'selector' => '{{WRAPPER}} .ova-image-box .content_inner .description',
				]
			);

			$this->add_control(
				'description_color',
				[
					'label' => esc_html__( 'Color', 'gimont' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-image-box .content_inner .description' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_responsive_control(
				'description_padding',
				[
					'label' => esc_html__( 'Padding', 'gimont' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-image-box .content_inner .description' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_responsive_control(
				'description_margin',
				[
					'label' => esc_html__( 'Margin', 'gimont' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-image-box .content_inner .description' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Border::get_type(),
				[
					'name' => 'description_border',
					'selector' => '{{WRAPPER}} .ova-image-box .content_inner .description',
				]
			);

		$this->end_controls_section();


		/* Text Link */
		$this->start_controls_section(
			'text_link_style_section',
			[
				'label' => esc_html__( 'Text Link', 'gimont' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_responsive_control(
				'text_link_margin',
				[
					'label' => esc_html__( 'Margin', 'gimont' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-image-box .content_inner .text_link' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name' => 'text_link_typography',
					'selector' => '{{WRAPPER}} .ova-image-box .content_inner .text_link',
				]
			);

			$this->add_control(
				'text_link_color',
				[
					'label' => esc_html__( 'Color', 'gimont' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-image-box .content_inner .text_link .text-button' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_control(
				'text_link_icon_color',
				[
					'label' => esc_html__( 'Icon Color', 'gimont' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-image-box .content_inner .text_link i' => 'color: {{VALUE}}',
					],
				]
			);

		$this->end_controls_section();
	}

	// Render Template Here
	protected function render() {
		$settings 	= $this->get_settings();
		$image 		= $settings['image'];
		$title 		= $settings['title'];

		$description = $settings['description'];

		$link 		= $settings['link'];
		$text_link 	= $settings['text_link'];
		$nofollow 	= $link['nofollow'] 	? 'rel="nofollow"' 	: '';
		$target 	= $link['is_external'] 	? 'target="_blank"' : '';

		$image_id 	= $image['id'];
		$image_alt 	= '';

		if ( $image_id ) {
			$image_alt = get_post_meta( $image_id, '_wp_attachment_image_alt', true );
			if ( ! $image_alt ) {
				$image_alt = get_the_title( $image_id );
			}
		}

		?>

			<div class="ova-image-box">

				<?php if ( $image['url'] ): ?>
					<img src="<?php echo esc_url( $image['url'] ); ?>" alt="<?php echo esc_attr( $image_alt ); ?>" class="img-box">
				<?php endif; ?>

				<div class="content_inner">
					<?php if ( $title ): ?>
						<?php if ( $text_link && $link['url'] ): ?>
						<a href="<?php echo esc_url( $link['url'] ); ?>" class="text_link" <?php printf( '%1$s %2$s', $nofollow, $target ); ?>>
						<?php endif; ?>
							<h3 class="title"><?php echo esc_html( $title ); ?></h3>
						<?php if ( $text_link && $link['url'] ): ?>
						</a>
						<?php endif; ?>
					<?php endif; ?>
					<?php if ( $description ): ?>
						<p class="description"><?php echo esc_html( $description ); ?></p>
					<?php endif; ?>
					<?php if ( $text_link ): ?>
						<a href="<?php echo esc_url( $link['url'] ); ?>" class="text_link" <?php printf( '%1$s %2$s', $nofollow, $target ); ?>>
							<span class="text-button">
								<?php echo esc_html( $text_link ); ?>
							</span>
							<i aria-hidden="true" class="flaticonnew- flaticon-new-right"></i>
						</a>
					<?php endif; ?>
				</div>

			</div>

		<?php
	}

	
}
$widgets_manager->register( new Gimont_Elementor_Image_Box() );