<?php

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Utils;
use Elementor\Group_Control_Border;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Gimont_Elementor_News_Update extends Widget_Base {

	public function get_name() {
		return 'gimont_elementor_news_update';
	}

	public function get_title() {
		return esc_html__( 'News Update', 'gimont' );
	}

	public function get_icon() {
		return 'eicon-post-navigation';
	}

	public function get_categories() {
		return [ 'gimont' ];
	}

	public function get_script_depends() {
		return [ 'gimont-elementor-news-update' ];
	}

	public function get_style_depends() {
		wp_enqueue_style( 'gimont-elementor-news-update', GIMONT_URI.'/assets/scss/elementor/boxes/news-update.css' );
		return [];
	}
	
	// Add Your Controll In This Function
	protected function register_controls() {

		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Content', 'gimont' ),
			]
		);

		$this->add_control(
			'icon',
			[
				'label' => esc_html__( 'Icon', 'gimont' ),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fas fa-newspaper',
					'library' => 'all',
				],
			]
		);

		$this->add_control(
			'title',
			[
				'label' => esc_html__( 'Title', 'gimont' ),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'rows' => 3,
				'default' => esc_html__( 'City Update', 'gimont' ),
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_news',
			[
				'label' => esc_html__( 'News Update', 'gimont' ),
			]
		);

		$this->add_control(
			'post_types',
			[
				'label' => esc_html__( 'Post Types', 'gimont' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'post',
				'options' => [
					'post' 		=> esc_html__( 'Blog', 'gimont' ),
					'ova_dep' 	=> esc_html__( 'Department', 'gimont' ),
					'ova_doc' 	=> esc_html__( 'Documentation', 'gimont' ),
					'event' 	=> esc_html__( 'Event', 'gimont' ),
					'ova_sev'	=> esc_html__( 'Service', 'gimont' ),
				],
			]
		);

		$this->add_control(
			'order',
			[
				'label' => esc_html__( 'Order', 'gimont' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'DESC',
				'options' => [
					'ASC' => esc_html__( 'Ascending', 'gimont' ),
					'DESC' => esc_html__( 'Descending', 'gimont' ),
				],
			]
		);

		$this->add_control(
			'order_by',
			[
				'label' => esc_html__( 'Order By', 'gimont' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'date',
				'options' => [
					'title' => esc_html__( 'Title', 'gimont' ),
					'date' => esc_html__( 'Date', 'gimont' ),
					'rand' => esc_html__( 'Random', 'gimont' ),
				],
			]
		);

		$this->add_control(
			'posts_per_page',
			[
				'label' => esc_html__( 'Items', 'gimont' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => -1,
				'max' => 10,
				'step' => 1,
				'default' => 4,
				'frontend_available' => true,
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_additional_options',
			[
				'label' => esc_html__( 'Additional Options', 'gimont' ),
			]
		);

		/***************************  VERSION 1 ***********************/

			$this->add_control(
				'item_number',
				[
					'label'       => esc_html__( 'Item Number', 'gimont' ),
					'type'        => \Elementor\Controls_Manager::NUMBER,
					'description' => esc_html__( 'Number Item', 'gimont' ),
					'default'     => 3,
				]
			);

			$this->add_control(
				'slides_to_scroll',
				[
					'label'       => esc_html__( 'Slides to Scroll', 'gimont' ),
					'type'        => \Elementor\Controls_Manager::NUMBER,
					'description' => esc_html__( 'Set how many slides are scrolled per swipe.', 'gimont' ),
					'default'     => 1,
				]
			);

			$this->add_control(
				'pause_on_hover',
				[
					'label'   => esc_html__( 'Pause on Hover', 'gimont' ),
					'type'    => \Elementor\Controls_Manager::SWITCHER,
					'default' => 'yes',
					'options' => [
						'yes' => esc_html__( 'Yes', 'gimont' ),
						'no'  => esc_html__( 'No', 'gimont' ),
					],
					'frontend_available' => true,
				]
			);

			$this->add_control(
				'infinite',
				[
					'label'   => esc_html__( 'Infinite Loop', 'gimont' ),
					'type'    => \Elementor\Controls_Manager::SWITCHER,
					'default' => 'yes',
					'options' => [
						'yes' => esc_html__( 'Yes', 'gimont' ),
						'no'  => esc_html__( 'No', 'gimont' ),
					],
					'frontend_available' => true,
				]
			);

			$this->add_control(
				'autoplay',
				[
					'label'   => esc_html__( 'Autoplay', 'gimont' ),
					'type'    => \Elementor\Controls_Manager::SWITCHER,
					'default' => 'yes',
					'options' => [
						'yes' => esc_html__( 'Yes', 'gimont' ),
						'no'  => esc_html__( 'No', 'gimont' ),
					],
					'frontend_available' => true,
				]
			);

			$this->add_control(
				'autoplay_speed',
				[
					'label'     => esc_html__( 'Autoplay Speed', 'gimont' ),
					'type'      => \Elementor\Controls_Manager::NUMBER,
					'default'   => 3000,
					'step'      => 500,
					'condition' => [
						'autoplay' => 'yes',
					],
					'frontend_available' => true,
				]
			);

			$this->add_control(
				'smartspeed',
				[
					'label'   => esc_html__( 'Smart Speed', 'gimont' ),
					'type'    => \Elementor\Controls_Manager::NUMBER,
					'default' => 500,
				]
			);

		$this->end_controls_section();

		/* General */
		$this->start_controls_section(
				'general_style_section',
				[
					'label' => esc_html__( 'General', 'gimont' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_responsive_control(
				'general_padding',
				[
					'label' => esc_html__( 'Padding', 'gimont' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-news-update' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_control(
				'general_background',
				[
					'label' => esc_html__( 'Background', 'gimont' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-news-update' => 'background: {{VALUE}}',
					],
				]
			);

		$this->end_controls_section();

		/* Icon */
		$this->start_controls_section(
				'icon_style_section',
				[
					'label' => esc_html__( 'Icon', 'gimont' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_responsive_control(
				'icon_margin',
				[
					'label' => esc_html__( 'Margin', 'gimont' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-news-update .icon' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_control(
				'icon_size',
				[
					'label' => esc_html__( 'Size', 'gimont' ),
					'type' => \Elementor\Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 64,
							'step' => 1,
						],
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .ova-news-update .icon i' => 'font-size: {{SIZE}}{{UNIT}};',
						'{{WRAPPER}} .ova-news-update .icon svg' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
					],
				]
			);

			$this->add_control(
				'icon_color',
				[
					'label' => esc_html__( 'Color', 'gimont' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-news-update .icon i' => 'color: {{VALUE}}',
						'{{WRAPPER}} .ova-news-update .icon svg' => 'fill: {{VALUE}}',
					],
				]
			);

		$this->end_controls_section();

		/* Title */
		$this->start_controls_section(
				'title_style_section',
				[
					'label' => esc_html__( 'Title', 'gimont' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_responsive_control(
				'title_margin',
				[
					'label' => esc_html__( 'Margin', 'gimont' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-news-update .title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name' => 'title_typography',
					'selector' => '{{WRAPPER}} .ova-news-update .title',
				]
			);

			$this->add_control(
				'title_color',
				[
					'label' => esc_html__( 'Color', 'gimont' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-news-update .title' => 'color: {{VALUE}}',
					],
				]
			);

		$this->end_controls_section();

		/* Item Title */
		$this->start_controls_section(
				'item_title_style_section',
				[
					'label' => esc_html__( 'Item Title', 'gimont' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_responsive_control(
				'item_title_margin',
				[
					'label' => esc_html__( 'Margin', 'gimont' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-news-update .content-right .title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name' => 'item_title_typography',
					'selector' => '{{WRAPPER}} .ova-news-update .content-right .title a',
				]
			);

			$this->add_control(
				'item_title_color',
				[
					'label' => esc_html__( 'Color', 'gimont' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-news-update .content-right .title a' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_control(
				'item_title_hover_color',
				[
					'label' => esc_html__( 'Hover Color', 'gimont' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-news-update .content-right .title a:hover' => 'color: {{VALUE}}',
					],
				]
			);

		$this->end_controls_section();

		/* Nav Icon */
		$this->start_controls_section(
				'nav_icon_style_section',
				[
					'label' => esc_html__( 'Nav Icon', 'gimont' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_control(
				'nav_icon_size',
				[
					'label' => esc_html__( 'Size', 'gimont' ),
					'type' => \Elementor\Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 64,
							'step' => 1,
						],
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .ova-news-update .content-right .owl-nav .owl-prev i' => 'font-size: {{SIZE}}{{UNIT}};',
						'{{WRAPPER}} .ova-news-update .content-right .owl-nav .owl-next i' => 'font-size: {{SIZE}}{{UNIT}};',
					],
				]
			);

			$this->add_control(
				'nav_icon_color',
				[
					'label' => esc_html__( 'Color', 'gimont' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-news-update .content-right .owl-nav .owl-prev i' => 'color: {{VALUE}}',
						'{{WRAPPER}} .ova-news-update .content-right .owl-nav .owl-next i' => 'color: {{VALUE}}',
					],
				]
			);

		$this->end_controls_section();
	}

	// Render Template Here
	protected function render() {
		$settings 		= $this->get_settings();

		$icon 			= $settings['icon'];
		$title 			= $settings['title'];
		$post_types 	= $settings['post_types'];
		$order 			= $settings['order'];
		$order_by 		= $settings['order_by'];
		$posts_per_page = $settings['posts_per_page'];

		$data_options['items']              = $settings['item_number'];
		$data_options['slideBy']            = $settings['slides_to_scroll'];
		$data_options['autoplayHoverPause'] = $settings['pause_on_hover'] === 'yes' ? true : false;
		$data_options['loop']               = $settings['infinite'] === 'yes' ? true : false;
		$data_options['autoplay']           = $settings['autoplay'] === 'yes' ? true : false;
		$data_options['autoplayTimeout']    = $settings['autoplay_speed'];
		$data_options['smartSpeed']         = $settings['smartspeed'];
		$data_options['rtl']				= is_rtl() ? true: false;

		$args = array(
			'post_type' 	 => $post_types,
			'post_status' 	 => 'publish',
			'order' 		 => $order,
			'orderby' 		 => $order_by,
			'posts_per_page' => $posts_per_page,
		);
		
		$the_query = new WP_Query( $args );
		
		?>

		<div class="ova-news-update" data-option="<?php echo esc_attr( json_encode( $data_options ) ); ?>">
			<div class="content-left">
				<div class="icon">
					<?php \Elementor\Icons_Manager::render_icon( $icon, [ 'aria-hidden' => 'true' ] ); ?>
				</div>
				<h2 class="title"><?php echo esc_html( $title ); ?></h2>
			</div>
			<div class="content-right">
				<?php if ( $the_query->have_posts() ): ?>
				    <div class="news-update-slider owl-carousel owl-theme">
				    	<?php while ( $the_query->have_posts() ) : $the_query->the_post(); ?>
					        <div class="item">
					        	<h3 class="title">
					        		<a href="<?php echo esc_url( get_the_permalink() ); ?>"
					        			title="<?php echo esc_attr( get_the_title() ); ?>">
					        			<?php echo esc_html( get_the_title() ); ?>
					        		</a>
					        	</h3>
					        </div>
				        <?php endwhile;wp_reset_postdata(); ?>
				    </div>
				<?php endif; ?>
			</div>
		</div>
		<?php
	}

	
}
$widgets_manager->register( new Gimont_Elementor_News_Update() );