<?php

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use Elementor\Utils;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


class Gimont_Elementor_Progress_Circle extends Widget_Base {

	
	public function get_name() {
		return 'gimont_elementor_progress_circle';
	}

	
	public function get_title() {
		return esc_html__( 'Progress Circle', 'gimont' );
	}

	
	public function get_icon() {
		return 'eicon-spinner';
	}

	
	public function get_categories() {
		return [ 'gimont' ];
	}

	public function get_script_depends() {
		wp_enqueue_script( 'appear', get_theme_file_uri('/assets/libs/appear/appear.js'), array('jquery'), false, true);
		wp_enqueue_script( 'progress-circle', get_template_directory_uri().'/assets/libs/circle-progress/circle-progress.min.js', array('jquery'), false, true );
		return [ 'gimont-elementor-progress-circle' ];
	}

	public function get_style_depends() {
		wp_enqueue_style( 'gimont-elementor-progress-circle', GIMONT_URI.'/assets/scss/elementor/progress/progress-circle.css' );
		return [];
	}
	
	// Add Your Controll In This Function
	protected function register_controls() {

		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Progress Circle', 'gimont' ),
			]
		);	
			
			
			// Add Class control

			$this->add_control(
				'icon',
				[
					'label' => esc_html__( 'Icon', 'gimont' ),
					'type' => \Elementor\Controls_Manager::ICONS,
					'default' => [
						'value' => 'gimonticon gimonticon-rocket',
						'library' => 'all',
					],
				]
			);

			$this->add_control(
				'title_link',
				[
					'label' => esc_html__( 'Link', 'gimont' ),
					'type' => \Elementor\Controls_Manager::URL,
					'placeholder' => esc_html__( 'https://your-link.com', 'gimont' ),
					'options' => [ 'url', 'is_external', 'nofollow' ],
					'default' => [
						'url' => '#',
						'is_external' => false,
						'nofollow' => false,
					],
					'label_block' => true,
				]
			);

			$this->add_control(
				'title',
				[
					'label' => esc_html__( 'Title', 'gimont' ),
					'type' => Controls_Manager::TEXT,
					'default' => esc_html__( 'Healthy Residents', 'gimont' ),
				]
			);

			$this->add_control(
				'description',
				[
					'label' => esc_html__( 'Description', 'gimont' ),
					'type' => Controls_Manager::TEXTAREA,
					'default' => esc_html__( 'We denounce with righteous indignation dislike beguiled charms pleasure', 'gimont' ),
				]
			);

			$this->add_control(
				'percent',
				[
					'label' => esc_html__( 'Percent or Value/Total', 'gimont' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' 	=> [ 'px'],
					'default' => [
						'size' => 90,
					],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 100,
							'step' => 1,
						],
					],
				]
			);

			$this->add_control(
				'total',
				[
					'label' => esc_html__( 'Total', 'gimont' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' 	=> [ 'px'],
					'range' => [
						'px' => [
							'min' => 1,
							'max' => 10000,
							'step' => 1,
						],
					],
					'description' => esc_html__( 'If you set Total, Percent = Value/Total*100', 'gimont' ),
				]
			);

			$this->add_control(
				'unit',
				[
					'label' => esc_html__( 'Unit', 'gimont' ),
					'type' => Controls_Manager::TEXT,
					'default' => esc_html__( '%', 'gimont' ),
				]
			);

			$this->add_control(
				'circle_heading',
				[
					'label' => esc_html__( 'Circle', 'gimont' ),
					'type' => \Elementor\Controls_Manager::HEADING,
					'separator' => 'before',
				]
			);

			    $this->add_control(
					'linecap',
					[
						'label' => esc_html__( 'LineCap', 'gimont' ),
						'type' => Controls_Manager::SELECT,
						'default' => 'default',
						'options' => [
							'default' => esc_html__('Default', 'gimont'),
							'round'   => esc_html__('Round', 'gimont'),
						]
					]
				);

				$this->add_control(
					'circle_size',
					[
						'label' => esc_html__( 'Size (px)', 'gimont' ),
						'type' => Controls_Manager::SLIDER,
						'size_units' 	=> [ 'px'],
						'default' => [
							'size' => 210,
						],
						'range' => [
							'px' => [
								'min' => 120,
								'max' => 280,
								'step' => 1,
							],
						],
					]
				);

				$this->add_control(
					'circle_thickness',
					[
						'label' => esc_html__( 'Thickness', 'gimont' ),
						'type' => Controls_Manager::NUMBER,
						'min' => 5,
						'max' => 50,
						'step' => 1,
						'default' => 5		
					]
				);

				$this->add_control(
					'color_circle',
					[
						'label' => esc_html__( 'Color', 'gimont' ),
						'type' => Controls_Manager::COLOR,
						'default' => '#D82221'
					]
				);

				$this->add_responsive_control(
					'align',
					[
						'label' => esc_html__( 'Alignment', 'gimont' ),
						'type' 	=> Controls_Manager::CHOOSE,
						'options' => [
							'left' => [
								'title' => esc_html__( 'Left', 'gimont' ),
								'icon' 	=> 'eicon-text-align-left',
							],
							'center' => [
								'title' => esc_html__( 'Center', 'gimont' ),
								'icon' 	=> 'eicon-text-align-center',
							],
							'right' => [
								'title' => esc_html__( 'Right', 'gimont' ),
								'icon' 	=> 'eicon-text-align-right',
							],
						],
						'default' => 'center',
						'selectors' => [
							'{{WRAPPER}} .ova-progress-circle-wrapper' => 'text-align: {{VALUE}};',
						],
					]
			   );

		$this->end_controls_section();

		/* Begin percent Style */
		$this->start_controls_section(
            'percent_style',
            [
                'label' => esc_html__( 'Percent', 'gimont' ),
                'tab' 	=> Controls_Manager::TAB_STYLE,
            ]
        );

            $this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' 		=> 'percent_typography',
					'selector' 	=> '{{WRAPPER}} .ova-progress-circle-wrapper .ova-progress-circle .percent',
				]
			);

			$this->add_control(
				'percent_color',
				[
					'label' 	=> esc_html__( 'Color', 'gimont' ),
					'type' 		=> Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-progress-circle-wrapper .ova-progress-circle .percent' => 'color: {{VALUE}};',
					],
				]
			);

			$this->add_control(
				'percent_border_size',
				[
					'label' => esc_html__( 'Border Size', 'gimont' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' 	=> [ 'px', '%'],
					'range' => [
						'px' => [
							'min' => 100,
							'max' => 400,
							'step' => 1,
						],
						'%' => [
							'min' => 0,
							'max' => 100,
							'step' => 1,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .ova-progress-circle-wrapper .ova-progress-circle:before' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
					],
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Border::get_type(),
				[
					'name' => 'percent_border',
					'label' => esc_html__( 'Border', 'gimont' ),
					'selector' => '{{WRAPPER}} .ova-progress-circle-wrapper .ova-progress-circle:before',
				]
			);

        $this->end_controls_section();
		/* End percent style */

		/* Begin title Style */
		$this->start_controls_section(
            'title_style',
            [
                'label' => esc_html__( 'Title', 'gimont' ),
                'tab' 	=> Controls_Manager::TAB_STYLE,
            ]
        );

            $this->add_responsive_control(
				'title_align',
				[
					'label' => esc_html__( 'Alignment', 'gimont' ),
					'type' 	=> Controls_Manager::CHOOSE,
					'options' => [
						'left' => [
							'title' => esc_html__( 'Left', 'gimont' ),
							'icon' 	=> 'eicon-text-align-left',
						],
						'center' => [
							'title' => esc_html__( 'Center', 'gimont' ),
							'icon' 	=> 'eicon-text-align-center',
						],
						'right' => [
							'title' => esc_html__( 'Right', 'gimont' ),
							'icon' 	=> 'eicon-text-align-right',
						],
					],
					'default' => '',
					'selectors' => [
						'{{WRAPPER}} .ova-progress-circle-wrapper .title' => 'text-align: {{VALUE}};',
					],
				]
			);

            $this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' 		=> 'title_typography',
					'selector' 	=> '{{WRAPPER}} .ova-progress-circle-wrapper .title',
				]
			);

			$this->add_control(
				'title_color',
				[
					'label' 	=> esc_html__( 'Color', 'gimont' ),
					'type' 		=> Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-progress-circle-wrapper .title' => 'color: {{VALUE}};',
					],
				]
			);

			$this->add_responsive_control(
				'title_margin',
				[
					'label' 		=> esc_html__( 'Margin', 'gimont' ),
					'type' 			=> Controls_Manager::DIMENSIONS,
					'size_units' 	=> [ 'px', '%', 'em' ],
					'selectors' 	=> [
						'{{WRAPPER}} .ova-progress-circle-wrapper .title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

        $this->end_controls_section();
		/* End title style */

		
	}

	// Render Template Here
	protected function render() {

		$settings = $this->get_settings();

		$icon           =    $settings['icon'];
		$title_link 	= 	 $settings['title_link'];
		$title          =    $settings['title'];
		$description	=    $settings['description'];
		$unit           =    $settings['unit'];
		$percent        =    is_numeric( $settings['percent']['size'] ) ? $settings['percent']['size']  : '0';
		$total        	=    is_numeric( $settings['total']['size'] )  ? $settings['total']['size'] 	: '';

		if ( !empty($total) ) {
			$percentage = $percent / $total;
		} else {
			$percentage =  $percent / 100;
		}

		$size           =    is_numeric( $settings['circle_size']['size'] ) ? $settings['circle_size']['size'] : '144';
		$color          =    ( isset( $settings['color_circle'] ) && $settings['color_circle'] !== '' ) ?  $settings['color_circle'] : '#5f2dee' ;
		$thickness      =    $settings['circle_thickness'];
	    $linecap        =    $settings['linecap'];

	    $target 		= '';
		$nofollow 		= '';
		if ( $title_link && $title_link['url'] ) {
			$target 	= $title_link['is_external'] ? 'target="_blank"' : '';
			$nofollow 	= $title_link['nofollow'] ? 'rel="nofollow"' : '';
		}

		 ?>

            <div class="ova-progress-circle-wrapper">
            	
        	    <div class="ova-progress-circle"  
	                data-thickness="<?php echo esc_attr( $thickness ); ?>" 
	                data-size="<?php echo esc_attr( $size ); ?>"
	                data-total="<?php echo esc_attr( $total ); ?>"
	                data-value="<?php echo esc_attr( $percentage ); ?>"
	                data-color="<?php echo esc_attr( $color ); ?>"
	                data-linecap="<?php echo esc_attr( $linecap ); ?>"
	            >
	                
	                <div class="percent">
	                	<div class="icon">
							<?php \Elementor\Icons_Manager::render_icon( $icon, [ 'aria-hidden' => 'true' ] ); ?>
						</div>
						<div class="content">
							<strong></strong>
	            	    	<span><?php echo esc_html( $unit ) ; ?></span>
						</div>
	                </div>
	            </div>

	            <div class="info">
	            	<?php if( !empty( $title ) ) : ?>
	            		<?php if ( $title_link && $title_link['url'] ) { ?>
	            			<a href="<?php echo esc_url( $title_link['url'] ); ?>" <?php printf( '%1$s %2$s', $target, $nofollow ); ?>>
	            		<?php } ?>
			        	    <h3 class="title">
			        	    	<?php echo esc_html( $title ) ; ?>	
			        	    </h3>
		        	    <?php if ( $title_link && $title_link['url'] ) { ?>
	            			</a>
	            		<?php } ?>
		        	<?php endif; ?>

		        	<?php if( !empty( $description ) ) : ?>
		        	    <p class="description">
		        	    	<?php echo esc_html( $description ) ; ?>	
		        	    </p>
		        	<?php endif; ?>
	            </div>

            </div>
           
			
		<?php
	}

	
}
$widgets_manager->register( new Gimont_Elementor_Progress_Circle() );