<?php

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Utils;
use Elementor\Group_Control_Border;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Gimont_Elementor_Road_Map_2 extends Widget_Base {

	public function get_name() {
		return 'gimont_elementor_road_map_2';
	}

	public function get_title() {
		return esc_html__( 'Road Map 2', 'gimont' );
	}

	public function get_icon() {
		return 'eicon-time-line';
	}

	public function get_categories() {
		return [ 'gimont' ];
	}

	public function get_script_depends() {
		return [ '' ];
	}

	public function get_style_depends() {
		wp_enqueue_style( 'gimont-elementor-roadmap-2', GIMONT_URI.'/assets/scss/elementor/roadmap/road-map-2.css' );
		return [];
	}
	
	// Add Your Controll In This Function
	protected function register_controls() {

		/* Content */
		$this->start_controls_section(
				'section_content',
				[
					'label' => esc_html__( 'Content', 'gimont' ),
				]
			);

			$repeater = new \Elementor\Repeater();

			$repeater->add_control(
				'date',
				[
					'label' => esc_html__( 'Date', 'gimont' ),
					'type' => \Elementor\Controls_Manager::DATE_TIME,
					'default'		=> date( 'Y-m-d h:i', current_time('timestamp')),
					'description' 	=> sprintf( esc_html__( 'Date set according to your timezone: %s.', 'gimont' ), Utils::get_timezone_string() ),
				]
			);

			$repeater->add_control(
				'text_1',
				[
					'label' => esc_html__( 'Text 1', 'gimont' ),
					'type' => \Elementor\Controls_Manager::TEXT,
					'default' => esc_html__( 'Computer science' , 'gimont' ),
					'label_block' => true,
				]
			);

			$repeater->add_control(
				'text_2',
				[
					'label' => esc_html__( 'Text 2', 'gimont' ),
					'type' => \Elementor\Controls_Manager::TEXT,
					'default' => esc_html__( 'Canadian National University' , 'gimont' ),
					'label_block' => true,
				]
			);

			$repeater->add_control(
				'highlight',
				[
					'label' => esc_html__( 'Highlight', 'gimont' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Yes', 'gimont' ),
					'label_off' => esc_html__( 'No', 'gimont' ),
					'return_value' => 'yes',
					'default' => 'no',
				]
			);

			$this->add_control(
				'road_map',
				[
					'label' => esc_html__( 'Road Map', 'gimont' ),
					'type' => \Elementor\Controls_Manager::REPEATER,
					'fields' => $repeater->get_controls(),
					'default' => [
						[
							'date' => '2016-07',
							'text_1' => esc_html__( 'Computer science', 'gimont' ),
							'text_2' => esc_html__( 'Canadian National University', 'gimont' ),
							'highlight' => 'no',
						],
						[
							'date' => '2017-10',
							'text_1' => esc_html__( 'Digital marketing', 'gimont' ),
							'text_2' => esc_html__( 'Canadian National University', 'gimont' ),
							'highlight' => 'yes',
						],
						[
							'date' => '2018-11',
							'text_1' => esc_html__( 'Master degree', 'gimont' ),
							'text_2' => esc_html__( 'Canadian National University', 'gimont' ),
							'highlight' => 'no',
						],
						[
							'date' => '2021-12',
							'text_1' => esc_html__( 'MS, Technology', 'gimont' ),
							'text_2' => esc_html__( 'Canadian National University', 'gimont' ),
							'highlight' => 'no',
						],
					],
					'title_field' => '{{{ text_1 }}}',
				]
			);

		$this->end_controls_section();

		/* Date */
		$this->start_controls_section(
				'date_style_section',
				[
					'label' => esc_html__( 'Date', 'gimont' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_responsive_control(
				'date_margin',
				[
					'label' => esc_html__( 'Margin', 'gimont' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-road-map-2 .date' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name' => 'date_typography',
					'selector' => '{{WRAPPER}} .ova-road-map-2 .date',
				]
			);

			$this->add_control(
				'date_color',
				[
					'label' => esc_html__( 'Color', 'gimont' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-road-map-2 .date' => 'color: {{VALUE}}',
					],
				]
			);

		$this->end_controls_section();

		/* Text 1 */
		$this->start_controls_section(
				'text_1_style_section',
				[
					'label' => esc_html__( 'Text 1', 'gimont' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_responsive_control(
				'text_1_margin',
				[
					'label' => esc_html__( 'Margin', 'gimont' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-road-map-2 .text-1' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name' => 'text_1_typography',
					'selector' => '{{WRAPPER}} .ova-road-map-2 .text-1',
				]
			);

			$this->add_control(
				'text_1_color',
				[
					'label' => esc_html__( 'Color', 'gimont' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-road-map-2 .text-1' => 'color: {{VALUE}}',
					],
				]
			);

		$this->end_controls_section();

		/* Text 2 */
		$this->start_controls_section(
				'text_2_style_section',
				[
					'label' => esc_html__( 'Text 2', 'gimont' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_responsive_control(
				'text_2_margin',
				[
					'label' => esc_html__( 'Margin', 'gimont' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-road-map-2 .text-2' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name' => 'text_2_typography',
					'selector' => '{{WRAPPER}} .ova-road-map-2 .text-2',
				]
			);

			$this->add_control(
				'text_2_color',
				[
					'label' => esc_html__( 'Color', 'gimont' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-road-map-2 .text-2' => 'color: {{VALUE}}',
					],
				]
			);

		$this->end_controls_section();
	}

	// Render Template Here
	protected function render() {
		$settings = $this->get_settings();
		$road_map = $settings['road_map'];
		?>

		<?php if ( $road_map ): ?>
			<ul class="ova-road-map-2">
				<?php foreach ($road_map as $key => $item): ?>
					<?php
					$timestamp 	= strtotime( $item['date'] );
					$date 		= date_i18n( 'F Y', $timestamp );
					$text_1 	= $item['text_1'];
					$text_2 	= $item['text_2'];
					$highlight 	= $item['highlight'] == 'yes' ? 'active' : '';
					?>
					<li class="item <?php echo esc_attr( $highlight ); ?>">
						<p class="date"><?php echo esc_html( $date ); ?></p>
						<h3 class="text-1"><?php echo esc_html( $text_1 ); ?></h3>
						<p class="text-2"><?php echo esc_html( $text_2 ); ?></p>
					</li>

				<?php endforeach; ?>
			</ul>
		<?php endif; ?>

		<?php
	}

	
}
$widgets_manager->register( new Gimont_Elementor_Road_Map_2() );