<?php

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Utils;
use Elementor\Group_Control_Border;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Gimont_Elementor_Road_Map extends Widget_Base {

	public function get_name() {
		return 'gimont_elementor_road_map';
	}

	public function get_title() {
		return esc_html__( 'Road Map', 'gimont' );
	}

	public function get_icon() {
		return 'eicon-time-line';
	}

	public function get_categories() {
		return [ 'gimont' ];
	}

	public function get_script_depends() {
		return [ 'gimont-elementor-road-map' ];
	}

	public function get_style_depends() {
		wp_enqueue_style( 'gimont-elementor-roadmap', GIMONT_URI.'/assets/scss/elementor/roadmap/road-map.css' );
		return [];
	}
	
	// Add Your Controll In This Function
	protected function register_controls() {

		/* Begin section road map */
		$this->start_controls_section(
			'section_road_map',
			[
				'label' => esc_html__( 'Road Map', 'gimont' ),
			]
		);	

			$this->add_control(
				'template',
				[
					'label' => esc_html__( 'Template', 'gimont' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'default' => 'template_1',
					'options' => [
						'template_1' => esc_html__( 'Template 1', 'gimont' ),
						'template_2' => esc_html__( 'Template 2', 'gimont' ),
					],
				]
			);
			
	        $repeater = new \Elementor\Repeater();

	        	$repeater->add_control(
					'image',
					[
						'label' => esc_html__( 'Choose Image', 'gimont' ),
						'type' => \Elementor\Controls_Manager::MEDIA,
						'default' => [
							'url' => \Elementor\Utils::get_placeholder_image_src(),
						],
					]
				);

				$repeater->add_control(
					'date',
					[
						'label' 		=> esc_html__( 'Date', 'gimont' ),
						'type' 			=> Controls_Manager::DATE_TIME,
						'default'		=> date( 'Y-m-d h:i', current_time('timestamp')),
						'description' 	=> sprintf( esc_html__( 'Date set according to your timezone: %s.', 'gimont' ), Utils::get_timezone_string() ),
					]
				);

				$repeater->add_control(
					'text_date',
					[
						'label' 		=> esc_html__( 'Text Date', 'gimont' ),
						'type' 			=> Controls_Manager::TEXT,
						'description'   => esc_html__('For entering date as text. If this field is empty, use the Date field above', 'gimont' ),
					]
				);

				$repeater->add_control(
					'title',
					[
						'label' 		=> esc_html__( 'Title', 'gimont' ),
						'type' 			=> Controls_Manager::TEXTAREA,
						'default' 		=> esc_html__('City council founded', 'gimont' ),
					]
				);

				$repeater->add_control(
					'active',
					[
						'label' => esc_html__( 'Highlight', 'gimont' ),
						'type' => \Elementor\Controls_Manager::SWITCHER,
						'label_on' => esc_html__( 'Yes', 'gimont' ),
						'label_off' => esc_html__( 'No', 'gimont' ),
						'return_value' => 'yes',
						'default' => 'no',
					]
				);

				$repeater->add_control(
					'desc',
					[
						'label' 		=> esc_html__( 'Description', 'gimont' ),
						'type' 			=> Controls_Manager::TEXTAREA,
						'default' 		=> esc_html__('There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised. Suspendisse sollicitudin velit sed leo. Ut pharetra augue nec augue. Nam elit agna endrerit sit amet.', 'gimont' ),
					]
				);

				$repeater->add_responsive_control(
					'animation_content',
					[
						'label' => esc_html__( 'Animation Content', 'gimont' ),
						'type' 	=> Controls_Manager::ANIMATION,
					]
				);

				$repeater->add_control(
					'animation_duration_content',
					[
						'label' 	=> esc_html__( 'Animation Duration', 'gimont' ),
						'type' 		=> Controls_Manager::SELECT,
						'default' 	=> '',
						'options' 	=> [
							'slow' 	=> esc_html__( 'Slow', 'gimont' ),
							'' 		=> esc_html__( 'Normal', 'gimont' ),
							'fast' 	=> esc_html__( 'Fast', 'gimont' ),
						],
						'condition' => [
							'animation_content!' => '',
						],
					]
				);

				$repeater->add_control(
					'animation_delay_content',
					[
						'label' 	=> esc_html__( 'Animation Delay', 'gimont' ) . ' (ms)',
						'type' 		=> Controls_Manager::NUMBER,
						'default' 	=> '',
						'min' 		=> 0,
						'step' 		=> 100,
						'condition' => [
							'animation_content!' => '',
						],
					]
				);

			$this->add_control(
				'road_map_items',
				[
					'label' 	=> esc_html__( 'Items', 'gimont' ),
					'type' 		=> Controls_Manager::REPEATER,
					'fields' 	=> $repeater->get_controls(),
					'default' 	=> [
						[
							'date'		=> '1996-04-20',
							'title' 	=> esc_html__( 'City council founded', 'gimont' ),
							'active' 	=> 'no',
						],
						[
							'date'		=> '1996-11-26',
							'title' 	=> esc_html__( 'First election conducted', 'gimont' ),
							'active' 	=> 'yes',
						],
						[
							'date' 		=> '2002-07-18',
							'title' 	=> esc_html__( 'Expand the field of activity', 'gimont' ),
							'active' 	=> 'no',
						],
						[
							'date' 		=> '2008-08-30',
							'title' 	=> esc_html__( 'Becoming a smart city', 'gimont' ),
							'active' 	=> 'no',
						],
					],
					'title_field' => '{{{ title }}}',
				]
			);

		$this->end_controls_section();
		/* End section road map */

		/* Image */
		$this->start_controls_section(
				'image_style_section',
				[
					'label' => esc_html__( 'Image', 'gimont' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_responsive_control(
				'image_padding',
				[
					'label' => esc_html__( 'Padding', 'gimont' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-road-map .road-map-wrapper .timeline-column .timeline-item-left .timeline-image' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .ova-road-map .road-map-wrapper .timeline-column .timeline-item-right .timeline-image' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_responsive_control(
				'image_height',
				[
					'label' => esc_html__( 'Height', 'gimont' ),
					'type' => \Elementor\Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 1000,
							'step' => 5,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .ova-road-map .road-map-wrapper .timeline-column .timeline-item-left .timeline-image img' => 'height: {{SIZE}}{{UNIT}};',
						'{{WRAPPER}} .ova-road-map .road-map-wrapper .timeline-column .timeline-item-right .timeline-image img' => 'height: {{SIZE}}{{UNIT}};',
					],
				]
			);

		$this->end_controls_section();

		/* Date */
		$this->start_controls_section(
				'date_style_section',
				[
					'label' => esc_html__( 'Date', 'gimont' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_responsive_control(
				'date_margin',
				[
					'label' => esc_html__( 'Margin', 'gimont' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-road-map .road-map-wrapper .timeline-column .timeline-item-left .timeline-info .content-info .date' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .ova-road-map .road-map-wrapper .timeline-column .timeline-item-right .timeline-info .content-info .date' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_responsive_control(
				'date_padding',
				[
					'label' => esc_html__( 'Padding', 'gimont' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-road-map .road-map-wrapper .timeline-column .timeline-item-left .timeline-info .content-info .date' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .ova-road-map .road-map-wrapper .timeline-column .timeline-item-right .timeline-info .content-info .date' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name' => 'date_typography',
					'selector' => '{{WRAPPER}} .ova-road-map .road-map-wrapper .timeline-column .timeline-item-left .timeline-info .content-info .date, {{WRAPPER}} .ova-road-map .road-map-wrapper .timeline-column .timeline-item-right .timeline-info .content-info .date',
				]
			);

			$this->add_control(
				'date_color',
				[
					'label' => esc_html__( 'Color', 'gimont' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-road-map .road-map-wrapper .timeline-column .timeline-item-left .timeline-info .content-info .date' => 'color: {{VALUE}}',
						'{{WRAPPER}} .ova-road-map .road-map-wrapper .timeline-column .timeline-item-right .timeline-info .content-info .date' => 'color: {{VALUE}}',
					],
				]
			);

		$this->end_controls_section();

		/* Title */
		$this->start_controls_section(
				'title_style_section',
				[
					'label' => esc_html__( 'Title', 'gimont' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_responsive_control(
				'title_margin',
				[
					'label' => esc_html__( 'Margin', 'gimont' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-road-map .road-map-wrapper .timeline-column .timeline-item-left .timeline-info .content-info .timeline-content .title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .ova-road-map .road-map-wrapper .timeline-column .timeline-item-right .timeline-info .content-info .timeline-content .title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_responsive_control(
				'title_padding',
				[
					'label' => esc_html__( 'Padding', 'gimont' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-road-map .road-map-wrapper .timeline-column .timeline-item-left .timeline-info .content-info .timeline-content .title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .ova-road-map .road-map-wrapper .timeline-column .timeline-item-right .timeline-info .content-info .timeline-content .title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name' => 'title_typography',
					'selector' => '{{WRAPPER}} .ova-road-map .road-map-wrapper .timeline-column .timeline-item-left .timeline-info .content-info .timeline-content .title,{{WRAPPER}} .ova-road-map .road-map-wrapper .timeline-column .timeline-item-right .timeline-info .content-info .timeline-content .title',
				]
			);

			$this->add_control(
				'title_color',
				[
					'label' => esc_html__( 'Color', 'gimont' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-road-map .road-map-wrapper .timeline-column .timeline-item-left .timeline-info .content-info .timeline-content .title' => 'color: {{VALUE}}',
						'{{WRAPPER}} .ova-road-map .road-map-wrapper .timeline-column .timeline-item-right .timeline-info .content-info .timeline-content .title' => 'color: {{VALUE}}',
					],
				]
			);

		$this->end_controls_section();

		/* Description */
		$this->start_controls_section(
				'desc_style_section',
				[
					'label' => esc_html__( 'Description', 'gimont' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_responsive_control(
				'desc_margin',
				[
					'label' => esc_html__( 'Margin', 'gimont' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-road-map .road-map-wrapper .timeline-column .timeline-item-left .timeline-info .content-info .timeline-content .desc' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .ova-road-map .road-map-wrapper .timeline-column .timeline-item-right .timeline-info .content-info .timeline-content .desc' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_responsive_control(
				'desc_padding',
				[
					'label' => esc_html__( 'Padding', 'gimont' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-road-map .road-map-wrapper .timeline-column .timeline-item-right .timeline-info .content-info .timeline-content .desc' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .ova-road-map .road-map-wrapper .timeline-column .timeline-item-left .timeline-info .content-info .timeline-content .desc' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name' => 'desc_typography',
					'selector' => '{{WRAPPER}} .ova-road-map .road-map-wrapper .timeline-column .timeline-item-right .timeline-info .content-info .timeline-content .desc,{{WRAPPER}} .ova-road-map .road-map-wrapper .timeline-column .timeline-item-left .timeline-info .content-info .timeline-content .desc',
				]
			);

			$this->add_control(
				'desc_color',
				[
					'label' => esc_html__( 'Color', 'gimont' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-road-map .road-map-wrapper .timeline-column .timeline-item-right .timeline-info .content-info .timeline-content .desc' => 'color: {{VALUE}}',
						'{{WRAPPER}} .ova-road-map .road-map-wrapper .timeline-column .timeline-item-left .timeline-info .content-info .timeline-content .desc' => 'color: {{VALUE}}',
					],
				]
			);

		$this->end_controls_section();
	}

	// Render Template Here
	protected function render() {

		$settings 	= $this->get_settings();

		$template 	= $settings['template'];
		$road_map 	= $settings['road_map_items'];
	
		?>

		<div class="ova-road-map <?php echo esc_attr( $template ); ?>">
			<div class="road-map-wrapper">

				<?php if ( ! empty( $road_map ) ): ?>
					<div class="timeline-column">
						<?php foreach ( $road_map as $k => $items ): 

							$time_stamp 	= strtotime( $items['date'] );
							$day 			= date_i18n('d', $time_stamp);
							$month 			= date_i18n('F', $time_stamp);
							$year 			= date_i18n('Y', $time_stamp);
							$image 			= $items['image'];
							$image_url 		= $image && $image['url'] ? $image['url'] : \Elementor\Utils::get_placeholder_image_src();
							$image_alt 		= $items['title'];
							$image_title 	= $items['title'];
							$title 			= $items['title'];
							$desc 			= $items['desc'];
							$active 		= $items['active'] == 'yes' ? 'active' : '';

							if ( $image && $image['id'] ) {
								$image_alt = get_post_meta( $image['id'] , '_wp_attachment_image_alt', true );
								$image_title = get_the_title( $image['id'] );
							}

							$text_date =  $items['text_date'];

							//Animation Content
							$animation_content 	= $items['animation_content'];
							$duration_content 	= $items['animation_duration_content'];
							$delay_content		= $items['animation_delay_content'];

							$data_animation_content = array(
								'animation' => $animation_content,
								'duration' 	=> $duration_content,
								'delay' 	=> $delay_content,
							);
						?>
							<?php if ( $k % 2 == 0 ): ?>
								<div class="timeline-item timeline-item-left <?php echo esc_attr( $active ); ?>">
									<div class="timeline-image">
										<img src="<?php echo esc_url( $image_url ); ?>" alt="<?php echo esc_attr( $image_alt ); ?>"
										title="<?php echo esc_attr( $image_title ); ?>">
									</div>
									<div class="timeline-info">
										<div class="content-info<?php if ( $animation_content ) echo ' ova-invisible'; ?>" 
											data-animation='<?php echo json_encode( $data_animation_content ); ?>'>

											<?php if ( empty($text_date) ) { ?>
												<div class="date">
													<?php echo esc_html( $day . ' ' . $month . ' ' . $year ); ?>
												</div>
											<?php } else { ?>
												<div class="date">
													<?php echo esc_html($text_date); ?>
												</div>
											<?php } ?>
											<div class="timeline-content">
												<h3 class="title"><?php echo esc_html( $title ); ?></h3>
												<p class="desc"><?php echo esc_html( $desc ); ?></p>
											</div>
										</div>
									</div>
								</div>
							<?php else: ?>
								<div class="timeline-item timeline-item-right <?php echo esc_attr( $active ); ?>">
									<div class="timeline-info">
										<div class="content-info<?php if ( $animation_content ) echo ' ova-invisible'; ?>" 
										data-animation='<?php echo json_encode( $data_animation_content ); ?>'>

											<?php if ( empty($text_date) ) { ?>
												<div class="date">
													<?php echo esc_html( $day . ' ' . $month . ' ' . $year ); ?>
												</div>
											<?php } else { ?>
												<div class="date">
													<?php echo esc_html($text_date); ?>
												</div>
											<?php } ?>

											<div class="timeline-content">
												<h3 class="title"><?php echo esc_html( $title ); ?></h3>
												<p class="desc"><?php echo esc_html( $desc ); ?></p>
											</div>
										</div>
									</div>
									<div class="timeline-image">
										<img src="<?php echo esc_url( $image['url'] ); ?>" alt="<?php echo esc_attr( $image_alt ); ?>">
									</div>
								</div>
						<?php endif; endforeach; ?>
					</div>
				<?php endif; ?>

			</div>
		</div>
		 	
		<?php
	}

	
}
$widgets_manager->register( new Gimont_Elementor_Road_Map() );