<?php if (!defined( 'ABSPATH' )) exit;

if( !class_exists('Gimont_Main') ){

	class Gimont_Main {

		public function __construct() {
			/* Add theme support */
			add_action( 'after_setup_theme', array( $this, 'gimont_theme_support' ) );
	
			/**
			 * Register Menu
			 */
			add_action( 'init', array( $this, 'gimont_register_menus' ) );

			/**
			 * Load google font from customize
			 */
			add_action('wp_enqueue_scripts', array( $this, 'gimont_load_google_fonts' ) );

			/**
			 * Add Body class
			 */
			add_filter('body_class', array( $this, 'gimont_body_classes' ) );
			
			/**
			 * Enqueue CSS, Javascript
			 */
			add_action('wp_enqueue_scripts', array( $this, 'gimont_enqueue_scripts' ) );

			/**
			 * Elementor Enqueue CSS
			 */
			add_action('wp_enqueue_scripts', array( $this, 'gimont_enqueue_elementor_style' ) );

			/**
			 * Enqueue style from customize
			 */
			add_action('wp_enqueue_scripts', array( $this, 'gimont_enqueue_customize' ), 11 );
        }

		function gimont_theme_support(){

			$GLOBALS['content_width'] = apply_filters('gimont_content_width', 800);
		    
		    add_theme_support('title-tag');

		    // Adds RSS feed links to <head> for posts and comments.
		    add_theme_support( 'automatic-feed-links' );

		    // Switches default core markup for search form, comment form, and comments    
		    // to output valid HTML5.
		    add_theme_support( 'html5', array( 'search-form', 'comment-form', 'comment-list' ) );

		    add_theme_support( 'responsive-embeds' );

		    /* See http://codex.wordpress.org/Post_Formats */
		    add_theme_support( 'post-formats', array( 'image', 'gallery', 'audio', 'video') );

		    add_theme_support( 'post-thumbnails' );
		    
		    add_theme_support( 'custom-header' );
		    add_theme_support( 'custom-background');

		    add_theme_support('responsive-embeds');

		    add_theme_support( 'woocommerce' );
		    add_theme_support( 'wc-product-gallery-zoom' );
			add_theme_support( 'wc-product-gallery-lightbox' );
			add_theme_support( 'wc-product-gallery-slider' );
		    
		    // Show Excerpt in Page
            add_post_type_support( 'page', 'excerpt' );

		    add_theme_support( 'ova_framework_hf_el' );

		    add_filter('gutenberg_use_widgets_block_editor', '__return_false');
            add_filter('use_widgets_block_editor', '__return_false');

		    add_image_size( 'gimont_thumbnail', 668, 520, true );
		    add_image_size( 'gimont_medium', 520, 360, true );
		    
		}

		function gimont_register_menus() {
		  	register_nav_menus( array(
		    	'primary'   => esc_html__( 'Primary Menu', 'gimont' )
		  	) );
		}
		
		function gimont_load_google_fonts(){

		    $fonts_url = '';

		    $default_primary_font = json_decode( gimont_default_primary_font() );

		    $custom_fonts = get_theme_mod('ova_custom_font','');

		    // Primary Font 
		    $primary_font = json_decode( get_theme_mod( 'primary_font' ) ) ? json_decode( get_theme_mod( 'primary_font' ) ) : $default_primary_font;
		    $primary_font_family = $primary_font->font;
		    $primary_font_weights_string = $primary_font->regularweight ? $primary_font->regularweight : '100,200,300,400,500,600,700,800,900';
		    $is_custom_primary_font = $custom_fonts != '' ? !strpos($primary_font_family, $custom_fonts) : true;
		    
		    $general_flag = _x( 'on', $primary_font_family.': on or off', 'gimont');
		    
		    if ( 'off' !== $general_flag ) {
		        $font_families = array();
		 
		        if ( 'off' !== $general_flag && $is_custom_primary_font ) {
		            $font_families[] = $primary_font_family.':'.$primary_font_weights_string;
		        }

		        $custom_primary_font = get_post_meta( get_the_ID(), 'ova_met_primary_font', true );

				if ( $custom_primary_font && ( is_page() || is_single() ) ) {
					$custom_primary_font_args = explode( ':', $custom_primary_font );

					if ( isset( $custom_primary_font_args[0] ) && isset( $custom_primary_font_args[1] ) && $custom_primary_font_args[0] && $custom_primary_font_args[1] ) {
						$font_families[] = $custom_primary_font_args[0].':'.$custom_primary_font_args[1];
					}
				}

		        if ( $font_families != null ) {
		          	$query_args = array(
		              	'family' => urlencode( implode( '|', $font_families ) )
		          	);

		          	$fonts_url = add_query_arg( $query_args, '//fonts.googleapis.com/css' );
		        }
		        
		    }
		 
		    $google_fonts =  esc_url_raw( $fonts_url );

		    /**
			 * Load google font from customize
			 */
			wp_enqueue_style( 'ova-google-fonts', $google_fonts, array(), null );
		}

		function gimont_body_classes( $classes ){

            global $is_lynx, $is_gecko, $is_IE, $is_opera, $is_NS4, $is_safari, $is_chrome, $is_iphone;
            if ($is_lynx) {
                $classes[] = 'lynx';
            } elseif ($is_gecko) {
                $classes[] = 'gecko';
            } elseif ($is_opera) {
                $classes[] = 'opera';
            } elseif ($is_NS4) {
                $classes[] = 'ns4';
            } elseif ($is_safari) {
                $classes[] = 'safari';
            } elseif ($is_chrome) {
                $classes[] = 'chrome';
            } elseif ($is_IE) {
                $classes[] = 'ie';
            }

            if ($is_iphone) {
                $classes[] = 'iphone';
            }

            // Adds a class to blogs with more than 1 published author.
            if (is_multi_author()) {
                $classes[] = 'group-blog';
            }

            // Add class when using homepage template + featured image.
            if (has_post_thumbnail()) {
                $classes[] = 'has-post-thumbnail';
            }

            

            $classes[] = apply_filters( 'gimont_theme_sidebar','' );

            $classes[] = gimont_woo_sidebar();

            $wide_site = apply_filters( 'gimont_wide_site', '' );
            if( $wide_site == 'boxed' ){
				$classes[] = 'container_boxed';
            }


            return $classes;
        }

		function gimont_enqueue_scripts() {
			// for translate select2 text
			$select2_text = array(
				'input_short' => esc_html__( 'Please enter 1 or more characters', 'gimont' ),
				'no_results' => esc_html__( 'No results found', 'gimont' ),
			);

		    // enqueue the javascript that performs in-link comment reply fanciness
		    if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		        wp_enqueue_script( 'comment-reply' ); 
		    }

		    // Carousel
			wp_enqueue_script('carousel', GIMONT_URI.'/assets/libs/carousel/owl.carousel.min.js', array('jquery'),null,true);
			wp_enqueue_style('carousel', GIMONT_URI.'/assets/libs/carousel/assets/owl.carousel.min.css', array(), null);

			// Fancybox
			wp_enqueue_script('fancybox', GIMONT_URI.'/assets/libs/fancybox/fancybox.umd.js', array('jquery'),null,true);
			wp_enqueue_style('fancybox', GIMONT_URI.'/assets/libs/fancybox/fancybox.css', array(), null);

			// Appear
			wp_enqueue_script('appear', GIMONT_URI.'/assets/libs/appear/appear.js', array('jquery'),null,true);

		    // Font Icon
		    wp_enqueue_style('ovaicon', GIMONT_URI.'/assets/libs/ovaicon/font/ovaicon.css', array(), null);

		    // Gimonticon
		    wp_enqueue_style('gimonticon', GIMONT_URI.'/assets/libs/gimonticon/font/flaticon_gimont.css', array(), null);

		    // Flaticon
		    wp_enqueue_style('flaticon', GIMONT_URI.'/assets/libs/flaticon/font/flaticon_giamont.css', array(), null);

		    // Flaticon new
		    wp_enqueue_style('flaticon_new', GIMONT_URI.'/assets/libs/flaticon_new/font/flaticon_new.css', array(), null);
		    
			// Flaticon new 2
			wp_enqueue_style('flaticon_new2', GIMONT_URI.'/assets/libs/flaticon_new2/font/flaticon_new2.css', array(), null);

		    wp_enqueue_script('masonry', GIMONT_URI.'/assets/libs/masonry.min.js', array('jquery'),null,true);
		    
		    wp_enqueue_script('gimont-script', GIMONT_URI.'/assets/js/script.js', array('jquery'),null,true);
		    wp_localize_script( 'gimont-script', 'ScrollUpText', array('value' => esc_html__( 'Go to top', 'gimont' )));
		    wp_localize_script( 'gimont-script', 'Select2Text', $select2_text );

		    /* Add Ajax JS */
		    $params  = array(
		    	'ajax_url' 		=> admin_url('admin-ajax.php'), 
		    	'ajax_nonce'	=> wp_create_nonce( apply_filters( 'gimont_ajax_security', 'ajax_theme' ) )
		    );
			wp_localize_script( 'gimont-script', 'ajax_object', $params );

			// Style
		    wp_enqueue_style( 'gimont-style', get_template_directory_uri() . '/style.css' );
		}

		function gimont_enqueue_elementor_style() {
			// Logo
			wp_enqueue_style( 'gimont-elementor-logo', GIMONT_URI.'/assets/scss/elementor/logo/logo.css', [], null );

			// Menus
			wp_enqueue_style( 'gimont-elementor-menu-canvas', GIMONT_URI.'/assets/scss/elementor/menus/menu-canvas.css', [], null );
			wp_enqueue_style( 'gimont-elementor-menu-cart', GIMONT_URI.'/assets/scss/elementor/menus/menu-cart.css', [], null );
			wp_enqueue_style( 'gimont-elementor-menu-nav', GIMONT_URI.'/assets/scss/elementor/menus/menu-nav.css', [], null );

			// Toggle Content - Menus
			wp_enqueue_style( 'gimont-elementor-toggle-content', GIMONT_URI.'/assets/scss/elementor/toggle/toggle-content.css' );

			// Search popup
			wp_enqueue_style( 'gimont-elementor-search-popup', GIMONT_URI.'/assets/scss/elementor/searchs/search-popup.css', [], null );

			// Contact info
			wp_enqueue_style( 'gimont-elementor-contact-info', GIMONT_URI.'/assets/scss/elementor/contact/contact-info.css' );
			wp_enqueue_style( 'gimont-elementor-contact-info-2', GIMONT_URI.'/assets/scss/elementor/contact/contact-info-2.css' );

			// Switch language
			wp_enqueue_style( 'gimont-elementor-switch-language', GIMONT_URI.'/assets/scss/elementor/switch-language/switch-language.css' );
		}

        function gimont_enqueue_customize(){

        	$css = '';
           
			$primary_color = gimont_default_primary_color();

			$custom_primary_color = get_post_meta( get_the_ID(), 'ova_met_primary_color', true );
			if ( $custom_primary_color ) {
				$primary_color = $custom_primary_color;
			}

			$heading_color 	= get_theme_mod( 'heading_color', '#051A53' );
			$text_color 	= get_theme_mod( 'text_color', '#6B6C70' );
			$light_color 	= get_theme_mod( 'light_color', '#D2d5DF' );

			/* Primary Font */
			$default_primary_font = json_decode( gimont_default_primary_font() );
			$primary_font = json_decode( get_theme_mod( 'primary_font' ) ) ? json_decode( get_theme_mod( 'primary_font' ) ) : $default_primary_font;
			$primary_font_family = $primary_font->font;

			$custom_primary_font = get_post_meta( get_the_ID(), 'ova_met_primary_font', true );

			if ( $custom_primary_font && ( is_page() || is_single() ) ) {
				$custom_primary_font_args = explode( ':', $custom_primary_font );

				if ( isset( $custom_primary_font_args[0] ) && $custom_primary_font_args[0] ) {
					$primary_font_family = $custom_primary_font_args[0];
				}
			}

			/* General Typo */
			$general_font_size = get_theme_mod( 'general_font_size', '15px' );
			$general_line_height = get_theme_mod( 'general_line_height', '1.9em' );
			$general_letter_space = get_theme_mod( 'general_letter_space', '0px' );
			
			// Width Sidebar
			$global_layout_sidebar = apply_filters( 'gimont_get_layout', '' );
			$width_sidebar = is_array( $global_layout_sidebar ) ? $global_layout_sidebar[1] : '0';

			// Container width
			$container_width = get_theme_mod( 'global_boxed_container_width', '1290' );
			$container_width_break = $container_width + 60;
			$boxed_offset = get_theme_mod( 'global_boxed_offset', '20' );


			// WooCommerce Sidebar
			$woo_archive_layout = get_theme_mod( 'woo_archive_layout', 'layout_1c' );
			$woo_sidebar_width = get_theme_mod( 'woo_sidebar_width', '320' );

            $css .= '--primary: '.$primary_color.';';
            $css .= '--heading: '.$heading_color.';';
            $css .= '--text: '.$text_color.';';
            $css .= '--light: '.$light_color.';';
            $css .= '--primary-font: '.$primary_font_family.';';
            $css .= '--font-size: '.$general_font_size.';';
            $css .= '--line-height: '.$general_line_height.';';
            $css .= '--letter-spacing: '.$general_letter_space.';';
            $css .= '--width-sidebar: '.$width_sidebar.'px;';
            $css .= '--main-content:  calc( 100% - '.$width_sidebar.'px )'.';';
            $css .= '--container-width: '.$container_width.'px;';
            $css .= '--boxed-offset: '.$boxed_offset.'px;';
            $css .= '--woo-layout: '.$woo_archive_layout.';';
            $css .= '--woo-width-sidebar: '.$woo_sidebar_width.'px;';
            $css .= '--woo-main-content:  calc( 100% - '.$woo_sidebar_width.'px )'.';';

            $var = ":root{{$css}}";

            $var .= '@media (min-width: 1024px) and ( max-width: '.$container_width_break.'px ){
		        body .row_site,
		        body .elementor-section.elementor-section-boxed>.elementor-container{
		            max-width: 100%;
		            padding-left: 30px;
		            padding-right: 30px;
		        }
		    }';

            wp_add_inline_style( 'gimont-style', $var );
        }
	}
}

return new Gimont_Main();