<?php
/**
 * Include and setup custom metaboxes and fields. (make sure you copy this file to outside the CMB2 directory)
 *
 * Be sure to replace all instances of 'yourprefix_' with your project's prefix.
 * http://nacin.com/2010/05/11/in-wordpress-prefix-everything/
 *
 * @category YourThemeOrPlugin
 * @package  Demo_CMB2
 * @license  http://www.opensource.org/licenses/gpl-license.php GPL v2.0 (or later)
 * @link     https://github.com/WebDevStudios/CMB2
 */


add_action( 'cmb2_init', 'ova_dep_metaboxes' );
function ova_dep_metaboxes() {

    // Start with an underscore to hide fields from custom fields list
    $prefix = 'ova_dep_met_';
    
    /* Team Settings ***************************************************************************/
    /* ************************************************************************************/
    $dep_settings = new_cmb2_box( array(
        'id'            => 'ovadep_settings',
        'title'         => esc_html__( 'Department settings', 'ova-dep' ),
        'object_types'  => array( 'ova_dep'), // Post type
        'context'       => 'normal',
        'priority'      => 'high',
        'show_names'    => true,
        
    ) );

        $dep_settings->add_field( array(
            'name'    => esc_html__( 'Class Icon', 'ova-dep' ),
            'id'      => $prefix . 'class_icon',
            'type'    => 'text',
        ) );

        $dep_settings->add_field( array(
            'name' => esc_html__( 'List File Attachment', 'ova-dep' ),
            'id'   => $prefix . 'list_file_dep',
            'type' => 'file_list',
        ) );

        $dep_settings->add_field( array(
            'name'  => esc_html__( 'Sort Order', 'ova-dep' ),
            'id'    => $prefix . 'order_dep',
            'desc' => esc_html__( 'Insert Number', 'ova-dep' ),
            'type'    => 'text',
             'default' =>'1',
        ) );

         // Listings
        $group_listing = $dep_settings->add_field( array(
            'id'          => $prefix . 'listing',
            'type'        => 'group',
            'options'     => array(
                'group_title'       => esc_html__( 'Listing', 'ova-dep' ), 
                'add_button'        => esc_html__( 'Add Listing', 'ova-dep' ),
                'remove_button'     => esc_html__( 'Remove', 'ova-dep' ),
                'sortable'          => true, 
            ),
        ) );

        $dep_settings->add_group_field( $group_listing, array(
            'name' => esc_html__( 'Title', 'ova-dep' ),
            'id'   => $prefix . 'listing_title',
            'type' => 'text',
        ) );       
        
        $dep_settings->add_group_field( $group_listing, array(
            'name' => esc_html__( 'Value', 'ova-dep' ),
            'id'   => $prefix . 'listing_value',
            'type' => 'text',
        ) );

        $dep_settings->add_group_field( $group_listing, array(
            'name' => esc_html__( 'Link', 'ova-dep' ),
            'id'   => $prefix . 'listing_link',
            'description' => esc_html__("Example: tel:0123456789; mailto:needhelp@gmail.com; https://ovatheme.com; or can leave empty",'ova-dep'),
            'type' => 'text',
        ) );

}