<?php
namespace ova_dep_elementor\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


class ova_archive_dep_slide extends Widget_Base {


	public function get_name() {
		return 'ova_archive_dep_slide';
	}

	public function get_title() {
		return __( 'Department Archive Slide', 'ova-dep' );
	}

	public function get_icon() {
		return 'eicon-post-slider';
	}

	public function get_categories() {
		return [ 'ovatheme_dep' ];
	}

	public function get_script_depends() {
		wp_enqueue_script( 'ovadep-slide', OVADEP_PLUGIN_URI.'assets/js/elementor/dep-slide.js', array('jquery'), false, true );

		return [ '' ];
	}

	public function get_style_depends() {
		wp_enqueue_style( 'ovadep-slide', OVADEP_PLUGIN_URI.'assets/css/elementor/ova-dep-slide.css' );	
		return [];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Content', 'ova-dep' ),
			]
		);

		$args = array(
           'taxonomy' => 'cat_department',
           'orderby' => 'name',
           'order'   => 'ASC'
       	);
	
		$categories = get_categories($args);
		$catAll = array( 'all' => esc_html__( 'All categories', 'ova-dep' ) );
		$cate_array = array();
		if ($categories) {
			foreach ( $categories as $cate ) {
				$cate_array[$cate->slug] = $cate->cat_name;
			}
		} else {
			$cate_array[] = esc_html__( "No content Category found", "ova-dep" );
		}

		$this->add_control(
			'category',
			[
				'label'   => esc_html__( 'Category', 'ova-dep' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'all',
				'options' => array_merge( $catAll, $cate_array )
			]
		);

		$this->add_control(
			'total_count',
			[
				'label'   => esc_html__( 'Total', 'ova-dep' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => 4
			]
		);

		$this->add_control(
			'orderby_post',
			[
				'label' => esc_html__( 'OrderBy', 'ova-dep' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'ID',
				'options' => [
					'ID'  => esc_html__( 'ID', 'ova-dep' ),
					'title'  => esc_html__( 'Title', 'ova-dep' ),
					'date'  => esc_html__( 'Date', 'ova-dep' ),
					'rand'  => esc_html__( 'Random', 'ova-dep' ),
					'ova_dep_met_order_dep' => esc_html__( 'Custom Order', 'ova-dep' ),
				],
			]
		);

		$this->add_control(
			'order',
			[
				'label' => esc_html__( 'Order', 'ova-dep' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'DESC',
				'options' => [
					'ASC'  	=> esc_html__( 'Ascending', 'ova-dep' ),
					'DESC'  => esc_html__( 'Descending ', 'ova-dep' ),
				],
			]
		);

		$this->add_control(
			'show_icon',
			[
				'label' => esc_html__( 'Show Icon', 'ova-dep' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'ova-dep' ),
				'label_off' => esc_html__( 'Hide', 'ova-dep' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'show_title',
			[
				'label' => esc_html__( 'Show Title', 'ova-dep' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'ova-dep' ),
				'label_off' => esc_html__( 'Hide', 'ova-dep' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'show_excerpt',
			[
				'label' => esc_html__( 'Show Excerpt', 'ova-dep' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'ova-dep' ),
				'label_off' => esc_html__( 'Hide', 'ova-dep' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'show_readmore',
			[
				'label' => esc_html__( 'Show Button Readmore', 'ova-dep' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'ova-dep' ),
				'label_off' => esc_html__( 'Hide', 'ova-dep' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'text_button',
			[
				'label'   => esc_html__( 'Text Button', 'ova-dep' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'Go Department', 'ova-dep' ),
				'condition' => [
				  	'show_readmore' => 'yes', 
				],
			]
		);

		$this->add_control(
			'background_image',
			[
				'label'   => esc_html__( 'Background Image ( Hover )', 'mellis' ),
				'type'    => \Elementor\Controls_Manager::MEDIA,
			]
		);
		
		$this->end_controls_section();


		$this->start_controls_section(
			'section_additional_options',
			[
				'label' => esc_html__( 'Additional Options', 'ova-dep' ),
			]
		);

			$this->add_control(
				'margin_items',
				[
					'label'   => esc_html__( 'Margin Right Items', 'ova-dep' ),
					'type'    => Controls_Manager::NUMBER,
					'default' => 30,
				]
				
			);

			$this->add_control(
				'item_number',
				[
					'label'       => esc_html__( 'Item Number', 'ova-dep' ),
					'type'        => Controls_Manager::NUMBER,
					'description' => esc_html__( 'Number Item', 'ova-dep' ),
					'default'     => 3,
				]
			);
	

			$this->add_control(
				'slides_to_scroll',
				[
					'label'       => esc_html__( 'Slides to Scroll', 'ova-dep' ),
					'type'        => Controls_Manager::NUMBER,
					'description' => esc_html__( 'Set how many slides are scrolled per swipe.', 'ova-dep' ),
					'default'     => 1,
				]
			);

			$this->add_control(
				'pause_on_hover',
				[
					'label'   => esc_html__( 'Pause on Hover', 'ova-dep' ),
					'type'    => Controls_Manager::SWITCHER,
					'default' => 'yes',
					'options' => [
						'yes' => esc_html__( 'Yes', 'ova-dep' ),
						'no'  => esc_html__( 'No', 'ova-dep' ),
					],
					'frontend_available' => true,
				]
			);


			$this->add_control(
				'infinite',
				[
					'label'   => esc_html__( 'Infinite Loop', 'ova-dep' ),
					'type'    => Controls_Manager::SWITCHER,
					'default' => 'yes',
					'options' => [
						'yes' => esc_html__( 'Yes', 'ova-dep' ),
						'no'  => esc_html__( 'No', 'ova-dep' ),
					],
					'frontend_available' => true,
				]
			);

			$this->add_control(
				'autoplay',
				[
					'label'   => esc_html__( 'Autoplay', 'ova-dep' ),
					'type'    => Controls_Manager::SWITCHER,
					'default' => 'yes',
					'options' => [
						'yes' => esc_html__( 'Yes', 'ova-dep' ),
						'no'  => esc_html__( 'No', 'ova-dep' ),
					],
					'frontend_available' => true,
				]
			);

			$this->add_control(
				'autoplay_speed',
				[
					'label'     => esc_html__( 'Autoplay Speed', 'ova-dep' ),
					'type'      => Controls_Manager::NUMBER,
					'default'   => 3000,
					'step'      => 500,
					'condition' => [
						'autoplay' => 'yes',
					],
					'frontend_available' => true,
				]
			);

			$this->add_control(
				'smartspeed',
				[
					'label'   => esc_html__( 'Smart Speed', 'ova-dep' ),
					'type'    => Controls_Manager::NUMBER,
					'default' => 500,
				]
			);

			$this->add_control(
				'dot_control',
				[
					'label'   => esc_html__( 'Show Dots', 'ova-dep' ),
					'type'    => Controls_Manager::SWITCHER,
					'default' => 'yes',
					'options' => [
						'yes' => esc_html__( 'Yes', 'ova-dep' ),
						'no'  => esc_html__( 'No', 'ova-dep' ),
					],
					'frontend_available' => true,
				]
			);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_icon',
			[
				'label' => esc_html__( 'Icon', 'ova-dep' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_control(
				'color_icon',
				[
					'label' => esc_html__( 'Color', 'ova-dep' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova_dep_slide .dep_slide_content .icon i' => 'color : {{VALUE}};',
					],
				]
			);

			$this->add_control(
				'color_icon_hover',
				[
					'label' => esc_html__( 'Color Hover', 'ova-dep' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova_dep_slide .dep_slide_content:hover .icon i' => 'color : {{VALUE}};',
					],
				]
			);

			$this->add_control(
				'bgcolor_icon',
				[
					'label' => esc_html__( 'Background Color', 'ova-dep' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova_dep_slide .dep_slide_content .icon' => 'background-color : {{VALUE}};',
					],
				]
			);

			$this->add_control(
				'bgcolor_icon_hover',
				[
					'label' => esc_html__( 'Background Color Hover', 'ova-dep' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova_dep_slide .dep_slide_content:hover .icon' => 'background-color : {{VALUE}};',
					],
				]
			);

		$this->end_controls_section();


		$this->start_controls_section(
			'section_title',
			[
				'label' => esc_html__( 'Title', 'ova-dep' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' => 'title_typography',
					'selector' => '{{WRAPPER}} .ova_dep_slide .dep_slide_content .title a',
				]
			);

			$this->add_control(
				'color_title',
				[
					'label' => esc_html__( 'Color ', 'ova-dep' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova_dep_slide .dep_slide_content .title a' => 'color : {{VALUE}};',
					],
				]
			);

			$this->add_control(
				'color_hover_title',
				[
					'label' => esc_html__( 'Color hover', 'ova-dep' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova_archive_dep_slide .dep_slide_content .title a:hover' => 'color : {{VALUE}};',
					],
				]
			);


			$this->add_responsive_control(
				'margin_title',
				[
					'label' => esc_html__( 'Margin', 'ova-dep' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .ova_dep_slide .dep_slide_content .title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

		$this->end_controls_section();


		$this->start_controls_section(
			'section_excerpt',
			[
				'label' => esc_html__( 'Excerpt', 'ova-dep' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' => 'excerpt_typography',
					'selector' => '{{WRAPPER}} .ova_dep_slide .dep_slide_content .description',
				]
			);

			$this->add_control(
				'color_excerpt',
				[
					'label' => esc_html__( 'Color ', 'ova-dep' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova_dep_slide .dep_slide_content .description' => 'color : {{VALUE}};',
					],
				]
			);


			$this->add_responsive_control(
				'margin_excerpt',
				[
					'label' => esc_html__( 'Margin', 'ova-dep' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .ova_dep_slide .dep_slide_content .description' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

		$this->end_controls_section();


		$this->start_controls_section(
			'section_readmore',
			[
				'label' => esc_html__( 'Read More', 'ova-dep' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' => 'readmore_typography',
					'selector' => '{{WRAPPER}} .ova_dep_slide .dep_slide_content .readmore',
				]
			);

			$this->add_control(
				'color_readmore',
				[
					'label' => esc_html__( 'Color ', 'ova-dep' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova_dep_slide .dep_slide_content .readmore' => 'color : {{VALUE}};',
					],
				]
			);

			$this->add_control(
				'color_readmore_hover',
				[
					'label' => esc_html__( 'Color hover', 'ova-dep' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova_dep_slide .dep_slide_content .readmore:hover' => 'color : {{VALUE}};',
					],
				]
			);

			$this->add_responsive_control(
				'margin_readmore',
				[
					'label' => esc_html__( 'Margin', 'ova-dep' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .ova_dep_slide .dep_slide_content .readmore' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

		$this->end_controls_section();
		

		$this->start_controls_section(
			'section_dot',
			[
				'label' => esc_html__( 'Dot', 'ova-dep' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_control(
				'dot_color_readmore_active',
				[
					'label' => __( 'Dot Active Color', 'ova-dep' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova_dep_slide .owl-dots .owl-dot.active span' => 'background-color : {{VALUE}};border-color : {{VALUE}};',
					],
				]
			);

		$this->end_controls_section();


	}


	protected function render() {

		$settings = $this->get_settings();

		$template = apply_filters( 'el_elementor_ova_dep_slide', 'elementor/ova_archive_dep_slide.php' );

		ob_start();
		ovadep_get_template( $template, $settings );
		echo ob_get_clean();
		
	}
}
