<?php
namespace ova_dep_elementor\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


class ova_list_dep extends Widget_Base {


	public function get_name() {
		return 'ova_list_dep';
	}

	public function get_title() {
		return esc_html__( 'Department List', 'ova-dep' );
	}

	public function get_icon() {
		return 'eicon-sitemap';
	}

	public function get_categories() {
		return [ 'ovatheme_dep' ];
	}

	public function get_style_depends() {
		wp_enqueue_style( 'ovadep-list-dep', OVADEP_PLUGIN_URI.'assets/css/elementor/ova-list-dep.css' );	
		return [];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Content', 'ova-dep' ),
			]
		);

			$args = array(
	           'taxonomy' => 'cat_department',
	           'orderby' => 'name',
	           'order'   => 'ASC'
	       	);
		
			$categories = get_categories($args);
			$catAll = array( 'all' => esc_html__( 'All categories', 'ova-dep' ) );
			$cate_array = array();
			if ($categories) {
				foreach ( $categories as $cate ) {
					$cate_array[$cate->slug] = $cate->cat_name;
				}
			} else {
				$cate_array[] = esc_html__( "No content Category found", "ova-dep" );
			}

			$this->add_control(
				'category',
				[
					'label'   => esc_html__( 'Category', 'ova-dep' ),
					'type'    => Controls_Manager::SELECT,
					'default' => 'all',
					'options' => array_merge( $catAll, $cate_array )
				]
			);

			$this->add_control(
				'total_count',
				[
					'label'   => esc_html__( 'Total', 'ova-dep' ),
					'type'    => Controls_Manager::NUMBER,
					'default' => 4
				]
			);

			$this->add_control(
				'template',
				[
					'label' => esc_html__( 'Template', 'ova-dep' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'default' => 'template1',
					'options' => [
						'template1'  => esc_html__( 'Template 1', 'ova-dep' ),
						'template2'  => esc_html__( 'Template 2', 'ova-dep' ),
						'template3'  => esc_html__( 'Template 3', 'ova-dep' ),
						'template4'  => esc_html__( 'Template 4', 'ova-dep' ),
						'template5'  => esc_html__( 'Template 5', 'ova-dep' ),
						'template6'  => esc_html__( 'Template 6', 'ova-dep' ),
					],
				]
			);

			$this->add_control(
				'template_layout',
				[
					'label' => esc_html__( 'Layout', 'ova-dep' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'default' => 'template_layout1',
					'options' => [
						'template_layout1'  => esc_html__( 'Layout 1', 'ova-dep' ),
						'template_layout2'  => esc_html__( 'Layout 2', 'ova-dep' ),
					],
					'condition' => [
						'template' => 'template6'
					]
				]
			);

			$this->add_control(
				'number_column',
				[
					'label' => esc_html__( 'Number Of Columns', 'ova-dep' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'default' => 'four_column',
					'options' => [
						'one_column'  => esc_html__( '1 Columns', 'ova-dep' ),
						'two_column'  => esc_html__( '2 Columns', 'ova-dep' ),
						'three_column'  => esc_html__( '3 Columns', 'ova-dep' ),
						'four_column'  => esc_html__( '4 Columns', 'ova-dep' ),
						'five_column' => esc_html__( '5 Columns', 'ova-dep' ),
						'six_column'   => esc_html__( '6 Columns', 'ova-dep' ),
					],
				]
			);

			$this->add_control(
				'orderby_post',
				[
					'label' => esc_html__( 'OrderBy', 'ova-dep' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'default' => 'ID',
					'options' => [
						'ID'  => esc_html__( 'ID', 'ova-dep' ),
						'title'  => esc_html__( 'Title', 'ova-dep' ),
						'date'  => esc_html__( 'Date', 'ova-dep' ),
						'rand'  => esc_html__( 'Random', 'ova-dep' ),
						'ova_dep_met_order_dep' => esc_html__( 'Custom Order', 'ova-dep' ),
					],
				]
			);

			$this->add_control(
				'order_post',
				[
					'label' => esc_html__( 'Order', 'ova-dep' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'default' => 'DESC',
					'options' => [
						'ASC'  => esc_html__( 'Ascending', 'ova-dep' ),
						'DESC'  => esc_html__( 'Descending', 'ova-dep' ),
					],
				]
			);

			$this->add_control( 
				'show_icon',
				[
					'label' => esc_html__( 'Show Icon', 'ova-dep' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'ova-dep' ),
					'label_off' => esc_html__( 'Hide', 'ova-dep' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);

			$this->add_control(
				'show_title',
				[
					'label' => esc_html__( 'Show Title', 'ova-dep' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'ova-dep' ),
					'label_off' => esc_html__( 'Hide', 'ova-dep' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);

			$this->add_control(
				'show_line',
				[
					'label' => esc_html__( 'Show Line', 'ova-dep' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'ova-dep' ),
					'label_off' => esc_html__( 'Hide', 'ova-dep' ),
					'return_value' => 'yes',
					'default' => 'yes',
					'condition' => [
						'template' => 'template3'
					]
				]
			);

			$this->add_control(
				'show_excerpt',
				[
					'label' => esc_html__( 'Show Excerpt', 'ova-dep' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'ova-dep' ),
					'label_off' => esc_html__( 'Hide', 'ova-dep' ),
					'return_value' => 'yes',
					'default' => 'yes',
					'condition' => [
						'template' => 'template4'
					]
				]
			);

			$this->add_control(
				'show_number',
				[
					'label' => esc_html__( 'Show Number', 'ova-dep' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'ova-dep' ),
					'label_off' => esc_html__( 'Hide', 'ova-dep' ),
					'return_value' => 'yes',
					'default' => 'yes',
					'condition' => [
						'template' => ['template1','template5']
					]
				]
			);

			$this->add_control(
				'show_link_to',
				[
					'label' => esc_html__( 'Show Link to Detail', 'ova-dep' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'ova-dep' ),
					'label_off' => esc_html__( 'Hide', 'ova-dep' ),
					'return_value' => 'yes',
					'default' => 'yes',
					'condition' => [
						'show_title' => 'yes'
					]
				]
			);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_icon',
			[
				'label' => esc_html__( 'Icon', 'ova-dep' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_control(
				'color_icon',
				[
					'label' => esc_html__( 'Color', 'ova-dep' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova_list_dep .items .icon i' => 'color : {{VALUE}};',
					],
				]
			);

			$this->add_control(
				'color_icon_hover',
				[
					'label' => esc_html__( 'Color Hover', 'ova-dep' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova_list_dep .items:hover .icon i' => 'color : {{VALUE}};',
					],
				]
			);

			$this->add_control(
				'bg_color_icon',
				[
					'label' => esc_html__( 'Background Color', 'ova-dep' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova_list_dep .items .icon' => 'background-color : {{VALUE}};',
					],
				]
			);

			$this->add_control(
				'bg_color_icon_hover',
				[
					'label' => esc_html__( 'Background Color Hover', 'ova-dep' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova_list_dep .items:hover .icon' => 'background-color : {{VALUE}};',
					],
				]
			);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_arrow_icon',
			[
				'label' => esc_html__( 'Arrow Icon', 'ova-dep' ),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition' => [
					'template' => 'template4'
				]
			]
		);

			$this->add_control(
				'color_arrow_icon',
				[
					'label' => esc_html__( 'Color', 'ova-dep' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova_list_dep .items .arrow-button' => 'color : {{VALUE}};',
					],
				]
			);

			$this->add_control(
				'color_arrow_icon_hover',
				[
					'label' => esc_html__( 'Color Hover', 'ova-dep' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova_list_dep .items:hover .arrow-button' => 'color : {{VALUE}};',
					],
				]
			);

			$this->add_control(
				'bg_color_arrow_icon',
				[
					'label' => esc_html__( 'Background Color', 'ova-dep' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova_list_dep .items .arrow-button' => 'background-color : {{VALUE}};',
					],
				]
			);

			$this->add_control(
				'bg_color_arrow_icon_hover',
				[
					'label' => esc_html__( 'Background Color Hover', 'ova-dep' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova_list_dep .items:hover .arrow-button' => 'background-color : {{VALUE}};',
					],
				]
			);

		$this->end_controls_section();


		$this->start_controls_section(
			'section_title',
			[
				'label' => esc_html__( 'Title', 'ova-dep' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' => 'title_typography',
					'selector' => '{{WRAPPER}} .ova_list_dep .items .title',
				]
			);

			$this->add_control(
				'color_title',
				[
					'label' => esc_html__( 'Color ', 'ova-dep' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova_list_dep .items .title a' => 'color : {{VALUE}};',
					],
				]
			);

			$this->add_control(
				'color_hover_title',
				[
					'label' => esc_html__( 'Color hover', 'ova-dep' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova_list_dep .items .title a:hover' => 'color : {{VALUE}};',
					],
				]
			);

			$this->add_responsive_control(
				'margin_title',
				[
					'label' => esc_html__( 'Margin', 'ova-dep' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .ova_list_dep .items .title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

		$this->end_controls_section();


		$this->start_controls_section(
			'section_excerpt',
			[
				'label' => esc_html__( 'Excerpt', 'ova-dep' ),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition' => [
					'template' => 'template4'
				]
			]
		);

			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' => 'excerpt_typography',
					'selector' => '{{WRAPPER}} .ova_list_dep .items .description',
				]
			);

			$this->add_control(
				'color_excerpt',
				[
					'label' => esc_html__( 'Color ', 'ova-dep' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova_list_dep .items .description' => 'color : {{VALUE}};',
					],
				]
			);

			$this->add_responsive_control(
				'margin_excerpt',
				[
					'label' => esc_html__( 'Margin', 'ova-dep' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .ova_list_dep .items .description' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);	

		$this->end_controls_section();

	}


	protected function render() {

		$settings = $this->get_settings();

		$template = apply_filters( 'el_elementor_ova_list_dep', 'elementor/ova_list_dep.php' );

		ob_start();
		ovadep_get_template( $template, $settings );
		echo ob_get_clean();
		
	}
}
