<?php
namespace ova_dep_elementor\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


class ova_list_dep_name extends Widget_Base {


	public function get_name() {
		return 'ova_list_dep_name';
	}

	public function get_title() {
		return esc_html__( 'Department Post/Category', 'ova-dep' );
	}

	public function get_icon() {
		return 'eicon-bullet-list';
	}

	public function get_categories() {
		return [ 'ovatheme_dep' ];
	}

	public function get_script_depends() {
		wp_enqueue_script( 'ovadep-list-name', OVADEP_PLUGIN_URI.'assets/js/elementor/list-dep-name.js', array('jquery'), false, true );
		return [ '' ];
	}

	public function get_style_depends() {
		wp_enqueue_style( 'ovadep-list-name', OVADEP_PLUGIN_URI.'assets/css/elementor/ova-list-dep-name.css' );	
		return [];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Content', 'ova-dep' ),
			]
		);

		$this->add_control(
			'title_dep_all',
			[
				'label'   => esc_html__( 'Title All', 'ova-dep' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'All categories', 'ova-dep' ),
			]
		);

		$this->add_control(
			'template',
			[
				'label' => esc_html__( 'Template', 'ova-dep' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'template1',
				'options' => [
					'template1'  => esc_html__( 'Template 1', 'ova-dep' ),
					'template2'  => esc_html__( 'Template 2', 'ova-dep' ),
				],
			]
		);

		$this->add_control(
			'type',
			[
				'label'   => esc_html__( 'Type', 'ova-dep' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'category',
				'options' => [
					'category' => esc_html__( 'Category', 'ova-dep' ),
					'post' => esc_html__( 'Post', 'ova-dep' ),
				]
			]
		);

		$args = array(
           'taxonomy' => 'cat_department',
           'orderby' => 'name',
           'order'   => 'ASC'
       	);
	
		$categories = get_categories($args);
		$catAll = array( 'all' => esc_html__( 'All categories', 'ova-dep' ) );
		$cate_array = array();
		if ($categories) {
			foreach ( $categories as $cate ) {
				$cate_array[$cate->slug] = $cate->cat_name;
			}
		} else {
			$cate_array[] = esc_html__( "No Category found", "ova-dep" );
		}

		$this->add_control(
			'category',
			[
				'label'   => esc_html__( 'Category', 'ova-dep' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'all',
				'options' => array_merge( $catAll, $cate_array ),
				'condition' => [
					'type' => 'post'
				]
			]
		);

		$this->add_control(
			'category_not_in',
			[
				'label'   		=> esc_html__( 'Category Not In', 'ova-dep' ),
				'type'    		=> \Elementor\Controls_Manager::TEXT,
				'description' 	=> esc_html__( 'Enter the department category IDs. IDs are separated by "|". Ex: 1|2|3.', 'ova-dep' ),
				'condition' => [
					'type' => 'category'
				]
			]
		);

		$this->add_control(
			'posts_per_page',
			[
				'label'   => esc_html__( 'Total', 'ova-dep' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => 6,
				'condition' => [
					'type' => 'post'
				]
			]
		);

		$this->add_control(
			'order',
			[
				'label' => esc_html__( 'Order', 'ova-dep' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'DESC',
				'options' => [
					'ASC'  => esc_html__( 'Ascending', 'ova-dep' ),
					'DESC'  => esc_html__( 'Descending', 'ova-dep' ),
				],
			]
		);

		$this->add_control(
			'orderby',
			[
				'label' => esc_html__( 'OrderBy', 'ova-dep' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'ID',
				'options' => [
					'ID'  => esc_html__( 'ID', 'ova-dep' ),
					'title'  => esc_html__( 'Title', 'ova-dep' ),
					'date'  => esc_html__( 'Date', 'ova-dep' ),
					'rand'  => esc_html__( 'Random', 'ova-dep' ),
					'ova_dep_met_order_dep' => esc_html__( 'Custom Order', 'ova-dep' ),
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'cate_border',
				'selector' => '{{WRAPPER}} .ova-list-dep-name .dep-list',
			]
		);

		$this->end_controls_section();

		/* Section STYLE*/
		$this->start_controls_section(
			'title_style_section',
			[
				'label' => esc_html__( 'Title', 'ova-dep' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name' => 'title_typography',
					'selector' => '{{WRAPPER}} .ova-list-dep-name .title',
				]
			);

			$this->add_control(
				'title_color',
				[
					'label' => esc_html__( 'Color', 'ova-dep' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-list-dep-name .title' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_control(
				'title_background',
				[
					'label' => esc_html__( 'Background', 'ova-dep' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-list-dep-name .title' => 'background: {{VALUE}}',
						'{{WRAPPER}} .ova-list-dep-name .title:after' => 'border-top-color: {{VALUE}}',
					],
				]
			);

		$this->end_controls_section();

		/*Category*/
		$this->start_controls_section(
				'category_style_section',
				[
					'label' => esc_html__( 'Category', 'ova-dep' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name' => 'cate_typography',
					'selector' => '{{WRAPPER}} .ova-list-dep-name .dep-list .item-link',
				]
			);

			$this->start_controls_tabs(
				'cate_style_tabs'
			);

				$this->start_controls_tab(
						'cate_style_normal_tab',
						[
							'label' => esc_html__( 'Normal', 'ova-dep' ),
						]
					);

					$this->add_control(
						'cate_color',
						[
							'label' => esc_html__( 'Color', 'ova-dep' ),
							'type' => \Elementor\Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .ova-list-dep-name .dep-list .item-link' => 'color: {{VALUE}}',
								'{{WRAPPER}} .ova-list-dep-name .dep-list .item-link i' => 'color: {{VALUE}}',
							],
						]
					);

					$this->add_control(
						'cate_background',
						[
							'label' => esc_html__( 'Background', 'ova-dep' ),
							'type' => \Elementor\Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .ova-list-dep-name .dep-list .item-link' => 'background: {{VALUE}}',
							],
						]
					);

				$this->end_controls_tab();

				$this->start_controls_tab(
					'cate_style_hover_tab',
					[
						'label' => esc_html__( 'Hover', 'ova-dep' ),
					]
				);

					$this->add_control(
						'cate_hover_color',
						[
							'label' => esc_html__( 'Color', 'ova-dep' ),
							'type' => \Elementor\Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .ova-list-dep-name .dep-list .item-link:hover' => 'color: {{VALUE}}',
								'{{WRAPPER}} .ova-list-dep-name .dep-list .item-link:hover i' => 'color: {{VALUE}}',
							],
						]
					);

					$this->add_control(
						'cate_hover_background',
						[
							'label' => esc_html__( 'Background', 'ova-dep' ),
							'type' => \Elementor\Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .ova-list-dep-name .dep-list .item-link:hover' => 'background: {{VALUE}}',
							],
						]
					);

				$this->end_controls_tab();

			$this->end_controls_tabs();

		$this->end_controls_section();

	}


	protected function render() {

		$settings = $this->get_settings();

		$template = apply_filters( 'el_elementor_ova_list_dep_name', 'elementor/ova_list_dep_name.php' );

		ob_start();
		ovadep_get_template( $template, $settings );
		echo ob_get_clean();
		
	}
}
