<?php 
defined( 'ABSPATH' ) || exit();

if( !class_exists( 'OVACAREER_assets' ) ){
	class OVACAREER_assets{

		public function __construct(){

			/* Add JS, CSS for admin */
			add_action( 'admin_enqueue_scripts', array( $this, 'ovacareer_admin_enqueue_scripts' ), 10, 0 );
            
            /* Add JS, CSS for frontend */
			add_action( 'wp_enqueue_scripts', array( $this, 'ovacareer_enqueue_scripts' ), 10, 0 );

			/* Add JS for Elementor */
			add_action( 'elementor/frontend/after_register_scripts', array( $this, 'ova_enqueue_scripts_elementor_career' ) );

		}

		// Admin
        public function ovacareer_admin_enqueue_scripts(){

        	global $pagenow;

        	$use_gg_map = get_theme_mod('ova_career_use_google_map','yes');

        	if ( ( $pagenow == 'post.php' || $pagenow == 'post-new.php' ) && 'career' === get_post_type() ) {
        		// Map
        		if($use_gg_map == 'yes') {
        			if ( get_theme_mod( 'ova_career_google_key_map', false ) ) {
						wp_enqueue_script( 'pw-google-maps-api', 'https://maps.googleapis.com/maps/api/js?key='.get_theme_mod( 'ova_career_google_key_map', '' ).'&libraries=places', false, true );
					} else {
						wp_enqueue_script( 'pw-google-maps-api','https://maps.googleapis.com/maps/api/js?sensor=false&libraries=places', array('jquery'), false, true );
					}
        		}

				wp_enqueue_style( 'career-admin-style', OVACAREER_PLUGIN_URI.'assets/css/admin-style.css' );
        		wp_enqueue_script( 'script-admin-career', OVACAREER_PLUGIN_URI. 'assets/js/script-admin.js', [ 'jquery' ], false, true );	
        	}
			
		}

		// Frontend
		public function ovacareer_enqueue_scripts(){

			$use_gg_map = get_theme_mod('ova_career_use_google_map','yes');

			if ( is_singular( 'career' ) || is_post_type_archive( 'career' ) || is_tax( 'cat_career' ) ) {
				wp_enqueue_style( 'career-style', OVACAREER_PLUGIN_URI.'assets/css/style.css' );	
				wp_enqueue_script( 'script-career', OVACAREER_PLUGIN_URI. 'assets/js/script.js', [ 'jquery' ], false, true );
				wp_localize_script( 'script-career', 'ova_career_use_google_map', array( 'value' => $use_gg_map ) );
			}
			
			if( is_singular('career') ){
				// Fancybox
				wp_enqueue_script('fancybox', GIMONT_URI.'/assets/libs/fancybox/fancybox.umd.js', array('jquery'),null,true);
				wp_enqueue_style('fancybox', GIMONT_URI.'/assets/libs/fancybox/fancybox.css', array(), null);

				// Map
        		if($use_gg_map == 'yes') {
        			if ( get_theme_mod( 'ova_career_google_key_map', false ) ) {
						wp_enqueue_script( 'pw-google-maps-api', 'https://maps.googleapis.com/maps/api/js?key='.get_theme_mod( 'ova_career_google_key_map', '' ).'&libraries=places', false, true );
					} else {
						wp_enqueue_script( 'pw-google-maps-api','https://maps.googleapis.com/maps/api/js?sensor=false&libraries=places', array('jquery'), false, true );
					}
        		}
			}

		}

		// Add JS for elementor
		public function ova_enqueue_scripts_elementor_career(){
			wp_register_script( 'script-elementor-career', OVACAREER_PLUGIN_URI. 'assets/js/script-elementor.js', [ 'jquery' ], false, true );
		}


	}
	new OVACAREER_assets();
}