(function( $ ){
	'use strict';

	$(document).ready(function(){
      
        /***** Pretty Photo *****/
        if($().prettyPhoto) {
            $(".fullscreen a[rel^='prettyPhoto']").prettyPhoto();
        }

		// init Masonry Archive Collection after all images have loaded
        if($().imagesLoaded) {
            var $grid = $('.archive_collection .content_archive_coll').imagesLoaded( function() {
                $grid.masonry({
                    itemSelector: '.items_archive_coll',
                    columnWidth: '.items_archive_coll',
                    gutter: 30,
                    percentPosition: true
                });
            });
        }

        /* Select2*/
        if ($('.archive_collection .postform').length > 0) {
            $('.archive_collection .postform').select2({
                language: {
                    inputTooShort: function() {
                        return Select2Text.input_short;
                    },
                    noResults: function (params) {
                      return Select2Text.no_results;
                    }
                }
            });
        };

        /* Single Toggle*/
        $(".single_collection .card button").click(function(){
            $(this).toggleClass("collapsed");
            $(this).next().slideToggle("slow");
        });  

   });

})(jQuery); 	