<?php if ( !defined( 'ABSPATH' ) ) exit();

get_header( );
global $post;

$collection_artists          = OVACOLL_get_data::OVACOLL_get_all_artist();

$collection_artist           = get_post_meta( $post->ID,'collection_artist', true ) ? get_post_meta( $post->ID,'collection_artist', true ) : array();
$collection_year_number      = get_post_meta( $post->ID, 'collection_year_number', true ) ? get_post_meta( $post->ID, 'collection_year_number', true ) : '';
$collection_year_text        = get_post_meta( $post->ID, 'collection_year_text', true ) ? get_post_meta( $post->ID, 'collection_year_text', true ) : '';

$collection_address          = get_post_meta( $post->ID, 'collection_address', true ) ? get_post_meta( $post->ID, 'collection_address', true ) : '';

$collection_marterial        = get_post_meta( $post->ID, 'collection_marterial', true ) ? get_post_meta( $post->ID, 'collection_marterial', true ) : '';

$collection_accession_number = get_post_meta( $post->ID, 'collection_accession_number', true ) ? get_post_meta( $post->ID, 'collection_accession_number', true ) : '';

$collection_dimensions       = get_post_meta( $post->ID, 'collection_dimensions', true ) ? get_post_meta( $post->ID, 'collection_dimensions', true ) : '';

$collection_credit           = get_post_meta( $post->ID, 'collection_credit', true ) ? get_post_meta( $post->ID, 'collection_credit', true ) : '';

$collection_file_download    = get_post_meta( $post->ID, 'collection_file_download', true ) ? get_post_meta( $post->ID, 'collection_file_download', true ) : '';
$link_download               = wp_get_attachment_url( $collection_file_download );

$collection_visual_desc      = get_post_meta( $post->ID, 'collection_visual_desc', true ) ? get_post_meta( $post->ID, 'collection_visual_desc', true ) : '';

$collection_history          = get_post_meta( $post->ID, 'collection_history', true ) ? get_post_meta( $post->ID, 'collection_history', true ) : '';

$collection_publication      = get_post_meta( $post->ID, 'collection_publication', true ) ? get_post_meta( $post->ID, 'collection_publication', true ) : '';

$link  = get_the_permalink();
$title = get_the_title(); 

$location = get_the_terms( get_the_id(), 'location') ; 

$feature_image   = wp_get_attachment_image_url(get_post_thumbnail_id() , 'full' );
if ( $feature_image == '') {
    $feature_image  =  \Elementor\Utils::get_placeholder_image_src();
}

$taxonomy 	= 'collection_type';
$terms 		= get_the_terms( get_the_ID(),$taxonomy );

// Get list artist
$array_artist = array();
$value_artist = '';

foreach ($collection_artists as $key => $id) {

	$slug_artist = get_post_field( 'post_name', $id );

	if(in_array($slug_artist, $collection_artist) == true ){

		$link = get_the_permalink( $id );
		$title_artist = get_the_title( $id );

		$array_artist[] = '<a class="value_artist" href="'. $link .'"> '. $title_artist .'</a>' ;
		
	}
}

// show fields
$show_share     = OVACOLL_Settings::single_collection_show_share();
$show_download  = OVACOLL_Settings::single_collection_show_download();
$show_popup	    = OVACOLL_Settings::single_collection_show_popup();
$show_artist    = OVACOLL_Settings::single_collection_show_artist();
$show_year      = OVACOLL_Settings::single_collection_show_year();
$show_location  = OVACOLL_Settings::single_collection_show_location();

$show_description  		= OVACOLL_Settings::single_collection_show_description();
$show_artist_mid   		= OVACOLL_Settings::single_collection_show_artist_mid();
$show_year_text    		= OVACOLL_Settings::single_collection_show_year_text();
$show_address      		= OVACOLL_Settings::single_collection_show_address();
$show_type         		= OVACOLL_Settings::single_collection_show_type();
$show_material     		= OVACOLL_Settings::single_collection_show_material();
$show_accession_number  = OVACOLL_Settings::single_collection_show_accession_number();
$show_dimensions  	    = OVACOLL_Settings::single_collection_show_dimensions();
$show_credit     	    = OVACOLL_Settings::single_collection_show_credit();
$show_visual_desc       = OVACOLL_Settings::single_collection_visual_desc();
$show_timeline_history  = OVACOLL_Settings::single_collection_timeline_history();
$show_publications      = OVACOLL_Settings::single_collection_publications();
$show_comment           = OVACOLL_Settings::single_collection_show_comment();

?>

<div class="row_site">
	<div class="container_site">

		<div class="single_collection">

			<div class="collection_intro">

				<div class="image">
					<img src="<?php echo esc_url( $feature_image ); ?>" alt="<?php the_title(); ?>" class="collection-feature-image">
					<div class="caption_img"><?php the_post_thumbnail_caption(); ?></div>
				</div>

				<?php if ( $show_share == 'yes' || $show_download == 'yes' || $show_popup == 'yes'  ) : ?>
					<ul class="buttons">
						<?php if ( $show_share == 'yes' ) { ?>
							<li class="share">
								<a href="#" rel="prettyPhoto">
									<i class="fas fa-share-alt"></i>
								</a>
								<?php echo apply_filters( 'ova_share_social', $link, $title  ); ?>
							</li>
						<?php } ?>

						<?php if( !empty($link_download) && $show_download == 'yes' ) { ?>
							<li class="download">
								<a href="<?php echo esc_attr( $link_download ); ?>" download>
									<i class="fas fa-download"></i>
								</a>
							</li>
						<?php } ?>

						<?php if ( $show_popup == 'yes' ) { ?>
							<li class="fullscreen">
								<a href="<?php echo esc_url( $feature_image ); ?>" rel="prettyPhoto">
									<i class="ovaicon ovaicon-fullscreen"></i>
								</a>
							</li>
						<?php } ?>
					</ul>
				<?php endif; ?>
			</div>

			<div class="collection_content">
				<div class="collection_top">
					<h1 class="title_top second_font">
						<?php echo get_the_title(); ?>
					</h1>

					<div class="desc">
						<?php if ( !empty($array_artist) && $show_artist == 'yes' ) { ?>
							<span class="artist">
								<?php echo implode(", ", $array_artist); ?>
							</span>
						<?php } ?>
						
						<?php if ($collection_year_number != '' && $show_year == 'yes') { ?>
							<span class="year_number"> 
								<?php if ( !empty($array_artist) && $show_artist == 'yes' ) echo ', '; ?>
								<?php esc_html_e( $collection_year_number );  ?>
							</span>
						<?php } ?>

						<?php if ( !empty($location) && $show_location == 'yes' ) {
							foreach ( $location as $value ) {
								$key_location[] = $value->name;
							} ?>
							<span class="location">
								<?php if ($collection_year_number != '' && $show_year == 'yes') echo ', '; ?>
								<?php echo (join( ", ", $key_location)); ?>
							</span>
						<?php } ?>
					</div>

					<?php if ($show_description == 'yes') { ?>
						<div class="content">
							<?php if ( have_posts() ) : while ( have_posts() ) : the_post();
								the_content();
							endwhile; endif; ?>
						</div>
					<?php } ?>
				</div>

				<div class="collection_mid">
					<ul>
						<?php if ( !empty( $array_artist ) && $show_artist_mid == 'yes' ) { ?>
							<li>
								<label class="title_mid">
									<?php esc_html_e('Artist','ova-collection');?>
								</label>
								<span class="value_mid">
									<?php echo implode(", ", $array_artist); ?>
								</span>
							</li>
						<?php } ?>


						<?php if ($collection_year_text != '' && $show_year_text == 'yes') { ?>
							<li>
								<label class="title_mid"><?php esc_html_e('Year:','ova-collection');?></label>
								<span class="value_mid"><?php echo esc_attr( $collection_year_text ); ?></span>
							</li>
						<?php } ?>

						<?php if ($collection_address != '' && $show_address == 'yes') { ?>
							<li>
								<label class="title_mid"><?php esc_html_e('Address:','ova-collection');?></label>
								<span class="value_mid"><?php echo esc_attr( $collection_address ); ?></span>
							</li>
						<?php } ?>

						<?php if ( $terms && ! is_wp_error($terms) && $show_type == 'yes' ) : ?>
							<li>
								<label class="title_mid"><?php esc_html_e('Type:','ova-collection');?></label>
								<span class="value_mid">
									<?php $tslugs_arr = array();
										foreach ($terms as $term) {
											$tslugs_arr[] = $term->name;
										}
										$terms_slug_str = join( ", ", $tslugs_arr);
										echo esc_html($terms_slug_str);
									?>		
								</span>
							</li>
						<?php endif; ?>

						<?php if ($collection_marterial != '' && $show_material == 'yes') { ?>
							<li>
								<label class="title_mid"><?php esc_html_e('Material:','ova-collection');?></label>
								<span class="value_mid"><?php echo esc_attr( $collection_marterial ); ?></span>
							</li>
						<?php } ?>

						<?php if ($collection_accession_number != '' && $show_accession_number == 'yes' ) { ?>
							<li>
								<label class="title_mid"><?php esc_html_e('Accession Number:','ova-collection');?></label>
								<span class="value_mid"><?php echo esc_attr( $collection_accession_number ); ?></span>
							</li>
						<?php } ?>

						<?php if ($collection_dimensions != '' && $show_dimensions == 'yes') { ?>
							<li>
								<label class="title_mid"><?php esc_html_e('Dimensions:','ova-collection');?></label>
								<span class="value_mid"><?php echo esc_attr( $collection_dimensions ); ?></span>
							</li>
						<?php } ?>

						<?php if ( $collection_credit != '' && $show_credit == 'yes' ) { ?>
							<li>
								<label class="title_mid"><?php esc_html_e('Credit:','ova-collection');?></label>
								<span class="value_mid"><?php echo esc_attr( $collection_credit ); ?></span>
							</li>
						<?php }?>
					</ul>
				</div>

				<div class="collection_bottom">

					<div class="accordion" id="accordionExample">

						<?php if ($collection_visual_desc != '' && $show_visual_desc == 'yes') { ?>
							<div class="card">
								<button data-toggle="collapse" data-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
									<?php esc_html_e( 'Visual Description', 'ova-collection' ); ?>
									<i class="fas fa-angle-up"></i>
								</button>
								<div id="collapseOne" class="collapse show" >		
									<div class="content">
										<?php echo $collection_visual_desc ; ?>
									</div>
								</div>
							</div>
						<?php } ?>

		                <?php if ($collection_history != '' && $show_timeline_history == 'yes') { ?>
							<div class="card">
								<button data-toggle="collapse" data-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo" class="collapsed">
									<?php esc_html_e( 'Timeline of Art History', 'ova-collection' ); ?>
									<i class="fas fa-angle-up"></i>
								</button>
								<div id="collapseTwo" class="collapse" >		
									<div class="content">
										<?php echo $collection_history ; ?>
									</div>
								</div>
							</div>
						<?php } ?>

						<?php if ($collection_publication != '' && $show_publications == 'yes') { ?>
							<div class="card">
								<button data-toggle="collapse" data-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree" class="collapsed">
									<?php esc_html_e( 'Publications', 'ova-collection' ); ?>
									<i class="fas fa-angle-up"></i>
								</button>
								<div id="collapseThree" class="collapse" >		
									<div class="content">
										<?php echo $collection_publication ; ?>
									</div>
								</div>
							</div>
						<?php } ?>

					</div>
					
				</div>

				<div class="collection_comment">
					<?php if($show_comment == 'yes') :
						if ( comments_open() || get_comments_number() ) {
							comments_template();
						}
					endif; ?>
				</div>
			</div>

		</div>

	</div>
</div>


<?php get_footer( );