<?php
namespace ova_doc_elementor\Widgets;

use Elementor\Widget_Base;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class ova_doc_download_2 extends Widget_Base {

	public function get_name() {
		return 'ova_doc_download_2';
	}

	public function get_title() {
		return esc_html__( 'Document Download 2', 'ova-doc' );
	}

	public function get_icon() {
		return 'eicon-document-file';
	}

	public function get_categories() {
		return [ 'ovatheme_doc' ];
	}

	public function get_script_depends() {
		wp_enqueue_script('ovadoc-download-2', OVADOC_PLUGIN_URI . 'assets/js/elementor/ova-doc-download-2.js', array('jquery'), false, true);	
		wp_enqueue_script('ova_show_doc_script', OVADOC_PLUGIN_URI . 'assets/js/show-document.js', array('jquery'), false, true);
		wp_localize_script( 'ova_show_doc_script', 'ova_doc_ajax_object', array( 'ajax_url' => admin_url( 'admin-ajax.php' ) ) );
		return [ '' ];
	}

	public function get_style_depends() {
		wp_enqueue_style( 'ovadoc-download-2', OVADOC_PLUGIN_URI.'assets/css/elementor/ova-doc-download-2.css' );	
		wp_enqueue_style( 'ova_show_doc_style', OVADOC_PLUGIN_URI.'assets/css/frontend/show-document.css' );
		return [];
	}

	protected function ova_doc_categories() {

		$cate_args = array(
			'taxonomy' => 'cat_doc',
			'orderby' => 'name',
			'order'   => 'ASC'
		);

		$categories = get_categories( $cate_args );
		$new_category = array('all'=> esc_html__('All', 'ova-doc'));
		if ( $categories ) {
			foreach ($categories as $key => $cate) {
				$new_category[$cate->slug] = $cate->name;
			}
		}
		return $new_category;
	}

	protected function register_controls() {
		/* Document */
		$this->start_controls_section(
				'doc_section',
				[
					'label' => esc_html__( 'Document', 'ova-doc' ),
					'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
				]
			);

			$this->add_control(
				'column',
				[
					'label' => esc_html__( 'Columns', 'ova-doc' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'default' => 'two_columns',
					'options' => [
						'two_columns' => esc_html__( '2 Columns', 'ova-doc' ),
						'three_columns' => esc_html__( '3 Columns', 'ova-doc' ),
					],
				]
			);

			$this->add_control(
				'order',
				[
					'label' => esc_html__( 'Order', 'ova-doc' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'default' => 'DESC',
					'options' => [
						'ASC' => esc_html__( 'Ascending', 'ova-doc' ),
						'DESC' => esc_html__( 'Descending', 'ova-doc' ),
					],
				]
			);

			$this->add_control(
				'order_by',
				[
					'label' => esc_html__( 'Order By', 'ova-doc' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'default' => 'ID',
					'options' => [
						'ova_doc_met_order_doc' 	=> esc_html__( 'Sort Order', 'ova-doc' ),
						'ova_doc_met_publish_date' 	=> esc_html__( 'Published Date', 'ova-doc' ),
						'ID'  						=> esc_html__( 'ID', 'ova-doc' ),
						'date'  					=> esc_html__( 'Date', 'ova-doc' ),
						'title' 					=> esc_html__( 'Title', 'ova-doc' ),
						'rand'  					=> esc_html__( 'Random', 'ova-doc' ),
					],
				]
			);

			$this->add_control(
				'posts_per_page',
				[
					'label' => esc_html__( 'Document Items', 'ova-doc' ),
					'type' => \Elementor\Controls_Manager::NUMBER,
					'min' => 1,
					'max' => 10,
					'step' => 1,
					'default' => 4,
					'frontend_available' => true,
				]
			);

			$categories = $this->ova_doc_categories();

			$this->add_control(
				'cate',
				[
					'label' => esc_html__( 'Category', 'ova-doc' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'default' => 'all',
					'options' => $categories,
					'frontend_available' => true,
				]
			);

			$this->add_control(
				'show_date',
				[
					'label' => esc_html__( 'Show Date', 'ova-doc' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'ova-doc' ),
					'label_off' => esc_html__( 'Hide', 'ova-doc' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);

			$this->add_control(
				'show_view_icon',
				[
					'label' => esc_html__( 'Show View Icon', 'ova-doc' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'ova-doc' ),
					'label_off' => esc_html__( 'Hide', 'ova-doc' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);

			$this->add_control(
				'show_title',
				[
					'label' => esc_html__( 'Show Title', 'ova-doc' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'ova-doc' ),
					'label_off' => esc_html__( 'Hide', 'ova-doc' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);

			$this->add_control(
				'show_link_to',
				[
					'label' => esc_html__( 'Show Link of Title', 'ova-doc' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'ova-doc' ),
					'label_off' => esc_html__( 'Hide', 'ova-doc' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);

		$this->end_controls_section();

		/* Item */
		$this->start_controls_section(
				'item_style_section',
				[
					'label' => esc_html__( 'Item', 'ova-doc' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_responsive_control(
				'item_padding',
				[
					'label' => esc_html__( 'Padding', 'ova-doc' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-doc-download-2 .document-list .item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Border::get_type(),
				[
					'name' => 'item_border',
					'selector' => '{{WRAPPER}} .ova-doc-download-2 .document-list .item',
				]
			);

			$this->add_control(
				'item_background',
				[
					'label' => esc_html__( 'Background', 'ova-doc' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-doc-download-2' => 'background: {{VALUE}}',
					],
				]
			);

		$this->end_controls_section();

		/* Date */
		$this->start_controls_section(
				'date_style_section',
				[
					'label' => esc_html__( 'Date', 'ova-doc' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);
			$this->add_responsive_control(
				'date_margin',
				[
					'label' => esc_html__( 'Margin', 'ova-doc' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-doc-download-2 .document-list .date' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name' => 'date_typography',
					'selector' => '{{WRAPPER}} .ova-doc-download-2 .document-list .date',
				]
			);

			$this->add_control(
				'date_color',
				[
					'label' => esc_html__( 'Color', 'ova-doc' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-doc-download-2 .document-list .date' => 'color: {{VALUE}}',
					],
				]
			);

		$this->end_controls_section();

		/*Title*/
		$this->start_controls_section(
				'title_style_section',
				[
					'label' => esc_html__( 'Title', 'ova-doc' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);
			$this->add_responsive_control(
				'title_margin',
				[
					'label' => esc_html__( 'Margin', 'ova-doc' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .ova-doc-download-2 .document-list .title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name' => 'title_typography',
					'selector' => '{{WRAPPER}} .ova-doc-download-2 .document-list .title',
				]
			);

			$this->start_controls_tabs(
					'title_style_tabs'
				);

				$this->start_controls_tab(
					'title_style_normal_tab',
					[
						'label' => esc_html__( 'Normal', 'ova-doc' ),
					]
				);

				$this->add_control(
					'title_color',
					[
						'label' => esc_html__( 'Color', 'ova-doc' ),
						'type' => \Elementor\Controls_Manager::COLOR,
						'selectors' => [
							'{{WRAPPER}} .ova-doc-download-2 .document-list .title' => 'color: {{VALUE}}',
						],
					]
				);

			$this->end_controls_tab();

			$this->start_controls_tab(
					'title_style_hover_tab',
					[
						'label' => esc_html__( 'Hover', 'ova-doc' ),
					]
				);

				$this->add_control(
					'title_hover_color',
					[
						'label' => esc_html__( 'Color', 'ova-doc' ),
						'type' => \Elementor\Controls_Manager::COLOR,
						'selectors' => [
							'{{WRAPPER}} .ova-doc-download-2 .document-list .title:hover' => 'color: {{VALUE}}',
							'{{WRAPPER}} .ova-doc-download-2 .document-list .title:after' => 'background: {{VALUE}}',
						],
					]
				);

			$this->end_controls_tab();

			$this->end_controls_tabs();

		$this->end_controls_section();

		/* Icon */
		$this->start_controls_section(
				'icon_style_section',
				[
					'label' => esc_html__( 'Icon', 'ova-doc' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);
			$this->add_responsive_control(
					'icon_size',
					[
						'label' => esc_html__( 'Size', 'ova-doc' ),
						'type' => \Elementor\Controls_Manager::SLIDER,
						'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
						'range' => [
							'px' => [
								'min' => 0,
								'max' => 100,
								'step' => 5,
							],
							'%' => [
								'min' => 0,
								'max' => 100,
							],
						],
						'selectors' => [
							'{{WRAPPER}} .ova-doc-download-2 .document-list .icon a' => 'font-size: {{SIZE}}{{UNIT}};',
						],
					]
				);

			$this->start_controls_tabs(
					'icon_style_tabs'
				);

				$this->start_controls_tab(
						'icon_style_normal_tab',
						[
							'label' => esc_html__( 'Normal', 'ova-doc' ),
						]
					);

					$this->add_control(
						'icon_color',
						[
							'label' => esc_html__( 'Color', 'ova-doc' ),
							'type' => \Elementor\Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .ova-doc-download-2 .document-list .icon a' => 'color: {{VALUE}}',
							],
						]
					);

					$this->end_controls_tab();

				$this->start_controls_tab(
						'icon_style_hover_tab',
						[
							'label' => esc_html__( 'Hover', 'ova-doc' ),
						]
					);

					$this->add_control(
						'icon_hover_color',
						[
							'label' => esc_html__( 'Color', 'ova-doc' ),
							'type' => \Elementor\Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .ova-doc-download-2 .document-list .icon a:hover' => 'color: {{VALUE}}',
							],
						]
					);

				$this->end_controls_tab();

			$this->end_controls_tabs();

		$this->end_controls_section();
	}


	protected function render() {
		$settings = $this->get_settings_for_display();
		$template = apply_filters( 'el_elementor_ova_doc_download2', 'elementor/ova_doc_download_2.php' );

		ob_start();
		ovadoc_get_template( $template, $settings );
		echo ob_get_clean();
	}
}
