<?php
namespace ova_por_elementor\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


class ova_por_grid extends Widget_Base {


	public function get_name() {
		return 'ova_por_grid';
	}

	public function get_title() {
		return esc_html__( 'Portfolio Grid', 'ova-por' );
	}

	public function get_icon() {
		return 'eicon-posts-grid';
	}

	public function get_categories() {
		return [ 'ovatheme_portfolio' ];
	}

	public function get_script_depends() {
		return [''];
	}

	public function get_style_depends() {
		wp_enqueue_style( 'ovapor-grid', OVAPOR_PLUGIN_URI.'/assets/css/elementor/portfolio-grid.css', array(), null);
		return [];
	}

	protected function ova_categories() {

		$args = array(
			'taxonomy' => 'cat_por',
			'orderby' => 'name',
			'order'   => 'ASC'
		);

		$categories = get_categories($args);
		$cate_array = array( 'all' => esc_html__( 'All categories', 'ova-por' ) );

		if ($categories) {
			foreach ( $categories as $cate ) {
				$cate_array[$cate->slug] = $cate->cat_name;
			}
		}
		return $cate_array;
	}

	protected function register_controls() {

		/* Content */
		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Content', 'ova-por' ),
			]
		);

			$this->add_control(
				'template',
				[
					'label' => esc_html__( 'Template', 'ova-por' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'default' => 'template1',
					'options' => [
						'template1' => esc_html__( 'Template 1', 'ova-por' ),
						'template2' => esc_html__( 'Template 2', 'ova-por' ),
					],
				]
			);

			$this->add_control(
				'columns',
				[
					'label' => esc_html__( 'Columns', 'ova-por' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'default' => 'five_columns',
					'options' => [
						'three_columns' => esc_html__( '3', 'ova-por' ),
						'four_columns' => esc_html__( '4', 'ova-por' ),
						'five_columns' => esc_html__( '5', 'ova-por' ),
					],
				]
			);

			$categories = $this->ova_categories();

			$this->add_control(
				'cate',
				[
					'label'   => esc_html__( 'Category', 'ova-por' ),
					'type'    => Controls_Manager::SELECT,
					'default' => 'all',
					'options' => $categories,
				]
			);

			$this->add_control(
				'posts_per_page',
				[
					'label'   => esc_html__( 'Total', 'ova-por' ),
					'type'    => Controls_Manager::NUMBER,
					'default' => 5
				]
			);

			$this->add_control(
				'order',
				[
					'label' => esc_html__( 'Order', 'ova-por' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'default' => 'DESC',
					'options' => [
						'ASC' => esc_html__( 'Ascending', 'ova-por' ),
						'DESC' => esc_html__( 'Descending', 'ova-por' ),
					],
				]
			);

			$this->add_control(
				'order_by',
				[
					'label' => esc_html__( 'OrderBy Post', 'ova-por' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'default' => 'ID',
					'options' => [
						'ID'  	=> esc_html__( 'ID', 'ova-por' ),
						'date'  => esc_html__( 'Date', 'ova-por' ),
						'title' => esc_html__( 'Title', 'ova-por' ),
						'rand'  => esc_html__( 'Random', 'ova-por' ),
						'ova_por_met_order_por' => esc_html__( 'Custom Order', 'ova-por' ),
					],
				]
			);

			$this->add_control(
				'lower_column',
				[
					'label'   => esc_html__( 'Lower Column', 'ova-por' ),
					'type'    => Controls_Manager::SWITCHER,
					'default' => 'yes',
					'options' => [
						'yes' => esc_html__( 'Yes', 'ova-por' ),
						'no'  => esc_html__( 'No', 'ova-por' ),
					],
					'frontend_available' => true,
					'separator' => 'before'
				]
			);

			$this->add_control(
				'show_icon',
				[
					'label' => esc_html__( 'Show Icon', 'ova-por' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'ova-por' ),
					'label_off' => esc_html__( 'Hide', 'ova-por' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);

			$this->add_control(
				'show_category',
				[
					'label'   => esc_html__( 'Show Category', 'ova-por' ),
					'type'    => Controls_Manager::SWITCHER,
					'default' => 'yes',
					'options' => [
						'yes' => esc_html__( 'Yes', 'ova-por' ),
						'no'  => esc_html__( 'No', 'ova-por' ),
					],
					'frontend_available' => true,
				]
			);

			$this->add_control(
				'show_title',
				[
					'label' => esc_html__( 'Show Title', 'ova-por' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'ova-por' ),
					'label_off' => esc_html__( 'Hide', 'ova-por' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);

			$this->add_control(
				'show_link_to',
				[
					'label' => esc_html__( 'Show Link to Detail', 'ova-por' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'ova-por' ),
					'label_off' => esc_html__( 'Hide', 'ova-por' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);

			$this->add_control(
				'show_text_count_gallery',
				[
					'label'   => esc_html__( 'Show Text Count Gallery', 'ova-por' ),
					'type'    => Controls_Manager::SWITCHER,
					'default' => 'no',
					'options' => [
						'yes' => esc_html__( 'Yes', 'ova-por' ),
						'no'  => esc_html__( 'No', 'ova-por' ),
					],
					'frontend_available' => true,
				]
			);

			$this->add_control(
				'text_count_gallery',
				[
					'label'   => esc_html__( 'Text Count Galery', 'ova-por' ),
					'type'    => Controls_Manager::TEXT,
					'default' => esc_html__( '+ Photos & Videos', 'ova-por' ),
					'condition' => [
						'show_text_count_gallery' => 'yes'
					]
				]
			);

		$this->end_controls_section();

		/* General */
		$this->start_controls_section(
				'general_style_section',
				[
					'label' => esc_html__( 'General', 'ova-por' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_responsive_control(
				'item_padding',
				[
					'label' => esc_html__( 'Padding', 'ova-por' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .portfolio-grid .info-wrap' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_control(
				'item_background',
				[
					'label' => esc_html__( 'Background', 'ova-por' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .portfolio-grid .info-wrap' => 'background: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Background::get_type(),
				[
					'name' => 'item_background_gradient',
					'types' => [ 'gradient'],
					'selector' => '{{WRAPPER}} .portfolio-grid .info-wrap',
				]
			);

		$this->end_controls_section();

		/* Icon */
		$this->start_controls_section(
				'icon_style_section',
				[
					'label' => esc_html__( 'Icon', 'ova-por' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_responsive_control(
				'icon_size',
				[
					'label' => esc_html__( 'Icon Size', 'ova-por' ),
					'type' => \Elementor\Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 100,
							'step' => 5,
						],
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .portfolio-grid .icon a i' => 'font-size: {{SIZE}}{{UNIT}};',
					],
				]
			);

			$this->add_responsive_control(
				'icon_box_size',
				[
					'label' => esc_html__( 'Icon Box Size', 'ova-por' ),
					'type' => \Elementor\Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 100,
							'step' => 5,
						],
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .portfolio-grid .icon a' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
					],
				]
			);

			$this->add_control(
				'icon_color',
				[
					'label' => esc_html__( 'Color', 'ova-por' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .portfolio-grid .icon a' => 'border-color: {{VALUE}}',
						'{{WRAPPER}} .portfolio-grid .icon a i' => 'color: {{VALUE}}',
					],
				]
			);

		$this->end_controls_section();

		/* Category */
		$this->start_controls_section(
				'cate_style_section',
				[
					'label' => esc_html__( 'Category', 'ova-por' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_responsive_control(
				'cate_margin',
				[
					'label' => esc_html__( 'Margin', 'ova-por' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .portfolio-grid .categories' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name' => 'cate_typography',
					'selector' => '{{WRAPPER}} .portfolio-grid .categories a',
				]
			);

			$this->add_control(
				'cate_color',
				[
					'label' => esc_html__( 'Color', 'ova-por' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .portfolio-grid .categories' => 'color: {{VALUE}}',
						'{{WRAPPER}} .portfolio-grid .categories a' => 'color: {{VALUE}}',
					],
				]
			);

		$this->end_controls_section();

		/* Title */
		$this->start_controls_section(
				'title_style_section',
				[
					'label' => esc_html__( 'Title', 'ova-por' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_responsive_control(
				'title_margin',
				[
					'label' => esc_html__( 'Margin', 'ova-por' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .portfolio-grid .title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name' => 'title_typography',
					'selector' => '{{WRAPPER}} .portfolio-grid .title',
				]
			);

			$this->add_control(
				'title_color',
				[
					'label' => esc_html__( 'Color', 'ova-por' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .portfolio-grid .title' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_control(
				'title_hover_color',
				[
					'label' => esc_html__( 'Hover Color', 'ova-por' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .portfolio-grid .title:hover' => 'color: {{VALUE}}',
					],
				]
			);

		$this->end_controls_section();
	}


	protected function render() {

		$settings = $this->get_settings();

		$template = apply_filters( 'el_elementor_ova_por_grid', 'elementor/ova_por_grid.php' );

		ob_start();
		ovapor_get_template( $template, $settings );
		echo ob_get_clean();
		
	}
}
