<?php
namespace ova_por_elementor\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


class ova_por_slide extends Widget_Base {


	public function get_name() {
		return 'ova_por_slide';
	}

	public function get_title() {
		return esc_html__( 'Portfolio Slide', 'ova-por' );
	}

	public function get_icon() {
		return 'eicon-slider-album';
	}

	public function get_categories() {
		return [ 'ovatheme_portfolio' ];
	}

	public function get_script_depends() {
		wp_enqueue_script( 'ovapor-slide', OVAPOR_PLUGIN_URI.'assets/js/elementor/portfolio-slide.js' );
		return [ '' ];
	}

	public function get_style_depends() {
		wp_enqueue_style( 'ovapor-slide', OVAPOR_PLUGIN_URI.'/assets/css/elementor/portfolio-slide.css', array(), null);
		return [];
	}


	protected function ova_categories() {

		$args = array(
			'taxonomy' => 'cat_por',
			'orderby' => 'name',
			'order'   => 'ASC'
		);

		$categories = get_categories($args);
		$cate_array = array( 'all' => esc_html__( 'All categories', 'ova-por' ) );

		if ($categories) {
			foreach ( $categories as $cate ) {
				$cate_array[$cate->slug] = $cate->cat_name;
			}
		}
		return $cate_array;
	}

	protected function register_controls() {

		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Content', 'ova-por' ),
			]
		);

		$categories = $this->ova_categories();

		$this->add_control(
			'cate',
			[
				'label'   => esc_html__( 'Category', 'ova-por' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'all',
				'options' => $categories,
			]
		);

		$this->add_control(
			'posts_per_page',
			[
				'label'   => esc_html__( 'Total', 'ova-por' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => 5
			]
		);

		$this->add_control(
			'order',
			[
				'label' => esc_html__( 'Order', 'ova-por' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'DESC',
				'options' => [
					'ASC' => esc_html__( 'Ascending', 'ova-por' ),
					'DESC' => esc_html__( 'Descending', 'ova-por' ),
				],
			]
		);

		$this->add_control(
			'order_by',
			[
				'label' => esc_html__( 'OrderBy Post', 'ova-por' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'ID',
				'options' => [
					'ID'  	=> esc_html__( 'ID', 'ova-por' ),
					'date'  => esc_html__( 'Date', 'ova-por' ),
					'title' => esc_html__( 'Title', 'ova-por' ),
					'rand'  => esc_html__( 'Random', 'ova-por' ),
					'ova_por_met_order_por' => esc_html__( 'Custom Order', 'ova-por' ),
				],
			]
		);

		$this->add_control(
			'show_icon',
			[
				'label' => esc_html__( 'Show Icon', 'ova-por' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'ova-por' ),
				'label_off' => esc_html__( 'Hide', 'ova-por' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_additional_options',
			[
				'label' => esc_html__( 'Additional Options', 'ova-por' ),
			]
		);


			$this->add_control(
				'margin_items',
				[
					'label'   => esc_html__( 'Space between 2 items', 'ova-por' ),
					'type'    => Controls_Manager::NUMBER,
					'default' => 30,
				]
				
			);

			$this->add_control(
				'item_number',
				[
					'label'       => esc_html__( 'Number of Items', 'ova-por' ),
					'type'        => Controls_Manager::NUMBER,
					'description' => esc_html__( 'Number of Items ', 'ova-por' ),
					'default'     => 3,
				]
			);

			$this->add_control(
				'slides_to_scroll',
				[
					'label'       => esc_html__( 'Slides to Scroll', 'ova-por' ),
					'type'        => Controls_Manager::NUMBER,
					'description' => esc_html__( 'Set how many slides are scrolled per swipe.', 'ova-por' ),
					'default'     => 1,
				]
			);

			$this->add_control(
				'pause_on_hover',
				[
					'label'   => esc_html__( 'Pause on Hover', 'ova-por' ),
					'type'    => Controls_Manager::SWITCHER,
					'default' => 'yes',
					'options' => [
						'yes' => esc_html__( 'Yes', 'ova-por' ),
						'no'  => esc_html__( 'No', 'ova-por' ),
					],
					'frontend_available' => true,
				]
			);

			$this->add_control(
				'infinite',
				[
					'label'   => esc_html__( 'Infinite Loop', 'ova-por' ),
					'type'    => Controls_Manager::SWITCHER,
					'default' => 'yes',
					'options' => [
						'yes' => esc_html__( 'Yes', 'ova-por' ),
						'no'  => esc_html__( 'No', 'ova-por' ),
					],
					'frontend_available' => true,
				]
			);

			$this->add_control(
				'autoplay',
				[
					'label'   => esc_html__( 'Autoplay', 'ova-por' ),
					'type'    => Controls_Manager::SWITCHER,
					'default' => 'yes',
					'options' => [
						'yes' => esc_html__( 'Yes', 'ova-por' ),
						'no'  => esc_html__( 'No', 'ova-por' ),
					],
					'frontend_available' => true,
				]
			);

			$this->add_control(
				'autoplay_speed',
				[
					'label'     => esc_html__( 'Autoplay Speed', 'ova-por' ),
					'type'      => Controls_Manager::NUMBER,
					'default'   => 3000,
					'step'      => 500,
					'condition' => [
						'autoplay' => 'yes',
					],
					'frontend_available' => true,
				]
			);

			$this->add_control(
				'smartspeed',
				[
					'label'   => esc_html__( 'Smart Speed', 'ova-por' ),
					'type'    => Controls_Manager::NUMBER,
					'default' => 500,
				]
			);

			$this->add_control(
				'dot_control',
				[
					'label'   => esc_html__( 'Show Dots', 'ova-por' ),
					'type'    => Controls_Manager::SWITCHER,
					'default' => 'no',
					'options' => [
						'yes' => esc_html__( 'Yes', 'ova-por' ),
						'no'  => esc_html__( 'No', 'ova-por' ),
					],
					'frontend_available' => true,
				]
			);

		$this->end_controls_section();

		/* General */
		$this->start_controls_section(
				'general_style_section',
				[
					'label' => esc_html__( 'General', 'ova-por' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_control(
				'item_background',
				[
					'label' => esc_html__( 'Background', 'ova-por' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova_por_slider .portfolio .info-wrap' => 'background: {{VALUE}}',
					],
				]
			);

		$this->end_controls_section();

		/* Icon */
		$this->start_controls_section(
				'icon_style_section',
				[
					'label' => esc_html__( 'Icon', 'ova-por' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_responsive_control(
				'icon_box_size',
				[
					'label' => esc_html__( 'Icon Box Size', 'ova-por' ),
					'type' => \Elementor\Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 100,
							'step' => 5,
						],
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .ova_por_slider .portfolio .icon' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'icon_size',
				[
					'label' => esc_html__( 'Icon Size', 'ova-por' ),
					'type' => \Elementor\Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 100,
							'step' => 5,
						],
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .ova_por_slider .portfolio .icon i' => 'font-size: {{SIZE}}{{UNIT}};',
					],
				]
			);

			$this->add_control(
				'icon_color',
				[
					'label' => esc_html__( 'Color', 'ova-por' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova_por_slider .portfolio .icon' => 'border-color: {{VALUE}}',
						'{{WRAPPER}} .ova_por_slider .portfolio .icon i' => 'color: {{VALUE}}',
					],
				]
			);

		$this->end_controls_section();
	}


	protected function render() {

		$settings = $this->get_settings();

		$template = apply_filters( 'el_elementor_ova_por_slide', 'elementor/ova_por_slide.php' );

		ob_start();
		ovapor_get_template( $template, $settings );
		echo ob_get_clean();
		
	}
}
