<?php 

if( !defined( 'ABSPATH' ) ) exit();

if( !class_exists( 'OVAPOR_custom_post_type' ) ) {

	class OVAPOR_custom_post_type{

		public function __construct(){
			add_action( 'init', array( $this, 'OVAPOR_register_post_type_ova_por' ) );
			add_action( 'init', array( $this, 'OVAPOR_register_taxonomy_ova_por' ) );
		}

		
		function OVAPOR_register_post_type_ova_por() {

			$taxonomies = array('cat_por');

			$labels = array(
				'name'                  => _x( 'Portfolio', 'Post Type General Name', 'ova-por' ),
				'singular_name'         => _x( 'Portfolio', 'Post Type Singular Name', 'ova-por' ),
				'menu_name'             => __( 'Portfolio', 'ova-por' ),
				'name_admin_bar'        => __( 'Portfolio', 'ova-por' ),
				'archives'              => __( 'Item Archives', 'ova-por' ),
				'attributes'            => __( 'Item Attributes', 'ova-por' ),
				'parent_item_colon'     => __( 'Parent Item:', 'ova-por' ),
				'all_items'             => __( 'All Portfolio', 'ova-por' ),
				'add_new_item'          => __( 'Add New Portfolio', 'ova-por' ),
				'add_new'               => __( 'Add New', 'ova-por' ),
				'new_item'              => __( 'New Item', 'ova-por' ),
				'edit_item'             => __( 'Edit Portfolio', 'ova-por' ),
				'view_item'             => __( 'View Item', 'ova-por' ),
				'view_items'            => __( 'View Items', 'ova-por' ),
				'search_items'          => __( 'Search Item', 'ova-por' ),
				'not_found'             => __( 'Not found', 'ova-por' ),
				'not_found_in_trash'    => __( 'Not found in Trash', 'ova-por' ),
			);
			$args = array(
				'description'         => __( 'Post Type Description', 'ova-por' ),
				'labels'              => $labels,
				'supports'            => array( 'title','excerpt', 'editor', 'comments', 'thumbnail' ),
				'taxonomies'          => $taxonomies,
				'hierarchical'        => false,
				'public'              => true,
				'show_ui'             => true,
				'show_in_rest'        => true,
				'menu_position'       => 20,
				'menu_icon' 		  => 'dashicons-portfolio',
				'query_var'           => true,
				'has_archive'         => true,
				'exclude_from_search' => true,
				'publicly_queryable'  => true,
				'rewrite'             => array( 'slug' => _x( 'ova_por', 'URL slug', 'ova-por' ) ),
				'capability_type'     => 'post',
			);
			register_post_type( 'ova_por', $args );
		}

		function OVAPOR_register_taxonomy_ova_por(){
			

			$labels = array(
				'name'                       => _x( 'Portfolio categories', 'Post Type General Name', 'ova-por' ),
				'singular_name'              => _x( 'Category', 'Post Type Singular Name', 'ova-por' ),
				'menu_name'                  => __( 'Categories', 'ova-por' ),
				'all_items'                  => __( 'Categories', 'ova-por' ),
				'parent_item'                => __( 'Parent Item', 'ova-por' ),
				'parent_item_colon'          => __( 'Parent Item:', 'ova-por' ),
				'new_item_name'              => __( 'New Item Name', 'ova-por' ),
				'add_new_item'               => __( 'Add New Category', 'ova-por' ),
				'add_new'                    => __( 'Add New Category', 'ova-por' ),
				'edit_item'                  => __( 'Edit Category', 'ova-por' ),
				'view_item'                  => __( 'View Item', 'ova-por' ),
				'separate_items_with_commas' => __( 'Separate items with commas', 'ova-por' ),
				'add_or_remove_items'        => __( 'Add or remove items', 'ova-por' ),
				'choose_from_most_used'      => __( 'Choose from the most used', 'ova-por' ),
				'popular_items'              => __( 'Popular Items', 'ova-por' ),
				'search_items'               => __( 'Search Items', 'ova-por' ),
				'not_found'                  => __( 'Not Found', 'ova-por' ),
				'no_terms'                   => __( 'No items', 'ova-por' ),
				'items_list'                 => __( 'Items list', 'ova-por' ),
				'items_list_navigation'      => __( 'Items list navigation', 'ova-por' ),

			);
			$args = array(
				'labels'            => $labels,
				'hierarchical'      => true,
				'publicly_queryable' => true,
				'public'            => true,
				'show_ui'           => true,
				'show_in_rest'      => true,
				'show_admin_column' => true,
				'show_in_nav_menus' => true,
				'query_var'          => true,
				'show_tagcloud'     => false,
				'rewrite'            => array(
					'slug'       => _x('cat_por','Portfolio Slug', 'ova-por'),
					'with_front' => false,
					'feeds'      => true,
				),
			);
			register_taxonomy( 'cat_por', array( 'ova_por' ), $args );
		}
	}

	new OVAPOR_custom_post_type();
}