<?php if ( !defined( 'ABSPATH' ) ) exit();

$portfolios = ova_por_query( $args );
?>
<div class="ova-por-gallery">
	<div class="grid">
		<?php if ( $portfolios->have_posts() ): $item = 0; ?>
			<?php while ( $portfolios->have_posts() ) : $portfolios->the_post();
				$id 		= get_the_ID();
				$image_id 	= get_post_thumbnail_id( $id );
				$image_alt 	= get_the_title();
				$image_url 	= \Elementor\Utils::get_placeholder_image_src();
				$item += 1;
				if ( $image_id ) {
					$image_url 	= get_the_post_thumbnail_url( $id, 'ova_por_thumbnail' );
				}
				if ( get_the_title( $image_id ) ) {
					$image_alt = get_the_title( $image_id );
				}
				$gallery = get_post_meta( $id, 'ova_por_met_gallery', true );
				$data_gallery = array();
				if ( $gallery ) {
					foreach ($gallery as $id => $url) {

						$mime_type 	= get_post_mime_type( $id );

						$image = array(
							'src' => $url,
							'thumb' => $url,
							'caption' => $image_alt = get_the_title( $id ),
						);

						if ( $mime_type == 'video/mp4' ) {
							$image['thumb'] = $image_url;
						}
						array_push($data_gallery, $image);
					}
				} else {
					$data_gallery = array(
						array(
							'src' => $image_url,
							'thumb' => $image_url,
							'caption' => $image_alt,
						),
					);
				}
				
			?>
				<div class="grid-item <?php echo esc_attr( "item-" . $item ); ?>">
					<div class="gallery-fancybox">
						<img src="<?php echo esc_url( $image_url ); ?>" alt="<?php echo esc_attr( $image_alt ); ?>">

						<div class="gallery-container">
							<div class="gallery-content">
								<?php if ( $show_icon == 'yes' ) : ?>
									<div class="gallery-icon">
										<div class="icon" data-gallery="<?php echo esc_attr( json_encode( $data_gallery ) ); ?>">
		  									<i class="ovaicon-next"></i>
		  								</div>
	  								</div>
  								<?php endif; ?>
  								
	  							<?php if ( $show_title == 'yes' ) : ?>
									<?php if ( $show_link_to == 'yes' ) : ?>
									<a href="<?php the_permalink(); ?>"
										title="<?php the_title(); ?>"
									>
									<?php endif; ?>
			        					<h2 class="gallery-title">
											<?php echo esc_html( get_the_title() ); ?>
										</h2>
									<?php if ( $show_link_to == 'yes' ) : ?>
									</a>
									<?php endif; ?>
								<?php endif; ?>
	  						</div>
						</div>
					</div>
				</div>	
			<?php endwhile; ?>
		<?php endif; ?>
	</div>
</div>
