<?php if ( !defined( 'ABSPATH' ) ) exit();

	$portfolios = ova_por_query( $args );
	$columns 	= $args['columns'];
?>

<div class="portfolio-grid-2 <?php echo esc_attr( $columns ); ?>">

	<?php if ( $portfolios->have_posts() ): ?>

		<ul class="wrapper">
			<?php while ( $portfolios->have_posts() ) : $portfolios->the_post();
				$id 		= get_the_ID();
				$image_src 	= \Elementor\Utils::get_placeholder_image_src();
				$image_alt 	= get_the_title();
				if ( has_post_thumbnail( $id ) ) {
					$image_src 	= get_the_post_thumbnail_url( $id, 'large' );
					$image_id 	= get_post_thumbnail_id( $id );
					if ( get_the_title( $image_id ) ) {
						$image_alt = get_the_title( $image_id );
					}
				}

				$categories = get_the_terms( $id, 'cat_por' );
				$cate_links = array();
				if ( $categories ) {
					foreach ($categories as $cate) {
						array_push( $cate_links, '<a href="'.esc_url( get_term_link( $cate ) ).'" title="'.esc_attr( get_the_title($id) ).'">'.esc_html( $cate->name ).'</a>' );
					}
					}
			?>
				<li class="item">
					<div class="item-wrap">
						<img src="<?php echo esc_url( $image_src ); ?>" alt="<?php echo esc_attr( $image_alt ); ?>" class="img">
						<div class="info">
							<div class="info-wrap">
								<div class="content">
									<?php if ( $cate_links && $show_category == 'yes' ) : ?>
										<p class="categories"><?php echo implode(", ",$cate_links); ?></p>
									<?php endif; ?>

									<?php if ( $show_title == 'yes' ) : ?>
										<?php if ( $show_link_to == 'yes' ) : ?>
										<a href="<?php the_permalink(); ?>"
											title="<?php the_title(); ?>"
										>
										<?php endif; ?>
				        					<h3 class="title">
												<?php echo esc_html( get_the_title() ); ?>
											</h3>
										<?php if ( $show_link_to == 'yes' ) : ?>
										</a>
										<?php endif; ?>
									<?php endif; ?>
								</div>

								<?php if ( $show_icon == 'yes' ) : ?>
		        					<?php if ( $show_link_to == 'yes' ) : ?>
		        					<a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>">	
									<?php endif; ?>
										<div class="icon">
											<i class="ovaicon-next"></i>
										</div>
									<?php if ( $show_link_to == 'yes' ) : ?>
									</a>
									<?php endif; ?>
								<?php endif; ?>
							</div>
						</div>
					</div>
				</li>
			<?php endwhile; ?>
		</ul>

	<?php endif;wp_reset_postdata(); ?>

</div>