<?php if ( !defined( 'ABSPATH' ) ) exit();

get_header( );

	$post_ID = get_the_ID();

	$event_map_address 	 = get_post_meta( $post_ID, 'ovaev_map_address', true );
	$event_map_lat     	 = get_post_meta( $post_ID, 'ovaev_map_lat', true );
	$event_map_lng     	 = get_post_meta( $post_ID, 'ovaev_map_lng', true );
	$event_map_zoom    	 = OVAEV_Settings::event_map_zoom();

	$date_format 	   	 = OVAEV_Settings::archive_event_format_date();
	$time 			   	 = OVAEV_Settings::archive_event_format_time();

	$event_name        	 = get_post_meta( $post_ID, 'ovaev_organizer', true);
	$event_phone       	 = get_post_meta( $post_ID, 'ovaev_phone', true);
	$event_email       	 = get_post_meta( $post_ID, 'ovaev_email', true);
	$event_website     	 = get_post_meta( $post_ID, 'ovaev_website', true);
	$event_gallery     	 = get_post_meta( $post_ID, 'ovaev_gallery_id', true);
	$event_template 	 = get_post_meta( $post_ID, 'event_template', true ) ? get_post_meta( $post_ID, 'event_template', true ) : 'global' ;

	$event_booking_links = get_post_meta( $post_ID, 'ovaev_booking_links', true);

	$sidebar_single 	 = isset( $_GET['show_sidebar_single'] ) ? $_GET['show_sidebar_single'] : OVAEV_Settings::ovaev_show_sidebar_single();

	$active_sidebar = 'main-event';
	if ( 'yes' === $sidebar_single && is_active_sidebar('event-sidebar') ) {
		$active_sidebar = 'sidebar-active';
	}

	$template = OVAEV_Settings::ovaev_get_template_single();

	// show fields
	$show_gg_calendar = OVAEV_Settings::ovaev_single_show_google_calendar();
	$show_ical_export = OVAEV_Settings::ovaev_single_show_ical_export();

	$show_register_button 	= OVAEV_Settings::ovaev_single_show_register_button();
	$show_content 			= OVAEV_Settings::ovaev_single_show_content();
	$show_map 			    = OVAEV_Settings::ovaev_single_show_map();
	$show_organizer			= OVAEV_Settings::ovaev_single_show_organizer();
	$show_phone			    = OVAEV_Settings::ovaev_single_show_phone();
	$show_email		        = OVAEV_Settings::ovaev_single_show_email();
	$show_website	        = OVAEV_Settings::ovaev_single_show_website();
	$show_gallery			= OVAEV_Settings::ovaev_single_show_gallery();
	$show_share 			= OVAEV_Settings::ovaev_single_show_share();
	$show_next_prev 		= OVAEV_Settings::ovaev_single_show_next_prev();
	$show_related			= OVAEV_Settings::ovaev_single_show_related();
	$show_comment			= OVAEV_Settings::ovaev_single_show_comment();

?>

<?php if ( 'default' != $template ): ?>
	<?php if ( 'global' != $event_template ): ?>
		<?php echo Elementor\Plugin::instance()->frontend->get_builder_content_for_display( $event_template ); ?>
	<?php else: ?>
		<?php echo Elementor\Plugin::instance()->frontend->get_builder_content_for_display( $template ); ?>
	<?php endif; ?>
<?php else: ?>
	<?php if ( 'global' != $event_template ): ?>
		<?php echo Elementor\Plugin::instance()->frontend->get_builder_content_for_display( $event_template ); ?>
	<?php else: ?>
		<div class="single_event">
			<div class="container-event">
				<div id="<?php echo $active_sidebar; ?>" class="content-event">	

					<div class="event_intro">

						<?php do_action( 'oavev_single_thumbnail' ); ?>
						<?php do_action( 'ovaev_single_title' ); ?>
						
						<div class="wrap-event-info">
							<div class="wrap-info">
								<?php 
									/**
									 * action oavev_single_time_loc
									 * Hooked oavev_single_time_loc_date
									 * Hooked oavev_single_time_loc_time
									 * Hooked oavev_single_time_loc_location
									 */
									do_action( 'oavev_single_time_loc' );
								?>

								<?php if( $show_gg_calendar == 'yes' || $show_ical_export == 'yes' ){ ?>
									<div class="ovaev-calendar-sync">
										<?php 
											$ovaev_start_date = get_post_meta( $post_ID, 'ovaev_start_date_time', true );
											$ovaev_end_date   = get_post_meta( $post_ID, 'ovaev_end_date_time', true );

											$date_start 	  = $ovaev_start_date  	? date('m/d/y H:i', $ovaev_start_date )   : '';
											$date_end 		  = $ovaev_end_date 		? date('m/d/y H:i', $ovaev_end_date ) : '';
											$address 	  	  = get_post_meta( $post_ID, 'ovaev_venue', true ); 
										?>

										<?php if( $show_gg_calendar == 'yes' ){ ?>
											<a href="http://addtocalendar.com/atc/google?utz=420&amp;uln=en-US&amp;vjs=1.5&amp;e[0][date_start]=<?php echo esc_html($date_start);?>&amp;e[0][date_end]=<?php echo esc_html($date_end);?>&amp;e[0][timezone]=<?php echo get_option('timezone_string'); ?>&amp;e[0][title]=<?php echo get_the_title();?>&amp;e[0][description]=<?php echo get_the_excerpt().'<br><br>'.get_the_permalink();?>&amp;e[0][location]=<?php echo esc_html($address);?>&amp;e[0][organizer]=<?php echo esc_html($event_name);?>&amp;e[0][organizer_email]=<?php echo esc_html($event_email);?>" target="_blank" rel="nofollow">
												<?php esc_html_e( '+ Google Calendar', 'ovaev' );?>
											</a>
										<?php } ?>

										<?php if( $show_ical_export == 'yes' ){ ?>
											<a href="http://addtocalendar.com/atc/ical?utz=420&amp;uln=en-US&amp;vjs=1.5&amp;e[0][date_start]=<?php echo esc_html($date_start);?>&amp;e[0][date_end]=<?php echo esc_html($date_end);?>&amp;e[0][timezone]=<?php echo get_option('timezone_string'); ?>&amp;e[0][title]=<?php echo get_the_title();?>&amp;e[0][description]=<?php echo get_the_excerpt().'<br><br>'.get_the_permalink();?>&amp;e[0][location]=<?php echo esc_html($address);?>&amp;e[0][organizer]=<?php echo esc_html($event_name);?>&amp;e[0][organizer_email]=<?php echo esc_html($event_email);?>" target="_blank" rel="nofollow">
												<?php esc_html_e( '+ Ical Export', 'ovaev' );?>	
											</a>
										<?php } ?>
									</div>
								<?php } ?>
							</div>

							<?php if( $show_register_button == 'yes' ){ ?>
								<div class="wrap-booking-links">
									<?php do_action( 'oavev_single_booking_links' );  ?>
								</div>
							<?php } ?>
						</div>

						<?php if( $show_content == 'yes' ){ ?>
							<div class="ovaev-event-content">
								<?php if( have_posts() ) : while( have_posts() ) : the_post();
									the_content();
						 		endwhile; endif; wp_reset_postdata(); ?>
							</div>
						<?php } ?>

						<?php if( ! empty( $event_map_address ) || ! empty( $event_name ) || ! empty( $event_phone ) || ! empty( $event_email ) || ! empty( $event_website ) || ! empty( $event_gallery ) ) { 
						?>
							<div class="tab-Location">
								<div class="event_nav event_nav-tabs" role="tablist" aria-label="<?php echo esc_attr('Event Tabs','ovaev');?>">
									<?php if( ! empty( $event_map_address ) && $show_map == 'yes' ) { ?>
								    	<button class="event_nav-link" id="ovaev-tab-location" data-href="#location-tab-pane"
								    		role="tab" aria-selected="true" aria-controls="location-tab-pane" tabindex="0"
								    	>
								    		<?php esc_html_e('Location','ovaev')?>
								    	</button>
									<?php } ?>

									<?php if( $show_organizer == 'yes' || $show_email == 'yes' || $show_phone == 'yes' || $show_website == 'yes' ) { ?>
									  	<?php if( ! empty( $event_name ) || ! empty( $event_phone ) || ! empty( $event_email ) || ! empty( $event_website ) ) { ?>
									    	<button class="event_nav-link" id="ovaev-tab-contact" data-href="#contact-tab-pane" role="tab"
									    		aria-selected="false" aria-controls="contact-tab-pane" tabindex="-1"
									    	>
									    		<?php esc_html_e('Contact Details','ovaev')?>
									    	</button>
									 	<?php } ?>
									<?php } ?>

								 	<?php if( $event_gallery != '' && $show_gallery == 'yes' ) :  ?>
								    	<button class="event_nav-link" id="ovaev-tab-gallery" data-href="#gallery-tab-pane" role="tab"
								    		aria-selected="false" aria-controls="gallery-tab-pane" tabindex="-1"
								    	>
								    		<?php esc_html_e('Gallery','ovaev')?>
								    	</button>
								  	<?php endif; ?>
								</div>

								<!-- Tab panes -->
								<div class="tab-content">

									<?php if( ! empty( $event_map_address ) && $show_map == 'yes' ) { ?>
							  			<div role="tabpanel" 
							  				class="event_tab-pane active" 
							  				id="location-tab-pane" 
							  				aria-labelledby="ovaev-tab-location"
							  				tabindex="0"
							  				style="height: 500px;" 
							  				data-address="<?php echo esc_attr($event_map_address);?>" 
							  				data-lat="<?php echo esc_attr($event_map_lat);?>" 
							  				data-lng="<?php echo esc_attr($event_map_lng);?>" 
							  				data-zoom="<?php echo esc_attr($event_map_zoom); ?>"
							  			></div>
								  	<?php } ?>
				
									<?php if( ! empty( $event_name ) || ! empty( $event_phone ) || ! empty( $event_email ) || ! empty( $event_website ) ) { ?>
								  		<div role="tabpanel" class="event_tab-pane" id="contact-tab-pane" aria-labelledby="ovaev-tab-contact" tabindex="0">
								  			<div class="event_row">
												<div class="col_contact">
													<div class="contact">
														<ul class="info-contact">
															<?php if( $event_name != '' && $show_organizer == 'yes' ) : ?>
				 												<li>
																	<span><?php esc_html_e('Organizer Name:','ovaev'); ?></span>
																	<span class="info"><?php echo esc_html($event_name); ?></span>
																</li>
															<?php endif; ?>
															<?php if( $event_phone != '' && $show_phone == 'yes' ) : ?>
																<li>
																	<span><?php esc_html_e('Phone:','ovaev'); ?></span>
																	<a href="tel:<?php echo esc_attr( $event_phone ) ?>" class="info">
																		<?php echo esc_html($event_phone); ?>
																	</a>
																</li>
															<?php endif; ?>
														</ul>
													</div>
												</div>
												<div class="col_contact">
													<div class="contact">
														<ul class="info-contact">
															<?php if( $event_email != '' && $show_email == 'yes' ) : ?>
																<li>
																	<span><?php esc_html_e('Email:','ovaev'); ?></span>
																	<a href="mailto:<?php echo esc_attr( $event_email ) ?>" class="info">
																		<?php echo esc_html($event_email); ?>
																	</a>
																</li>
															<?php endif; ?>
															<?php if( $event_website != '' && $show_website == 'yes' ) : ?>
																<li>
																	<span><?php esc_html_e('Website:','ovaev'); ?></span>
																	<a href="<?php echo esc_url( $event_website ) ?>" class="info">
																		<?php echo esc_html($event_website); ?>
																	</a>
																</li>
															<?php endif; ?>
														</ul>
													</div>
												</div>
								  			</div>
								  		</div>
							  		<?php } ?>

							  		<?php if( $event_gallery != '' && $show_gallery == 'yes' ) : ?>
							 		 	<div role="tabpanel" class="event_tab-pane" id="gallery-tab-pane" aria-labelledby="ovaev-tab-gallery" tabindex="0">
							 		 		<div class="event_row">
							 		 			<?php foreach ( $event_gallery as $items ) {
							 		 				$img_url = wp_get_attachment_image_url( $items, 'large' );
							 		 			?>
							 		 				<div class="event_col-6">
														<div class="gallery-items">
															<a href="<?php echo esc_url($img_url);?>" data-gal="prettyPhoto[gal]"><img src="<?php echo esc_url($img_url);?>" alt="<?php echo get_the_title() ?>" 
															>
															</a> 
														</div>
													</div>
							 		 			<?php } ?>
							 		 		</div>
							 		 	</div>
					 		 		<?php endif; ?>
						 		 	
								</div>
							</div>
						<?php } ?>

						<?php if($show_share == 'yes') { ?>
							<div class="event_tags_share">
								<?php do_action( 'oavev_single_share' ); ?>
							</div>
						<?php } ?>

						<?php if($show_next_prev == 'yes') {
							do_action( 'oavev_single_nav' ); 
						} ?>

						<?php if($show_related == 'yes') {
							do_action( 'oavev_single_related' ); 
						} ?>

				        <?php if($show_comment == 'yes') {
				        	if( comments_open( get_the_ID() ) ) {
					        	comments_template(); 
					        }
				        } ?>

					</div>
				</div>

				<?php 
					if ( 'yes' === $sidebar_single ) {
						ovaev_get_template( 'sidebar-event.php' );
					}
				?>
			</div>
		</div>
	<?php endif; ?>
<?php endif; ?>

<?php get_footer();