<?php 

if( !defined( 'ABSPATH' ) ) exit();


if( !class_exists( 'OVAEX_Admin_Settings' ) ){

	/**
	 * Make Admin Class
	 */
	class OVAEX_Admin_Settings{

		/**
		 * Construct Admin
		 */
		public function __construct(){

			add_action( 'admin_enqueue_scripts', array( $this, 'ovaex_load_media' ) );
			add_action( 'admin_init', array( $this, 'register_options' ) );

		}


		public function ovaex_load_media() {
			wp_enqueue_media();
		}

		public function print_options_section(){
			return true;
		}

		public function register_options(){

			register_setting(
				'ovaex_options_group', // Option group
				'ovaex_options', // Name Option
				array( $this, 'settings_callback' ) // Call Back
			);

			/**
			 * General Settings
			 */

			// Add Section: General Settings
			add_settings_section(
				'ovaex_general_section_id', // ID
				esc_html__('General Setting', 'ovaex'), // Title
				array( $this, 'print_options_section' ),
				'ovaex_general_settings' // Page
			);

			// Add Fields: General Section
			add_settings_field(
				'ovaex_exhibition_post_type_rewrite_slug', // ID
				esc_html__('Rewrite Slug','ovaex'),
				array( $this, 'ovaex_exhibition_post_type_rewrite_slug' ),
				'ovaex_general_settings', // Page
				'ovaex_general_section_id' // Section ID
			);

			add_settings_field(
				'ovaex_format_date_lang', // ID
				esc_html__('Calendar Language','ovaex'),
				array( $this, 'ovaex_format_date_lang' ),
				'ovaex_general_settings', // Page
				'ovaex_general_section_id' // Section ID
			);

			// Add Section: Archive Exhibiton Settings
			add_settings_section(
				'ovaex_archive_exhibition_section_id', // ID
				esc_html__('Archive Exhibiton Settings', 'ovaex'), // Title
				array( $this, 'print_options_section' ),
				'ovaex_archive_exhibition_settings' // Page
			);

			add_settings_field(
				'ovaex_show_past', // ID
				esc_html__('Show Past in Archive','ovaex'),
				array( $this, 'ovaex_show_past' ),
				'ovaex_archive_exhibition_settings', // Page
				'ovaex_archive_exhibition_section_id' // Section ID
			);

			add_settings_field(
				'archive_exhibition_total', // ID
				esc_html__('Total','ovaex'),
				array( $this, 'archive_exhibition_total' ),
				'ovaex_archive_exhibition_settings', // Page
				'ovaex_archive_exhibition_section_id' // Section ID
			);

			add_settings_field(
				'archive_exhibition_orderby', // ID
				esc_html__('Order By','ovaex'),
				array( $this, 'archive_exhibition_orderby' ),
				'ovaex_archive_exhibition_settings', // Page
				'ovaex_archive_exhibition_section_id' // Section ID
			);

			add_settings_field(
				'archive_exhibition_order', // ID
				esc_html__('Order','ovaex'),
				array( $this, 'archive_exhibition_order' ),
				'ovaex_archive_exhibition_settings', // Page
				'ovaex_archive_exhibition_section_id' // Section ID
			);

			add_settings_field(
				'archive_exhibition_type', // ID
				esc_html__('Archive Type','ovaex'),
				array( $this, 'archive_exhibition_type' ),
				'ovaex_archive_exhibition_settings', // Page
				'ovaex_archive_exhibition_section_id' // Section ID
			);

			add_settings_field(
				'archive_exhibition_heading', // ID
				esc_html__('Heading','ovaex'),
				array( $this, 'archive_exhibition_heading' ),
				'ovaex_archive_exhibition_settings', // Page
				'ovaex_archive_exhibition_section_id' // Section ID
			);

			add_settings_field(
				'archive_exhibition_desc', // ID
				esc_html__('Description','ovaex'),
				array( $this, 'archive_exhibition_desc' ),
				'ovaex_archive_exhibition_settings', // Page
				'ovaex_archive_exhibition_section_id' // Section ID
			);

			add_settings_field(
				'ovaex_format_date_frontend', // ID
				esc_html__('Date Format','ovaex'),
				array( $this, 'ovaex_format_date_frontend' ),
				'ovaex_archive_exhibition_settings', // Page
				'ovaex_archive_exhibition_section_id' // Section ID
			);

			add_settings_field(
				'archive_exhibition_header', // ID
				esc_html__('Header','ovaex'),
				array( $this, 'archive_exhibition_header' ),
				'ovaex_archive_exhibition_settings', // Page
				'ovaex_archive_exhibition_section_id' // Section ID
			);

			add_settings_field(
				'archive_exhibition_footer', // ID
				esc_html__('Footer','ovaex'),
				array( $this, 'archive_exhibition_footer' ),
				'ovaex_archive_exhibition_settings', // Page
				'ovaex_archive_exhibition_section_id' // Section ID
			);

			add_settings_field(
				'archive_exhibition_show_title', // ID
				esc_html__('Show Title','ovaex'),
				array( $this, 'archive_exhibition_show_title' ),
				'ovaex_archive_exhibition_settings', // Page
				'ovaex_archive_exhibition_section_id' // Section ID
			);

			add_settings_field(
				'archive_exhibition_show_link_of_title', // ID
				esc_html__('Show Link of Title','ovaex'),
				array( $this, 'archive_exhibition_show_link_of_title' ),
				'ovaex_archive_exhibition_settings', // Page
				'ovaex_archive_exhibition_section_id' // Section ID
			);

			add_settings_field(
				'archive_exhibition_show_image', // ID
				esc_html__('Show Image','ovaex'),
				array( $this, 'archive_exhibition_show_image' ),
				'ovaex_archive_exhibition_settings', // Page
				'ovaex_archive_exhibition_section_id' // Section ID
			);

			add_settings_field(
				'archive_exhibition_show_date', // ID
				esc_html__('Show Date','ovaex'),
				array( $this, 'archive_exhibition_show_date' ),
				'ovaex_archive_exhibition_settings', // Page
				'ovaex_archive_exhibition_section_id' // Section ID
			);

			add_settings_field(
				'archive_exhibition_show_category', // ID
				esc_html__('Show Category','ovaex'),
				array( $this, 'archive_exhibition_show_category' ),
				'ovaex_archive_exhibition_settings', // Page
				'ovaex_archive_exhibition_section_id' // Section ID
			);

			add_settings_field(
				'archive_exhibition_show_view_exhibition', // ID
				esc_html__('Show View Exhibition','ovaex'),
				array( $this, 'archive_exhibition_show_view_exhibition' ),
				'ovaex_archive_exhibition_settings', // Page
				'ovaex_archive_exhibition_section_id' // Section ID
			);


			// Add Section: Single Exhibiton Settings
			add_settings_section(
				'ovaex_single_exhibition_section_id', // ID
				esc_html__('Single Exhibiton Settings', 'ovaex'), // Title
				array( $this, 'print_options_section' ),
				'ovaex_single_exhibition_settings' // Page
			);

			add_settings_field(
				'ovaex_format_date_frontend_single', // ID
				esc_html__('Date Format','ovaex'),
				array( $this, 'ovaex_format_date_frontend_single' ),
				'ovaex_single_exhibition_settings', // Page
				'ovaex_single_exhibition_section_id' // Section ID
			);

			add_settings_field(
				'single_exhibition_header', // ID
				esc_html__('Header','ovaex'),
				array( $this, 'single_exhibition_header' ),
				'ovaex_single_exhibition_settings', // Page
				'ovaex_single_exhibition_section_id' // Section ID
			);

			add_settings_field(
				'single_exhibition_footer', // ID
				esc_html__('Footer','ovaex'),
				array( $this, 'single_exhibition_footer' ),
				'ovaex_single_exhibition_settings', // Page
				'ovaex_single_exhibition_section_id' // Section ID
			);

			add_settings_field(
				'google_key_map', // ID
				esc_html__('Google Key Map','ovaex'),
				array( $this, 'google_key_map' ),
				'ovaex_single_exhibition_settings', // Page
				'ovaex_single_exhibition_section_id' // Section ID
			);

			add_settings_field(
				'exhibition_map_zoom', // ID
				esc_html__('Google Map Zoom','ovaex'),
				array( $this, 'exhibition_map_zoom' ),
				'ovaex_single_exhibition_settings', // Page
				'ovaex_single_exhibition_section_id' // Section ID
			);

			add_settings_field(
				'single_exhibition_show_image', // ID
				esc_html__('Show Image','ovaex'),
				array( $this, 'single_exhibition_show_image' ),
				'ovaex_single_exhibition_settings', // Page
				'ovaex_single_exhibition_section_id' // Section ID
			);

			add_settings_field(
				'single_exhibition_show_content', // ID
				esc_html__('Show Content','ovaex'),
				array( $this, 'single_exhibition_show_content' ),
				'ovaex_single_exhibition_settings', // Page
				'ovaex_single_exhibition_section_id' // Section ID
			);

			add_settings_field(
				'single_exhibition_show_gallery', // ID
				esc_html__('Show Gallery','ovaex'),
				array( $this, 'single_exhibition_show_gallery' ),
				'ovaex_single_exhibition_settings', // Page
				'ovaex_single_exhibition_section_id' // Section ID
			);

			add_settings_field(
				'single_exhibition_show_video', // ID
				esc_html__('Show Video','ovaex'),
				array( $this, 'single_exhibition_show_video' ),
				'ovaex_single_exhibition_settings', // Page
				'ovaex_single_exhibition_section_id' // Section ID
			);

			add_settings_field(
				'single_exhibition_show_map', // ID
				esc_html__('Show Map','ovaex'),
				array( $this, 'single_exhibition_show_map' ),
				'ovaex_single_exhibition_settings', // Page
				'ovaex_single_exhibition_section_id' // Section ID
			);

			add_settings_field(
				'single_exhibition_show_related', // ID
				esc_html__('Show Related','ovaex'),
				array( $this, 'single_exhibition_show_related' ),
				'ovaex_single_exhibition_settings', // Page
				'ovaex_single_exhibition_section_id' // Section ID
			);

			add_settings_field(
				'single_exhibition_show_comment', // ID
				esc_html__('Show Comment','ovaex'),
				array( $this, 'single_exhibition_show_comment' ),
				'ovaex_single_exhibition_settings', // Page
				'ovaex_single_exhibition_section_id' // Section ID
			);

			add_settings_field(
				'single_exhibition_show_member_button', // ID
				esc_html__('Show Member Button','ovaex'),
				array( $this, 'single_exhibition_show_member_button' ),
				'ovaex_single_exhibition_settings', // Page
				'ovaex_single_exhibition_section_id' // Section ID
			);

			add_settings_field(
				'single_exhibition_show_order_button', // ID
				esc_html__('Show Order Ticket Button','ovaex'),
				array( $this, 'single_exhibition_show_order_button' ),
				'ovaex_single_exhibition_settings', // Page
				'ovaex_single_exhibition_section_id' // Section ID
			);

			add_settings_field(
				'single_exhibition_show_date', // ID
				esc_html__('Show Date','ovaex'),
				array( $this, 'single_exhibition_show_date' ),
				'ovaex_single_exhibition_settings', // Page
				'ovaex_single_exhibition_section_id' // Section ID
			);

			add_settings_field(
				'single_exhibition_show_time', // ID
				esc_html__('Show Time','ovaex'),
				array( $this, 'single_exhibition_show_time' ),
				'ovaex_single_exhibition_settings', // Page
				'ovaex_single_exhibition_section_id' // Section ID
			);

			add_settings_field(
				'single_exhibition_show_location', // ID
				esc_html__('Show Location','ovaex'),
				array( $this, 'single_exhibition_show_location' ),
				'ovaex_single_exhibition_settings', // Page
				'ovaex_single_exhibition_section_id' // Section ID
			);

			add_settings_field(
				'single_exhibition_show_curators', // ID
				esc_html__('Show Curators','ovaex'),
				array( $this, 'single_exhibition_show_curators' ),
				'ovaex_single_exhibition_settings', // Page
				'ovaex_single_exhibition_section_id' // Section ID
			);

			add_settings_field(
				'single_exhibition_show_duration', // ID
				esc_html__('Show Duration','ovaex'),
				array( $this, 'single_exhibition_show_duration' ),
				'ovaex_single_exhibition_settings', // Page
				'ovaex_single_exhibition_section_id' // Section ID
			);

			add_settings_field(
				'single_exhibition_show_share', // ID
				esc_html__('Show Share','ovaex'),
				array( $this, 'single_exhibition_show_share' ),
				'ovaex_single_exhibition_settings', // Page
				'ovaex_single_exhibition_section_id' // Section ID
			);

		}

		public function settings_callback( $input ){

			$new_input = array();

			// General
			if( isset( $input['ovaex_exhibition_post_type_rewrite_slug'] ) )
				$new_input['ovaex_exhibition_post_type_rewrite_slug'] = sanitize_text_field( $input['ovaex_exhibition_post_type_rewrite_slug'] ) ? sanitize_text_field( $input['ovaex_exhibition_post_type_rewrite_slug'] ) : 'exhibition';

			if( isset( $input['ovaex_format_date_lang'] ) )
				$new_input['ovaex_format_date_lang'] = sanitize_text_field( $input['ovaex_format_date_lang'] ) ? sanitize_text_field( $input['ovaex_format_date_lang'] ) : 'en';

			// Archive
			if( isset( $input['ovaex_show_past'] ) )
				$new_input['ovaex_show_past'] = sanitize_text_field( $input['ovaex_show_past'] ) ? sanitize_text_field( $input['ovaex_show_past'] ) : 'yes';

			if( isset( $input['archive_exhibition_total'] ) )
				$new_input['archive_exhibition_total'] = sanitize_text_field( $input['archive_exhibition_total'] ) ? sanitize_text_field( $input['archive_exhibition_total'] ) : 6;

			if( isset( $input['archive_exhibition_orderby'] ) )
				$new_input['archive_exhibition_orderby'] = sanitize_text_field( $input['archive_exhibition_orderby'] ) ? sanitize_text_field( $input['archive_exhibition_orderby'] ) : 'title';

			if( isset( $input['archive_exhibition_order'] ) )
				$new_input['archive_exhibition_order'] = sanitize_text_field( $input['archive_exhibition_order'] ) ? sanitize_text_field( $input['archive_exhibition_order'] ) : 'ASC';

			if( isset( $input['archive_exhibition_heading'] ) )
				$new_input['archive_exhibition_heading'] = sanitize_text_field( $input['archive_exhibition_heading'] ) ? sanitize_text_field( $input['archive_exhibition_heading'] ) : '';

			if( isset( $input['archive_exhibition_desc'] ) )
				$new_input['archive_exhibition_desc'] = sanitize_text_field( $input['archive_exhibition_desc'] ) ? sanitize_text_field( $input['archive_exhibition_desc'] ) : '';

			if( isset( $input['archive_exhibition_type'] ) )
				$new_input['archive_exhibition_type'] = sanitize_text_field( $input['archive_exhibition_type'] ) ? sanitize_text_field( $input['archive_exhibition_type'] ) : 'grid';	

			if( isset( $input['ovaex_format_date_frontend'] ) )
				$new_input['ovaex_format_date_frontend'] = sanitize_text_field( $input['ovaex_format_date_frontend'] ) ? sanitize_text_field( $input['ovaex_format_date_frontend'] ) : 'M d, Y';

			if( isset( $input['archive_exhibition_header'] ) )
				$new_input['archive_exhibition_header'] = sanitize_text_field( $input['archive_exhibition_header'] ) ? sanitize_text_field( $input['archive_exhibition_header'] ) : 'default';

			if( isset( $input['archive_exhibition_footer'] ) )
				$new_input['archive_exhibition_footer'] = sanitize_text_field( $input['archive_exhibition_footer'] ) ? sanitize_text_field( $input['archive_exhibition_footer'] ) : 'default';

			if( isset( $input['archive_exhibition_show_title'] ) )
				$new_input['archive_exhibition_show_title'] = sanitize_text_field( $input['archive_exhibition_show_title'] ) ? sanitize_text_field( $input['archive_exhibition_show_title'] ) : 'yes';

			if( isset( $input['archive_exhibition_show_link_of_title'] ) )
				$new_input['archive_exhibition_show_link_of_title'] = sanitize_text_field( $input['archive_exhibition_show_link_of_title'] ) ? sanitize_text_field( $input['archive_exhibition_show_link_of_title'] ) : 'yes';

			if( isset( $input['archive_exhibition_show_image'] ) )
				$new_input['archive_exhibition_show_image'] = sanitize_text_field( $input['archive_exhibition_show_image'] ) ? sanitize_text_field( $input['archive_exhibition_show_image'] ) : 'yes';

			if( isset( $input['archive_exhibition_show_date'] ) )
				$new_input['archive_exhibition_show_date'] = sanitize_text_field( $input['archive_exhibition_show_date'] ) ? sanitize_text_field( $input['archive_exhibition_show_date'] ) : 'yes';

			if( isset( $input['archive_exhibition_show_category'] ) )
				$new_input['archive_exhibition_show_category'] = sanitize_text_field( $input['archive_exhibition_show_category'] ) ? sanitize_text_field( $input['archive_exhibition_show_category'] ) : 'yes';

			if( isset( $input['archive_exhibition_show_view_exhibition'] ) )
				$new_input['archive_exhibition_show_view_exhibition'] = sanitize_text_field( $input['archive_exhibition_show_view_exhibition'] ) ? sanitize_text_field( $input['archive_exhibition_show_view_exhibition'] ) : 'yes';



			// Single
			if( isset( $input['ovaex_format_date_frontend_single'] ) )
				$new_input['ovaex_format_date_frontend_single'] = sanitize_text_field( $input['ovaex_format_date_frontend_single'] ) ? sanitize_text_field( $input['ovaex_format_date_frontend_single'] ) : 'd M Y';

			if( isset( $input['single_exhibition_header'] ) )
				$new_input['single_exhibition_header'] = sanitize_text_field( $input['single_exhibition_header'] ) ? sanitize_text_field( $input['single_exhibition_header'] ) : 'default';

			if( isset( $input['single_exhibition_footer'] ) )
				$new_input['single_exhibition_footer'] = sanitize_text_field( $input['single_exhibition_footer'] ) ? sanitize_text_field( $input['single_exhibition_footer'] ) : 'default';

			if( isset( $input['google_key_map'] ) )
				$new_input['google_key_map'] = sanitize_text_field( $input['google_key_map'] ) ? sanitize_text_field( $input['google_key_map'] ) : '';

			if( isset( $input['exhibition_map_zoom'] ) )
				$new_input['exhibition_map_zoom'] = sanitize_text_field( $input['exhibition_map_zoom'] ) ? sanitize_text_field( $input['exhibition_map_zoom'] ) : '18';

			if( isset( $input['single_exhibition_show_image'] ) )
				$new_input['single_exhibition_show_image'] = sanitize_text_field( $input['single_exhibition_show_image'] ) ? sanitize_text_field( $input['single_exhibition_show_image'] ) : 'yes';

			if( isset( $input['single_exhibition_show_content'] ) )
				$new_input['single_exhibition_show_content'] = sanitize_text_field( $input['single_exhibition_show_content'] ) ? sanitize_text_field( $input['single_exhibition_show_content'] ) : 'yes';

			if( isset( $input['single_exhibition_show_gallery'] ) )
				$new_input['single_exhibition_show_gallery'] = sanitize_text_field( $input['single_exhibition_show_gallery'] ) ? sanitize_text_field( $input['single_exhibition_show_gallery'] ) : 'yes';

			if( isset( $input['single_exhibition_show_video'] ) )
				$new_input['single_exhibition_show_video'] = sanitize_text_field( $input['single_exhibition_show_video'] ) ? sanitize_text_field( $input['single_exhibition_show_video'] ) : 'yes';

			if( isset( $input['single_exhibition_show_map'] ) )
				$new_input['single_exhibition_show_map'] = sanitize_text_field( $input['single_exhibition_show_map'] ) ? sanitize_text_field( $input['single_exhibition_show_map'] ) : 'yes';

			if( isset( $input['single_exhibition_show_related'] ) )
				$new_input['single_exhibition_show_related'] = sanitize_text_field( $input['single_exhibition_show_related'] ) ? sanitize_text_field( $input['single_exhibition_show_related'] ) : 'yes';

			if( isset( $input['single_exhibition_show_comment'] ) )
				$new_input['single_exhibition_show_comment'] = sanitize_text_field( $input['single_exhibition_show_comment'] ) ? sanitize_text_field( $input['single_exhibition_show_comment'] ) : 'yes';

			if( isset( $input['single_exhibition_show_member_button'] ) )
				$new_input['single_exhibition_show_member_button'] = sanitize_text_field( $input['single_exhibition_show_member_button'] ) ? sanitize_text_field( $input['single_exhibition_show_member_button'] ) : 'yes';

			if( isset( $input['single_exhibition_show_order_button'] ) )
				$new_input['single_exhibition_show_order_button'] = sanitize_text_field( $input['single_exhibition_show_order_button'] ) ? sanitize_text_field( $input['single_exhibition_show_order_button'] ) : 'yes';

			if( isset( $input['single_exhibition_show_date'] ) )
				$new_input['single_exhibition_show_date'] = sanitize_text_field( $input['single_exhibition_show_date'] ) ? sanitize_text_field( $input['single_exhibition_show_date'] ) : 'yes';

			if( isset( $input['single_exhibition_show_time'] ) )
				$new_input['single_exhibition_show_time'] = sanitize_text_field( $input['single_exhibition_show_time'] ) ? sanitize_text_field( $input['single_exhibition_show_time'] ) : 'yes';

			if( isset( $input['single_exhibition_show_location'] ) )
				$new_input['single_exhibition_show_location'] = sanitize_text_field( $input['single_exhibition_show_location'] ) ? sanitize_text_field( $input['single_exhibition_show_location'] ) : 'yes';

			if( isset( $input['single_exhibition_show_curators'] ) )
				$new_input['single_exhibition_show_curators'] = sanitize_text_field( $input['single_exhibition_show_curators'] ) ? sanitize_text_field( $input['single_exhibition_show_curators'] ) : 'yes';

			if( isset( $input['single_exhibition_show_duration'] ) )
				$new_input['single_exhibition_show_duration'] = sanitize_text_field( $input['single_exhibition_show_duration'] ) ? sanitize_text_field( $input['single_exhibition_show_duration'] ) : 'yes';

			if( isset( $input['single_exhibition_show_share'] ) )
				$new_input['single_exhibition_show_share'] = sanitize_text_field( $input['single_exhibition_show_share'] ) ? sanitize_text_field( $input['single_exhibition_show_share'] ) : 'yes';


			return $new_input;
		}


		public static function create_admin_setting_page() { ?>
			<div class="wrap">
				<h1><?php esc_html_e( "Exhibiton Settings", "ovaex" ); ?></h1>

				<form method="post" action="options.php">
					<div id="tabs">
						<?php settings_fields( 'ovaex_options_group' ); // Options group ?>

						<!-- Menu Tab -->
						<ul>
							<li><a href="#ovaex_general_settings"><?php esc_html_e( 'General Settings', 'ovaex' ); ?></a></li>
							<li><a href="#ovaex_exhibiton_settings"><?php esc_html_e( 'Exhibiton Settings', 'ovaex' ); ?></a></li>
						</ul>

						<!-- General Tab Content -->  
						<div id="ovaex_general_settings" class="ovaex_admin_settings">
							<?php do_settings_sections( 'ovaex_general_settings' ); // Page ?>
						</div>

						<!-- General Tab Content -->  
						<div id="ovaex_exhibiton_settings" class="ovaex_admin_settings">
							<?php do_settings_sections( 'ovaex_archive_exhibition_settings' ); // Page ?>
							<hr>
							<?php do_settings_sections( 'ovaex_single_exhibition_settings' ); // Page ?>
						</div>
					</div>
					<?php submit_button(); ?>
				</form>
			</div>
		<?php }

		/***** General Settings *****/
		public function ovaex_exhibition_post_type_rewrite_slug(){
			$ovaex_exhibition_post_type_rewrite_slug = esc_attr( OVAEX_Settings::ovaex_exhibition_post_type_rewrite_slug() );
			printf(
				'<input type="text"  id="ovaex_exhibition_post_type_rewrite_slug" name="ovaex_options[ovaex_exhibition_post_type_rewrite_slug]" value="%s" />',
				isset( $ovaex_exhibition_post_type_rewrite_slug ) ? $ovaex_exhibition_post_type_rewrite_slug : 'exhibition'
			);
			echo '<span >'.esc_html__(' Name should only contain lowercase letters and the underscore character, and not be more than 32 characters long and  without any spaces', 'ovaex').'<span>';
		}
		

		public function ovaex_format_date_lang(){
			$ovaex_format_date_lang = OVAEX_Settings::ovaex_format_date_lang() ? OVAEX_Settings::ovaex_format_date_lang() : 'en';
			?>
			<input type="text" name="ovaex_options[ovaex_format_date_lang]" value="<?php echo esc_attr($ovaex_format_date_lang) ?>" />
			<?php
			echo esc_html__('Example: en','ovaex');
			echo '<br/>'.esc_html__('You can check language here','ovaex').' <a href="https://xdsoft.net/jqplugins/datetimepicker/#lang" target="_blank">'.'Here'.'</a>';
		}


		/***** Exhibition Settings *****/
		public function ovaex_show_past() {
			$ovaex_show_past = esc_attr( OVAEX_Settings::ovaex_show_past() );
			$ovaex_show_past = isset( $ovaex_show_past ) ? $ovaex_show_past : 'yes';
			$yes = ( 'yes' == $ovaex_show_past ) ? 'selected' : '';
			$no  = ( 'no' == $ovaex_show_past ) ? 'selected' : '';

			?>
			<select name="ovaex_options[ovaex_show_past]" id="ovaex_show_past">
				<option <?php echo esc_attr($yes) ?> value="yes"><?php echo esc_html__('Yes', 'ovaex') ?></option>
				<option <?php echo esc_attr($no) ?> value="no"><?php echo esc_html__('No', 'ovaex') ?></option>
			</select>
			<?php
		}

		public function archive_exhibition_total() {
			$archive_exhibition_total = OVAEX_Settings::archive_exhibition_total();

				if (! $archive_exhibition_total) {
					$archive_exhibition_total = 6;
				}
			?>

			<input type="number" name="ovaex_options[archive_exhibition_total]" id="archive_exhibition_total"
				value="<?php esc_attr_e( $archive_exhibition_total ); ?>" min="-1" max="20" step="1" 
			/>
			<?php
		}

		public function archive_exhibition_orderby(){
			$archive_exhibition_orderby = OVAEX_Settings::archive_exhibition_orderby();
			$archive_exhibition_orderby = isset( $archive_exhibition_orderby ) ? $archive_exhibition_orderby : 'title';

			$title                  = ( 'title' == $archive_exhibition_orderby) ? 'selected' : '';
			$exhibition_custom_sort = ( 'exhibition_custom_sort' == $archive_exhibition_orderby) ? 'selected' : '';
			$ex_start_date          = ( 'ex_start_date' == $archive_exhibition_orderby) ? 'selected' : '';
			$id                     = ( 'ID' == $archive_exhibition_orderby) ? 'selected' : '';

			?>
			<select name="ovaex_options[archive_exhibition_orderby]" id="archive_exhibition_orderby">
				<option <?php echo esc_attr($title) ?> value="title"><?php echo esc_html__('Title', 'ovaex') ?></option>
				<option <?php echo esc_attr($exhibition_custom_sort) ?> value="exhibition_custom_sort"><?php echo esc_html__('Custom Sort', 'ovaex') ?></option>
				<option <?php echo esc_attr($ex_start_date) ?> value="ex_start_date"><?php echo esc_html__('Start Date', 'ovaex') ?></option>
				<option <?php echo esc_attr($id) ?> value="ID"><?php echo esc_html__('ID', 'ovaex') ?></option>
			</select>
			<?php
		}

		public function archive_exhibition_order(){
			$archive_exhibition_order = OVAEX_Settings::archive_exhibition_order(); 	
			$archive_exhibition_order = isset( $archive_exhibition_order ) ? $archive_exhibition_order : 'ASC';

			$asc_selected  = ('ASC' == $archive_exhibition_order) ? 'selected' : '';
			$desc_selected = ('DESC' == $archive_exhibition_order) ? 'selected' : '';

			?>
			<select name="ovaex_options[archive_exhibition_order]" id="archive_exhibition_order">
				<option <?php echo esc_attr($asc_selected) ?> value="ASC"><?php echo esc_html__('Ascending', 'ovaex') ?></option>
				<option <?php echo esc_attr($desc_selected) ?> value="DESC"><?php echo esc_html__('Descending', 'ovaex') ?></option>
			</select>
			<?php
		}

		public function archive_exhibition_type(){
			$archive_exhibition_type = OVAEX_Settings::archive_exhibition_type();
			$archive_exhibition_type = isset( $archive_exhibition_type ) ? $archive_exhibition_type : 'grid';
			
			$grid = ( 'grid' == $archive_exhibition_type) ? 'selected' : '';
			$list = ( 'list' == $archive_exhibition_type) ? 'selected' : '';

			?>
			<select name="ovaex_options[archive_exhibition_type]" id="archive_exhibition_type">
				<option <?php echo esc_attr($grid) ?> value="grid"><?php echo esc_html__('Grid', 'ovaex') ?></option>
				<option <?php echo esc_attr($list) ?> value="list"><?php echo esc_html__('List', 'ovaex') ?></option>
			</select>
			<?php
		}

		public function archive_exhibition_heading(){
			$archive_exhibition_heading =  esc_attr( OVAEX_Settings::archive_exhibition_heading() );
			printf(
				'<input type="text" id="archive_exhibition_heading"  name="ovaex_options[archive_exhibition_heading]" value="%s" />',
				isset( $archive_exhibition_heading ) ? $archive_exhibition_heading : ''
			);
		}

		public function archive_exhibition_desc(){
			$archive_exhibition_desc = esc_attr( OVAEX_Settings::archive_exhibition_desc() );
			printf(
				'<textarea id="archive_exhibition_desc" rows="4" cols="50" name="ovaex_options[archive_exhibition_desc]" value="%s">'.$archive_exhibition_desc.'</textarea>',
				isset( $archive_exhibition_desc ) ? $archive_exhibition_desc : ''
			);
		}

		public function ovaex_format_date_frontend(){
			$ovaex_format_date_frontend = OVAEX_Settings::ovaex_format_date_frontend() ? OVAEX_Settings::ovaex_format_date_frontend() : 'M d, Y';
			?>
			<input type="text" name="ovaex_options[ovaex_format_date_frontend]" value="<?php echo esc_attr($ovaex_format_date_frontend) ?>" />
			<?php
			echo esc_html__('Example: M j, Y','ovaex');
			echo '<br/>'.esc_html__('You can check language here','ovaex').' <a href="http://php.net/manual/en/function.date.php" target="_blank">'.'Here'.'</a>';
		}

		public function archive_exhibition_header(){
			$archive_exhibition_header = OVAEX_Settings::archive_exhibition_header(); 	
			$archive_exhibition_header = isset( $archive_exhibition_header ) ? $archive_exhibition_header : 'default';

			$list_header = apply_filters('gimont_list_header', '');

			?>
			<select name="ovaex_options[archive_exhibition_header]" id="archive_exhibition_header">
				<?php if( $list_header ){ ?>
					<?php foreach ($list_header as $key => $value) { ?>
						<option <?php if( $key == $archive_exhibition_header ) echo 'selected'; ?> value="<?php echo $key; ?>"><?php echo $value; ?></option>
					<?php } ?>
				<?php } ?>
				
			</select>
			<?php
		}

		public function archive_exhibition_footer(){
			$archive_exhibition_footer = OVAEX_Settings::archive_exhibition_footer(); 	
			$archive_exhibition_footer = isset( $archive_exhibition_footer ) ? $archive_exhibition_footer : 'default';

			$list_footer = apply_filters('gimont_list_footer', '');

			?>
			<select name="ovaex_options[archive_exhibition_footer]" id="archive_exhibition_footer">
				<?php if( $list_footer ){ ?>
					<?php foreach ($list_footer as $key => $value) { ?>
						<option <?php if( $key == $archive_exhibition_footer ) echo 'selected'; ?> value="<?php echo $key; ?>"><?php echo $value; ?></option>
					<?php } ?>
				<?php } ?>
				
			</select>
			<?php
		}

		public function archive_exhibition_show_title(){
			$archive_exhibition_show_title = OVAEX_Settings::archive_exhibition_show_title(); 	
			$archive_exhibition_show_title = isset( $archive_exhibition_show_title ) ? $archive_exhibition_show_title : 'yes';

			$yes_selected  = ('yes' == $archive_exhibition_show_title) ? 'selected' : '';
			$no_selected = ('no' == $archive_exhibition_show_title) ? 'selected' : '';

			?>
			<select name="ovaex_options[archive_exhibition_show_title]" id="archive_exhibition_show_title">
				<option <?php echo esc_attr($yes_selected) ?> value="yes"><?php echo esc_html__('Yes', 'ovaex') ?></option>
				<option <?php echo esc_attr($no_selected) ?> value="no"><?php echo esc_html__('No', 'ovaex') ?></option>
			</select>
			<?php
		}

		public function archive_exhibition_show_link_of_title(){
			$archive_exhibition_show_link_of_title = OVAEX_Settings::archive_exhibition_show_link_of_title(); 	
			$archive_exhibition_show_link_of_title = isset( $archive_exhibition_show_link_of_title ) ? $archive_exhibition_show_link_of_title : 'yes';

			$yes_selected  = ('yes' == $archive_exhibition_show_link_of_title) ? 'selected' : '';
			$no_selected = ('no' == $archive_exhibition_show_link_of_title) ? 'selected' : '';

			?>
			<select name="ovaex_options[archive_exhibition_show_link_of_title]" id="archive_exhibition_show_link_of_title">
				<option <?php echo esc_attr($yes_selected) ?> value="yes"><?php echo esc_html__('Yes', 'ovaex') ?></option>
				<option <?php echo esc_attr($no_selected) ?> value="no"><?php echo esc_html__('No', 'ovaex') ?></option>
			</select>
			<?php
		}

		public function archive_exhibition_show_image(){
			$archive_exhibition_show_image = OVAEX_Settings::archive_exhibition_show_image(); 	
			$archive_exhibition_show_image = isset( $archive_exhibition_show_image ) ? $archive_exhibition_show_image : 'yes';

			$yes_selected  = ('yes' == $archive_exhibition_show_image) ? 'selected' : '';
			$no_selected = ('no' == $archive_exhibition_show_image) ? 'selected' : '';

			?>
			<select name="ovaex_options[archive_exhibition_show_image]" id="archive_exhibition_show_image">
				<option <?php echo esc_attr($yes_selected) ?> value="yes"><?php echo esc_html__('Yes', 'ovaex') ?></option>
				<option <?php echo esc_attr($no_selected) ?> value="no"><?php echo esc_html__('No', 'ovaex') ?></option>
			</select>
			<?php
		}

		public function archive_exhibition_show_date(){
			$archive_exhibition_show_date = OVAEX_Settings::archive_exhibition_show_date(); 	
			$archive_exhibition_show_date = isset( $archive_exhibition_show_date ) ? $archive_exhibition_show_date : 'yes';

			$yes_selected  = ('yes' == $archive_exhibition_show_date) ? 'selected' : '';
			$no_selected = ('no' == $archive_exhibition_show_date) ? 'selected' : '';

			?>
			<select name="ovaex_options[archive_exhibition_show_date]" id="archive_exhibition_show_date">
				<option <?php echo esc_attr($yes_selected) ?> value="yes"><?php echo esc_html__('Yes', 'ovaex') ?></option>
				<option <?php echo esc_attr($no_selected) ?> value="no"><?php echo esc_html__('No', 'ovaex') ?></option>
			</select>
			<?php
		}

		public function archive_exhibition_show_category(){
			$archive_exhibition_show_category = OVAEX_Settings::archive_exhibition_show_category(); 	
			$archive_exhibition_show_category = isset( $archive_exhibition_show_category ) ? $archive_exhibition_show_category : 'yes';

			$yes_selected  = ('yes' == $archive_exhibition_show_category) ? 'selected' : '';
			$no_selected = ('no' == $archive_exhibition_show_category) ? 'selected' : '';

			?>
			<select name="ovaex_options[archive_exhibition_show_category]" id="archive_exhibition_show_category">
				<option <?php echo esc_attr($yes_selected) ?> value="yes"><?php echo esc_html__('Yes', 'ovaex') ?></option>
				<option <?php echo esc_attr($no_selected) ?> value="no"><?php echo esc_html__('No', 'ovaex') ?></option>
			</select>
			<?php
		}

		public function archive_exhibition_show_view_exhibition(){
			$archive_exhibition_show_view_exhibition = OVAEX_Settings::archive_exhibition_show_view_exhibition(); 	
			$archive_exhibition_show_view_exhibition = isset( $archive_exhibition_show_view_exhibition ) ? $archive_exhibition_show_view_exhibition : 'yes';

			$yes_selected  = ('yes' == $archive_exhibition_show_view_exhibition) ? 'selected' : '';
			$no_selected = ('no' == $archive_exhibition_show_view_exhibition) ? 'selected' : '';

			?>
			<select name="ovaex_options[archive_exhibition_show_view_exhibition]" id="archive_exhibition_show_view_exhibition">
				<option <?php echo esc_attr($yes_selected) ?> value="yes"><?php echo esc_html__('Yes', 'ovaex') ?></option>
				<option <?php echo esc_attr($no_selected) ?> value="no"><?php echo esc_html__('No', 'ovaex') ?></option>
			</select>
			<?php
		}


		// Single
		public function ovaex_format_date_frontend_single(){
			$ovaex_format_date_frontend_single = OVAEX_Settings::ovaex_format_date_frontend_single() ? OVAEX_Settings::ovaex_format_date_frontend_single() : 'd M Y';
			?>
			<input type="text" name="ovaex_options[ovaex_format_date_frontend_single]" value="<?php echo esc_attr($ovaex_format_date_frontend_single) ?>" />
			<?php
			echo esc_html__('Example: j M Y','ovaex');
			echo '<br/>'.esc_html__('You can check language here','ovaex').' <a href="http://php.net/manual/en/function.date.php" target="_blank">'.'Here'.'</a>';
		}

		public function single_exhibition_header(){
			$single_exhibition_header = OVAEX_Settings::single_exhibition_header(); 	
			$single_exhibition_header = isset( $single_exhibition_header ) ? $single_exhibition_header : 'default';

			$list_header = apply_filters('gimont_list_header', '');

			?>
			<select name="ovaex_options[single_exhibition_header]" id="single_exhibition_header">
				<?php if( $list_header ){ ?>
					<?php foreach ($list_header as $key => $value) { ?>
						<option <?php if( $key == $single_exhibition_header ) echo 'selected'; ?> value="<?php echo $key; ?>"><?php echo $value; ?></option>
					<?php } ?>
				<?php } ?>
				
			</select>
			<?php
		}

		public function single_exhibition_footer(){
			$single_exhibition_footer = OVAEX_Settings::single_exhibition_footer(); 	
			$single_exhibition_footer = isset( $single_exhibition_footer ) ? $single_exhibition_footer : 'default';

			$list_footer = apply_filters('gimont_list_footer', '');

			?>
			<select name="ovaex_options[single_exhibition_footer]" id="single_exhibition_footer">
				<?php if( $list_footer ){ ?>
					<?php foreach ($list_footer as $key => $value) { ?>
						<option <?php if( $key == $single_exhibition_footer ) echo 'selected'; ?> value="<?php echo $key; ?>"><?php echo $value; ?></option>
					<?php } ?>
				<?php } ?>
				
			</select>
			<?php
		}

		public function google_key_map(){
			$google_key_map =  esc_attr( OVAEX_Settings::google_key_map() );
			printf(
				'<input type="text" id="google_key_map"  name="ovaex_options[google_key_map]" value="%s" />',
				isset( $google_key_map ) ? $google_key_map : ''
			);

			echo '<br/>'; 
			esc_html_e('You can get here: https://developers.google.com/maps/documentation/javascript/get-api-key', 'ovaex');
		}

		public function exhibition_map_zoom(){
			$exhibition_map_zoom = OVAEX_Settings::exhibition_map_zoom();
			$exhibition_map_zoom = isset( $exhibition_map_zoom ) ? $exhibition_map_zoom : '18';

			printf(
				'<input type="number" id="exhibition_map_zoom" name="ovaex_options[exhibition_map_zoom]" value="%s" />',
				isset( $exhibition_map_zoom ) ? $exhibition_map_zoom : '18'
			);
		}

		public function single_exhibition_show_image(){
			$single_exhibition_show_image = OVAEX_Settings::single_exhibition_show_image(); 	
			$single_exhibition_show_image = isset( $single_exhibition_show_image ) ? $single_exhibition_show_image : 'yes';

			$yes_selected  = ('yes' == $single_exhibition_show_image) ? 'selected' : '';
			$no_selected = ('no' == $single_exhibition_show_image) ? 'selected' : '';

			?>
			<select name="ovaex_options[single_exhibition_show_image]" id="single_exhibition_show_image">
				<option <?php echo esc_attr($yes_selected) ?> value="yes"><?php echo esc_html__('Yes', 'ovaex') ?></option>
				<option <?php echo esc_attr($no_selected) ?> value="no"><?php echo esc_html__('No', 'ovaex') ?></option>
			</select>
			<?php
		}

		public function single_exhibition_show_content(){
			$single_exhibition_show_content = OVAEX_Settings::single_exhibition_show_content(); 	
			$single_exhibition_show_content = isset( $single_exhibition_show_content ) ? $single_exhibition_show_content : 'yes';

			$yes_selected  = ('yes' == $single_exhibition_show_content) ? 'selected' : '';
			$no_selected = ('no' == $single_exhibition_show_content) ? 'selected' : '';

			?>
			<select name="ovaex_options[single_exhibition_show_content]" id="single_exhibition_show_content">
				<option <?php echo esc_attr($yes_selected) ?> value="yes"><?php echo esc_html__('Yes', 'ovaex') ?></option>
				<option <?php echo esc_attr($no_selected) ?> value="no"><?php echo esc_html__('No', 'ovaex') ?></option>
			</select>
			<?php
		}

		public function single_exhibition_show_gallery(){
			$single_exhibition_show_gallery = OVAEX_Settings::single_exhibition_show_gallery(); 	
			$single_exhibition_show_gallery = isset( $single_exhibition_show_gallery ) ? $single_exhibition_show_gallery : 'yes';

			$yes_selected  = ('yes' == $single_exhibition_show_gallery) ? 'selected' : '';
			$no_selected = ('no' == $single_exhibition_show_gallery) ? 'selected' : '';

			?>
			<select name="ovaex_options[single_exhibition_show_gallery]" id="single_exhibition_show_gallery">
				<option <?php echo esc_attr($yes_selected) ?> value="yes"><?php echo esc_html__('Yes', 'ovaex') ?></option>
				<option <?php echo esc_attr($no_selected) ?> value="no"><?php echo esc_html__('No', 'ovaex') ?></option>
			</select>
			<?php
		}

		public function single_exhibition_show_video(){
			$single_exhibition_show_video = OVAEX_Settings::single_exhibition_show_video(); 	
			$single_exhibition_show_video = isset( $single_exhibition_show_video ) ? $single_exhibition_show_video : 'yes';

			$yes_selected  = ('yes' == $single_exhibition_show_video) ? 'selected' : '';
			$no_selected = ('no' == $single_exhibition_show_video) ? 'selected' : '';

			?>
			<select name="ovaex_options[single_exhibition_show_video]" id="single_exhibition_show_video">
				<option <?php echo esc_attr($yes_selected) ?> value="yes"><?php echo esc_html__('Yes', 'ovaex') ?></option>
				<option <?php echo esc_attr($no_selected) ?> value="no"><?php echo esc_html__('No', 'ovaex') ?></option>
			</select>
			<?php
		}

		public function single_exhibition_show_map(){
			$single_exhibition_show_map = OVAEX_Settings::single_exhibition_show_map(); 	
			$single_exhibition_show_map = isset( $single_exhibition_show_map ) ? $single_exhibition_show_map : 'yes';

			$yes_selected  = ('yes' == $single_exhibition_show_map) ? 'selected' : '';
			$no_selected = ('no' == $single_exhibition_show_map) ? 'selected' : '';

			?>
			<select name="ovaex_options[single_exhibition_show_map]" id="single_exhibition_show_map">
				<option <?php echo esc_attr($yes_selected) ?> value="yes"><?php echo esc_html__('Yes', 'ovaex') ?></option>
				<option <?php echo esc_attr($no_selected) ?> value="no"><?php echo esc_html__('No', 'ovaex') ?></option>
			</select>
			<?php
		}

		public function single_exhibition_show_related(){
			$single_exhibition_show_related = OVAEX_Settings::single_exhibition_show_related(); 	
			$single_exhibition_show_related = isset( $single_exhibition_show_related ) ? $single_exhibition_show_related : 'yes';

			$yes_selected  = ('yes' == $single_exhibition_show_related) ? 'selected' : '';
			$no_selected = ('no' == $single_exhibition_show_related) ? 'selected' : '';

			?>
			<select name="ovaex_options[single_exhibition_show_related]" id="single_exhibition_show_related">
				<option <?php echo esc_attr($yes_selected) ?> value="yes"><?php echo esc_html__('Yes', 'ovaex') ?></option>
				<option <?php echo esc_attr($no_selected) ?> value="no"><?php echo esc_html__('No', 'ovaex') ?></option>
			</select>
			<?php
		}

		public function single_exhibition_show_comment(){
			$single_exhibition_show_comment = OVAEX_Settings::single_exhibition_show_comment(); 	
			$single_exhibition_show_comment = isset( $single_exhibition_show_comment ) ? $single_exhibition_show_comment : 'yes';

			$yes_selected  = ('yes' == $single_exhibition_show_comment) ? 'selected' : '';
			$no_selected = ('no' == $single_exhibition_show_comment) ? 'selected' : '';

			?>
			<select name="ovaex_options[single_exhibition_show_comment]" id="single_exhibition_show_comment">
				<option <?php echo esc_attr($yes_selected) ?> value="yes"><?php echo esc_html__('Yes', 'ovaex') ?></option>
				<option <?php echo esc_attr($no_selected) ?> value="no"><?php echo esc_html__('No', 'ovaex') ?></option>
			</select>
			<?php
		}

		public function single_exhibition_show_member_button(){
			$single_exhibition_show_member_button = OVAEX_Settings::single_exhibition_show_member_button(); 	
			$single_exhibition_show_member_button = isset( $single_exhibition_show_member_button ) ? $single_exhibition_show_member_button : 'yes';

			$yes_selected  = ('yes' == $single_exhibition_show_member_button) ? 'selected' : '';
			$no_selected = ('no' == $single_exhibition_show_member_button) ? 'selected' : '';

			?>
			<select name="ovaex_options[single_exhibition_show_member_button]" id="single_exhibition_show_member_button">
				<option <?php echo esc_attr($yes_selected) ?> value="yes"><?php echo esc_html__('Yes', 'ovaex') ?></option>
				<option <?php echo esc_attr($no_selected) ?> value="no"><?php echo esc_html__('No', 'ovaex') ?></option>
			</select>
			<?php
		}

		public function single_exhibition_show_order_button(){
			$single_exhibition_show_order_button = OVAEX_Settings::single_exhibition_show_order_button(); 	
			$single_exhibition_show_order_button = isset( $single_exhibition_show_order_button ) ? $single_exhibition_show_order_button : 'yes';

			$yes_selected  = ('yes' == $single_exhibition_show_order_button) ? 'selected' : '';
			$no_selected = ('no' == $single_exhibition_show_order_button) ? 'selected' : '';

			?>
			<select name="ovaex_options[single_exhibition_show_order_button]" id="single_exhibition_show_order_button">
				<option <?php echo esc_attr($yes_selected) ?> value="yes"><?php echo esc_html__('Yes', 'ovaex') ?></option>
				<option <?php echo esc_attr($no_selected) ?> value="no"><?php echo esc_html__('No', 'ovaex') ?></option>
			</select>
			<?php
		}

		public function single_exhibition_show_date(){
			$single_exhibition_show_date = OVAEX_Settings::single_exhibition_show_date(); 	
			$single_exhibition_show_date = isset( $single_exhibition_show_date ) ? $single_exhibition_show_date : 'yes';

			$yes_selected  = ('yes' == $single_exhibition_show_date) ? 'selected' : '';
			$no_selected = ('no' == $single_exhibition_show_date) ? 'selected' : '';

			?>
			<select name="ovaex_options[single_exhibition_show_date]" id="single_exhibition_show_date">
				<option <?php echo esc_attr($yes_selected) ?> value="yes"><?php echo esc_html__('Yes', 'ovaex') ?></option>
				<option <?php echo esc_attr($no_selected) ?> value="no"><?php echo esc_html__('No', 'ovaex') ?></option>
			</select>
			<?php
		}

		public function single_exhibition_show_time(){
			$single_exhibition_show_time = OVAEX_Settings::single_exhibition_show_time(); 	
			$single_exhibition_show_time = isset( $single_exhibition_show_time ) ? $single_exhibition_show_time : 'yes';

			$yes_selected  = ('yes' == $single_exhibition_show_time) ? 'selected' : '';
			$no_selected = ('no' == $single_exhibition_show_time) ? 'selected' : '';

			?>
			<select name="ovaex_options[single_exhibition_show_time]" id="single_exhibition_show_time">
				<option <?php echo esc_attr($yes_selected) ?> value="yes"><?php echo esc_html__('Yes', 'ovaex') ?></option>
				<option <?php echo esc_attr($no_selected) ?> value="no"><?php echo esc_html__('No', 'ovaex') ?></option>
			</select>
			<?php
		}

		public function single_exhibition_show_location(){
			$single_exhibition_show_location = OVAEX_Settings::single_exhibition_show_location(); 	
			$single_exhibition_show_location = isset( $single_exhibition_show_location ) ? $single_exhibition_show_location : 'yes';

			$yes_selected  = ('yes' == $single_exhibition_show_location) ? 'selected' : '';
			$no_selected = ('no' == $single_exhibition_show_location) ? 'selected' : '';

			?>
			<select name="ovaex_options[single_exhibition_show_location]" id="single_exhibition_show_location">
				<option <?php echo esc_attr($yes_selected) ?> value="yes"><?php echo esc_html__('Yes', 'ovaex') ?></option>
				<option <?php echo esc_attr($no_selected) ?> value="no"><?php echo esc_html__('No', 'ovaex') ?></option>
			</select>
			<?php
		}

		public function single_exhibition_show_curators(){
			$single_exhibition_show_curators = OVAEX_Settings::single_exhibition_show_curators(); 	
			$single_exhibition_show_curators = isset( $single_exhibition_show_curators ) ? $single_exhibition_show_curators : 'yes';

			$yes_selected  = ('yes' == $single_exhibition_show_curators) ? 'selected' : '';
			$no_selected = ('no' == $single_exhibition_show_curators) ? 'selected' : '';

			?>
			<select name="ovaex_options[single_exhibition_show_curators]" id="single_exhibition_show_curators">
				<option <?php echo esc_attr($yes_selected) ?> value="yes"><?php echo esc_html__('Yes', 'ovaex') ?></option>
				<option <?php echo esc_attr($no_selected) ?> value="no"><?php echo esc_html__('No', 'ovaex') ?></option>
			</select>
			<?php
		}

		public function single_exhibition_show_duration(){
			$single_exhibition_show_duration = OVAEX_Settings::single_exhibition_show_duration(); 	
			$single_exhibition_show_duration = isset( $single_exhibition_show_duration ) ? $single_exhibition_show_duration : 'yes';

			$yes_selected  = ('yes' == $single_exhibition_show_duration) ? 'selected' : '';
			$no_selected = ('no' == $single_exhibition_show_duration) ? 'selected' : '';

			?>
			<select name="ovaex_options[single_exhibition_show_duration]" id="single_exhibition_show_duration">
				<option <?php echo esc_attr($yes_selected) ?> value="yes"><?php echo esc_html__('Yes', 'ovaex') ?></option>
				<option <?php echo esc_attr($no_selected) ?> value="no"><?php echo esc_html__('No', 'ovaex') ?></option>
			</select>
			<?php
		}

		public function single_exhibition_show_share(){
			$single_exhibition_show_share = OVAEX_Settings::single_exhibition_show_share(); 	
			$single_exhibition_show_share = isset( $single_exhibition_show_share ) ? $single_exhibition_show_share : 'yes';

			$yes_selected  = ('yes' == $single_exhibition_show_share) ? 'selected' : '';
			$no_selected = ('no' == $single_exhibition_show_share) ? 'selected' : '';

			?>
			<select name="ovaex_options[single_exhibition_show_share]" id="single_exhibition_show_share">
				<option <?php echo esc_attr($yes_selected) ?> value="yes"><?php echo esc_html__('Yes', 'ovaex') ?></option>
				<option <?php echo esc_attr($no_selected) ?> value="no"><?php echo esc_html__('No', 'ovaex') ?></option>
			</select>
			<?php
		}


	}
	new OVAEX_Admin_Settings();
}