<?php

if ( !defined( 'ABSPATH' ) ) {
	exit;
}

class OVAEX_get_data {
	public function __construct() {
		add_filter( 'upload_mimes', array( $this, 'upload_mimes' ), 1, 1);

		add_filter( 'OVAEX_exhibition', array( $this, 'OVAEX_exhibition' ), 10, 1 );

		add_filter( 'OVAEX_related_ex', array( $this, 'OVAEX_related_ex' ), 10, 1 );

		add_action('wp_ajax_ovaex_loadmore', array( $this, 'ovaex_loadmore' ), 10 , 0 );
		add_action('wp_ajax_nopriv_ovaex_loadmore', array( $this, 'ovaex_loadmore' ), 10, 0 );
	}

	function upload_mimes($mimes){
		$mimes['zip'] = 'application/zip';
		$mimes['svg'] = 'image/svg+xml';
		return $mimes;
	}

	private function OVAEX_query_base( $paged = '', $show_past = 'yes', $posts_per_page = -1, $order = 'ASC',$orderby = 'title' ){

		$args_base = $args_paged = $args_cat = $args_past = $args_orderby = array();

		$args_base = array(
			'posts_per_page' => $posts_per_page,
			'post_type' => 'exhibition',
			'post_status' => 'publish',
			'order'	=> $order
		);

		$args_paged = ( $paged != '' ) ? array( 'paged' => $paged ) : array();

		if( $show_past == 'no' ){
			$args_past = array(
				'meta_query' => array(
					array(
						'key' => 'ex_end_date',
						'value' => current_time( 'timestamp' ),
						'compare' => '>'
					)
				)
			);
		}

		if ( is_tax( 'cat_exhibition' ) || get_query_var( 'cat_exhibition' ) != '' ){
			$args_cat = array( 
				'tax_query' => array(
					array(
						'taxonomy' => 'cat_exhibition',
						'field'    => 'slug',
						'terms'    => get_query_var( 'cat_exhibition' ),
					)
				)
			);
		}
		
		switch ($orderby) {
			case 'title':
			$args_orderby =  array( 'orderby' => 'title' );
			break;

			case 'exhibition_custom_sort':
			$args_orderby =  array( 'orderby' => 'meta_value_num', 'meta_key' => $orderby );
			break;

			case 'ex_start_date':
			$args_orderby =  array( 'orderby' => 'meta_value_num', 'meta_key' => $orderby );
			break;
			
			case 'ID':
			$args_orderby =  array( 'orderby' => 'ID');
			break;
			
			default:
			break;
		}

		return array_merge_recursive( $args_base, $args_paged, $args_cat, $args_orderby, $args_past );
	}


	public function OVAEX_exhibition(){
		$posts_per_page = OVAEX_Settings::archive_exhibition_total();

		$paged     = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
		$show_past = OVAEX_Settings::ovaex_show_past();
		$order     = OVAEX_Settings::archive_exhibition_order();
		$orderby   = OVAEX_Settings::archive_exhibition_orderby();

		// Query base
		$args_basic = $this->OVAEX_query_base( $paged, $show_past, $posts_per_page, $order, $orderby );

		$exhibition = new WP_Query( $args_basic );
		
		return $exhibition;
	}


	public function OVAEX_related_ex( $params ) {
		// Query base
		$args_basic = array(
			'post_type' 		=> 'exhibition',
			'post_status' 		=> 'publish',
			'post__not_in' 		=> $params,
			'posts_per_page' 	=> 3,
			'order' 			=> OVAEX_Settings::archive_exhibition_order()
		);

		// Order by
		$orderby = OVAEX_Settings::archive_exhibition_orderby();

		switch ( $orderby ) {
			case 'title':
				$args_basic['orderby'] = $orderby;
				break;
			case 'exhibition_custom_sort':
				$args_basic['orderby'] 	= 'meta_value_num';
				$args_basic['meta_key'] = $orderby;
				break;
			case 'ex_start_date':
				$args_basic['orderby'] 	= 'meta_value_num';
				$args_basic['meta_key'] = $orderby;
				break;
			case 'ID':
				$args_basic['orderby'] = $orderby;
				break;
		}

		$related_ex = new WP_Query( apply_filters( 'OVAEX_query_related_ex', $args_basic, $params ) );
		
		return $related_ex;
	}


	public function ovaex_loadmore(){
		$type_action     	= $_POST['type_action'];
		$paged           	= $_POST['pageid'];
		$ovaex_perpage   	= $_POST['ovaex_perpage'];
		$ovaex_order_by  	= $_POST['ovaex_order_by'];
		$ovaex_order      	= $_POST['ovaex_order'];
		$ovaex_data_post 	= $_POST['ovaex_data_post'];
		$upcoming_day    	= $_POST['upcoming_day'];
		$args_show          = $_POST['args_show'];
		$categories    		= isset( $_POST['ovaex_categories'] ) ? $_POST['ovaex_categories'] : array();
		$artist 			= isset( $_POST['ovaex_artist'] ) ? $_POST['ovaex_artist'] : '';

		switch( $ovaex_order_by ) {
			case 'title' : {
				$args_order = [
					'orderby' 	=> 'title',
					'order' 	=> $ovaex_order,
				];
				break;
			}
			case 'ID' : {
				$args_order = [
					'orderby' 	=> 'ID',
					'order' 	=> $ovaex_order,
				];
				break;
			}
			case 'exhibition_custom_sort' : {
				$args_order = [
					'orderby' 	=> 'meta_value_num',
					'meta_key' 	=> 'exhibition_custom_sort',
					'order' 	=> $ovaex_order,
				];
				break;
			}
			case 'ex_start_date' : {
				$args_order = [
					'orderby' 	=> 'meta_value_num',
					'meta_key' 	=> 'ex_start_date',
					'order' 	=> $ovaex_order,
				];
				break;
			}
			default: {
				$args_order = [
					'orderby' 	=> 'ID',
					'order' 	=> $ovaex_order,
				];
				break;
			}
		}

		if ( $type_action == 'current' ) {
			$ovaex_args = array(
				'post_type'      => $ovaex_data_post,
				'post_status'    => 'publish',
				'paged'          => $paged,
				'posts_per_page' => $ovaex_perpage,
				'meta_query'     => array(
					array(
						'relation' => 'OR',
						array(
							'key' 		=> 'ex_start_date',
							'value' 	=> array( current_time('timestamp' )-1, current_time('timestamp' )+(24*60*60)+1 ),
							'type' 		=> 'numeric',
							'compare' 	=> 'BETWEEN'	
						),
						array(
							'relation' => 'AND',
							array(
								'key' 		=> 'ex_start_date',
								'value' 	=> current_time('timestamp' ),
								'compare' 	=> '<',
								'type'		=> 'NUMERIC'
							),
							array(
								'key' 		=> 'ex_end_date',
								'value' 	=> current_time('timestamp' ),
								'compare' 	=> '>=',
								'type'		=> 'NUMERIC'
							)
						)
					)
				)
			);
		} elseif ( $type_action == 'upcoming' ) {
			$ovaex_args = array(
				'post_type'      => $ovaex_data_post,
				'post_status'    => 'publish',
				'paged'          => $paged,
				'posts_per_page' => $ovaex_perpage,
				'meta_query'     => array(
					array(
						'relation' => 'AND',
						array(
							'key' 		=> 'ex_start_date',
							'value' 	=> current_time( 'timestamp' ),
							'compare' 	=> '>',
							'type'		=> 'NUMERIC'
						),
						array(
							'key' 		=> 'ex_end_date',
							'value' 	=> current_time( 'timestamp') + ( $upcoming_day * 24 * 60 * 60 ),
							'compare' 	=> '<=',
							'type'		=> 'NUMERIC'
						)	
					)
				)
			);		
		} elseif ( $type_action == 'past' ) {
			$ovaex_args = array(
				'post_type'      => $ovaex_data_post,
				'post_status'    => 'publish',
				'paged'          => $paged,
				'posts_per_page' => $ovaex_perpage,
				
				'meta_query'   => array(
					array(
						'key'     	=> 'ex_end_date',
						'value'   	=> current_time( 'timestamp' ),
						'compare' 	=> '<',
						'type'		=> 'NUMERIC'
					),
				),
			);
		}

		$args_cat = $args_artist = array();

		if ( !empty( $categories ) && is_array( $categories ) ) {
			$args_cat = array(
				'tax_query' => array(
					array(
						'taxonomy' => 'cat_exhibition',
						'field'    => 'slug',
						'terms'    => $categories,
					)
				)
			);
		}

		if ( !empty( $artist ) ) {
			$args_artist = array(
				'meta_query' => array(
					array(
						'key'     => 'exhibition_artist',
						'value'   => $artist,
						'compare' => 'LIKE'
					)
				)
			);
		}

		$ovaex_args 		= array_merge_recursive( $ovaex_args, $args_order, $args_cat, $args_artist );
		$ovaex_more_post 	= new WP_Query( $ovaex_args );

		if ( $ovaex_more_post -> have_posts() ) : while ($ovaex_more_post -> have_posts()) : $ovaex_more_post -> the_post();
			ovaex_get_template( 'parts/item-exhibition.php', $args_show );
		endwhile; endif;  wp_reset_postdata(); wp_reset_query();
		die();
	}
}

new OVAEX_get_data();