<?php if ( !defined( 'ABSPATH' ) ) exit();

	$id = get_the_ID();

	$exhibition_type = ( OVAEX_Settings::archive_exhibition_type() ) ? OVAEX_Settings::archive_exhibition_type() : 'grid';
	$exhibition_type =  isset( $_GET['exihibition_type'] ) ? $_GET['exihibition_type'] : $exhibition_type;

	$date          = OVAEX_Settings::ovaex_format_date_frontend();

	$ex_start_date = get_post_meta( $id, 'ex_start_date', true );
	$ex_end_date   = get_post_meta( $id, 'ex_end_date', true );

	$date_start_fm = $ex_start_date != '' ? date_i18n($date, $ex_start_date ) : '';
	$date_end_fm   = $ex_end_date 	!= '' ? date_i18n($date, $ex_end_date ) : '';

	$day_week_st   = $ex_start_date != '' ? date_i18n( 'l', $ex_start_date ) : ''; 
	$day_week_end  = $ex_end_date 	!= '' ? date_i18n( 'l', $ex_end_date ) : '';

	$time_start    = $ex_start_date != '' ? date_i18n(get_option('time_format'), $ex_start_date ) : ''; 
	$time_end      = $ex_end_date 	!= '' ? date_i18n(get_option('time_format'), $ex_end_date ) : ''; 

	$feature_image   = wp_get_attachment_image_url(get_post_thumbnail_id() , 'gimont_medium' );
	if ( $feature_image == '') {
	    $feature_image  =  \Elementor\Utils::get_placeholder_image_src();
	}

	// Categories
	$categories = get_the_terms($id, 'cat_exhibition');

	// show fields
	$show_title 			= isset($args['show_title']) ? $show_title : 'yes';
	$show_link_of_title 	= isset($args['show_link_of_title']) ? $show_link_of_title : 'yes';
	$show_image 	   	 	= isset($args['show_image']) ? $show_image : 'yes';
	$show_date	        	= isset($args['show_date']) ? $show_date : 'yes';
	$show_category	    	= isset($args['show_category']) ? $show_category : 'yes';
	$show_view_exhibition	= isset($args['show_view_exhibition']) ? $show_view_exhibition : 'yes';

?>

<div class="post-items <?php echo esc_attr($exhibition_type);?>">

	<?php if($show_image == 'yes') { ?>
		<div class="img-exhibition">
			<a href="<?php the_permalink();?>" title="<?php the_title();?>">
				<img src="<?php echo esc_url( $feature_image ); ?>" alt="<?php the_title(); ?>" class="exhibition-feature-image">
			</a>
		</div>
	<?php } ?>

	<div class="content">
		<div class="ex-meta">
			<?php if($show_date == 'yes') { ?>
				<div class="times">
					<i class="far fa-calendar-alt" aria-hidden="true"></i>
					<?php if( $date_start_fm === $date_end_fm && $date_start_fm != '' && $date_end_fm != '' ){ ?>
						<span>
							<?php echo esc_html($date_start_fm) .'&nbsp'.'&#47;'.'&nbsp'. esc_html($time_start) .'&nbsp'.'&#45;'.'&nbsp'. esc_html($time_end);?>
						</span>
					<?php } elseif( $date_start_fm != $date_end_fm && $date_start_fm != '' && $date_end_fm != '' ){ ?>
						<span><?php echo esc_html($date_start_fm);?></span>
						<span><?php echo esc_html('-');?></span>
						<span><?php echo esc_html($date_end_fm);?></span>
					<?php } ?>
				</div>
			<?php } ?>

			<?php if( !empty($categories) && is_array($categories) && $show_category == 'yes' ) { ?>
				<div class="categories">
					<i class="far fa-folder" aria-hidden="true"></i>
	    			<?php $category_first_link = get_term_link($categories[0]->term_id);
				        if ( $category_first_link ) {
				        	echo '<a href="'.esc_url( $category_first_link ).'" title="'.esc_attr($categories[0]->name).'">'.$categories[0]->name.'</a>';
				        }
					?>
		    	</div>
		    <?php } ?>
		</div>

		<?php if($show_title == 'yes') { ?>
			<?php if($show_link_of_title == 'yes') { ?>
			<a href="<?php the_permalink();?>" title="<?php the_title();?>">
			<?php } ?>
				<h3>
					<?php the_title();?>
				</h3>
			<?php if($show_link_of_title == 'yes') { ?>
			</a>
			<?php } ?>
		<?php } ?>

		<?php if($show_view_exhibition == 'yes') { ?>
			<a class="link-to-detail" href="<?php the_permalink();?>" title="<?php the_title();?>">
				<span>
					<?php esc_html_e('View Exhibition','ovaex');?>
				</span>
				<i class="flaticonnew- flaticon-new-right" aria-hidden="true"></i>
			</a>
		<?php } ?>

	</div>
</div>