<?php if ( !defined( 'ABSPATH' ) ) exit();

get_header();

$post_ID = get_the_ID();
$date 	 = OVAEX_Settings::ovaex_format_date_frontend_single();

// Embed Video Link
$ovaex_embed_video_link   = get_post_meta( $post_ID, 'ovaex_embed_video_link', true );

// Map
$exhibition_map_address 	 = get_post_meta( $post_ID, 'ovaex_map_address', true );
$exhibition_map_lat     	 = get_post_meta( $post_ID, 'ovaex_map_lat', true );
$exhibition_map_lng     	 = get_post_meta( $post_ID, 'ovaex_map_lng', true );
$exhibition_map_zoom    	 = OVAEX_Settings::exhibition_map_zoom();

// Get Data Metabox 
$ex_start_date = get_post_meta( $post_ID, 'ex_start_date', true );
$ex_end_date   = get_post_meta( $post_ID, 'ex_end_date', true );

$date_start_fm = $ex_start_date != '' ? date_i18n($date, $ex_start_date ) 	: '';
$date_end_fm   = $ex_end_date 	!= '' ? date_i18n($date, $ex_end_date ) 	: '';

$day_week_st   = $ex_start_date != '' ? date_i18n( 'l', $ex_start_date ) 	: ''; 
$day_week_end  = $ex_end_date 	!= '' ? date_i18n( 'l', $ex_end_date ) 		: '';

$time_start    = $ex_start_date != '' ? date_i18n(get_option('time_format'), $ex_start_date ) 	: ''; 
$time_end      = $ex_end_date 	!= '' ? date_i18n(get_option('time_format'), $ex_end_date ) 	: ''; 

$ex_morning_time 	= get_post_meta( $post_ID, 'ex_morning_time', true );
$ex_afternoon_time  = get_post_meta( $post_ID, 'ex_afternoon_time', true );
$ex_evening_time    = get_post_meta( $post_ID, 'ex_evening_time', true );
$ex_closed    		= get_post_meta( $post_ID, 'ex_closed', true );

$gallery_slide = get_post_meta( $post_ID, 'ovaex_gallery_id', true );

$ex_location   = get_post_meta( $post_ID,'ex_location', true );
$ex_curator    = get_post_meta( $post_ID,'ex_curator', true );
$ex_duaration  = get_post_meta( $post_ID,'ex_duaration', true );

$ovaex_member_book_link  	= get_post_meta( $post_ID, 'ovaex_member_book_link', true );
$ovaex_target_member_book   = get_post_meta( $post_ID, 'ovaex_target_member_book', true );
$ovaex_order_book_link  	= get_post_meta( $post_ID, 'ovaex_order_book_link', true );
$ovaex_target_order_book    = get_post_meta( $post_ID, 'ovaex_target_order_book', true );

$link_ex = ( isset( $_GET[ apply_filters('ex_back_param', 'back') ] ) && $_GET[ apply_filters('ex_back_param', 'back') ] == apply_filters('ex_back_val', 'ago') ) ? '' : get_post_type_archive_link( 'exhibition' );

$feature_image   = wp_get_attachment_image_url(get_post_thumbnail_id() , 'full' );
if ( $feature_image == '') {
    $feature_image  =  \Elementor\Utils::get_placeholder_image_src();
}

// show fields
$show_image 	= OVAEX_Settings::single_exhibition_show_image();
$show_content 	= OVAEX_Settings::single_exhibition_show_content();
$show_gallery 	= OVAEX_Settings::single_exhibition_show_gallery();
$show_video 	= OVAEX_Settings::single_exhibition_show_video();
$show_map 		= OVAEX_Settings::single_exhibition_show_map();
$show_related   = OVAEX_Settings::single_exhibition_show_related();
$show_comment 	= OVAEX_Settings::single_exhibition_show_comment();

// fields in sidebar
$show_member_button = OVAEX_Settings::single_exhibition_show_member_button();
$show_order_button  = OVAEX_Settings::single_exhibition_show_order_button();
$show_date 			= OVAEX_Settings::single_exhibition_show_date();
$show_time 			= OVAEX_Settings::single_exhibition_show_time();
$show_location 	 	= OVAEX_Settings::single_exhibition_show_location();
$show_curators  	= OVAEX_Settings::single_exhibition_show_curators();
$show_duration 		= OVAEX_Settings::single_exhibition_show_duration();
$show_share 		= OVAEX_Settings::single_exhibition_show_share();

?>

	<div class="row_site">
		<div class="container_site">

			<div class="single_exhibition">

				<div class="exhibition_content">

					<div class="wrap_content">
						<?php if( has_post_thumbnail() && $show_image == 'yes' ){ ?>
							<div class="feature_img">
								<img src="<?php echo esc_url( $feature_image ); ?>" alt="<?php the_title(); ?>">
							</div>
						<?php } ?>
						<?php if($show_content == 'yes') {
							the_content(); 
						} ?>
					</div>

					<div class="line">
						<div class="wrapper_order">
							<div class="order_ticket">
								<?php if( $ovaex_member_book_link && $show_member_button == 'yes' ){ ?>
									<a class="member" href="<?php echo esc_html( $ovaex_member_book_link ); ?>" target="<?php echo esc_html( $ovaex_target_member_book ); ?>">
										<?php esc_html_e('Become a member','ovaex');?>
									</a>
								<?php } ?>

								<?php if( ($ex_end_date > current_time('timestamp')) && $ovaex_order_book_link && $show_order_button == 'yes' ){ ?>
									<a class="button_order" href="<?php echo esc_html( $ovaex_order_book_link ); ?>" target="<?php echo esc_html( $ovaex_target_order_book ); ?>">
										<?php esc_html_e('Order Ticket','ovaex');?>
									</a>
								<?php } ?>

								<ul class="info_order">
									<?php if( $show_date == 'yes' ) : ?>
									<li>
										<span class="label"><?php esc_html_e('Date:','ovaex');?></span>
										<?php if( $date_start_fm === $date_end_fm && $date_start_fm != '' && $date_end_fm != '' ){ ?>
											<span><?php echo esc_html($date_start_fm);?></span>
											<span><?php echo esc_html($time_start) .'&nbsp'.'&#45;'.'&nbsp'. esc_html($time_end);?></span>
										<?php } elseif( $date_start_fm != $date_end_fm && $date_start_fm != '' && $date_end_fm != '' ){ ?>
											<span><?php echo esc_html($date_start_fm) .'&nbsp;&#45;&nbsp;'. esc_html($date_end_fm);?></span>
										<?php }
										?>
									</li>
									<?php endif; ?>

									<?php if( $show_time == 'yes' ) { 
										if( $ex_morning_time != '' || $ex_afternoon_time != '' || $ex_evening_time != '' || $ex_closed != '' ) : 
									?>
										<li>
											<span class="label"><?php esc_html_e( 'Time:', 'ovaex' );?></span>
											<?php if( $ex_morning_time != '' ) { ?>
											<span><?php echo esc_html__('Morning:','ovaex') . ' ' . esc_html($ex_morning_time);?></span>
											<?php } ?>
											<?php if( $ex_afternoon_time != '' ) { ?>
											<span><?php echo esc_html__('Afternoon:','ovaex') . ' ' . esc_html($ex_afternoon_time);?></span>
											<?php } ?>
											<?php if( $ex_evening_time != '' ) { ?>
											<span><?php echo esc_html__('Evening:','ovaex') . ' ' . esc_html($ex_evening_time);?></span>
											<?php } ?>
											<?php if( $ex_closed != '' ) { ?>
											<span><?php echo esc_html__('Closed:','ovaex') . ' ' . esc_html($ex_closed);?></span>
											<?php } ?>
										</li>
									<?php endif; } ?>

									<?php if( $ex_location != '' && $show_location == 'yes' ) : ?>
										<li>
											<span class="label"><?php esc_html_e( 'Location:', 'ovaex' );?></span>
											<span><?php echo esc_html($ex_location);?></span>
										</li>
									<?php endif; ?>

									<?php if( $ex_curator != '' && $show_curators == 'yes' ) : ?>
										<li>
											<span class="label"><?php esc_html_e( 'Curators:', 'ovaex');?></span>
											<span><?php echo esc_html($ex_curator); ?></span>
										</li>
									<?php endif; ?>

									<?php if( $ex_duaration != '' && $show_duration == 'yes' ) : ?>
										<li>
											<span class="label"><?php esc_html_e( 'Duration:', 'ovaex');?></span>
											<span><?php echo esc_html($ex_duaration); ?></span>
										</li>
									<?php endif; ?>
								</ul>
								<?php if( has_filter( 'ova_share_social' ) && $show_share == 'yes' ){ ?>
									<div class="share_social">
										<?php echo apply_filters('ova_share_social', get_the_permalink(), get_the_title() ); ?>
									</div>
								<?php } ?>
							</div>
						</div>
					</div>
				</div>

				<?php if( $gallery_slide && $show_gallery == 'yes' ): ?>
					<div class="gallery_exhibition">
						<h2 class="title_glr">
							<?php esc_html_e( 'Image Gallery', 'ovaex' );?>	
						</h2>
						<div class="gallery_slide owl-carousel">
							<?php foreach ($gallery_slide as $gallery_id ) {
								$gallery_url 	 = wp_get_attachment_image_url( $gallery_id, 'large' );
								$gallery_caption = wp_get_attachment_caption( $gallery_id );
								if( empty($gallery_caption) ) {
									$gallery_caption = esc_html__('Exhibiton Gallery','ovaex');
								}
							?>
								<div class="items">
									<a class="gallery-fancybox" data-src="<?php echo esc_url( $gallery_url ); ?>" 
	  								data-fancybox="exhibition-gallery" 
	  								data-caption="<?php echo esc_attr($gallery_caption); ?>">
									<img src="<?php echo esc_url($gallery_url);?>" title="<?php the_title(); ?>">
									</a>
								</div> 
							<?php } ?>
						</div>
					</div>
				<?php endif; ?>

				<?php if( (! empty( $ovaex_embed_video_link ) && wp_oembed_get($ovaex_embed_video_link) ) || ! empty( $exhibition_map_address ) ) { ?>
					<div class="map-and-video">
						<?php if( ! empty( $ovaex_embed_video_link ) && wp_oembed_get($ovaex_embed_video_link) && $show_video == 'yes' ) { ?>
							<div class="video-wrapper">
								<h2 class="title_embed_link">
									<?php esc_html_e( 'Video', 'ovaex' );?>	
								</h2>
								<div class="exhibition-embed-link">
									<?php echo wp_oembed_get($ovaex_embed_video_link); ?>
								</div>
							</div>
					  	<?php } ?>

						<?php if( ! empty( $exhibition_map_address ) && $show_map == 'yes' ) { ?>
							<div class="map-wrapper">
								<h2 class="title_map">
									<?php esc_html_e( 'Location', 'ovaex' );?>	
								</h2>
								<div class="exhibition-map" id="single-exhibition-map"
					  				style="height: 450px;" 
					  				data-address="<?php echo esc_attr($exhibition_map_address);?>" 
					  				data-lat="<?php echo esc_attr($exhibition_map_lat);?>" 
					  				data-lng="<?php echo esc_attr($exhibition_map_lng);?>" 
					  				data-zoom="<?php echo esc_attr($exhibition_map_zoom); ?>"
					  			></div>
							</div>
					  	<?php } ?>
					</div>
				<?php } ?>

				<?php if($show_related == 'yes') :
					$exhibition = apply_filters( 'OVAEX_related_ex', array($post_ID) ); 
					if( $exhibition->have_posts() ) {  
				?>
					<div class="related_post">
						<div class="related_ex">
							<h2>
								<?php esc_html_e( 'Related Exhibitions', 'ovaex' ); ?>
							</h2>
							<div class="ova-wrap-exhibition wrap-content">
								<?php while( $exhibition->have_posts() ): $exhibition->the_post();
									ovaex_get_template( 'parts/item-exhibition.php' );
								endwhile; wp_reset_postdata(); ?>
							</div>
						</div>
					</div>
				<?php } endif; ?>
				
				<?php if($show_comment == 'yes') {
					if ( comments_open() || get_comments_number() ) {
						comments_template();
					}
				} ?>

			</div>

		</div>
	</div>

<?php get_footer();