<?php if ( !defined( 'ABSPATH' ) ) exit();
	$args = array(
	   'taxonomy' => 'cat_por',
	   'orderby' => 'name',
	   'order'   => 'ASC'
	);

	$categories = get_categories($args);

	$term_id = get_queried_object_id();
	$class_active_all = $term_id == 0 ? 'active' : '';

	$number_column = get_theme_mod( 'ova_por_layout', 'three_column' );
	$post_per_page = get_theme_mod( 'ova_por_total_record', 60 );
?>

<div class="wrap-portfolio">
	<div class="archive-por">

		<?php if( $term_id == 0 && $show_filter == 'yes' ){ ?>
			<ul class="list-cat-por">
				<li data-filter="*" class="<?php echo esc_attr( $class_active_all ); ?>">
					<a class="second_font cate_name" data-id="0" href="<?php echo esc_url( get_post_type_archive_link( 'ova_por' ) ) ?>"><?php echo esc_html__( 'All', 'ova-por' ) ?>
					</a>
				</li>
				<?php if ($categories) : foreach ( $categories as $cate ) {
					$class_active = ( $term_id == $cate->term_id ) ? 'active' : '';
				?>
					<li data-filter=".<?php echo esc_attr( $cate->term_id ); ?>" class="<?php echo esc_attr( $class_active ); ?>">
						<a class="second_font cate_name" href="#" data-id="<?php echo esc_attr( $cate->term_id ); ?>" 
							title="<?php echo esc_attr( $cate->cat_name ); ?>"
						>
							<?php echo esc_html( $cate->cat_name ); ?>
						</a>
					</li>
				<?php } endif; ?>
			</ul>
		<?php } ?>

		<div class="ova-por-loader">
			<div class="loader"></div>
		</div>

		<div class="category-desc"></div>

		<div class="content-por <?php echo esc_attr( $number_column ); ?> modern-portfolio">
			<?php if( have_posts() ) : while ( have_posts() ) : the_post(); 
				$id = get_the_id();

				$url_img = get_the_post_thumbnail_url( $id, 'ova_por_thumbnail' );

				if( !$url_img ){
					$url_img = OVAPOR_PLUGIN_URI.'assets/img/placeholder.jpg';
				}
				
				$title = get_the_title( $id );
				$link  = get_the_permalink( $id );

				$cat_por = get_cat_id_por_by_id_por( $id );
				$gallery = get_post_meta( $id, 'ova_por_met_gallery', true );
			?>
				<div class="ovapor-item <?php echo esc_attr( $cat_por ) ?>">
					<?php if( $url_img ){ ?>

						<?php if($show_link_to == 'yes') : ?>
						<a href="<?php echo esc_url( $link ); ?>">
						<?php endif; ?>
							<?php if( ! empty( $gallery ) ){ ?>
								<span class="number-gallery">
									<?php echo count( $gallery ); ?>
								</span>
							<?php } ?>
							<img src="<?php echo esc_url( $url_img ); ?>" alt="<?php echo esc_attr( $title ); ?>">
						<?php if($show_link_to == 'yes') : ?>
						</a>
						<?php endif; ?>

						<?php if($show_category == 'yes' || $show_title == 'yes' ) : ?>
							<div class="content-item">
								<?php if($show_category == 'yes') : ?>
									<div class="category">
										<?php get_category_por_by_id_por( $id ); ?>
									</div>
								<?php endif; ?>
								<?php if($show_title == 'yes') : ?>
									<h2 class="title">
										<?php if($show_link_to == 'yes') : ?>
										<a class="second_font" href="<?php echo $link; ?>">
										<?php endif; ?>
											<?php echo $title; ?>
										<?php if($show_link_to == 'yes') : ?>
										</a>
										<?php endif; ?>
									</h2>
								<?php endif; ?>
							</div>
						<?php endif; ?>
					<?php } ?>
				</div>
			<?php endwhile; endif; wp_reset_postdata(); ?>
		</div>

		<?php if($show_loadmore == 'yes') : ?>
			<div class="ova_more_por" data-paged="2" data-perpage="<?php echo esc_attr($post_per_page); ?>" 
				data-cat="<?php echo esc_attr( $term_id ); ?>" data-type="<?php echo 'modern_porfolio'; ?>" 
			>
	            <span class="ova-load-more-por second_font">
	            	<?php echo esc_html__('Load More','ova-por'); ?>
	            </span>
	            <div class="ova-loader"></div> 
	        </div>
        <?php endif; ?>

        <div class="ova-nodata">
        	<span><?php echo esc_html__('No Data','ova-por'); ?></span>
        </div>

	</div>
</div>